; ptbt3 - kjw/bqsd - 11/82
;
	TITLE	'<PowerTOOL Boot III>'
;
;	This program will locate at Track 0/Sector 1
;	in double density.  It will read in a rather
;	'unusual' manner the 'true' loader which
;	will reside on track 1, at sectors 50H & 70H
;	The sectors will be have Track/Head/Sector
;	numbers all the same
;
;	equivalences
;
CLS	EQU	01C9H		;ROM cls routine
VIDEO	EQU	3C00H		;start of video
KEYBRD	EQU	3840H		;last row keyboard
DELAY	EQU	0060H		;dec BC till 0
;
NMI	EQU	0E4H		;NMI select latch
FDC	EQU	0F0H		;FDC command/status reg.
TRACK	EQU	0F1H		;FDC track register
SECTOR	EQU	0F2H		;FDC sector register
XFER	EQU	0F3H		;FDC transfer register
SELFDC	EQU	0F4H		;FDC select register
;
DRIVE	EQU	001H		;drive select code
SEEK	EQU	013H		;seek command
SREAD	EQU	080H		;read command
CLEAR	EQU	0D0H		;clear FDC
;
	ORG	4300H		;Mod III loader
;
ENTRY	LD	SP,STACK	;relocate stack
	CALL	CLS		;clear video screen
	DI			;leave off!
	XOR	A		;load zero
	LD	BC,NMIRET	;disable NMI
	CALL	SETNMI		;setup NMI
;
;	all register data loaded via POP's
;
	CALL	SEEK1		;head to track 1
	POP	HL		;I/O buffer
	POP	DE		;track/sector
	CALL	READ		;read sector
	JR	NZ,GOERR	;go if disk error
	POP	HL		;get next buffer
	POP	DE		;next sector
	CALL	READ		;read next sector
	RET	Z		;go loader if OK
GOERR	JR	ERROR		;go error
;
;	actual read routine
;	return/entry point on stack
;
;	ENT	HL => I/O buffer to use
;		A  = sector # factor
;		E  = offset to sector # (also REAL track)
;	(E+A) = first sector number
;	(E+A+A) = second sector number
;
;	EXT	return made via stack
;		first pass a CALL is on stack
;		second pass, stack overflow fetchs
;		the entry point from init table
;
READ	PUSH	HL		;save buffer address
	CALL	READ1		;try once
	POP	BC		;restore buffer
	RET	Z		;no error, return
	LD	H,B		;pass buffer back to HL
	LD	L,C		;HL => I/O buffer
	LD	A,CLEAR		;reset FDC
	OUT	(FDC),A		;clear it
;
READ1	CALL	SELECT		;select drive 0
	LD	A,E		;get sector
	OUT	(SECTOR),A	;to FDC sector reg
	LD	A,D		;get track
	OUT	(TRACK),A	;to FDC track reg
;
	CALL	SELECT		;select drive
	LD	(SPSAVE),SP	;save stack
	LD	BC,RETNMI	;NMI vector
	LD	A,0C0H		;allow NMI
	CALL	SETNMI		;setup NMI
	LD	C,XFER		;xfer port
	LD	A,SREAD		;read command
	CALL	SLOW		;issue and delay
;
RDL1	IN	A,(FDC)		;read FDC status
	AND	2		;byte ready?
	JR	Z,RDL1		;wait for it
	JR	RDL3		;fetch it
;
RDL2	LD	A,DRIVE.OR.40H	;set wait states
	OUT	(SELFDC),A	;select drive
RDL3	IN	A,(C)		;read the byte
	RRD			;move into buffer
;
	LD	A,DRIVE.OR.40H	;set wait
	OUT	(SELFDC),A	;select drive
	IN	A,(C)		;read the byte
	RRD			;to buffer
	DEC	L		;buffer back
	JR	NZ,RDL2		;go till full
	INC	H		;HL => next buffer addr
	JR	RDL2		;continue
;
;	move head to track 1
;
SEEK1	CALL	SELECT		;select drive
	LD	A,01		;track to seek
	OUT	(XFER),A	;set track 1
	LD	A,SEEK		;get seek command
	CALL	SLOW		;issue command
SEEKWT	CALL	SELECT		;select drive
	RRCA			;command done?
	JR	C,SEEKWT	;wait if not
	RET			;else done
;
RETNMI	XOR	A		;load zero
	LD	BC,NMIRET	;non-disk NMI's
	CALL	SETNMI		;reset NMI's
	LD	SP,$		;reset stack
SPSAVE	EQU	$-2
	IN	A,(FDC)		;read status
	OR	A		;check for error
	RET			;return with Z/NZ status
;
SETNMI	LD	(404AH),BC	;pass interrupt vector
	LD	B,C		;pass lsb
	LD	C,0C3H		;JP opcode
	LD	(4049H),BC	;pass JP opcode
	OUT	(NMI),A		;setup NMI vector
	IN	A,(FDC)		;clear FDC
	RET			;done!
;
;	error vector
;
ERROR	LD	DE,MESG		;message
	LD	HL,VIDEO-1	;start of video-1
;
PRINT	LD	(HL),A		;to video
	INC	HL		;bump video
NEXT	LD	A,(DE)		;get a char
	INC	E		;bump buffer
	RRCA			;divide it
	JR	NC,PRINT	;send to video
;
;	wait for a key and re-boot
;
WAIT	LD	A,(KEYBRD)	;read keyboard row
	RRCA			;check bit 0
	JR	NC,WAIT		;wait if not set
	RST	0		;re-boot mod III
;
NMIRET	RETN
;
;	issue FDC command and delay for valid status
;
SLOW	OUT	(FDC),A		;issue command
;
	EX	(SP),HL		;delay time
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	select drive and return with FDC status
;
SELECT	IN	A,(FDC)		;read FDC
	BIT	7,A		;motor on?
	PUSH	AF		;save FDC status
	LD	A,DRIVE		;drive select code
	OUT	(SELFDC),A	;select reg FDC
	POP	AF		;restore FDC status
	RET	Z		;return if already on
;
	PUSH	BC		;save
	LD	BC,9000H	;motor on delay
	CALL	DELAY		;call rom delay
	POP	BC		;restore
	JR	SELECT		;re-select drive
;
MESG	DEFB	'E'<1
	DEFB	'R'<1
	DEFB	'R'<1
	DEFB	'O'<1
	DEFB	'R'<1
	DEFB	'!'<1
	DEFB	' '<1
	DEFB	5FH<1
	DEFB	-1		;terminator
;
;	following is the real stack area
;
	DEFB	'P'<1,'r'<1,'o'<1,'g'<1,'r'<1,'a'<1,'m'<1
	DEFB	' '<1,'b'<1,'y'<1,' '<1,'K'<1,'i'<1,'m'<1
	DEFB	' '<1,'W'<1,'a'<1,'t'<1,'t'<1,' '<1,'1'<1
	DEFB	'9'<1,'8'<1,'2'<1
;
;	stack area follows, registers popped here
;
STACK	DEFW	4500H		;buffer address
	DEFW	5050H		;track/sector
	DEFW	4600H		;buffer address
	DEFW	7070H		;track sector
	DEFW	4500H		;loader entry point!
;
	END	ENTRY
