; ptboot1d/asm - kjw/bqsd - 10/82
;
	PAGE
;
	SUBTTL	'<PTBOOT1D/ASM - Boot Loader Mod I DD>'
;
$DIFD	EQU	4200H-$		;offset to actual load
$SECLD	EQU	01		;lowest sector on track
$SECHD	EQU	18		;highest sector
;
;	boot entry point 4200H
;
BOOT1D	CP	0		;3rd byte dir track
	NOP
;
	LD	HL,37EEH	;select reg R/S doubler
	LD	(HL),80H	;select double density
	DEC	L		;37ED
	DEC	L		;37EC
	LD	(HL),0D0H	;interrupt out
	LD	(HL),0FFH	;select double den percom
	LD	(HL),0D0H	;clear FDC
;
	CALL	01C9H		;ROM $CLS routine
	LD	DE,0101H	;track 1, sector 1
	LD	L,-1		;set buffer as empty
	EXX			;save in alt set
;
@1DLOOP	CALL	@1DGETB+$DIFD	;fetch a byte
;
;	begin of load block, check which type
;
	DEC	A		;01 header?
	JR	Z,@1DLOAD	;load it!
	DEC	A		;02 header?
	JR	Z,@1DSTRT	;done!
	CP	1EH		;valid remark? (0-1FH)
	JR	NC,@1DSER	;data error!
;
;	remark block, remove and re-loop
;
	CALL	@1DGETB+$DIFD	;fetch a byte
	LD	B,A		;B = block length
;
@1DLOP2	CALL	@1DGETB+$DIFD	;fetch a remark byte
	DJNZ	@1DLOP2		;finish it off
	JR	@1DLOOP		;go next loop
;
;	entry point marker, fetch address and go!
;
@1DSTRT	CALL	@1DGETL+$DIFD	;fetch load address
	JP	(HL)		;go program!
;
;	load block marker, get address and load it!
;
@1DLOAD	CALL	@1DGETL+$DIFD	;get block address
;
@1DLOP3	CALL	@1DGETB+$DIFD	;fetch block length
	LD	(HL),A		;to buffer
	CP	(HL)		;memory there for it?
	JR	NZ,@1DMER	;memory error
	INC	HL		;bump buffer
	DJNZ	@1DLOP3		;finish off the block
	JR	@1DLOOP		;go next block
;
;	fetch 2 byte address from file
;
@1DGETL	CALL	@1DGETB+$DIFD	;fetch length byte
	SUB	2		;less address length
	LD	B,A		;B = data length
	CALL	@1DGETB+$DIFD	;fetch LSB address
	LD	L,A		;pass it
	CALL	@1DGETB+$DIFD	;fetch MSB address
	LD	H,A		;pass it
	RET			;HL = address
;
;	error vectors
;
;	memory error (attempt to load non-existing mem)
;
@1DMER	LD	HL,@1DREM+$DIFD	;memory error text
	JR	@1DERR		;go common
;
;	invalid data (file format error)
;
@1DSER	LD	HL,@1DRES+$DIFD	;data error text
	JR	@1DERR		;go common
;
;	disk I/O error
;
@1DDER	LD	HL,@1DRED+$DIFD	;disk error text
;
@1DERR	CALL	@1DDSP+$DIFD	;display message
	LD	HL,@1DRRE+$DIFD	;'error'
	CALL	@1DDSP+$DIFD	;display also
;
;	wait for a key then re-boot
;
	CALL	0040H		;wait for ENTER key
	HALT			;re-boot Mod I
;
@1DDSP	LD	A,(HL)		;get a byte
	OR	A		;high bit on?
	RET	M		;done, return
	CALL	0033H		;else display byte
	INC	L		;bump pointer
	JR	@1DDSP		;continue
;
;	fetch byte from file
;
@1DGETB	EXX			;get disk set back
	INC	L		;bump LSB buff pointer
	JR	NZ,@1DHAVB	;go if in buffer
;
;	read another sector
;
	LD	BC,4400H	;I/O buffer to use
	CALL	@1DRD+$DIFD	;read the sector
	JR	NZ,@1DDER	;disk error!
	LD	A,E		;get sector
	INC	E		;bump sector
	SUB	$SECHD		;highest sector/track
	JR	NZ,@1DHAVB	;go, not at track end
	LD	E,$SECLD	;lowest sector/track
	INC	D		;bump track
;
;	byte in buffer => by HL
;
@1DHAVB	LD	A,(HL)		;fetch byte
	EXX			;store registers again
	RET			;done, A = byte
;
;	message text for errors
;
@1DREM	DEFM	'Memory',-1
@1DRES	DEFM	'Data',-1
@1DRED	DEFM	'Disk',-1
@1DRRE	DEFM	' Error',-1
;
;	short delay for FDC to load valid status byte
;
@1DSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	sector read: DE = track/sector, BC = buff address
;
@1DRD	LD	A,5		;allow 5 retries
;
@1DRDL	EX	AF,AF'		;swap retries left
	PUSH	BC		;save load address
	CALL	@1DRD1+$DIFD	;read a sector
	POP	HL		;original load address
	RET	Z		;no error, return
	LD	B,H		;pass buffer back
	LD	C,L		;to BC from original
	EX	AF,AF'		;get counter back
	DEC	A		;less this pass
	JR	NZ,@1DRDL	;go till out of tries
	EX	AF,AF'		;get NZ error back
	RET			;back NZ
;
;	actual sector I/O - single density Mod I
;
@1DRD1	LD	HL,37ECH	;Mod I FDC command reg.
;
	LD	A,1		;select drive 0
	LD	(37E1H),A	;it's on now
	LD	(37EEH),DE	;status/sector registers
	LD	(HL),1BH	;issue seek command
	CALL	@1DSLO+$DIFD	;wait for valid status
;
@1DSEK	BIT	0,(HL)		;command done?
	JR	NZ,@1DSEK	;wait if not
	LD	(HL),80H	;issue read command
	CALL	@1DSLO+$DIFD	;wait for valid status
	PUSH	DE		;save track/sector
	LD	DE,37EFH	;transfer register
;
@1DRD2	LD	A,(HL)		;get status byte
	AND	87H		;motor on, byte ready
	JP	PO,@1DRD2+$DIFD	;wait if not
;
@1DRD3	LD	A,(DE)		;get FDC byte
	LD	(BC),A		;to I/O buffer
	INC	BC		;bump buff pointer
;
@1DRD4	BIT	1,(HL)		;byte ready?
	JR	NZ,@1DRD3	;get it if yes
	BIT	1,(HL)		;ready now?
	JR	NZ,@1DRD3	;yes, go!
	BIT	1,(HL)		;motor still on?
	JR	NZ,@1DRD3	;go if not!
	BIT	7,(HL)		;byte ready now?
	JR	NZ,@1DRD5	;go if yes
	BIT	0,(HL)		;command done?
	JR	NZ,@1DRD4	;go if not
;
@1DRD5	LD	A,(HL)		;fetch result status
	LD	(HL),0D0H	;interrupt FDC
	POP	DE		;restore DE
	AND	9FH		;check status
	RET			;done!
;
BOOT1DL	EQU	$-BOOT1D	;length of module
;
