j :COPYRIGHT (C) CLOAD 1982 k
 1000:K,L:L(34)::@83,"PILOT User's Manual


PILOT (Programmed Inquiry Learning Or Teaching) is a computer
language, as is BASIC.

PILOT uses words and sentences, but almost no math.  The only
math it can do is count to nine.
" 3l "PILOT is simple; there are few commands to learn.
It is an ideal "L"first language"L" for elementary children.
It has been learned and used by first graders.":420 l "
PILOT is useful in writing computer assisted instruction
(CAI) programs, even by someone who doesn't want to spend
much time learning a computer language.
" m( "Although PILOT is a simple language, it is powerful.
Long and complex programs can be written, if you wish.

PILOT uses 4 basic statements:  T:  Type
                                A:  Answer" ?n- "                                M:  Match
                                J:  Jump

You can start writing programs with just these four statements.":420 n2 "T:     means TYPE


This statement will type anything you wish onto the screen.

Example:

T: HELLO, I AM A COMPUTER.  I AM RUNNING A PILOT PROGRAM.
":420 o< "A:     means ACCEPT an answer


This statement will stop and wait for the user to type an
answer.  It can also type a message first.

Examples:

T: ARE YOU FEELING OK
A:

or you could do the same thing by using:

A: ARE YOU FEELING OK":420 pF "M:     means MATCH


This statement checks the user's answer for a word or words.
Words must be separated by "L"/"L" marks.

Examples:

M: SICK
M: YES/YEAH/I GUESS SO/YUP
" pP "The computer will remember if it found a match for one of the
words or phrases in the previous answer.
":420 qZ "Y     YES, there was a MATCH
N     NO, there was no MATCH


These are conditional statements.  When they are the second
letter of a statement, it will only execute on that condition.

Examples:

TY: I'M GLAD TO HEAR THAT.
TN: THAT'S TOO BAD.
" rd 420:"LABELS

Since PILOT uses no line numbers, you can refer to a statement
by labeling it.

Labels must start with a "L"*"L" and can have up to four letters.

Example:
" si "*WHEN T: YOU CAN SEE THE MOON AT NIGHT.

There must be one space between the label and the statement.":420 sn "*NAME     a special label


If you use this label with a "L"A:"L" statement, the computer
will remember the user's answer.  It can then be used in
a "L"T:"L", "L"A:"L", or "L"E:"L" statement." ]tx "
Example:

T: WHO ARE YOU
*NAME A:
T: NICE TO KNOW YOU, *NAME

*NAME must be the last thing in the statement.":420 u "J:     means JUMP


This will cause the computer to jump to a particular statement.
Naturally, that statement must be identified with a label.

Example:

J: *WHEN
" u "This tells the computer to jump to the line labeled "L"*WHEN"L".
":420:"C:     means CLEAR the screen


This statement will have the computer clear the screen.  It
can also then type any message.

Example:

C:
T: HELLO THERE.
" v "or you can do the same thing by using:

C: HELLO THERE.":420:"R:     means REMARK


This is ignored by PILOT.  The programmer can use it to make
notes or other remarks about his program.

Example:

R: WRITTEN BY J. OLSEN
":420 w "Z:     means ZERO the counter
I:     means INCREMENT the counter


PILOT can count from 0 to 9.  You can tell the computer to
start at zero with the "L"Z:"L" statement.  You can then add one" x "more with the "L"I:"L" statement.  When the counter reaches 9,
then the "L"I:"L" is ignored.
":420:"0 - 9


When used as the second character in a statement, it causes the
statement to be executed only if the counter has that value.
" y "Example:

T4: THAT TOOK FOUR TIMES
":420:
"U:     means USE a subroutine


You can jump to a subroutine from anywhere in your program,
using the "L"U:"L" statement, then return, using the "L"E:"L" statement.

Example:

U: *LINE
" ^z "You cannot put a subroutine inside another subroutine.
":420:"E:     means END


This is used to end a subroutine or your program.  It can also
type a message.  It does not have to be the last statement in" z "a program.

Example:

E: GOODBYE
":420 m{ "That concludes the complete list of PILOT statements.
Here are a few review examples and explanations:

C: HELLO                    clears the screen, types message
*TOP U: *NAME               jump to subroutine *NAME" Z| "EY: I KNOW YOU              end if match was yes, type message
I:                          add one to counter
E5: I DON'T KNOW YOU FIVE   end if counter is 5, type message
TN: GET SOMEONE ELSE        if match was no, type message" I} "J: *TOP                     jump to the line labeled *TOP
*NAME A: WHO ARE YOU        asks name, remembers answer
M: BOB/JOHN                 tries to find a match in answer
E:                          ends subroutine, return
":420 } "Here is a list of direct commands for PILOT:

RUN
LIST
LLIST (if you have a printer)
NEW
E (EDIT)
D (DELETE)
I (INSERT)
CLOAD
CSAVE
LOAD (disk only)
SAVE (disk only)
":420 ~ "RUN


When you have finished writing your PILOT program, this will
begin execution.

Disk users can type RUN "L"FILESPEC"L", where "L"FILESPEC"L" is the
name of any PILOT program on disk.  The program will load
and automatically run.
" m "Examples:

RUN               (runs the program in memory)
RUN "L"TURK"L"        (loads TURK from disk and runs it)":420  "LIST


This lists the first 14 lines of your program on the video
display.  Each time you press the <UP-ARROW> key, the list
will scroll up one line.
":420 "LLIST


This lists your complete program to a line printer.  If one
is not available, an error message is given, but the system
does not freeze up.
":420 "NEW


This erases your PILOT program from memory.
":420 с"E


This is the command to EDIT a program line.  When you enter
this mode, you will see a listing of your program, and a
marker pointing to the first line.  Move the marker to the
line you wish to EDIT, then <ENTER>.
" S""You can then edit the line using commands very similar to
the BASIC editing commands.  A summary is on the next page.":420 6,"Here is a list of EDIT commands:
C            change a character
D            delete a character
I            insert characters
X            go to end of line, and insert
H            hack and insert
A            cancel" 6"SPACE BAR    move cursor
LEFT ARROW   backspace cursor
RIGHT ARROW  advance cursor 10 spaces
UP ARROW     escape key
ENTER        completed editing

See your BASIC User's Manual for details.":420 @"D


This is the command to DELETE a program line.  When you
enter this mode, you will see a listing of your program,
and a marker pointing to the first line.  Move the marker" J"to the line you wish to delete, then <ENTER>.
":420:"I


This is the command to INSERT a program line in the middle
of your program.  When you enter this mode, you will see
a listing of your program, and a marker pointing ahead of" "T"the first line.  Move it between the two lines you want,
then <ENTER>.  You can then type a new program line.
":420 ^"CSAVE


This is the same as in BASIC, but uses no filespec.  It
saves your program onto a cassette tape.  Be sure the tape
is advanced pass the leader and the recorder is in the
"L"RECORD"L" mode.
":420 h"CLOAD


This is the same as in BASIC.  It loads a previously saved
program from cassette.  Be sure the cassette is rewound and
is in the "L"PLAY"L" mode.
":420 r"LOAD
SAVE


For disk users only, they require a filespec.


Examples:

LOAD "L"GAME"L"
SAVE "L"NAME"L:420 |"That concludes a list of PILOT statements and commands.

Here are a few special notes:

Remember, there are no line numbers in PILOT.
Each line must be 60 characters or less.
PILOT will not accept lower case letters." 牆"PILOT programs can accept all other letters, numbers, and
  characters, except a double quote ("L").
You must use a double quote in certain commands such as "L"LOAD"L".
The <BREAK> key is disabled.
Use the <CLEAR> key for the "L"BREAK"L" key.
" W420:"The program after the PILOT interpreter is a sample PILOT
program.  When in PILOT, "L"CLOAD"L" it.
" "You will learn much about the PILOT language if you "L"LIST"L" it
and examine the program before you type "L"RUN"L".


Good luck with PILOT, and have fun!
": $"
Press <ENTER> to continue.";:K >K:K(13)ʄ::430   