;MSBNOHI BY ROD STEVENSON 19TH JANUARY, 1985
;TO SET MSB OF NUMBERS OF SOURCE CODE FILE AS
;   REQUIRED BY ASSEMBLERS.
;
	ORG	5200H
OPEN	EQU	4424H	;opens file
CLOSE	EQU	4428H	;closes file
READ	EQU	4436H	;reads file
CKEOF	EQU	4458H	;(MODEL1=444B) checks end of file
INBUF$	EQU	4225H	;(MODEL1=4318) keyboard input buffer
REW	EQU	443FH	;points to start of file
WRITE	EQU	4439H	;writes file
FSPEC	EQU	441CH	;transfers filename input
DSPLY	EQU	4467H	;displays message on screen
BUFFER	EQU	6000H	;memory for data read in
;
;get filename, create FCB, open file
	LD	HL,INBUF$+8	;keyboard input buffer
	LD	DE,FCB		;file area in memory
	CALL	FSPEC		;transfer filename
	JP	NZ,ERROR	;test for valid name
	LD	HL,BUFFER	;data area in memory
	LD	B,0		;zero counter
	PUSH	BC		;save counter
	CALL	OPEN
	JP	NZ,ERROR	;check it was opened
;
;read whole file into memory
LOOP	CALL	READ		;read one sector
	JP	NZ,ERROR	;check it was read
	POP	BC		;get counter and
	INC	B		;   increment it for
	PUSH	BC		;   each file read
	LD	DE,FCB		;check to see if any 
	CALL	CKEOF		;   more sectors to read
	PUSH	AF		;save flags from check
	LD	HL,(FCB+3)	;increment data memory
	INC	H		;   ready for next sector
	LD	(FCB+3),HL	;to be read from file
	POP	AF		;get flags from check
	LD	DE,FCB
	JR	Z,LOOP		;keep reading sectors
;
;calculate total amount of memory filled by reads
	POP	BC		;get count of sectors
	PUSH	BC		;save it again
	LD	HL,BUFFER	;add number of sectors
	ADD	HL,BC		;   of 256 bytes to start
	LD	A,H		;   of data buffer 
	LD	(ENDBUF),A	;   and save it
;
;look for first number in file
	LD	HL,BUFFER	;start testing from
FNDZER	LD	A,(HL)		;   start of data memory
	CP	3AH		;   by testing if <9
	JR	NC,CONT		;   or >0
	CP	30H		;if not found, keep
	JR	C,CONT		;   testing until found
	LD	B,5
	JR	CHANGE
CONT	INC	HL
	JR	FNDZER
;
;test for and change numbers 0-9 five times only
TESTNO	LD	A,(HL)
	CP	3AH
	JR	NC,NEXT
	CP	30H
	JR	C,NEXT
CHANGE	SET	7,A		;if 0-9, set MSB high
	LD	(HL),A		;   as assembler expects
NEXT	INC	HL		;keep going, but
	DJNZ	TESTNO		;   only five times
;
;test if done all file
	LD	A,(ENDBUF)	;test if at end of
	CP	H		;   data memory
	JR	C,FINISH
;
;look for CR so other zeros not changed
TESTCR	LD	A,(HL)		;after changing five
	INC	HL		;   line numbers, find CR
	CP	13		;   so other numbers not
	JR	NZ,TESTCR	;   changed mistakenly
	LD	B,5		;look for only five
	JR	TESTNO		;   line numbers
;
;when whole file is done, re-write to disk
FINISH	POP	BC		;get sector count
	LD	DE,FCB
	CALL	REW		;start from first sector
	LD	HL,BUFFER	;   and write it to disk
	JP	NZ,ERROR	;check it was written
	LD	DE,FCB		;   and continue till all
	LD	(FCB+3),HL	;   sectors written
WRTLP	CALL	WRITE
	JP	NZ,ERROR
	LD	DE,FCB
	LD	HL,(FCB+3)
	INC	H
	LD	(FCB+3),HL
	LD	DE,FCB
	DJNZ	WRTLP
;
;when re-written, close file and return to DOS
	LD	DE,FCB
	CALL	CLOSE
	JP	NZ,ERROR
	RET
;
ERROR	LD	HL,ERRMSG	;gives same error message
	CALL	DSPLY		;   whatever the cause,
	JP	4030H		;   likely bad name
;
ERRMSG	DEFM	10,10,10,'YOU HAVE MADE AN ERROR!!!!!!!!!!!!',10,10
	DEFM	'Correct syntax is:',10,'MSBNOHI xxxxxxxx/xxx where xxxxxxxx/xxx is filename to change',10,10,13
;
FCB	DS	32		;space allocated for FCB
ENDBUF	DS	1		;store total memory used
	END	5200H
