DSPLY/ ;*****
 ;	OUTPUT ROUTINES FOR THE NON-DOS USER
 ;*****
 ETX	EQU	3		;end-of-text control byte
 CR	EQU	13		;<ENTER> key
 PUT	EQU	1BH		;ROM entry to put a byte
 ;*****
 ;	DSPLY routine outputs to Video (*DO)
 ;	  HL => start of string
 ;	    end string with ETX (X'03') for no CR
 ;	    end string with CR (X'0D') for CR
 ;*****
 DSPLY	LD	DE,401DH	;point to Video DCB
 D1	PUSH	HL		;save string pointer
 D2	LD	A,(HL)		;get a byte
 	CP	3		;check for end of string
 	JR	Z,D3		;exit if ETX
 	PUSH	AF		;else save byte
 	CALL	PUT		;put it to device
 	POP	AF		;recover byte
 	INC	HL		;advance pointer
 	CP	0DH		;check for <ENTER>
 	JR	NZ,D2		;loop if not
 D3	POP	HL		;recover pointer to 1st byte
 	RET			;& go home to rest
 ;*****
 ;	PRINT routine outputs to printer (*PR)
 ;	   parms same as DSPLY
 ;*****
 PRINT	LD	DE,4025H	;point to Printer DCB
 	JR	D1		;& enter put routine
 ;*****
 ;	useful test to return to DOS or BASIC
 ;	depending on system configuration
 ;*****
 LVLFLG	EQU	402FH
 DOS	LD	A,(LVLFLG)	;p/u flag for DOS/BASIC
 	CP	50H		;BASIC will use this value
 	JP	Z,BASIC
 	JP	DOSRET		;else assume DOS
