/*%
ansi.h
/*
 * ansi.h - X3J11 - new keywords, not implemented - 10/25/87
 */

#ifndef	_ANSITYPES
#define	_ANSITYPES
#define	const
#define	signed
#define	volatile
typedef char *voidstar;
#endif
/*%
assert.h
/*
 * assert.h - SVID - 11/04/87
 */

#ifdef	NDEBUG
#define	assert(X)
#else
#define	assert(X)\
if(!(X)){\
fprintf(stderr,"assertion failed: X, file %s, line %d\n",__FILE__,__LINE__);\
abort();}
#endif
/*%
attrib.h
/*
 * attrib.h - 10/31/87
 */

struct attrib
{
	unsigned a_create	: 1;	/* created bit */
	unsigned a_mod		: 1;	/* mod flag */
						: 7;	/* unused */
	unsigned a_system	: 1;	/* system file */
	unsigned a_pds		: 1;	/* PDS - cannot be set */
						: 1;	/* unused */
	unsigned a_vis		: 1;	/* visibility */
	unsigned a_prot		: 3;	/* protection level */
	unsigned short a_lrl;		/* logical record length */
	char a_ownerpw[9];			/* owner password - cannot be retrieved */
	char a_userpw[9];			/* user password - cannot be retrieved */
};

/* modes to pass to sattrib() */
#define	ASETFLAGS	1			/* set bit flags */
#define	ASETLRL		2			/* set logical record length */
#define	ASETOPW		4			/* set owner password */
#define	ASETUPW		8			/* set user password */

/* values for bit fields */
#define	ACREATED	1			/* created file */
#define	ANOTCREATED	0			/* not created file */
#define	AMODIFIED	1			/* modified file */
#define	AUNMODIFIED	0			/* unmodified or backed up file */
#define	ASYSTEM		1			/* system file */
#define	ANOTSYSTEM	0			/* not system file */
#define	APDS		1			/* PDS */
#define	ANOTPDS		0			/* not a PDS */
#define	AINVISIBLE	1			/* invisible file */
#define	AVISIBLE	0			/* visible file */

/* access or protection levels - DOS 5 and DOS 6 */
#define	AFULL		0
#define	ARENAME		2
#define	AREAD		5
#define	AEXEC		6
#define	ANOACCESS	7

/* access or protection levels - DOS 6 only */
#define	AREMOVE		1
#define	AWRITE6		3
#define	AUPDATE		4

/* access or protection levels - DOS 5 only */
#define	AKILL		1
#define	ARESERVED	3
#define	AWRITE5		4
/*%
ctype.h
/*
 * CTYPE/H - 07/09/85
 */

#define	_U	01		/* uppercase */
#define	_L	02		/* lowercase */
#define	_N	04		/* numeric */
#define	_S	010		/* whitespace */
#define _P	020		/* punctuation */
#define _C	040		/* control */
#define _B	0100	/* blank */
#define	_X	0200	/* hex digit */

extern char _ctype[];

#define	isalpha(c)	(_ctype[c]&(_U|_L))
#define	isupper(c)	(_ctype[c]&_U)
#define	islower(c)	(_ctype[c]&_L)
#define	isdigit(c)	(_ctype[c]&_N)
#define	isxdigit(c)	(_ctype[c]&_X)
#define	isspace(c)	(_ctype[c]&_S)
#define ispunct(c)	(_ctype[c]&_P)
#define isalnum(c)	(_ctype[c]&(_U|_L|_N))
#define isprint(c)	(_ctype[c]&(_P|_U|_L|_N|_B))
#define isgraph(c)	(_ctype[c]&(_P|_U|_L|_N))
#define iscntrl(c)	(_ctype[c]&_C)
#define isascii(c)	((unsigned)(c)<=0177)
#define _toupper(c)	((c)-'a'+'A')
#define _tolower(c)	((c)-'A'+'a')
#define toascii(c)	((c)&0177)
/*%
dirent.h
/*
 * dirent.h - IEEE P1003 - 11/01/87
 */

#include <types.h>

typedef struct dir		/* dummy definition - do not change this */
#ifndef	_DIR
{ }
#endif
DIR;

struct dirent
{
	ino_t d_ino;		/* file serial number (DEC) */
	char d_name[14+1];	/* null-terminated filename - w/o password */
};

#ifndef	M80
extern DIR *opendir();
extern struct dirent *readdir();
extern void rewinddir();
extern int closedir();
#endif
/*%
errno.h
/*
 * errno.h - 10/24/87 - system error codes
 */

extern int errno;			/* global error number variable */
extern int sys_nerr;		/* max error number */
extern char *sys_errlist();	/* retrieve system error message */

/*
 * The following are Unix errors
 */

#define	EPERM	25	/* Not owner */
#define	ENOENT	24	/* No such file or directory */
#define	ESRCH	24	/* No such process */
#define	EINTR	64	/* Interrupted system call */
#define	EIO		72	/* I/O error */
#define	ENXIO	 8	/* No such device or address */
#define	E2BIG	65	/* Arg list too long */
#define	ENOEXEC	34	/* Exec format error */
#define	EBADF	16	/* Bad file number */
#define	ECHILD	64	/* No children */
#define	EAGAIN	64	/* No more processes */
#define	ENOMEM	35	/* Not enough space */
#define	EACCES	37	/* Permission denied */
#define	EFAULT	35	/* Bad address */
#define	ENOTBLK	67	/* Block device required */
#define	EBUSY	39	/* Mount device busy */
#define	EEXIST	25	/* File exists */
#define	EXDEV	 8	/* Cross-device link */
#define	ENODEV	 8	/* No such device */
#define	ENOTDIR	66	/* Not a directory */
#define	EISDIR	 6	/* Is a directory */
#define	EINVAL	67	/* Invalid argument */
#define	ENFILE	26	/* File table overflow */
#define	EMFILE	68	/* Too many open files */
#define	ENOTTY	69	/* Not a typewriter */
#define	ETXTBSY	64	/* Text file busy */
#define	EFBIG	30	/* File too large */
#define	ENOSPC	27	/* No space left on device */
#define	ESPIPE	 2	/* Illegal seek */
#define	EROFS	15	/* Read only file system */
#define	EMLINK	64	/* Too many links */
#define	EPIPE	64	/* Broken pipe */
#ifdef	EDOM
#undef	EDOM
#endif
#define	EDOM	70	/* Math arg out of domain of func */
#ifdef	ERANGE
#undef	ERANGE
#endif
#define	ERANGE	71	/* result too large */
#define	EDEADLK	64	/* Deadlock avoided */
#define	ENOLCK	64	/* No locks available */
/*%
fcntl.h
/*
 * fcntl.h - IEEE P1003 - 10/25/87
 */

#define	F_DUPFD		1		/* Return a new file descrptor */
#define	F_GETFD		2		/* Get the close_on_exec flag */
#define	F_SETFD		3		/* Set the close_on_exec flag */
#define	F_GETFL		4		/* Get file status flags */
#define	F_SETFL		5		/* Set file status flags */
#define	F_GETLK		6		/* Get first lock - unsupported */
#define	F_SETLK		7		/* Set, clear segment lock - unsupported */
#define	F_SETLKW	8		/* SETLK with sleep - unsupported */

#define	O_RDONLY	0001	/* Open for reading only */
#define	O_WRONLY	0002	/* Open for writing only */
#define	O_RDWR		0004	/* Open for reading and writing */
#define	O_NDELAY	0010	/* Non-blocking I/O - unsupported */
#define	O_APPEND	0020	/* Append (writes guaranteed at the end) */
#define	O_CREAT		0040	/* Open with file create - unsupported */
#define	O_TRUNC		0100	/* Open with truncation - unsupported */
#define	O_EXCL		0200	/* Exclusive open - unsupported */
#define	O_BINARY	0000	/* Binary file - meaningless, but ok */
#define	O_SYNC		0000	/* Synchronous writes - meaningless, but ok */
/*%
limits.h
/*
 * limits.h - IEEE P1003 and ANSI X3J11 - 10/25/87
 */

#define	ARG_MAX		79				/* max length of args to exec() */
#define	CHAR_BIT	8				/* bits in type char */
#define	CHAR_MAX	UCHAR_MAX		/* max value of type char */
#define	CHAR_MIN	0				/* min value of type char */
#define	CHILD_MAX	0				/* max number of offspring */
#ifndef	CLK_TCK
#define	CLK_TCK		30				/* clock ticks per second */
#endif
#define	FCHR_MAX	16777216L		/* max size of file in bytes (16Mb) */
#define	INT_MAX		SHRT_MAX		/* max value of type int */
#define	INT_MIN		SHRT_MIN		/* min value of type int */
#define	LOCK_MAX	0				/* max number of system lock entries */
#define	LINK_MAX	1				/* max number of links to a file */
#define	LONG_MAX	2147483647L		/* max value of type long int */
#define	LONG_MIN	(-2147483648L)	/* max value of type long int */
#define	MAX_CHAR	79				/* max number of terminal input chars */
#define	NAME_MAX	23				/* max chars in file name */
#define	NGROUPS_MAX	0				/* max number of supplementary groups */
#ifndef	OPEN_MAX
#define	OPEN_MAX	_getfcnt()		/* max number of open files - process
									   (defined by value of @_MAXFILES+3) */
#endif
#define	PASS_MAX	8				/* max chars in password */
#define	PATH_MAX	NAME_MAX		/* max chars in path name */
#define	PID_MAX		0				/* max value for process id */
#define	PIPE_BUF	0				/* size of pipe atomic write */
#define	PIPE_MAX	0				/* max bytes in pipe write */
#define	PROC_MAX	1				/* max number of simutaneous processes */
#define	SCHAR_MAX	127				/* max value of type signed char */
#define	SCHAR_MIN	(-128)			/* min value of type signed char */
#define	SHRT_MAX	32767			/* max value of type short int */
#define	SHRT_MIN	(-32768)		/* min value of type short int */
#define	STD_BLK		256				/* number of bytes in std I/O block */
#ifndef	SYS_NMLN
#define	SYS_NMLN	7				/* length of strings returned by uname() */
#endif
#define	SYS_OPEN	OPEN_MAX		/* max number of open files - system */
#define	UCHAR_MAX	255				/* max value of type unsigned char */
#define	UID_MAX		0				/* max value of user or group id */
#define	UINT_MAX	USHRT_MAX		/* max value of type unsigned int */
#define	ULONG_MAX	4294967295L		/* max value of type unsigned long int */
#define	USHRT_MAX	65535			/* max value of type unsigned short int */
#define	WORD_BIT	16				/* number of bits in word or type int */
/*%
malloc.h
/*
 * malloc.h - 10/25/87
 */

extern char *malloc(), *calloc(), *realloc();
extern void free();
/*%
math.h
/*
 * math.h - 10/25/87
 */

#option	MATHLIB	-1	/* necessary */

#ifndef	M80
extern char *ecvt(), *fcvt(), *gcvt(), *dtoa(), *ftoa();
extern double frexp(), ldexp(), modf(), atod(), fabs(), dfix(), dint(),
	_ddv2(), exp(), log(), log10(), pow(), sqrt(), sinh(), cosh(), tanh(),
	sin(), cos(), tan(), atan(), atan2(), asin(), acos(), floor(), ceil(),
	fmod(), hypot(), strtod(), difftime();
extern float atof(), fabsf(), fatn(), fcos(), fexp(), ffix(), fint(), flog(),
	fraise(), frnd(), fseed(), fsin(), fsqr(), ftan();
extern int dsgn(), fsgn(), errno, rand();
extern void srand();
#endif

#ifdef	EDOM
#undef	EDOM
#endif
#define	EDOM	70			/* illegal function call - argument error */
#ifdef	ERANGE
#undef	ERANGE
#endif
#define	ERANGE	71			/* overflow error */

#define	M_E			2.71828182845904524		/* value of e */
#define	M_LOG2E		1.442695040888963		/* value of log_base_2 of e */
#define	M_LOG10E	0.43429448190325183		/* value of log_base_10 of e */
#define	M_LN2		0.69314718055994531		/* value of log_base_e of 2 */
#define	M_LN10		2.30258509299404568		/* value of log_base_e of 10 */
#define M_PI		3.14159265358979324		/* value of pi */
#define	M_PI_2		1.57079632679489662		/* value of pi over 2 */
#define	M_PI_4		0.78539816339744831		/* value of pi over 4 */
#define	M_1_PI		0.31830988618379067		/* value of one over pi */
#define	M_2_PI		0.63661977236758134		/* value of two over pi */
#define	M_2_SQRTPI	1.283792				/* value of two over sqrt(pi) */
#define	M_SQRT2		1.41421356237309505		/* value of sqrt(2) */
#define	M_SQRT_2	0.70710678118654752		/* value of 1 over sqrt(2) */
#define	HUGE		1.70141183460469225e+38	/* really the biggest! */
#define	HUGE_VAL	HUGE

#define	DOMAIN		1	/* argument domain error */
#define SING		2	/* argument singularity */
#define OVERFLOW	3	/* overflow range error */
#define	UNDERFLOW	4	/* underflow range error */
#define	TLOSS		5	/* total loss of significance */
#define	PLOSS		6	/* partial loss of significance */
#define	DIVBY0		7	/* divide by zero */

struct exception
{
	int	type;			/* type of error */
	char *name;			/* pointer to name of function where error ocurred */
	double	arg1,		/* first argument with which *name was invoked */
			arg2,		/* second argument with which *name was invoked */
			retval;		/* default value returned by the function */
};
/*%
memory.h
/*
 * memory.h - 10/25/87
 */

#include <ansi.h>

#ifndef	M80
extern voidstar memccpy(), memchr(), memcpy(), memset();
extern int memcmp();
#endif
/*%
setjmp.h
/*
 * SETJMP/H - 05/11/86
 */

extern int setjmp();
extern void longjmp();

typedef unsigned jmp_buf[5];	/* setjmp() environment */
/*%
sgtty.h
/* sgtty.h header file for ioctl() */
struct sgttyb {
	char sg_colctr;
	char sg_control;
	char sg_flag;
};
#define TIOCGETP 0			/* get the tty structure data */
#define TIOCSETP 1			/* set the tty structure data */
#define IO_BREAK 0x10		/* mask for #option BREAK in sg_control */
#define IO_TABSTOP 0x0f		/* mask for "tabstop-1" in sg_control */
#define IO_FDCOE 0x80		/* mask for "close_on_exec" flag in sg_control */
/*%
stat.h
/*
 * stat.h - SVID and IEEE P1003 - 10/25/87
 * LDOS defines "other" permissions as those available on a file w/o password
 */

#include <types.h>

struct stat
{
	dev_t			st_dev;			/* device # - (DEC/DRV or Device name) */
	ino_t			st_ino;			/* index node - unused in MC */
	unsigned short	st_mode;		/* modes - see #define */
	short			st_nlink;		/* # of file links - unused */
	unsigned short	st_uid;			/* User ID - MC uses 16-bit user pswd */
	unsigned short	st_gid;			/* Group ID - MC uses 16-bit owner pswd */
	dev_t			st_rdev;		/* unused */
	off_t			st_size;		/* Size of file in bytes */
	time_t			st_atime;		/* time last read - unused in MC */
	time_t			st_mtime;		/* time last written - MOD date */
	time_t			st_ctime;		/* attribute change, mtime - unused */
};

/*
	#define's bit masks for st_mode
*/
#define	S_IFMT		0170000	/* type of file - mask */
#define	S_IFDIR		0040000	/* directory - set if DIR/SYS */
#define	S_IFCHR		0020000	/* character special - set if device */
#define	S_IFBLK		0060000	/* block special - set if SYS */
#define	S_IFREG		0100000	/* regular - set for files */
#define	S_IFMPC		0030000	/* multiplexed char special - unused */
#define	S_IFMPB		0070000	/* multiplexed block channel - unused */

#define	S_ISUID		0004000	/* set user id on execution - unused */
#define	S_ISGID		0002000	/* set group id on execution - unused */
#define	S_ISVTX		0001000	/* save swapped text - unused */
#define	S_ENFMT		0		/* SVID record locking - unused */

#define	S_IRWXU		0000700	/* rwx permissions, owner */
#define	S_IREAD		0000400	/* read permission, owner */
#define	S_IWRITE	0000200	/* write permission, owner */
#define	S_IEXEC		0000100	/* execute/search permission, owner */
#define	S_IRUSR		S_IREAD	/* IEEE/SVID */
#define	S_IWUSR		S_IWRITE
#define	S_IXUSR		S_IEXEC

#define	S_IRWXG		0000070	/* rwx permissions, group */
#define	S_GREAD		0000040	/* read permission, group */
#define	S_GWRITE	0000020	/* write permission, group */
#define	S_GEXEC		0000010	/* execute/search permission, group */
#define	S_IRGRP		S_GREAD	/* IEEE/SVID */
#define	S_IWGRP		S_GWRITE
#define	S_IXGRP		S_GEXEC

#define	S_IRWXO		0000007	/* rwx permissions, other */
#define	S_UREAD		0000004	/* read permission, other */
#define	S_UWRITE	0000002	/* write permission, other */
#define	S_UEXEC		0000001	/* execute/search permission, user */
#define	S_IROTH		S_UREAD	/* IEEE/SVID */
#define	S_IWOTH		S_UWRITE
#define	S_IXOTH		S_UEXEC

/* IEEE macros */
#define	S_ISDIR(m)	((m&S_IFMT)==S_IFDIR)	/* non-zero if directory */
#define	S_ISCHR(m)	((m&S_IFMT)==S_IFCHR)	/* non-zero if character special */
#define	S_ISBLK(m)	((m&S_IFMT)==S_IFBLK)	/* non-zero if block special */
#define	S_ISREG(m)	((m&S_IFMT)==S_IFREG)	/* non-zero if regular */
#define	S_ISFIFO(m)	0						/* never true - unused */
/*%
stdarg.h
/*
 * stdarg.h - ANSI X3J11 - 10/25/87
 */

#define	va_list	char*
#define va_start(ap,first) (ap=(char*)&first+sizeof(first))
#define va_end(ap)
#define va_arg(ap,type) (((type*)(ap+=sizeof(type)))[-1])
/*%
stddef.h
/*
 * stddef.h - ANSI X3J11 - 11/01/87
 */

#ifndef	_STDDEF
#define	_STDDEF
typedef short ptrdiff_t;		/* difference of two pointers */
typedef unsigned short size_t;	/* result of sizeof() */
#ifndef	NULL
#define	NULL	((char *) 0)	/* NULL pointer */
#endif
extern int errno;				/* system error variable */
/*
 * The following macro uses the value 0 in a clever kludge in order to imple-
 * ment the offsetof() macro. It will not work for a member which is an array -
 * use member[0] as 2nd arg in this case. Cannot be used in static initializer.
 */
#define	offsetof(S,M)	((char*)&((S*)0)->(M)-(char*)0)
#endif
/*%
stdio.h
/*
 * stdio.h - ANSI X3J11 - 11/01/87
 */

#include <stddef.h>
#include <types.h>

#define	EOF			0xFFFF
#define	EOL			'\n'
typedef char *FILE;
#ifndef	NULL
#define	NULL		((char *) 0)	/* NULL pointer */
#endif
#define	TRUE		1
#define	FALSE		0
#define	ON			0xFFFF
#define	OFF			0
#define	BUFSIZ		256
#define	STDIN		0
#define	STDOUT		1
#define	STDERR		2
#define	O_BRIEF		6
#define	O_KBECHO	4
#define	O_ERRORMSG	0
#define	MC

/* ANSI stuff */
typedef	long fpos_t;	/* for fgetpos(), fsetpos() */
#ifndef	OPEN_MAX
#define	OPEN_MAX	_getfcnt()		/* max number of open files - process
									   (defined by value of @_MAXFILES+3) */
#endif

/* for fseek() */
#ifndef	_SEEK
#define	_SEEK
#define	SEEK_SET	0	/* set file pointer to offset */
#define	SEEK_CUR	1	/* set file pointer to current plus offset */
#define	SEEK_END	2	/* set file pointer to EOF minus offset */
#endif

/* note: _IOFBF, _IOLBF, _IONBF, L_tmpnam, TMP_MAX not implemented */

#ifndef	M80
extern void perror(), rewind();
extern int clearerr(), fclose(), feof(), ferror(), fflush(), fgetc(),
	fgetpos(), fileno(), fprintf(), fputc(), fputs(), fscanf(), fseek(),
	fsetpos(), getc(), getchar(), printf(), putc(), putchar(), puts(),
	rename(), scanf(), sprintf(), sscanf(), ungetc(), vfprintf(), vprintf(),
	vsprintf(), remove(), unlink();
extern size_t fread(), fwrite();
extern FILE *fopen(), *freopen();
extern off_t ftell();
extern char *fgets(), *gets();
/* note: setbuf(), setvbuf(), tmpfile(), tmpnam() not implemented */
#endif
/*%
stdlib.h
/*
 * stdlib.h - ANSI X3J11 - 10/25/87
 */

#include <ansi.h>

typedef struct  div_t {  int quot, rem; }  *div_t;
typedef struct ldiv_t { long quot, rem; } *ldiv_t;

#define	RAND_MAX		32767
#define	EXIT_SUCCESS	0
#define	EXIT_FAILURE	(-1)

#ifndef	M80
extern void abort(), exit(), free(), qsort(), srand();
extern int abs(), atoi(), rand(), system();
extern double atod(), strtod();
extern float atof();	/* should be double; oh, well */
extern long atol(), labs(), strtol();
extern voidstar bsearch(), calloc(), malloc(), realloc();
extern div_t div();
extern ldiv_t ldiv();
unsigned long strtoul();
#endif
/*%
string.h
/*
 * string.h - ANSI X3J11 - 11/01/87
 */

#include <memory.h>
#include <stddef.h>

#ifndef	M80
extern char *strcat(), *strchr(), *strcpy(), *strncat(), *strncpy(),
	*strpbrk(), *strrchr(), *strstr(), *strtok(), *strdup(), *strerror();
extern int strcmp(), strncmp(), strcoll();
extern size_t strcspn(), strlen(), strspn(), strftime();
#endif

/* note: strxfrm() not implemented */
/*%
time.h
/*
 * time.h - IEEE P1003 and ANSI X3J11 - 11/05/87
 */

#include <stddef.h>

#ifndef	_TIME_T
#define	_TIME_T
typedef long time_t;		/* UNIX time format */
#endif
#ifndef	CLK_TCK
#define	CLK_TCK	30			/* clock ticks per second */
#endif
typedef long clock_t;		/* system clock tick format */

struct tm
{
		int tm_sec;			/* seconds 0-59 */
		int	tm_min;			/* minutes 0-59 */
		int	tm_hour;		/* hours 0-23 */
		int	tm_mday;		/* day of month 1-31 */
		int	tm_mon;			/* month of year 0-11 */
		int	tm_year;		/* year base 1900 */
		int	tm_wday;		/* day of week 0-6; Sun=0 */
		int	tm_yday;		/* day of year 0-365 */
		int	tm_isdst;		/* positive if daylight saving time */
							/* set to -1, not implemented */
};

#ifndef	M80
extern char *asctime(), *ctime();
extern clock_t clock();
extern double difftime();
extern struct tm *localtime(), *gmtime();
extern time_t mktime(), time();
extern size_t strftime();
#endif
/*%
types.h
/*
 * types.h - IEEE P1003 - 10/25/87
 */

#ifndef	_TYPES
#define	_TYPES
typedef int ino_t;			/* inode format */
typedef int dev_t;			/* device format */
typedef long off_t;			/* file offset format */
#ifndef	_TIME_T
#define	_TIME_T
typedef long time_t;		/* UNIX time format */
#endif
typedef long ttime_t;		/* system clock tick format */
typedef int daddr_t;		/* disk block address format */
#endif
/*%
unistd.h
/*
 * unistd.h - IEEE P1003 - 11/01/87
 */

/* for access() */
#define	R_OK	4		/* test for read permission */
#define	W_OK	2		/* test for write permission */
#define	X_OK	1		/* test for execute or search permission */
#define	F_OK	0		/* test for existence of file */

/* for lockf() - not implemented */

/* for lseek() */
#ifndef	_SEEK
#define	_SEEK
#define	SEEK_SET	0	/* set file pointer to offset */
#define	SEEK_CUR	1	/* set file pointer to current plus offset */
#define	SEEK_END	2	/* set file pointer to EOF minus offset */
#endif

/* note: IN_PATH and IEEE1003 not implemented */
/*%
ustat.h
/*
 * ustat.h - SVID and IEEE P1003 - 10/25/87
 */

#include <types.h>

struct ustat
{
	/* SVID/IEEE fields */
	daddr_t f_tfree;			/* free blocks in file system */
	ino_t f_tinode; 			/* free inodes (file slots) in file system */
	char f_fname[9];			/* file system name */
	char f_fpack[9];			/* file system pack (we use date) */
	/* implementation-defined fields */
	unsigned char f_osver;		/* file system OS version in BCD */
	unsigned char f_cyls;		/* file system cylinders */
	struct f_config 			/* file system configuration bit flags */
	{
		/* high byte */
		int f_type		: 1;	/* 7:   0=system, 1=data disk */
		int f_density	: 1;	/* 6:   0=single, 1=double density floppy */
		int f_sides		: 1;	/* 5:   0=1, 1=2 sided floppy */
						: 1;	/* 4:   reserved */
						: 1;	/* 3:   reserved */
		int f_gpt		: 3;	/* 2-0: granules per track - 1 */
		/* low byte unused */
	} f_config;
	unsigned char f_media[11];	/* file system media data block */
	daddr_t f_talloc; 			/* allocated blocks in file system */
	ino_t f_uinode; 			/* used inodes (file slots) in file system */
};
/*%
utime.h
/*
 * utime.h - IEEE P1003 and SVID
 */

#include <types.h>

struct utimbuf
{
	time_t actime;	/* time of last access - not implemented */
	time_t modtime;	/* time of last modification */
};
/*%
utsname.h
/*
 * utsname.h - IEEE P1003 - 10/25/87
 */

#ifndef	SYS_NMLN
#define	SYS_NMLN	7			/* length of strings returned by uname() */
#endif

struct utsname
{
	char sysname[SYS_NMLN];		/* OS name */
	char nodename[SYS_NMLN];	/* network node name - unsupported */
	char release[SYS_NMLN];		/* OS release level */
	char version[SYS_NMLN];		/* OS version */
	char machine[SYS_NMLN];		/* hardware type */
};
/*%
varargs.h
/*
 * varargs.h - SVID - 10/25/87
 */

#define	va_list	char*
#define va_dcl int va_alist;
#define va_start(list) (list=(char *)&va_alist)
#define va_end(list)
#define va_arg(list,mode) (((mode*)(list+=sizeof(mode)))[-1])
/*%
z80regs.h
/*
 * Z80REGS/H - Definitions for Z80 register structures, used with call()
 */
union REGS
{	struct		/* double register variables */
	{	unsigned short af;
		unsigned short bc;
		unsigned short de;
		unsigned short hl;
		unsigned short ix;
		unsigned short iy;
	} wordregs;
	struct		/* single register variables */
	{	unsigned char f;
		unsigned char a;
		unsigned char c;
		unsigned char b;
		unsigned char e;
		unsigned char d;
		unsigned char l;
		unsigned char h;
		unsigned char lx;
		unsigned char hx;
		unsigned char ly;
		unsigned char hy;
	} byteregs;
};

/* simpler definitions */

#define	AF	wordregs.af
#define	BC	wordregs.bc
#define	DE	wordregs.de
#define	HL	wordregs.hl
#define	IX	wordregs.ix
#define	IY	wordregs.iy
#define	F	byteregs.f
#define	A	byteregs.a
#define	C	byteregs.c
#define	B	byteregs.b
#define	E	byteregs.e
#define	D	byteregs.d
#define	L	byteregs.l
#define	H	byteregs.h
#define	LX	byteregs.lx
#define	HX	byteregs.hx
#define	LY	byteregs.ly
#define	HY	byteregs.hy
