;VIDSAV/CMD USES X'02' TO FILE VIDEO INTO MEMORY
;X'03' TO RETRIEVE VIDEO FROM HIGH MEMORY AND
;X'04' TO SWAP CURRENT VIDEO FOR STORED VIDEO
;IT  FILTERS BOTH *KI AND *DO
	TITLE	<VIDSAV/ASM>
STORE 	EQU	02H
VIDEO	EQU	03C00H
GET	EQU	03H
SWAP	EQU	04H
@ABORT	EQU	04030H		;ERROR ABORT
@EXIT	EQU	0402DH
@DSPLY	EQU	04467H
@KBD	EQU	02BH
DODCB$	EQU	0401DH
KIDCB$	EQU	04015H
PARAM1	EQU	04476H
PARAM3	EQU	04454H
	ORG	05200H
	PUSH	HL		;SAVE PARAMETER POINTER
	LD	A,(0125H)	;LOOK IN FLAG
	CP	049H		;49=MOD III
	JR	Z,MOD3	
	LD	A,(430FH)	;check for JCL in progress
	BIT	5,A		;set if DO in effect
	JR	Z,MODIF1
	LD	HL,43BEH	;mod 1 kijcl$
	LD	(KIJCL1+1),HL	;modify into code
	LD	(KIJCL2+1),HL
	LD	(KIJCL3+1),HL
MODIF1	LD	HL,PARAM1	;STUFF @PARAM INTO CODE
	LD	(PARAM+1),HL
	LD	HL,04049H	;MOD1 HIGH$
	LD 	DE,0447BH	;@LOGOT
	JR	LDHIGH
MOD3	LD	HL,PARAM3	;STUFF M3 @PARAM
	LD	(PARAM+1),HL
	LD	A,(442BH)	;check for JCL in progress
	BIT	5,A		;set if DO in effect
	JR	Z,MODIF3
	LD	HL,42BEH	;mod 1 kijcl$
	LD	(KIJCL1+1),HL	;modify into code
	LD	(KIJCL2+1),HL
	LD	(KIJCL3+1),HL
MODIF3	LD	HL,04411H	;MOD3 HIGH$
	LD	DE,0428AH	;@LOGOT
LDHIGH	LD	(BUFFER+1),HL	;INSTALL HIGH$
	LD	(NEWHI+2),HL
	LD	C,(HL)		;PUT CONTENTS LSB IN C
	INC	HL		;POINT TO MSB
	LD	B,(HL)		;PUT MSB IN B
	LD	(VIDSAV+2),BC	;STUFF OLD HIGH$ IN HEADER
	LD	(ERROR+1),DE	;INSTALL @LOGOT
;
;**** CHECK FOR DEVICE CONDITIONS
;
	LD	A,(DODCB$)	;VIDEO TYPE BYTE
	CALL	CHKDEV		;SEE	IF ROUTED OR NIL
KIJCL1	LD 	A,(KIDCB$)	;KI TYPE BYTE
	CALL	CHKDEV		;SEE IF ROUTED OR NIL
	JR	FILTOK
CHKDEV	BIT	3,A		;SET NIL?
	JR	NZ,DEVNIL
	BIT	4,A		;ROUTED?
	JR	NZ,DEVROUT
	RET
FILTOK	LD	HL,(DODCB$+1)	;POINT TO OLD DO DRIVER
	LD	(OLDDO+1),HL	;INSTALL IN CODE
KIJCL2	LD	HL,(KIDCB$+1)	;DO IT TO KI DRIVER
	LD	(START+1),HL
	LD	HL,SIGNON	;SAY HELLO
	CALL	@DSPLY
;
;**** ESTABLISH MEMORY BUFFER
;
BUFFER	LD	HL,(0000H)	;OLD HIGH$
	LD	A,20H		;ASCII SPACE
	LD	(HL),A		;PUT SPACE AT HIGH$
	LD	E,L		;PUT HL -1 IN DE
	LD	D,H
	DEC	DE
	LD	BC,0402H	;LOOP FOR 1K+2BYTES
	LDDR			;WRITE 1026 SPACES
;HIGH$ NOW = DE
;
	EX	DE,HL
	PUSH	HL		;SAVE DESTINATION
	INC	DE		;POINT TO BUFFER START
	LD	(BUFORG+1),DE	;INSTALL BUFFER START
	LD	(BUFORG2+1),DE	;INSTALL BUFFER START
	OR	A		;CLEAR CARRY
	LD	DE,LAST			;GET END
	SBC	HL,DE		;FIND OFFSET
	PUSH	DE		;SAVE LAS
	EX	DE,HL
	LD	HL,(REL1)	;ABS ADDRESS OF REL1
	ADD	HL,DE		;CALC NEW ADDRESS
	LD	(REL1),HL	;AND MODIFY CODE
	LD	HL,(REL2)
	ADD	HL,DE	
	LD	(REL2),HL
	LD	HL,OVIDSAV
	ADD	HL,DE
	LD	(REL3),HL
	POP	HL		;POINT TO LAST BYTE
	POP	DE		;POINT TO DESTINATION
	LD	BC,LAST-VIDSAV+1	;LENGTH OF MODULE INTO BC
	LDDR			;RELOCATE CODE
NEWHI	LD	(0000H),DE	;WRITE HIGH$ TO SYSTEM
	INC	DE		;POINT TO CODE START
	POP	HL		;RETRIEVE PARAM POINTER
	PUSH	DE		;SAVE CODE START
	LD	DE,PARMS	;POINT TO TABLE
PARAM	CALL	0000H		;CALL @PARAM
KEY	LD	BC,-1		;DEFAULT IS K=Y
	LD	A,B		;CHECK IF K=N
	OR	C
	POP	DE		;GET CODE START
	JR	Z,SKIPKI	;BYPASS *KI
KIJCL3	LD	(KIDCB$+1),DE	;SET DCB TO MODULE
SKIPKI	LD	HL,0000H	;POINT HL TO OUTPUT SEC
REL3	EQU	$-2
	LD	(DODCB$+1),HL	;& STUFF IN DCB
	JP	@EXIT		;BACK TO LDOS
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
ERROR	CALL	0000H		;CALL @LOGOT
	JP	@ABORT
;
;****	MESSAGE SECTION
;
SIGNON	DB	1CH,1FH,'VIDEO SAVER - LDOS Keyboard/Video Filter - Version 5.1',0AH
	DB	'Copyright (c) 1982 by Logical Systems Incorpoated',0AH,0DH
NILMSG	DB	'Device is not active',0DH
ROUTMSG	DB	'Device is Routed',0DH
PARMS	DB	'KEY   '	;KEY= PARM
	DW	KEY+1
	DB	'K     '
	DW	KEY+1
	NOP
;
;****	VIDSAV/CMD START OF CODE
;
VIDSAV	JR	START
	DW	0000H
	DB	6,'VIDSAV'
START	CALL	0000H		;ALLOW NORMAL DRIVER
VIDSAV2	PUSH	AF		;SAVE FLAGS & CHAR
	OR	A
	JR	Z,NOJOB		;IF NO CHARACTER, EXIT
	DEC	A		;WAS A a BREAK?
	JR	Z,NOJOB		;IF YES EXIT
	CP	04H		;IS A < 4?
	CALL	C,DOCOM		;GO IF 1 2 OR 3
REL1	EQU	$-2
NOJOB	POP	AF		;RESTORE FLAGS
	RET			;& EXIT
DOCOM	DEC	A		;COMMANDS ARE 0 1 2
	CP	02H		;IS IT 2?
	JR	Z,DOSWAP	;GO IF YES
GETSAVE	LD	HL,VIDEO	;POINT TO SCREEN
BUFORG	LD	DE,0000H	;POINT TO BUFFER
	LD	BC,0400H	;1024 INTO BC
	OR	A		;IS A=0?
	JR	Z,DOSTOR	;DO VID TO MEM
	EX	DE,HL		;OTHERWISE MEM TO VID
DOSTOR	LDIR
	JR	NZ,GETCURS	;RESTORE CURSOR IF GET
	LD	HL,(DODCB$+3)	;GET CURSOR POS
	EX	DE,HL
	LD	(HL),E		;LSB OF CURSOR TO MEM
	INC	HL
	LD	(HL),D		;STUFF MSB
	RET			;EXIT
GETCURS	LD	E,(HL)		;GET LSB OF CUR FR BUFF
	INC	HL
	LD	D,(HL)		;GET MSB
	LD	HL,DODCB$+3	;POINT HL TO DCB
	LD	(HL),E		;PUT CURSOR INTO DCB
	INC	HL
	LD	(HL),D
	RET
DOSWAP	LD	BC,0400H	;1024 TIMES
	DI
	LD	HL,VIDEO	;POINT HL TO SCREEN
BUFORG2	LD	DE,0000H	;POINT TO BUFFER ORG
LOOP	PUSH	BC		;SAVE COUNT
	LD	B,(HL)		;PUT VIDEO IN B
	LD	A,(DE)		;PUT BUFFER IN A
	EX 	DE,HL		;SWAP POINTERS
	LD	(HL),B		;PUT B IN BUFFER
	LD	(DE),A		;PUT A IN VIDEO
	INC	HL		;POINT TO NEXT BYTE
	INC	DE
	POP	BC		;GET COUNT
	DEC	BC		;IS C ZERO?
	LD	A,B		;MSB TO B
	OR	C
	JR	NZ,LOOP		;IF NOT CONTINUE
	LD	HL,DODCB$+3	;POINT HL TO DCB CURSOR
	LD 	B,2		;SET UP LOOP
LOOP2	LD	C,(HL)		;PUT LSB OF CURSOR IN B
	LD	A,(DE)		;PUT MEM CURSOR LSB
	EX	DE,HL		;SWAP POINTERS
	LD	(HL),C		;REPLACE DATA
	LD	(DE),A
	INC	HL
	INC 	DE
	DJNZ	LOOP2		;LOOP IF NOT DONE
	EI
	RET			;EXIT SWAP
OVIDSAV	PUSH	AF		;SAVE STATUS WORD
	LD	A,C		;PUT CHARACTER IN A
	CALL	VIDSAV2		;DO WHAT WE MUST
REL2	EQU	$-2
	OR	A		;CLEAR FLAGS
	DEC	A		;CHECK FOR X'01'
	JR	Z,OLD		;HANDLE IF YES
	CP	04H		;IS A < 4
	JR	C,SKIPDO	;THROW AWAY 1 2 3
OLD	POP	AF		;RESTORE FLAGS
OLDDO	JP	0000H		;GOTO OLD DRIVER
SKIPDO	POP	AF		;RESORE FLAGS
LAST	RET			;AND LEAVE
	END	05200H
