;****	TRAP/FLT	VERSION 5.1
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
;
	ORG 5200H
	PUSH	DE		;save DCB
	PUSH	HL		;save parameters
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,MOD1EQU
	JR	LDHIGH
M3	LD	HL,MOD3EQU
LDHIGH	LD	IX,PARMREL
CKREL	LD	D,(IX+1)
	LD	E,(IX)
	LD	A,(HL)
	OR	A
	JR	Z,DUNREL
	LD	(DE),A
	INC	HL
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	INC	IX
	INC	IX
	INC	HL
	JR	CKREL
;
DUNREL	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JP	NZ,DEVNIL
	BIT	4,A		;Routed?
	JP	NZ,DEVROUT
	BIT	1,A		;Output device?
	JP	Z,NOTOUT
;
;****	Pick up parameters
	POP	HL		;recover command line
	LD	DE,PARMTBL
PARM	CALL	0000H		;@param call
	JP	NZ,PERROR
;
CHAR	LD	BC,0000H
	LD	A,C
	OR	B		;char entered?
	JR	Z,PERROR	;must have char!
	LD	(TCHAR+1),A	;install in filter code
;
;****	ok to filter device
	POP	IX		;get dcb
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(OUTP1+1),HL	;install in filter code
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHI),HL	;put in filter header
	LD	BC,LENGTH	;len of filter
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL		;filter relo address
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	EX	DE,HL		;DE to new address
	LD	HL,TRAP		;HL to filter code
	LDIR			;relocate filter
	JP	@EXIT		;all done
;
PERROR	LD	HL,PARMSG
	JR	ERROR
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'TRAP - Character Trap Filter - Version 5.1',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
;
PARMSG	DB	'Parameter error',0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
PARMTBL	DB	'CHAR  '
	DW	CHAR+1
	DB	'C     '
	DW	CHAR+1
	DW	0000H		;end of table
;
;HIGH$,HIGH$,@LOGOT,@PARAM
;
MOD1EQU	DW	4049H,4049H,447BH,4476H,0000H
MOD3EQU	DW	4411H,4411H,428AH,4454H,0000H
PARMREL	DW	MHI+1,SHI+1,ERROR+1,PARM+1
;
TRAP	JR	START
OLDHI	DW	0000H		;HIGH$ before filtering
	DB	START-FNAME
FNAME	DB	'TRAP'
;
START	JR	C,OUTP1		;go if input
	PUSH	AF
	LD	A,C
TCHAR	CP	0		;char to trap
	JR	NZ,DUNTRAP
	POP	AF
	XOR	A
	RET
DUNTRAP	POP	AF
OUTP1	JP	0000H
;
LENGTH	EQU	$-TRAP
	END	5200H
