;
;SLOSTEP/DCT
;An addition to the LDOS disk drivers to provide an
;Increased delay for head settling whenever the disk
;Function would cause the head to move.
;This may provide greater reliability with certain
;Double-headed drives
;
DELAY1	EQU	100		;Delay before stepping
DELAY	EQU	1350		;<=countdown delay for head settling
;
;SYSTEM ENTRY POINT DEFINITIONS...
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
@PAUSE	EQU	60H
DCT$	EQU	4700H
HIGH$	EQU	4049H
HIGH3	EQU	4411H
;
;
	ORG	6000H
;On entry to a /DCT program called by the
;SYSTEM (DRIVE=n,DRIVER), DE contains the address of the
;Specified DCT
;
ENTRY:	PUSH	DE		; Save DCT pointer passed by SYSTEM
	LD	HL,LOGON	; =>Logon message
	CALL	@DSPLY		; print it
	LD	HL,(HIGH$)	;Pick up available memory pointer
; CHECK FOR MOD 3...
	LD	A,(125H)	; TEST FOR MOD III
	CP	'I'		; match if mod III 
	JR	NZ,MODI		; go if Mod I
; IF THIS IS A MOD III
	LD	HL,HIGH3	;Mod 3 HIGH$
	LD	(NMEM),HL	;Save for later
	LD	HL,(4411H)	;Get contents
;
MODI:	LD	(MYMEM),HL	;Store away for relocating
	LD	(OLDHI),HL	;And in header
;
	POP	IY		; put DCT pointer in IY
; IY=> DCT FOR THIS DRIVE
	LD	H,(IY+2)
	LD	L,(IY+1)	;HL=Driver address
	LD	(DVR1),HL	;Stuff into program..
	LD	(DVR2),HL	;Everywhere needed
	LD	(DVR3),HL
	LD	DE,$-$		;<=HIGH$ value
MYMEM	EQU	$-2
	LD	HL,LAST		;Relocate working parts
	LD	BC,LEN		;Byte count to move
	LDDR			;Move to high memory
	LD	(HIGH$),DE	;Lower HIGH$ to protect
NMEM	EQU	$-2		;<=self modifying for mod 1/3
	INC	DE		;Point to driver start
	LD	(IY+1),E	;Store new driver address
	LD	(IY+2),D	;In DCT for drive
	JP	@EXIT
;
LOGON:	DB	'Stepping delay for double headed drives',0DH
;
;LDOS type header for hi-memory module:
START:	JR	DRIVER		;Branch around header
OLDHI:	DW	0		;<=pointer to previous HIGH$
	DB	5,'STEPS'	;Length / name
;
;Actual routine
;Trap only functions that require head movement
DRIVER:	LD	A,B		; GET FCN CODE
	CP	0AH		; VERIFY?
	JR	Z,CHECK
	CP	0DH		; WRITE SECTOR?
	JR	Z,CHECK
	CP	0EH		; WRITE SYSTEM SEC?
	JR	Z,CHECK		; SAME
	CP	9		; READ SECTOR?
	JR	Z,CHECK
	CP	6		;SEEK?
	JR	Z,CHECK
	CP	5		;STEPIN?
	JR	Z,STEPIN
	CP	4		;RESTORE?
	JR	Z,STEPIN	;Same for RESTORE
OLDDVR:	JP	$-$		;Go direct to driver if other function
DVR1	EQU	$-2
;
STEPIN:	PUSH	BC
	LD	BC,100
	CALL	@PAUSE
	POP	BC
	PUSH	BC
	JR	CMDOUT		;B already has correct fcn number
;
;Check if head is going to move for these commands...
CHECK:	LD	A,D		;Desired track
	CP	(IY+5)		;Current head position
	JR	Z,OLDDVR	;Go direct if not moving head
;
;If head is going to move.....
GOSLO:	PUSH	BC
	LD	BC,100
	CALL	@PAUSE		;Slight pause, then..
	LD	B,6		;Seek track first...
;
CMDOUT:	CALL	$-$		;Using old driver
DVR2	EQU	$-2
	LD	B,7		;Tstbsy
	CALL	$-$		;Check disk status/wait till done
DVR3	EQU	$-2
	LD	BC,DELAY	;Delay countdown
	CALL	@PAUSE		;Let heads settle
	POP	BC		;Get back function code
	LD	A,B		;Was it a seek, stepin or restore?
	CP	7
	JR	NC,OLDDVR	;Complete function if read or write
	XOR	A		;Set Z flag for good completion
	RET			;Done if seek or stepin
;
LAST	EQU	$-1		;Symbols for assembly 
LEN	EQU	$-START
;
	END	ENTRY
