;REMOVE/ASM - 12/18/81 - Roy Soltoff
;*=*=*
LF	EQU	10
CR	EQU	13
@ABORT	EQU	04030H
@CLOSE	EQU	04428H
@DSPLY	EQU	04467H
@ERROR	EQU	4409H
@EXIT	EQU	0402DH
@FEXT1	EQU	04473H
@FEXT3	EQU	444BH
@FSPEC	EQU	0441CH
@GET	EQU	00013H
@INIT	EQU	4420H
@LOGOT1	EQU	0447BH
@LOGOT3	EQU	428AH
@OPEN	EQU	04424H
@PARAM1	EQU	04476H
@PARAM3	EQU	4454H
@POSN	EQU	04442H
@PUT	EQU	0001BH
@REW	EQU	0443FH
@WRITE	EQU	04439H
KFLAG$1	EQU	04423H
KFLAG$3	EQU	429FH
SFLAG$1	EQU	0430FH
SFLAG$3	EQU	442BH
	ORG	5200H
STRIP	PUSH	HL		;SAve INBUF$ pointer
	LD	A,(125H)	;Model I or III
	CP	'I'
	JR	NZ,BEGIN	;Go if Model I
	LD	HL,@FEXT3
	LD	(FEXT+1),HL
	LD	HL,@PARAM3
	LD	(PARAM+1),HL
	LD	HL,@LOGOT3
	LD	(LOGOT+1),HL
	LD	HL,KFLAG$3
	LD	(KFLAG+1),HL
	LD	HL,SFLAG$3
	LD	(SFLAG),HL
BEGIN	LD	HL,(KFLAG+1)	;Strip BREAK, etc.
	LD	A,(HL)		;  from KFLAG$
	AND	0F8H
	LD	(HL),A
	LD	HL,HELLO$	;Hello message
	CALL	@DSPLY
	POP	HL
	LD	DE,FCB1		;Get source filespec
	CALL	@FSPEC
	JP	NZ,SPCREQ
	PUSH	HL
	LD	HL,TXTEXT	;Default to TXT
	CALL	FEXT
	POP	HL
	LD	DE,FCB2		;Get destination spec
	CALL	@FSPEC
	JR	Z,$+5		;Use spec if entered
	CALL	CVRTUC		;Cvrt dest spec to uc
	PUSH	HL		;Save INBUF pointer
	LD	DE,FCB2		;Get default extension
	LD	HL,TXTEXT
	CALL	FEXT
	POP	HL		;Rcvr INBUF$ ptr
	LD	DE,PRMTBL
	CALL	PARAM		;P/u parameter
	JP	NZ,PRMERR
	CALL	PRSPC		;Xfer matching specs
	LD	DE,FCB1
	LD	HL,BUF1		;Establish linkage to
	LD	B,0		;  source file
	CALL	@OPEN
	JP	NZ,IOERR	;Go on error
	LD	DE,FCB2
	LD	HL,BUF2		;Establish linkage to
	LD	B,0		;  destination file
	CALL	@INIT
	JP	NZ,IOERR
;*=*=*
;	Check if source & destination are the same
;*=*=*
	LD	HL,(FCB1+6)	;If SRC & DST have same
	LD	DE,(FCB2+6)	;  DEC & drive, they are
	XOR	A		;  identical, abort if so
	SBC	HL,DE
	JP	Z,DSTREQ
;*=*=*
;	Write revised ERN for space check
;*=*=*
	LD	BC,(FCB1+12)	;write a format sector
	CALL	WRERN
	LD	HL,0		;reset destination to 0
	LD	(FCB2+12),HL
	CALL	@REW
;*=*=*
;	Transfer requested strip char to test area
;*=*=*
BPARM	LD	DE,0		;Test for ASCII input
	INC	D		;D<>0 => B="c"
	DEC	D		;D=0 => B=X'xx'
	LD	A,(DE)		;P/u assumed string
	JR	NZ,$+3		;Go if string entry
	LD	A,E		;P/u hex or dec entry
	LD	(PUCHAR+1),A
	LD	HL,STRPCH$	;Convert back to ASCII
	CALL	HEXDEC		;  & stuff in message
	LD	HL,STRPNG$	;Inform user
	CALL	@DSPLY
;*=*=*
;	Routine to read characters from the source
;*=*=*
RDLOOP	DEC	C		;Count down for break
	CALL	Z,CKBRK		;  every 256 chars
	LD	DE,FCB1		;Fetch a char
	CALL	@GET
	JR	Z,PUCHAR
	CP	1CH
	JP	NZ,IOERR
	LD	DE,FCB2		;Close up the destination
	CALL	@CLOSE		;  at end-read of source
	JP	NZ,IOERR
	JP	DONE
;*=*=*
;	Routine to put OK characters to destination
;*=*=*
PUCHAR	LD	B,0		;P/u char to strip
	CP	B		;Match the one read?
	JR	Z,RDLOOP	;Don't write if match
	LD	DE,FCB2
	CALL	@PUT		;Else put it out
	JR	Z,RDLOOP
	JP	IOERR
;*****
;	Routine xfers partial filespec & cvrts to UC
;*****
CVRTUC	CALL	CVRT
	LD	A,CR
	LD	(DE),A		;ensure end-of-line
	RET
CVRT0	INC	HL
CVRT	LD	A,(HL)		;P/u possible dest char
	CP	CR		;Exit on CR
	RET	Z
	CP	' '		;Loop on space
	JR	Z,CVRT0
	DEC	HL		;backup to 1st separator
	LD	B,32		;max 32 chars
COP1	LD	A,(HL)		;transfer the partial
	CP	'a'		;cvrt lc to uc
	JR	C,$+4
	RES	5,A
	LD	(DE),A		;filespec until paren
	CP	CR
	RET	Z
	CP	'('
	RET	Z
	INC	HL		;or end-of-line
	INC	DE		;or 32 chars max
	DJNZ	COP1
	RET
;*****
;	match source & destination specs for defaults
;*****
PRSPC	LD	HL,FCB1		;match up default spec
	LD	DE,FCB2		;to file 2
	LD	A,(DE)
	CP	CR
	JP	Z,DSTREQ
	PUSH	DE		;HL=FCB1, DE=FCB2
	LD	A,(DE)		;p/u a dest char
	CP	'A'		;xfer the source field
	CALL	C,PRSPC7	;if dest doesn't start
	LD	B,'/'		;with an alpha, init to
	CALL	PRSPC2		; test for extension
	LD	B,'.'		;init to test for pswd
	CALL	PRSPC2
	POP	DE
	RET
PRSPC1	INC	DE
PRSPC2	LD	A,(DE)		;is the next char the
	CP	B		;separator to look for
	JR	Z,PRSPC3
	CP	'A'		;if "A" to whatever, ck
	JR	NC,PRSPC1	;next dest char
	CP	'0'		;if 0-9, continue to ck
	JR	C,PRSPC4	;subsequent dest chars
	CP	'9'+1
	JR	C,PRSPC1
	JR	PRSPC4		;Go to reuse source field
PRSPC3	INC	DE
	RET
;*****
;	scan source spec to see if it contains the field
;*****
PRSPC4	PUSH	HL		;save ptr to source
PRSPC5	LD	A,(HL)		;grab a source char
	INC	HL
	CP	3		;end of text?
	JR	Z,PRSPC6	;if so, not in source
	CP	CR		;end of line?
	JR	Z,PRSPC6	;if so, not in source
	CP	B		;separator?
	JR	NZ,PRSPC5	;nope, continue
	CALL	MVFLD1		;yes, xfer the SRC field
PRSPC6	POP	HL		;rcvr source ptr
	RET
;*****
;	routine to transfer the source field to the
;	destination and push the partial down
;*****
PRSPC7	LD	A,(HL)		;p/u source char
	CP	'0'		;ret if not alpha
	RET	C
	CP	'9'+1		;0-9?
	JR	C,MVFLD		;xfer if it is
	CP	'A'		;or is it A-whatever?
	RET	C		;ret if not
;*****
;	shoehorn a source field byte into destination
;*****
MVFLD	INC	HL		;bump source pointer
MVFLD1	PUSH	HL
	LD	H,D		;xfer dest ptr to HL
	LD	L,E
MVFLD2	LD	C,(HL)		;p/u dest char
	LD	(HL),A		;stuff source char
	INC	HL
	LD	A,C		;test dest for 
	CP	3		;etx?
	JR	Z,MVFLD3
	CP	CR		;or end of line
	JR	NZ,MVFLD2	;ripple the destination
MVFLD3	LD	(HL),A		;stuff the terminator
	POP	HL
	INC	DE		;advance to next pos
	JR	PRSPC7		;go get next source byte
;*****
;	Scan for BREAK
;*****
CKBRK	LD	A,(SFLAG$1)	;return if BREAK disabled
SFLAG	EQU	CKBRK+1
	AND	10H		;  with Z-flag set
	XOR	10H
	RET	Z
KFLAG	LD	A,(KFLAG$1)	;Return on BREAK with
	BIT	0,A		;  Z-flag reset (NZ)
	RET	Z
	POP	HL		;Pop the ret addr
	JP	BRKABT
;*****
;	position file 2 to new end & write format sector
;*****
WRERN	LD	A,B		;don't bother to write
	OR	C		;a sector if source
	RET	Z		;is empty
	LD	DE,FCB2
	DEC	BC		;adj for ERN
	CALL	@POSN
	LD	HL,BUF1
	LD	DE,BUF1+1
	LD	BC,255
	LD	(HL),0E5H
	LDIR
	LD	DE,FCB2
	CALL	@WRITE
	RET	Z		;Go if no error
	JP	IOERR
IOERR	OR	40H
	JP	@ERROR
BRKABT	LD	HL,BRKABT$
	DB	0DDH
DSTREQ	LD	HL,DSTREQ$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
	DB	0DDH
SPCREQ	LD	HL,SPCREQ$
	CALL	LOGOT
	JP	@ABORT
DONE	LD	HL,DONE$
	CALL	LOGOT
	JP	@EXIT
HEXDEC	PUSH	AF
	RRA
	RRA
	RRA
	RRA
	CALL	HXD1
	POP	AF
HXD1	AND	0FH
	ADD	A,90H
	DAA
	ADC	A,40H
	DAA
	LD	(HL),A
	INC	HL
	RET
FEXT	JP	@FEXT1
PARAM	JP	@PARAM1
LOGOT	JP	@LOGOT1
HELLO$	DB	'REMOVE - LDOS Character Strip Utility '
	DB	'- Version 1.0',LF
	DB	'Copyright (C) 1981 by Logical Systems'
	DB	', Incorporated',LF,CR
PRMERR$	DB	'Parameter error!',CR
SPCREQ$	DB	'Filespec required!',CR
DSTREQ$	DM	'Destination spec required',CR
BRKABT$	DB	'Manual BREAK abort!',CR
STRPNG$	DB	'Stripping character X',27H
STRPCH$	DB	'xx',27H,CR
DONE$	DB	'Strip operation complete.',CR
TXTEXT	DB	'TXT'
PRMTBL	DB	'BYTE  '
	DW	BPARM+1
	DB	'B     '
	DW	BPARM+1
	NOP
FCB1	DS	32
FCB2	DS	32
	ORG	$<-8+1<8
BUF1	DS	256
BUF2	DS	256
	END	STRIP
