;****	LISTBAS/FLT	Version 5.1
;
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
;
	ORG 5200H
	PUSH	DE
	LD	A,(DE)		;type byte
	PUSH	AF
	LD	HL,SIGNON
	CALL	@DSPLY
;
;****	Mod I or III determination
	LD	A,(125H)	;Mod I or III?
	CP	49H		;III=49h
	JR	Z,M3
	LD	HL,4049H	;Mod I HIGH$
	LD	DE,447BH	;@logot
	JR	LDHIGH
M3	LD	HL,4411H	;Mod III HIGH$
	LD	DE,428AH	;@logot
LDHIGH	LD	(MHI+1),HL	;install HIGH$
	LD	(SHI+1),HL
	LD	(ERROR+1),DE	;install @logot
;
	POP	AF		;device type byte
	BIT	3,A		;device set NIL?
	JR	NZ,DEVNIL
	BIT	4,A		;Routed?
	JR	NZ,DEVROUT
	BIT	1,A		;Output device?
	JR	Z,NOTOUT
;
;****	ok to filter device
	POP	IX		;get dcb
	LD	L,(IX+1)
	LD	H,(IX+2)	;get old address
	LD	(BASLIS+1),HL	;install in filter code
	LD	(PRTCHR+2),HL	;  ''
	PUSH	IX
;
;****	install new HIGH$ and move filter code
MHI	LD	HL,(0000H)	;get current HIGH$
	LD	(OLDHI),HL	;store in filter
	LD	BC,LENGTH	;len of filter
	XOR	A
	SBC	HL,BC		;figure new HIGH$
SHI	LD	(0000H),HL	;store HIGH$
	INC	HL		;filter relo address
	PUSH	HL
	PUSH	BC		;save filter byte count
	LD	BC,START	;reloc. code start
	OR	A
	SBC	HL,BC		;calc. offset for reloc.
	LD	C,L
	LD	B,H		;offset into BC
	LD	IX,RELTBL	;table of labels to adj.
RELP	LD	L,(IX)		;pre-move address
	LD	H,(IX+1)
	LD	A,H		;msb
	OR	A
	JR	Z,DUNTBL	;end of reloc.
	PUSH	HL		;save loc. of address
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		;get move offset
	EX	DE,HL		;new address into DE
	POP	HL		;loc of address
	LD	(HL),E
	INC	HL
	LD	(HL),D		;install new addr
	INC	IX		;next loc in table
	INC	IX
	JR	RELP		;reloc. next label
;
DUNTBL	POP	BC		;restore byte count
	POP	HL		;restore relo address
	POP	IX
	LD	(IX+1),L
	LD	(IX+2),H	;install addr into dcb
	EX	DE,HL		;DE to new address
	LD	HL,START	;HL to filter code
	LDIR			;relocate filter
	JP	@EXIT		;all done
;
DEVNIL	LD	HL,NILMSG
	JR	ERROR
DEVROUT	LD	HL,ROUTMSG
	JR	ERROR
NOTOUT	LD	HL,OUTMSG
ERROR	CALL	0000H		;call @LOGOT
	JP	@ABORT
;
SIGNON	DB	31,'LISTBAS - LBASIC Listing Formatter - Version 5.1',0AH
	DB	'Copyright (c) 1981 by Logical Systems',2CH,' Inc.',0AH,0DH
NILMSG	DB	'Device not active',0DH
ROUTMSG	DB	'Device is routed',0DH
OUTMSG	DB	'Not an output device',0DH
;
RELTBL	DW	REL1+1,REL2+1,REL3+1,REL4+1,REL5+1,REL6+1,REL7+1,REL8+1,REL9+1,REL10+1,REL11+1,REL12+1,REL13+1,REL14+1,REL15+1,0
;
START	JR	BASLIS		;Go to start
OLDHI	DW	0		;OLD HIGH$
	DB	BASLIS-FNAME	;Length of string
FNAME	DB	'BASLIS'	;prog. title
BASLIS	JP	C,0000H		;Go orig driver if input
REL7	LD	A,(FLAG)	;get line status
	LD	B,A		;B holds status flags
	LD	A,C		;get output character
	CP	13		;carriage ret?
REL10	JP	Z,NEXLIN	;yes-next BASIC line
	CP	34		;a quote ?
	JR	NZ,NOQUOTE	;no-don't flip flag then
	LD	A,B		;toggle
	XOR	1		;quote
	LD	B,A		;flag
	LD	A,C		;get output char. back
NOQUOTE	BIT	0,B		;quote flag set?
REL15	JP	NZ,PRINT	;set-ignore char & print it
	CP	39		;REM statement?
	JR	NZ,NOREM	;no-don't set flag
	SET	1,B		;yes-set REM flag
NOREM	BIT	2,B		;last char. an "R" ?
	JR	NZ,CHECK3	;maybe-see if last char. was an "E"
	CP	'R'		;is this char. an "R"
	JR	NZ,CHECK1	;no-see if we are in a REM anyway
	SET	2,B		;one down two to go
	JR	CHECK1		;see if we are in a REM
CHECK3	BIT	3,B		;last char. an "E" ?
	JR	NZ,CHECKM	;yes-two down one to go
	CP	'E'		;is this an "E" ?
	JR	NZ,MASKBIT	;no-somethin' else, clear REM check bits
	SET	3,B		;two down one to go
	JR	CHECK1		;see if we are in a REM
CHECKM	CP	'M'		;well ?????
	JR	NZ,MASKBIT	;no-all for nothin'
	SET	1,B		;got it-set REM flag
MASKBIT	LD	A,B		;clear "R" & "E" flags
	AND	3		;erase bits 2 & 3
	LD	B,A		;and keep bits 0 & 1
	LD	A,C		;get output char. back
CHECK1	BIT	1,B		;are we in a REM ?
	JR	NZ,PRINT	;yes! ignore char. & print it
	CP	':'		;char. a colon ?
	JR	NZ,NOTCOL	;uhuh-somethin' else maybe???
REL6	CALL	PRINT		;it is - print it
	LD	C,0AH		;and do a line feed & a carriage ret
REL1	CALL	PRINT		;carriage ret to boot
REL11	LD	HL,INDENT	;have to indent
	INC	(HL)		;bump indent counter by 1
	LD	B,(HL)		;current # of spaces
SP1	PUSH	BC		;save indent count
REL2	CALL	SPACE		;and space that many times
	POP	BC
	DJNZ	SP1		;keep doin' it
	JR	SPACE		;one more for posterity & escape routine
NOTCOL	CP	';'		;semicolon ?
	JR	Z,REL3		;yes-we got some stuff for ya to do
	CP	'('		;no- how about a left paren ?
	JR	NZ,OTHERP	;no- the other one ?
REL9	CALL	SPACE		;yes-one space first
	LD	C,'('		;and print the "(" too
	JR	PRINT		;and escape the routine
OTHERP	CP	')'		;right paren ?
	JR	NZ,PRINT	;no-default by printing char. and escape routine
REL8	CALL	PRINT		;yes-print ")" and
	JR	SPACE		;space after it, and escape
REL3	CALL	PRINT		;print the semicolon
	LD	C,0AH		;and line feed & carriage ret
REL4	CALL	PRINT		;with a line feed
REL14	LD	A,(INDENT)	;indent # spaces
	LD	B,A		;b holds spc #
SP2	PUSH	BC		;save indent count
REL5	CALL	SPACE		;for a nice format
	POP	BC
	DJNZ	SP2		;do it to it
	JR	SPACE		;one more & escape routine
NEXLIN	LD	A,5		;reset indentation # to 5
REL12	LD	(INDENT),A	;and save it
	XOR	A		;reset flags 
	JR	REL13		;don't look at current flags
PRINT	LD	A,B		;let's get the flags
REL13	LD	(FLAG),A	;store flags
PRTCHR	XOR	A
	JP	0000H		;Jump to printer driver
SPACE	LD	C,20H		;prints a blank
	JR	PRTCHR		;and returns
FLAG	DB	0		;storage of flags
INDENT	DB	5		;storage for indentation #
LENGTH	EQU	$-START		;appr. # of bytes of code
	END	5200H
