;DICT/FLT
;Turn cassette motor ON/OFF with ctl-C
TGLCHR	EQU	3		;Ctl-C
;
; Hardware dependant EQUates.. Mod 1 addresses used
MOTOR3	EQU	2		;Bit 1
M3MSK	EQU	4210H		;Image of last value to port
CASS3	EQU	0ECH		;Motor control
MOTOR1	EQU	3		;Bit 3
M1MSK	EQU	403DH		;Image for port FF
CASS1	EQU	0FFH
HIGH3	EQU	4411H
PARAM3	EQU	4454H
HIGH$	EQU	4049H	
@PARAM	EQU	4476H
@LOGOT	EQU	447BH
LOGOT3	EQU	428AH
KIJCL$1	EQU	43BEH
KIJCL$3	EQU	42BEH
SFLAG$1	EQU	430FH
SFLAG$3	EQU	442BH
;
; General EQUates...
KDCB$	EQU	4015H
@EXIT	EQU	402DH
@ABORT	EQU	4030H
@DSPLY	EQU	4467H
LF	EQU	10		;Linefeed character
CR	EQU	13		;Carriage return
;
; LDOS 'FILTER' command handler
;
	COM	'<Copyright (C) 1983 by Logical Systems, Incorporated>'
;
	ORG	5200H	
ENTRY:	PUSH	DE		;Save DCB pointer
	POP	IX		;Into IX register
	PUSH	HL		;Save cmd line pointer
	CALL	MODEL
	LD	A,(DE)		;Pick up DCB type byte
	PUSH	AF
	LD	HL,SIGNON	;=>Signon message
	CALL	@DSPLY		;Print it
	POP	AF		;Restore type byte
	BIT	3,A		;Device routed to NIL?
	JP	NZ,ISNIL	;Go if so
	BIT	4,A		;Routed?
	JP	NZ,ROUTED	;Go if so (error)
	AND	1		;Does driver handle input?
	CP	1		; 
	JP	NZ,DEVERR	;Go if not
	POP	HL		;Restore cmd line pointer
	LD	DE,PRMTBL	;Scan parameters
	CALL	@PARAM
MMOD4	EQU	$-2
	JP	NZ,PRMERR	;Quit if error
;
;Test parameter values and initialize filter
	LD	BC,$-$		;Value set by @PARAM call
CHARP	EQU	$-2		;<=here
	LD	A,C
	OR	A		;Set flag
	JR	Z,GETDVR	;Go if not specified
	LD	(TGL),A		;Stuff byte if wanted
;Allow installation to *KI in JCL
GETDVR	PUSH	IX		;If the DCB is for *KI,
	POP	DE		; then use KIJCL saved
	LD	HL,KDCB$	; vector for hooks
	XOR	A		;Clear carry
	SBC	HL,DE		;Zero if *KI
	LD	L,(IX+1)	;P/u DCB vector address
	LD	H,(IX+2)
	JR	NZ,SETADD	;Use if not *KI
	LD	A,(SFLAG$1)	;Is DO in effect?
SFLAG	EQU	$-2
	AND	20H
	JR	Z,SETADD	;Not KIJCL if no DO
	LD	HL,(KIJCL$1)	;P/u JCL saved vector
KJCL	EQU	$-2
	LD	(WASKI+1),A	;Note for later
;
SETADD	LD	(DVRADD),HL	;Put where needed in filter
	LD	(DVR1),HL
	LD	HL,(HIGH$)	;Find top of available memory
MMOD1	EQU	$-2
	LD	(OLDMEM),HL	;Save in filter header
	PUSH	HL		;Save
	LD	HL,LAST		;End of relocated code
	POP	DE		;Old HIGH$
	LD	BC,LAST-FENTRY+1	;Length of relocated code
	LDDR			;Move it
	EX	DE,HL
	LD	(HIGH$),HL	;Set new HIGH$
MMOD2	EQU	$-2
	INC	HL		;Point to filter entry point
;
	DI			;Off while DCB update
WASKI	LD	A,0		;If DCB was for KI &
	OR	A		; DO was in effect,
	JR	Z,WASKI1	; then update KIJCL
	LD	(KIJCL$1),HL
KJCL2	EQU	$-2
	JR	WASKI2
WASKI1	LD	(IX+1),L	;Set new address in DCB
	LD	(IX+2),H
WASKI2	EI
;*=*=*
EXIT:	JP	@EXIT		;Done
;*=*=*
;       Error handling
;*=*=*
ISNIL:	LD	HL,ISNIL$
	JR	ERROUT
DEVERR:	LD	HL,DEVER$
	JR	ERROUT
ROUTED:	LD	HL,ROUTD$
	JR	ERROUT
PRMERR:	LD	HL,PRMER$	;'Parameter error'
ERROUT:	CALL	@LOGOT		;Display and log
MMOD3	EQU	$-2
	JP	@ABORT		;Quit
;*=*=*
MODEL:	LD	A,(125H)
	CP	'I'
	RET	NZ
	LD	HL,HIGH3
	LD	(MMOD1),HL
	LD	(MMOD2),HL
	LD	HL,LOGOT3
	LD	(MMOD3),HL
	LD	HL,PARAM3
	LD	(MMOD4),HL
	LD	HL,M3MSK
	LD	(MMOD5),HL
	LD	(MMOD6),HL
	LD	A,MOTOR3
	LD	(MMOD7),A
	LD	A,CASS3
	LD	(MMOD8),A
	LD	HL,KIJCL$3
	LD	(KJCL),HL
	LD	(KJCL2),HL
	LD	HL,SFLAG$3
	LD	(SFLAG),HL
	RET
;*=*=*
;       Data area
;*=*=*
SIGNON:	DB	'DICT/FLT - LDOS cassette control filter'
	DB	LF,CR
PRMER$:	DB	'Parameter error!',CR
ISNIL$:	DB	'Device not active!',CR
DEVER$:	DB	'Incorrect device type!',CR
ROUTD$:	DB	'Device is routed!',CR
;
PRMTBL:	DB	'CHAR  '
	DW	CHARP
	DB	'C     '
	DW	CHARP
	DW	0		;End of list
;
;*=*=*
;       Actual filter moved to high memory
;       LDOS style header...
;*=*=*
FENTRY:	JR	START		;Branch around linkage
	DW	$-$		;Last byte used
OLDMEM	EQU	$-2		;<=previous HIGH$ value
;
	DB	5,'DICT1'
;
; actual filter routine
START:	JP	NC,$-$		;Go if not input request
DVR1	EQU	$-2
	CALL	$-$		;Otherwise call old driver
DVRADD	EQU	$-2		;Stuff driver address here
;
	PUSH	AF		;Save char/status
	CP	TGLCHR		;Is it a toggle?
TGL	EQU	$-1
	JR	NZ,DONE
	LD	A,(M1MSK)
MMOD5	EQU	$-2
	XOR	MOTOR1
MMOD7	EQU	$-1
	OUT	(CASS1),A
MMOD8	EQU	$-1
	LD	(M1MSK),A
MMOD6	EQU	$-2
DONE	POP	AF
	RET
;
LAST	EQU	$-1		;Used for length calculation
;
	END	ENTRY
