;****	CALC Dec/Hex/Bin convert filter Ver 5.1
;
@KEYIN	EQU	0040H
KIDCB$	EQU	4015H
@EXIT	EQU	402DH
@DSPLY	EQU	4467H		;No @logot needed
@DSP	EQU	33H
;
	ORG	5200H
	PUSH	DE		;save dcb
	LD	HL,CMSG		;some friendly sign on
	CALL	@DSPLY
;
	LD	A,(125H)	;Mod1 or Mod3
	CP	49H		;Z = Mod3
	LD	BC,0000H	;Mod 1 KIJCL$ offset
	JR	NZ,M3
	LD	BC,100H		;Mod3 offset
M3	PUSH	AF		;save Z flag
	OR	A		;reset CF
	LD	HL,43BEH	;Mod1 KIJCL$
	SBC	HL,BC		;set Mod 1 or 3
	LD	(MACH2+2),HL
	LD	(MACH3+1),HL	;install addresses
	POP	AF		;get Z = Mod 3
	JR	Z,M3HI		;JR if Mod3
	LD	HL,430FH	;SFLAG$
	LD	(MACH4+1),HL
	LD	HL,4049H
	LD	(MACH1+1),HL	;install Mod1 HIGH$
	LD	HL,(4049H)	;get current HIGH$
	JR	DUNMACH
M3HI	LD	HL,442BH	;SFLAG$
	LD	(MACH4+1),HL
	LD	HL,4411H	;Mod3 HIGH$
	LD	(MACH1+1),HL
	LD	HL,(4411H)	;current HIGH$
;
;****	Figure new HIGH$ from length of CALC/FLT
DUNMACH	LD	BC,LENGTH	;len of filter
	LD	(OLDHI),HL	;put in filter header
	OR	A
	SBC	HL,BC		;new high$
MACH1	LD	(0000H),HL	;machine dependent HIGH$
	INC	HL		;new TRA
;
;****	Relocate hard Jumps, Calls, and Addresses
	PUSH	HL		;CALC TRA
	PUSH	BC		;save filter byte count
	LD	BC,CKEY		;reloc. code start
	OR	A
	SBC	HL,BC		;calc. offset for reloc.
	LD	C,L
	LD	B,H		;offset into BC
	LD	IX,RELTBL	;table of labels to adj.
RELP	LD	L,(IX)		;pre-move address
	LD	H,(IX+1)
	LD	A,H		;msb
	OR	A
	JR	Z,DUNREL	;end of reloc.
	PUSH	HL		;save loc. of address
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC		;get move offset
	EX	DE,HL		;new address into DE
	POP	HL		;loc of address
	LD	(HL),E
	INC	HL
	LD	(HL),D		;install new addr
	INC	IX		;next loc in table
	INC	IX
	JR	RELP		;reloc. next label
;
;****	Relocate CALC/FLT code and place new address
;	into KIDCB$ or KIJCL$ as required
DUNREL	POP	BC		;restore bytes to move
	POP	HL		;restore CALC TRA
	POP	IX		;pop dcb
	LD	DE,(KIDCB$+1)	;current KI vector
MACH4	LD	A,(0000H)	;see if JCL in progress
	BIT	5,A		;DO active?
	JR	Z,RELK1		;Z = not DOing
MACH2	LD	DE,(0000H)	;else get true KI vector
RELK1	LD	(START+1),DE	;install KI vector
	DI			;no int. during move
	JR	NZ,MACH3	;NZ=DO is active, so go
	LD	(IX+1),L
	LD	(IX+2),H	;Calc TRA into Dcb
	JR	RELK3
MACH3	LD	(0000H),HL	;stor Calc TRA during DO
RELK3	EX	DE,HL		;DE to filter loc
	LD	HL,CKEY		;start of real code
	LDIR			;BC still = #bytes
	EI			;ok to int . . .
	JP	@EXIT		;Filter Installed, Exit
;
;****	All JP, CALL, DS, etc. relocation labels
;
RELTBL	DW	REL1+2,REL2+1,REL3+1,REL4+1,REL5+1,REL6+1
	DW	REL7+1,REL8+1,REL9+1,REL10+1,REL11+1
	DW	REL14+1,REL15+1,REL17+1,REL18+2,REL19+2
	DW	REL20+1,REL21+1,REL22+1,BASC+1,FERET+1
	DW	FDRET+1,HBCV+1,REL12+1,REL13+1,REL23+1
	DW	REL24+1,REL25+1,TYPERR+1,0,0,0,0
;
CMSG	DB	31,0AH,'CALC - Bin/Dec/Hex Keyboard Filter conversion routine',0AH
	DB	'Version 5.1 - Copyright (C) 1981 by Logical Systems, Inc.',0AH,0DH
;
;****	Start of actual filter code
CKEY	JR	START
OLDHI	DW	0000H		;HIGH$ before filtering
	DB	START-FNAME
FNAME	DB	'CALC'
;
START	CALL	00H		;orig. keyboard address
	RET	P		;ret if no <CLEAR>
	RET	C		;ret if only <CLEAR>
	PUSH	AF		;save flag reg.
	CP	137		;<CLEAR><RTARW>
	JR	Z,OKMODE
	POP	AF
	RET
OKMODE	POP AF
REL17	LD	HL,INPMSG	;input prompt msg
	CALL	@DSPLY
REL5	LD	HL,CMBUFF	;keyin buffer
	LD	B,10		;max len. of input
	CALL	@KEYIN		;ROM keybd input
REL23	JP	C,FRET2		;ret if <BREAK> used
	LD	A,B		;len input
	CP	2		;must be >2 chars
REL24	JP	C,FERET		;go if <2 char input
	RES	5,(HL)		;make upper case
	LD	A,(HL)		;get #1 char
	CP	'B'
	JR	Z,CTOBIN	;conv to Binary
	CP	'C'
REL4	JP	Z,BINHEX	;Binary to Hex
	CP	'D'
REL6	JP	Z,HEXDEC	;Hex to Decimal
	CP	'M'
REL25	JP	Z,MATH		;hex math routine
	CP	'H'
	JR	NZ,TYPERR	;ret no valid entry
;
;****	H option, converts Dec ascii to Hex ascii
	INC	HL		;first ascii char
	DEC	B		;chars entered
	LD	A,(HL)
	CP	'-'		;see if neg. valu
	PUSH	AF		;save flag
	JR	NZ,DEC1
	INC	HL		;bypass '-' char
	DEC	B		;dec char count
DEC1	LD	C,B		;save len input in B
REL2	CALL	AS2HX		;convert ascii to DE
	POP	HL		;get flag into HL
	LD	A,B		;# valid chars
	CP	C		;# chars entered
	JR	NZ,FERET	;ret if bad
	PUSH	HL
	POP	AF
	JR	NZ,REL3		;go if not neg.
	LD	A,D
	CP	80H		;see if allowed neg.
	JR	Z,CKONE
	JR	NC,FERET
DOCPL	CPL			;cpl DE for convert neg.
	LD	D,A
	LD	A,E
	CPL
	LD	E,A
	INC	DE
REL3	CALL	ASCHX		;conv DE to hex ascii
	JR	FDRET		;display and exit
CKONE	INC	E		;if D=80, see if
	DEC	E		;E=0 - bad if not
	JR	NZ,FERET	;go if e>0 (de>8000)
	JR	DOCPL
;
;****	Convert Hex or Dec to Binary
CTOBIN	DEC	B		;check conv char count
	DEC	B
	JR	Z,FERET		;go if none
	INC	HL		;pt to "H" or "D"
	RES	5,(HL)		;make Upper case
	LD	A,(HL)
	INC	HL		;pt to first char
	LD	C,B		;orig char count
	CP	'H'		;conv Hex?
	JR	Z,HBCV
	CP	'D'		;conv Dec?
	JR	NZ,FERET	;go if not "H" or "D"
REL10	CALL	AS2HX		;conv Dec ascii to DE
	JR	BDSPLY		;dsply as binary
HBCV	CALL	HCONV		;Hex ascii to DE
BDSPLY	LD	A,B		;chars converted
	CP	C		;chars entered
	JR	NZ,FERET	;go if invalid char
REL11	LD	HL,DSPBUFF	;posn for display
	LD	A,D
	OR	A		;msb entered?
	PUSH	AF		;save flag for exit CP
	JR	NZ,BD3
BD4	LD	A,E		;else <256
BD3	LD	B,8		;number of bits
BD1	RLCA			;bit into CF
	LD	(HL),'0'	;assume "0"
	JR	NC,BD2
	INC	(HL)		;else make "1"
BD2	INC	HL		;next dsply posn
	LD	(HL),20H
	DJNZ	BD1		;do 8 bits
	INC	HL		;leave spaces if 2 bytes
	POP	AF		;get back exit flag
	LD	(HL),0DH	;end of buffer
	JR	Z,FDRET		;go if last was lsb
	XOR	A		;set Z flag for exit
	PUSH	AF
	JR	BD4		;and do lsb
;
;****	Ultimate return point and buffer display
TYPERR	LD	HL,TYPRET	;missing type byte msg
	JR	FERET1
FERET	LD	HL,ERRET	;error return msg
	JR	FERET1
FDRET	LD	HL,DSPBUFF-1	;display buffer
FERET1	CALL	@DSPLY
FRET2	XOR	A
	RET			;return to orig program
;
;****	Hex Math routine
MATH	INC	HL		;pt first char
REL21	CALL	HCONV		;convert to DE
	PUSH	DE		;save value
	PUSH	HL		;save operator
	INC	HL		;start 2nd value
REL22	CALL	HCONV		;second ascii to DE
	POP	HL		;restore operator
	LD	A,(HL)
	POP	HL		;first value
	CP	'+'
	JR	Z,MADD		;add
	CP	'-'
	JR	NZ,FERET
	OR	A		;clear CF
	SBC	HL,DE		;do if subtract
	JR	MATHDIS
MADD	ADD	HL,DE		;else do if add
MATHDIS	EX	DE,HL		;result for conversion
REL20	CALL	ASCHX		;to ascii
	JR	FDRET		;display and exit
;
;****	convert Binary ascii, 8 bits max
BINHEX	DEC	B		;conv char count
	JR	Z,FERET		;go if no chars
	LD	DE,0		;zero initial value
	INC	HL		;get first char
BH1	LD	A,(HL)
	RRCA			;set CF on A=1
	RL	E		;rotate CF into E
	INC	HL		;next char
	DJNZ	BH1		;do all chars entered
BASC	CALL	ASCHX		;conv DE to Hex ascii
	JR	FDRET		;display and exit
;
;****	D option, converts Hex ascii to Dec ascii
HEXDEC	DEC	B		;chars to conv
	LD	A,B
	CP	5
	JR	NC,FERET	;go if > 4 hex chars!
	LD	C,B		;save in C
	INC	HL		;pt to first char
REL7	CALL	HCONV		;convert hex ascii
	LD	A,B		;# valid chars
	CP	C		;chars entered
	JR	NZ,FERET	;go if bad
	EX	DE,HL		;# into HL
	PUSH	HL		;save valu for neg.
REL8	CALL	ASCII		;convert to Dec ascii
REL12	CALL	FDRET		;display positive valu
	POP	HL
	LD	A,H
	CP	80H
	JR	C,FRET2
	CPL
	LD	H,A
	LD	A,L
	CPL
	LD	L,A
	LD	A,'-'
	INC	HL
	CALL	@DSP		;dsply neg sign
REL13	CALL	ASCII
	JR	FDRET
;
;****	convert Decimal ascii to a value in DE
AS2HX	LD	B,0		;chars converted
	LD	DE,0		;zero value
CVDEC	LD	A,(HL)		;get ascii digit
	SUB	30H
	CP	10
	RET	NC		;ret if non-digit
	PUSH	HL		;save char buffer
	LD	H,D
	LD	L,E		;existing value into HL
	ADD	HL,HL		;mult by 10
	ADD	HL,HL
	ADD	HL,DE
	ADD	HL,HL
	EX	DE,HL		;number into DE
	ADD	A,E		;add new digit
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	POP	HL		;restore char buffer
	INC	HL		;next char
	INC	B		;char count
	JR	CVDEC		;do to end
;
;****	Convert a value in the HL register
ASCII	PUSH	IY
REL18	LD	IX,DSPBUFF	;position for output
	CP	'-'		;is it neg. dsply?
	JR	Z,REL1		;go if so
	LD	(IX),20H	;else insert space char
	INC	IX		;and inc dsply point
REL1	LD	IY,CTBL		;Conversion table
CONVERT	XOR	A		;zero a reg.
	LD	D,(IY+1)
	LD	E,(IY)		;dec. conversion table
DCO2	OR	A		;reset C
	SBC	HL,DE
	JR	C,LDEC		;C= <0 result
	INC	A		;counter
	JR	DCO2
LDEC	ADD	HL,DE		;add last sub
	ADD	A,30H		;convert 10's to ascii
	LD	(IX),A
	INC	IX		;next dsply posn
	INC	IY		;next table loc
	INC	IY
	LD	A,E		;lsb 10's
	CP	01		;end of table?
	JR	NZ,CONVERT
	POP	IY
	LD	(IX),0DH
	RET
CTBL	DW	10000
	DW	1000
	DW	100
	DW	10
	DW	1
;
;****	Convert DE to Hex ascii display
ASCHX	LD	C,D		;first 2 chars
	LD	B,2		;2 digits
REL19	LD	IX,DSPBUFF
AS1	LD	A,0F0H		;mask for upper nibble
	AND	C		;and ascii char value
	RRCA			;adjust to proper nibble
	RRCA
	RRCA
	RRCA
REL14	CALL	ASCV1		;fix numeric or alpha
	LD	A,0FH		;mask for lower nibble
	AND	C
REL15	CALL	ASCV1
	DEC	B		;char count
	LD	(IX),0DH
	RET	Z		;go if both done
	LD	C,E		;next char pair value
	JR	AS1		;do it again
ASCV1	ADD	A,30H		;adjust A to ascii
	CP	3AH
REL9	JP	M,ASCV2		;JP if digit
	ADD	A,7		;else alpha ascii
ASCV2	LD	(IX),A		;dsply char
	INC	IX
	RET
;
;****	Convert Hex Ascii, HL pts to start of buffer.
HCONV	LD	DE,0		;clear reg
	LD	B,0		;conv char count in B
HCV1	LD	A,(HL)		;char to conv
	CP	30H		;less than "0"
	RET	C		;go if so
	SUB	30H		;conv fm ascii
	CP	10		;digit?
	JR	C,HCV2		;go if so
	RES	5,A		;else make upper case
	SUB	7		;and adjust alpha char
	CP	10H		; > "F" ?
	RET	NC		;bad if so
	CP	0AH		; < "A" ?
	RET	C		;bad if so
HCV2	EX	DE,HL		;conv value into HL
	ADD	HL,HL		;mult * 16
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	EX	DE,HL		;result back into DE
	ADD	A,E		;add in new char
	LD	E,A
	LD	A,0
	ADC	A,D
	INC	HL		;pt to next char
	INC	B		;inc char count
	JR	HCV1		;and do again
;
INPMSG	DB	31,': B,C,D,H,M or <Break> to Abort: ',3
TYPRET	DB	'Missing type byte',0EH,0DH
ERRET	DB	'Input error',0EH,0DH
	DB	0EH
DSPBUFF	DS	18
CMBUFF	DS	11		;input buffer
LENGTH	EQU	$-CKEY
	END	5200H
