SH     	ORG	4250H
 ; SH/ASM
 RST8	JP	ENTRY
 RST10	JP	READ
 RST18	JP	WRITE
 RST20	JP	PRINT
 RST28	JP	FLASH
 RST30	JP	FILECOMM
 RST38	JP	TASK
 CURSOR	DW	3C00H
 RESULT	DB	0
 SGRANS	DB	0
 DGRANS	DB	0
 SFILES	DB	0
 DFILES	DB	0
 GRANS	DB	0
 STRSPC	DB	0,0,0,0,0,0,0
 CTRACK	DB	0,0,0,0
 STACK	EQU	41F0H
 ENTRY	DI
 	IM	1
 	LD	SP,STACK
 	LD	HL,RST8		;restart vectors
 	LD	DE,4000H
 	LD	BC,21
 	LDIR
 	EI
 	LD	H,80H
 	CALL	TMEM
 	JR	NZ,HAVMEM
 	LD	H,0C0H
 	CALL	TMEM
 	JR	NZ,HAVMEM
 	LD	H,0
 HAVMEM	LD	A,H
 	SUB	4
 	LD	(TOPMEM),A
 	LD	HL,MSG1
 	RST	20H
 	XOR	A
 	SBC	HL,HL
 	LD	(SGRANS),HL
 	LD	(SFILES),HL
 	LD	(FLAG),A
 	CALL	DRIVESET
 	LD	A,(4202H)
 	LD	D,A
 	LD	E,0
 	LD	A,10
 	LD	BC,SDIRBUFF
 	CALL	MREAD
 	LD	HL,MSG7
 	JP	NZ,ERROR
 	LD	HL,SDIRBUFF+0D0H
 	CALL	PUTNAMEDATE
 	LD	HL,PRINTFILE
 	RST	30H
 	LD	A,(SGRANS)
 	CALL	ASCII
 	LD	(SGRANSA),A
 	LD	(SGRANSA+1),BC
 	LD	A,(SFILES)
 	CALL	ASCII
 	LD	(SFILESA),A
 	LD	(SFILESA+1),BC
 	LD	HL,FILMSG
 	RST	20H
 BAD1	LD	HL,MSG6
 	RST	20H
 	CALL	INKEY
 	SUB	30H
 	JR	C,BAD1
 	CP	4
 	JR	NC,BAD1
 	LD	(DEST),A
 	LD	(SOURCE),A
 	LD	HL,MSG00
 	RST	20H
 	CALL	DMOUNT
 	XOR	A
 	LD	(SOURCE),A
 	LD	DE,0
 	LD	BC,DDIRBUFF
 	RST	10H
 	LD	HL,MSG8
 	JP	NZ,ERROR
 	LD	A,(DDIRBUFF+2)
 	AND	7FH
 	LD	(DESDIR),A
 	LD	D,A
 	LD	E,0
 	LD	A,10
 	LD	BC,DDIRBUFF
 	CALL	MREAD
 	LD	HL,MSG8
 	JP	NZ,ERROR
 	LD	A,(RESULT)
 	BIT	5,A
 	LD	HL,MSG11
 	JP	Z,ERROR
 	LD	HL,DDIRBUFF
 	LD	BC,5000H
 GRNLOOP	LD	A,(HL)
 	CPL
 	AND	3
 	RRA
 	ADC	A,0
 	ADD	A,C
 	LD	C,A
 	INC	HL
 	DJNZ	GRNLOOP
 	LD	(DGRANS),A
 	CALL	ASCII
 	LD	(MSG18),A
 	LD	(MSG18+1),BC
 	LD	HL,DDIRBUFF+0D0H
 	CALL	PUTNAMEDATE
 	LD	HL,MSG18
 	RST	20H
 	LD	A,(DGRANS)
 	LD	C,A
 	LD	A,(SGRANS)
 	CP	C
 	JR	Z,DOLOOP
 	JR	C,DOLOOP
 	LD	A,1
 	LD	(FLAG),A
 	LD	HL,MSG28
 	RST	20H
 DOLOOP	LD	HL,MSG19
 	RST	28H
 	JP	COPYALL
 TMEM	LD	A,(HL)
 	CPL
 	LD	(HL),A
 	CP	(HL)
 	RET
 CONTROL	CP	10
 	JR	Z,LINFEED
 	CP	11
 	JR	Z,TAB
 	CP	1DH
 	JR	Z,BOL
 	CP	1EH
 	JR	Z,EOL
 	CP	31
 	JR	Z,CLS
 	RET
 LINFEED	LD	DE,40H
 	CALL	BOL
 	ADD	HL,DE
 	JR	OFFVID
 TAB	LD	A,L
 	AND	0E0H
 	LD	L,A
 	LD	DE,20H
 	ADD	HL,DE
 	JR	OFFVID
 BOL	LD	A,L
 	AND	0C0H
 	LD	L,A
 	RET
 EOL	CALL	BOL
 	PUSH	BC
 	LD	BC,3FH
 FIXCON	PUSH	HL
 	LD	D,H
 	LD	E,L
 	INC	DE
 	LD	(HL),20H
 	LDIR
 	POP	HL
 	POP	BC
 OFFVID	LD	A,H
 	CP	3CH
 	JR	NC,OFFAOK
 	LD	HL,3C00H
 	RET
 OFFAOK	CP	40H
 	RET	C
 	PUSH	BC
 	LD	DE,3C00H
 	LD	HL,3C40H
 	LD	BC,3C0H
 	LDIR
 	POP	BC
 	LD	HL,3FC0H
 	JR	EOL
 CLS	XOR	A
 	OUT	(0FFH),A
 	LD	HL,3C00H
 	PUSH	BC
 	LD	BC,1023
 	JR	FIXCON
 KEY	PUSH	HL		;save all registers
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;return address
 	PUSH	HL		;to the stack
 	LD	HL,STRSPC	;work area
 	LD	BC,3801H	;keyboard memory
 	LD	D,0		;row counter
 NEXROW	LD	A,(BC)		;get key byte
 	LD	E,A		;save it here
 	XOR	(HL)		;reverse with mask
 	LD	(HL),E		;save new key
 	AND	E		;same as last key?
 	JR	NZ,HAVEIT	;have a new one
 	INC	D		;bump row count
 	INC	L		;bump mask byte
 	RLC	C		;move key memory
 	JP	P,NEXROW	;go for 7 rows
 	RET			;done
 HAVEIT	LD	E,A		;save masked byte
 	LD	A,D		;get row count
 	RLCA			;*2
 	RLCA			;*4
 	RLCA			;*8
 	LD	D,A		;row * 8
 	LD	C,1		;column mask bit
 MKT1	LD	A,C
 	AND	E		;this the right key?
 	JR	NZ,MKT2		;yup
 	INC	D		;bump row*8
 	RLC	C		;shift mask bit left
 	JR	MKT1		;continue
 MKT2	LD	A,(3880H)	;get shift key
 	LD	B,-1		;set mask for shift
 	OR	A		;any bits on?
 	JR	NZ,KI3		;continue if yes
 	INC	B		;else clear B
 KI3	LD	A,D		;get value back
 	ADD	A,40H		;make it ascii
 	CP	60H		;a-z?
 	JR	NC,LXH3		;go if not
 	RRC	B		;shift key pressed?
 	JR	NC,GOTKEY	;have the key
 	ADD	A,20H		;make it lower
 	LD	D,A		;save char
 	JR	GOTKEY
 LXH3	SUB	70H		;check for last row
 	JR	NC,LXH5		;get byte from table
 	ADD	A,40H		;adjust ascii back
 	CP	3CH		;test for =*/
 	JR	C,LXH4		;don't adjust
 	XOR	10H		;works backwards
 LXH4	RRC	B		;shift key?
 	JR	NC,GOTKEY	;continue if not
 	XOR	10H		;reverse back
 	JR	GOTKEY
 LXH5	RLCA			;double it for table
 	RRC	B		;check for shift
 	JR	NC,LXH6		;go
 	INC	A		;add one for shift entry
 LXH6	LD	HL,KEYTABL	;look up key table
 	LD	C,A
 	LD	B,0		;bc=displacement
 	ADD	HL,BC
 	LD	A,(HL)		;get the byte
 GOTKEY	LD	BC,1000H	;debounce delay
 DELAY	PUSH	AF
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,DELAY+1
 	POP	AF
 	RET			;done, or accum in GET
 GET	POP	BC
 	POP	DE
 	POP	HL
 	OR	A
 	RET			;restore 'em all
 KEYTABL	DB	13		;enter
 	DB	13		;sh enter
 	DB	3		;clear
 	DB	3		;sh clear
 	DB	1		;break
 	DB	1		;sh break
 	DB	5BH		;u arr
 	DB	1BH		;sh u arr
 	DB	5CH		;d arr
 	DB	1AH		;sh d arr
 	DB	5DH		;l arr
 	DB	18H		;sh l arr
 	DB	5EH		;r arrow
 	DB	19H		;sh r arr
 	DB	20H		;space
 	DB	80H		;sh space
 ASCII	PUSH	HL		;save from this
 	CALL	ASCI		;convert to ascii
 	LD	H,B		;save lsb here
 	PUSH	HL
 	LD	A,C		;get msb
 	SUB	30H		;remove ascii
 	CALL	ASCI
 	LD	A,C		;get msb
 	CP	'0'		;leading 0 ?
 	JR	NZ,ASCIGO1
 	LD	A,20H
 ASCIGO1	POP	HL		;restore hl
 	LD	C,B
 	LD	B,H		;ACB = ascii
 	POP	HL
 	RET
 ASCI	LD	C,'0'		;start with 0
 ASCII1	SUB	10		;repeat 10 subtract
 	JR	C,ASCII2
 	INC	C		;bump msb
 	JR	ASCII1
 ASCII2	ADD	A,3AH		;make this ascii
 	LD	B,A		;BC = ascii
 	RET
 TASK	PUSH	AF		;interrupt service
 	LD	A,(37E0H)	;read latch
 	BIT	6,A		;FDC interrupting
 	JR	NZ,FDCROST	;making its roster
 	BIT	7,A		;valid interrupt?
 	JR	Z,TASKDN
 	PUSH	HL		;save these from test
 	PUSH	DE
 	LD	HL,KIM		;point to name
 	LD	DE,KIM2		;decoded name
 	PUSH	BC
 	LD	B,8		;8 chars
 KIMLP	LD	A,(DE)		;check it out
 	AND	7FH		;remove high bit
 	CP	(HL)		;same ?
 	JR	NZ,KILLPGM	;kill the program
 	INC	HL
 	INC	DE
 	DJNZ	KIMLP		;do 'em all
 	POP	BC
 	POP	DE
 	POP	HL
 	LD	A,(3840H)	;check for break key
 	AND	4		;is it pressed
 	JR	Z,TASKDONE
 	DI
 TASKERR	LD	A,(SOURCE)
 	LD	(DEST),A	;save into destination
 	CALL	SMOUNT		;force a prompt for mount
 	RST	8		;re-start program
 TASKDONE	LD	A,(3C00H+63)
 	INC	A
 	CP	5BH
 	JR	C,TASKGO-2
 	CP	5FH
 	JR	C,TASKGO
 	LD	A,5BH
 TASKGO	LD	(3C00H+63),A	;put it back
 TASKDN	LD	A,(37E0H)	;clear latch
 	POP	AF
 	EI			;must re-enable 'em
 	RET
 FDCROST	LD	A,(37ECH)	;clear FDC latch
 	JR	TASKDN
 KILLPGM	DI			;interrupts off
 	LD	HL,3C00H	;start in video
 	LD	DE,3C01H
 	LD	BC,0B000H	;do a bunch
 	LD	(HL),'?'	;spaces to all
 	LDIR
 	HALT
 	RST	0
 FILECOMM	LD	(COMMADDR),HL	;comman looper
 FILELOOP	LD	IX,SDIRBUFF+200H
 	LD	B,64		;64 files possible
 FILELP	BIT	4,(IX)		;active file
 	JR	Z,NEXFILE	;skip dead ones
 	BIT	7,(IX)		;extension?
 	JR	NZ,NEXFILE	;skip those too
 	BIT	6,(IX)		;system file?
 	JR	NZ,NEXFILE
 	BIT	3,(IX)		;invisible ?
 	JR	NZ,NEXFILE	;skip them too
 	PUSH	BC
 	CALL	0		;set from calling routine
 COMMADDR	EQU	$-2
 	POP	BC
 NEXFILE	LD	DE,20H		;displacement to next
 	ADD	IX,DE
 	DJNZ	FILELP
 	RET			;done
 PRINTFILE	PUSH	BC	;save loop counter
 	LD	HL,SFILES	;bump source file count
 	INC	(HL)
 	LD	B,8		;8 chars in name
 	PUSH	IX		;IX => IY
 	POP	IY
 	LD	HL,FILENAME	;name string
 	PUSH	HL		;save on stack
 PF1	LD	B,8		;8 chars in name
 	CALL	PFPUT		;put in string
 	LD	A,(IY+5)	;get next byte
 	CP	20H		;space ?
 	JR	Z,PF2
 	LD	(HL),'/'	;for extension
 	INC	HL
 	LD	B,3		;3 char extension
 	CALL	PFPUT
 PF2	LD	(HL),0		;terminate message
 	POP	HL		;filename message
 	RST	20H		;display it
 	CALL	MANYGRANS	;how many grans this file
 	LD	A,(HL)		;get file gran count
 	CALL	ASCII
 	LD	(GRANMSG),A
 	LD	(GRANMSG+1),BC	;to the string
 	LD	HL,GRANMSG-3
 	RST	20H		;display it
 	POP	BC		;restore counter
 	RET			;done
 MANYGRANS	PUSH	IX	;IX => IY
 	POP	IY
 	LD	HL,GRANS	;how many grans
 	LD	(HL),0		;start with 0
 MGRLP	LD	A,(IY+22)	;get extent element
 	CP	0FFH		;terminator?
 	RET	Z
 	CP	0FEH		;extension?
 	JR	Z,MGREXT
 	LD	A,(IY+23)	;get # grans
 	AND	1FH		;low 5 bits only
 	INC	A		;actual # of grans assign
 	LD	B,A		;give here for count
 	CALL	ADDCOUNT	;bump counter B times
 	PUSH	HL		;save counter pointer
 	LD	HL,SGRANS	;add to total
 	CALL	ADDCOUNT	;bump this one
 	POP	HL
 	INC	IY		;bump position
 	INC	IY		;to next extry pair
 	JR	MGRLP		;continue
 MGREXT	LD	A,(IY+23)	;get DEC of extension
 	LD	IY,SDIRBUFF+200H	;start of names
 	LD	C,A		;save here a sec
 	AND	7		;low 3 bits only
 	LD	B,A		;give to BC
 	LD	A,C		;get original back
 	AND	0E0H		;high 3 bits only
 	LD	C,A		;position within sector
 	ADD	IY,BC		;point to next entry
 	JR	MGRLP		;continue in loop
 ADDCOUNT	LD	C,B	;save the count
 ADDCLOOP	INC	(HL)	;bump the counter
 	DJNZ	ADDCLOOP	;till B = 0
 	LD	B,C		;get count back
 	RET			;done
 INITCOUNT	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),'0'
 	RET
 PFPUT	LD	A,(IY+5)	;get name byte
 	CP	20H		;space ?
 	JR	Z,PFPUTX	;skip them
 	LD	(HL),A		;else put in string
 	INC	HL		;bump string pointer
 PFPUTX	INC	IY		;get next byte
 	DJNZ	PFPUT		;go some more
 	RET
 GETTRK	PUSH	HL		;save HL
 	PUSH	AF		;save C flag
 	LD	HL,CTRACK	;current track table
 	LD	A,0		;binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore C flag
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get the byte
 PUTIN	LD	(HL),A		;put byte in table
 	POP	HL		;restore HL
 	OR	A		;set flags this byte
 	RET			;done
 INKEY	LD	HL,(CURSOR)	;get cursor address
 	LD	BC,400H		;delay count
 	LD	A,(HL)		;get cursor byte
 	XOR	90H		;change space to cursor
 	LD	(HL),A		;put it back
 INKI	CALL	KEY		;scan keyboard
 	JR	NZ,KEYIN	;have a key
 	DEC	C		;decrement flash counter
 	JR	NZ,INKI
 	DJNZ	INKI
 	JR	INKEY+3		;reverse cursor
 KEYIN	CP	60H		;lowercase input?
 	JR	C,INKEYOK	;nope
 	AND	5FH		;make it uppercase
 INKEYOK	LD	(HL),A		;display it
 	RET			;done
 KIM2	DB	'K'+80H,'i'+80H,'m'+80H,' '+80H
 	DB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
 ERROR	RST	20H		;display error message
 	LD	HL,MSG10	;termination
 	RST	20H
 	JP	TASKERR		;remount disk
 MDWRITE	LD	HL,DWRITE	;directory write
 	JR	MWRITE+3	;go common
 MREAD	LD	HL,READ		;read routine
 	JR	MWRITE+3	;go common routine
 MWRITE	LD	HL,WRITE
 	LD	(RDWRT),HL	;save in code
 	LD	L,A		;L = counter
 MLOOP	PUSH	HL		;save counter
 	CALL	0		;do the command
 RDWRT	EQU	$-2
 	POP	HL		;restore count
 	RET	NZ		;bad I/O
 	INC	E		;bump sector
 	LD	A,E		;check for end of track
 	SUB	10		;10 sectors/track
 	JR	NZ,XLOOP	;go loop
 	LD	E,A		;E = 0
 	INC	D		;bump track
 XLOOP	DEC	L		;reduce counter
 	RET	Z		;all done
 	JR	MLOOP		;now continue
 PUTNAMEDATE	LD	DE,MSG2	;use this message string
 	LD	BC,8		;8 chars in name & date
 	PUSH	BC		;save 8
 	LDIR
 	INC	DE
 	LD	A,'-'
 	LD	(DE),A
 	INC	DE
 	INC	DE
 	POP	BC		;get 8 back
 	LDIR
 	LD	HL,MSG2AA
 	JP	PRINT		;display/return
 DWRITE	LD	A,0A9H		;directory write
 	JR	WRITE+2		;use common routine
 WRITE	LD	A,0A8H		;data write
 	EX	AF,AF'
 	LD	HL,120AH	;transfer direction
 	LD	A,0FCH		;error mask byte
 	JR	IOCOMM		;go common
 READ	LD	A,88H		;IBM read command
 	EX	AF,AF'		;pass here
 	LD	A,9CH		;error mask
 	LD	HL,021AH	;direction
 IOCOMM	LD	(WAY),HL	;save direction
 	LD	(MASK),A	;save error mask
 	EX	AF,AF'		;get operation byte
 	LD	(IOTYPE),A	;save this
 	PUSH	BC		;save load address
 	CALL	TRYONE		;try it once
 	POP	HL		;HL = address
 	RET	Z		;OK first time
 	LD	B,H		;HL => BC
 	LD	C,L
 TRYONE	LD	HL,37ECH	;FDC address
 	CALL	SELECT		;turn on drive
 	RET	NZ		;bad already
 	CALL	SEEK		;move head to track
 	RET	NZ		;bad seek
 	DI
 	LD	(HL),0		;issue the command
 IOTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;FDC transfer address
 	CALL	DSKSLO		;wait for valid status
 	JR	XFER2		;transfer the bytes
 XFER1	RRCA			;command done ?
 	JR	NC,XFER3	;finished if bit 0 off
 XFER2	LD	A,(HL)		;read the FDC register
 	BIT	1,A		;ready for transfer?
 	JR	Z,XFER1		;wait if not
 WAY	LD	A,(DE)		;set from above
 	LD	(BC),A
 	INC	BC		;bump buffer pointer
 	JR	XFER2		;same way next byte
 XFER3	LD	A,(HL)		;read result of I/O
 	LD	(RESULT),A	;save the result
 	POP	DE		;restore track/sector
 	EI
 	AND	0		;check status bits
 MASK	EQU	$-1
 	RET	Z		;done OK
 	LD	(HL),0D0H	;force interrupt the FDC
 	RET			;now return
 DRVASC	LD	A,(DRIVE)	;get binary drive
 	ADD	A,30H		;add ascii
 	RET			;that's all
 DSKSLO	PUSH	BC
 	LD	B,10
 	DJNZ	$
 	POP	BC
 	RET
 SEEK	OR	A		;clear carry
 	CALL	GETTRK		;get current track
 	JR	NZ,SEEK1	;continue if not 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad one
 SEEK1	LD	(37EDH),A	;give track to FDC
 	LD	(37EEH),DE	;desired track to 37EFH
 	CP	D		;already on the track?
 	JR	Z,SEEK2		;don't bother with it
 	LD	A,1FH		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;error in move
 SEEK2	LD	A,(37EDH)	;get current track
 	SCF			;carry = put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET			;done OK
 RESTORE	LD	A,0FH		;drive restore command
 	CALL	MOVE		;move the head
 	RET	NZ		;bad
 	LD	A,(HL)		;get the status byte
 	CPL			;reverse the bits
 	BIT	2,A		;head over track 0 ?
 	LD	A,0		;set track 0
 	RET			;Z = OK
 MOVE	LD	(HL),A		;give command to FDC
 MOVEWT	CALL	SELECT		;select the drive
 	RET	NZ		;dropped ready
 	BIT	0,(HL)		;command done?
 	RET	Z		;return if yes
 	JR	MOVEWT		;else wait some more
 DRIVESET	LD	(DRIVE),A	;save binary driv
 	LD	B,1		;which bit to set
 	OR	A		;set flags
 	JR	DRVCK		;have it
 DRVSET	SLA	B		;move drive bit left
 	DEC	A		;binary - 1
 DRVCK	JR	NZ,DRVSET	;continue loop
 	LD	A,B		;get bit
 	LD	(DRIV),A	;save for drive select
 	RET			;done
 PRINT	LD	A,(HL)		;get data byte
 	INC	HL		;bump pointer
 	OR	A		;check for terminator
 	RET	Z		;done if yes
 	CP	20H		;control byte ?
 	PUSH	HL		;save data pointer
 	LD	HL,(CURSOR)	;get cursor position
 	JR	C,DOCTL		;do control byte
 	LD	(HL),A		;display the byte
 	CP	(HL)		;still there ?
 	JR	Z,PRTOK		;lower case if yes
 	SUB	20H		;make it upper case
 	LD	(HL),A		;put it back
 PRTOK	INC	HL		;bump the cursor
 	LD	(CURSOR),HL	;update where it is
 	POP	HL		;get data address back
 	JR	PRINT		;do next byte
 DOCTL	CALL	CONTROL		;display control code
 	JR	PRTOK+1		;continue
 FLASH	EXX
 	LD	HL,MSG0
 	EXX
 	JR	WAIT2
 SMOUNT	LD	HL,MSG4		;mount source diskette
 	LD	A,(SOURCE)	;source drive
 	JR	MOUNT		;go common routine
 DMOUNT	LD	HL,MSG5		;mount destination disk
 	LD	A,(DEST)	;dest drive
 MOUNT	CALL	DRIVESET	;set up for select
 	EXX			;alternate HL
 	LD	HL,MSG0		;clear line code
 	EXX			;back to this
 	LD	A,0		;get source drive
 SOURCE	EQU	$-1
 	CP	0		;same as destination ?
 DEST	EQU	$-1
 	JR	NZ,MOUNTDONE	;check status
 WAIT2	PUSH	HL		;save message pointer
 	RST	20H		;print it
 	POP	HL
 LOOP2	CALL	KEY		;get a key
 	CP	13		;yes ?
 	JR	Z,MOUNTDONE	;terminate
 	LD	A,0		;get counter
 COUNT1	EQU	$-1
 	DEC	A		;less 1
 	LD	(COUNT1),A	;put updated one back
 	JR	NZ,LOOP2
 	EXX			;other message
 	JR	WAIT2		;print this message/wait
 MOUNTDONE	LD	HL,MSG0
 	RST	20H		;print it
 	RET
 SELECT	BIT	7,(HL)		;read drive status
 	LD	A,0		;get drive bit
 DRIV	EQU	$-1
 	LD	(37E1H),A	;select the drive
 	RET	Z		;already was on
 	PUSH	BC		;save this
 	LD	BC,0		;1 second delay time
 	CALL	DELAY		;decrement BC till 0
 	POP	BC		;restore it
 	JR	SELECT
 COPYALL	LD	HL,CREATE	;create/allocate files
 	RST	30H
 	LD	HL,DOCOPY	;file copy routine
 	RST	30H	;do all files
 	CALL	MAKEHIT		;rebuild HIT table
 	LD	HL,MSG27	;updating directory
 	RST	20H
 	CALL	DMOUNT		;set it up
 	LD	A,10		;write 10 sectors
 	LD	BC,DDIRBUFF	;destination directory
 	LD	DE,1700H	;directory track
 DESDIR	EQU	$-1
 	CALL	MDWRITE		;multiple directory write
 	LD	HL,MSG21	;bad directory update
 	JP	NZ,ERROR	;messed it up
 	LD	HL,MSG23
 	RST	20H
 	LD	HL,MSG20	;enter to re-boot
 	RST	28H		;flash it
 	DI			;disable
 	LD	HL,37ECH	;wait till drive stops
 DRVSTOP	BIT	7,(HL)		;stopped now
 	JR	Z,DRVSTOP	;wait some more
 	HALT			;reset the system
 	RST	0
 IFMATCH	PUSH	HL		;save pointers
 	PUSH	DE
 	LD	B,11		;must match 11 chars
 IFMATCH1	LD	A,(DE)	;get a byte
 	CP	(HL)		;same ?
 	JR	NZ,IFMATCH2
 	INC	DE		;bump pointers
 	INC	HL
 	DJNZ	IFMATCH1	;continue for 11
 IFMATCH2	POP	DE	;restore pointers
 	POP	HL
 	RET
 KILLIT	BIT	4,(IX)		;dead already?
 	RET	Z		;yep
 	PUSH	IX		;pass to IY for kill
 	POP	IY
 KILLLP	RES	4,(IY)		;de-activate the file
 KILLLP1	LD	A,(IY+16H)	;get extension entry
 	CP	0FFH		;terminator?
 	RET	Z		;yep
 	CP	0FEH		;extension?
 	JR	Z,EXTENDKL	;kill that too
 	LD	H,A		;start track of kill
 	LD	A,(IY+17H)	;get gran offset/count
 	LD	L,0		;offset from track start
 	BIT	5,A		;2'nd gran?
 	JR	Z,PASTAA
 	LD	L,5		;else 2'nd gran
 PASTAA	AND	1FH		;get gran counter
 	INC	A		;actual gran count
 	LD	C,A		;here for count
 	CALL	RELEASE		;de-allocate the grans
 	INC	IY		;point to next extent
 	INC	IY
 	JR	KILLLP1		;do it
 EXTENDKL	LD	A,(IY+17H)	;get next DEC
 	LD	C,A
 	AND	7		;rel sector offset
 	LD	H,A
 	LD	A,C		;get byte back
 	AND	0E0H		;within sector displ.
 	LD	L,A
 	ADD	HL,DE		;point to next entry
 	PUSH	HL		;pass to IY
 	POP	IY
 	JR	KILLLP		;do the next one too
 RELEASE	PUSH	DE		;save HIT table pointer
 	EX	DE,HL		;DE => start track/sector
 	DEC	H		;HL points to GAT table
 	DEC	H
 	LD	L,D		;point to GAT track
 	LD	A,E		;see if start on sec 0
 	OR	A
 	JR	NZ,SECOND
 RELLP	RES	0,(HL)		;release the gran
 	DEC	C
 	JR	NZ,SECOND
 	JR	RELDONE		;done with this entry
 SECOND	RES	1,(HL)		;release the gran
 	INC	HL		;point to next track
 	DEC	C
 	JR	NZ,RELLP
 RELDONE	POP	DE		;restore DE
 	RET			;HIT done separately
 CREATE2	LD	A,L		;get lsb
 	AND	0E0H		;set to begin of extent
 	LD	L,A
 	BIT	4,(HL)		;alive ?
 	JR	Z,CREATE2B	;skip it, dead already
 CREATE2A	PUSH	HL		;save on stack
 	CALL	PRINTFILE	;print the filename
 	LD	HL,MSG25	;ask if to be replaced
 	RST	20H
 	CALL	INKEY		;wait for answer
 	PUSH	AF		;save key
 	LD	HL,MSG00	;linefeed
 	RST	20H
 	POP	AF
 	POP	HL
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;no ?
 	JP	Z,KILLIT	;cancel this file
 	CP	'Y'		;yes ?
 	JR	NZ,CREATE2A	;try again
 	PUSH	IX		;save pointer
 	PUSH	HL
 	POP	IX
 	LD	DE,DDIRBUFF+200H
 	CALL	KILLIT		;kill dest file
 	POP	IX		;restore pointer
 	JR	CREATE3
 CREATE2B	LD	A,L
 	ADD	A,5		;put it back
 	LD	L,A
 	JR	CREATE2C	;continue with dir
 CREATE	LD	A,0		;get prompt flag
 FLAG	EQU	$-1
 	DEC	A		;must be 1 for prompt
 	JR	NZ,CREATE00	;continue with copy
 	CALL	PRINTFILE	;show name
 	LD	HL,MSG12	;copy it?
 	RST	20H
 	CALL	INKEY		;get a key
 	PUSH	AF
 	LD	HL,MSG00
 	RST	20H
 	POP	AF
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;nope ?
 	JP	Z,KILLIT	;kill from source file
 	CP	'Y'
 	JR	NZ,CREATE	;ask again if wrong
 CREATE00	PUSH	IX	;pass file data start
 	POP	DE
 	LD	A,E
 	ADD	A,5		;point to name
 	LD	E,A
 	LD	HL,DDIRBUFF+205H	;destination name
 	LD	C,64		;see if file is there
 CREATE1	CALL	IFMATCH		;see if files match
 	JR	Z,CREATE2	;see if to be overwritten
 CREATE2C	PUSH	BC	;save this
 	LD	BC,20H		;displacement between
 	ADD	HL,BC		;add to dest pointer
 	POP	BC		;get counter back
 	DEC	C
 	JR	NZ,CREATE1	;go some more
 CREATE3	CALL	FINDSPOT	;locate an entry
 	PUSH	HL		;pass to IY for allocate
 	POP	IY
 	EX	DE,HL		;DE => dest spot
 	PUSH	IX
 	POP	HL		;HL => source spot
 	LD	BC,22		;move the entry here
 	LDIR			;exact duplication
 	LD	H,D
 	LD	L,E
 	INC	DE		;clear the extents
 	LD	BC,9		;5 2 byte pairs
 	LD	(HL),0FFH	;set no extents
 	LDIR
 	PUSH	IY		;save from manygrans
 	CALL	MANYGRANS	;how many grans we need?
 	POP	IY
 	LD	B,(HL)		;get the count
 ALLOCLP0	LD	A,4	;allow 4 extents/entry
 	PUSH	IY		;save pointer
 ALLOCLP	PUSH	AF		;save extent counter
 	CALL	CHUNK		;allocate chunk of grans
 	LD	HL,MSG26	;disk space full
 	JP	C,ERROR		;no good
 	LD	(IY+16H),D	;save start track
 	LD	A,C		;get gran count
 	DEC	A		;less 1 for directory
 	OR	E		;or with sector start
 	LD	(IY+17H),A	;save this too
 	INC	IY		;look at next entry
 	INC	IY
 	LD	A,B		;get needed count
 	SUB	C		;less this entry
 	LD	B,A		;re-save it
 	JR	Z,ALLOCDN	;finished
 	POP	AF		;get 4 counter back
 	DEC	A		;only 4 spots available
 	JR	NZ,ALLOCLP	;do them all
 	POP	IY
 	CALL	NEWENTRY	;create an extension
 	JR	ALLOCLP0	;do this one now
 ALLOCDN	POP	AF		;restore stack
 	POP	IY
 	RET			;done with this entry
 NEWENTRY	LD	A,(IY)	;get this from primary
 	PUSH	AF		;save on stack
 	CALL	FINDSPOT	;locate an entry
 	LD	DE,DDIRBUFF+200H	;start of names
 	PUSH	HL		;save start of entry
 	OR	A
 	SBC	HL,DE		;get new DEC
 	LD	A,H		;get displacement
 	OR	L		;have DEC code now
 	LD	(IY+30),0FEH	;mark as extension
 	LD	(IY+31),A	;put DEC of extension
 	PUSH	IY		;get this DEC
 	POP	HL		;get this
 	LD	DE,DDIRBUFF+200H
 	OR	A
 	SBC	HL,DE
 	LD	A,H
 	OR	L
 	POP	HL		;get start of area
 	PUSH	HL		;save again
 	LD	D,H
 	LD	E,L
 	INC	DE
 	PUSH	BC
 	LD	BC,21
 	LD	(HL),0		;clear start
 	LDIR
 	INC	HL
 	INC	DE
 	LD	(HL),0FFH	;extents
 	LD	BC,9
 	LDIR
 	POP	BC
 	POP	IY		;get this back
 	LD	(IY+1),A	;put backward DEC
 	POP	AF		;get activation
 	OR	80H		;set high bit
 	LD	(IY),A
 	RET
 FINDSPOT	LD	HL,DDIRBUFF+200H
 	PUSH	DE
 	PUSH	BC
 	LD	B,64		;64 entries/dir
 	LD	DE,20H
 CREATE4	BIT	4,(HL)		;available?
 	JR	Z,CREATE5	;check it out
 CREATE6	ADD	HL,DE		;next one
 	DJNZ	CREATE4		;continue
 	LD	HL,MSG13	;out of filespace
 	JP	ERROR		;terminate
 CREATE5	LD	A,L		;get lsb
 	CP	40H		;don't use system area
 	JR	C,CREATE6	;continue if yes
 	POP	BC
 	POP	DE
 	RET			;HL => entry area
 CHUNK	LD	HL,DDIRBUFF	;dest gat table
 	LD	C,0		;how many allocated
 CHUNK1	BIT	0,(HL)		;gran 0 available?
 	LD	D,L		;get track we're on
 	LD	E,0
 	JR	Z,CHUNK2	;yes, set E at 0
 	BIT	1,(HL)		;gran 1 available ?
 	LD	E,20H
 	JR	Z,CHUNK3	;yes, set E at 20H
 	INC	L		;next one
 	LD	A,L
 	CP	50H		;end of table?
 	JR	C,CHUNK1	;continue
 	SCF			;C = error
 	RET			;done
 CHUNK2	BIT	0,(HL)		;allocation test
 	JR	NZ,CHUNK4	;finished
 	SET	0,(HL)		;allocate it
 	INC	C		;bump counter
 	LD	A,B		;get needed count
 	CP	C		;enough ?
 	RET	Z		;done
 CHUNK3	BIT	1,(HL)		;allocation test
 	JR	NZ,CHUNK4	;done
 	SET	1,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	INC	L		;next track
 	JR	CHUNK2
 CHUNK4	OR	A		;clear carry
 	RET
 DOCOPY	LD	HL,MSG22	;copying file....
 	RST	20H		;display it
 	CALL	PRINTFILE	;print filename
 	CALL	POSITIY		;position IY to file
 	LD	HL,1		;position in file
 DOCOPY0	XOR	A		;use this as a counter
 	LD	(COUNTER),A	;save it
 	LD	(DESPOS),HL	;dest start position
 	PUSH	HL		;save this
 	CALL	SMOUNT		;mount source disk
 	POP	HL
 	LD	BC,DATABUFF
 DOCOPY1	PUSH	BC		;save buffer
 	PUSH	HL		;save position
 	CALL	POSITS
 	POP	HL
 	POP	BC
 	JR	C,EMPTYBUFF	;write the buffer back
 	PUSH	HL		;save position
 	LD	A,5		;1 gran read
 	CALL	MREAD		;read it
 	POP	HL		;restore it
 	JR	NZ,DOCOPYN	;bad read on source
 	INC	HL		;bump position in file
 	LD	A,0
 COUNTER	EQU	$-1
 	INC	A
 	LD	(COUNTER),A
 	LD	A,B		;get page in memory
 	CP	0		;at top of memory?
 TOPMEM	EQU	$-1
 	JR	C,DOCOPY1
 	OR	A		;clear carry for not done
 EMPTYBUFF	PUSH	AF	;save carry flag for loop
 	PUSH	HL
 	CALL	DMOUNT		;mount destination disk
 	LD	A,(COUNTER)	;sector counter
 	LD	BC,DATABUFF	;where data is
 	LD	HL,0		;get start position
 DESPOS	EQU	$-2		;saved from above
 	CALL	CREATWRITE	;write the grans back
 	POP	HL		;restore position
 	POP	AF		;get result back
 	RET	C		;done with this file
 	JR	DOCOPY0		;do the rest
 DOCOPYN	LD	HL,MSG7
 	JP	ERROR		;source read error
 MAKEHIT	LD	HL,DDIRBUFF+100H	;dest HIT table
 	LD	DE,DDIRBUFF+101H
 	LD	BC,0FFH
 	LD	(HL),0		;zero it out
 	LDIR
 	LD	IX,DDIRBUFF+200H	;start of names
 	LD	B,64		;64 entries
 HITLP	BIT	4,(IX)		;active entry
 	PUSH	BC		;save count
 	CALL	NZ,PUTHIT	;insert HIT byte
 	LD	BC,20H		;next entry
 	ADD	IX,BC
 	POP	BC
 	DJNZ	HITLP		;do all 64
 	RET			;done
 HASH	PUSH	IX		;save position
 	PUSH	BC
 	LD	BC,0B00H	;B = char count, C = hash
 HASHLP	LD	A,(IX+5)	;get a name byte
 	INC	IX		;point to next one
 	XOR	C		;hash it
 	RLCA
 	LD	C,A
 	DJNZ	HASHLP
 	OR	A		;check for 0 hash
 	JR	NZ,HASHOK	;ok if not
 	INC	A		;else make it 1
 HASHOK	POP	BC
 	POP	IX
 	RET			;done
 PUTHIT	BIT	7,(IX)		;extension entry ?
 	RET	NZ		;don't do those YET
 	PUSH	IX		;pass to HL for breakdown
 	POP	HL
 	LD	DE,DDIRBUFF+200H
 	OR	A		;clear carry
 	SBC	HL,DE
 	LD	A,H
 	OR	L		;compute HIT location
 	LD	HL,DDIRBUFF+100H
 	LD	L,A
 	CALL	HASH		;compute hash byte
 	LD	(HL),A		;put in table
 	EX	AF,AF'		;save hash byte here
 	PUSH	IX		;pass to IY
 	POP	IY
 PUTHITX1	LD	A,(IY+30)
 	CP	0FEH		;any extensions ?
 	RET	NZ		;nope, all done
 PUTHITX	LD	L,(IY+31)	;get DEC for next one
 	EX	AF,AF'
 	LD	(HL),A		;save this byte too
 	EX	AF,AF'		;resave it
 	LD	A,L
 	AND	1FH		;get track displacement
 	PUSH	HL
 	LD	H,A
 	LD	A,L
 	AND	0E0H		;get sector position
 	LD	L,A
 	LD	BC,DDIRBUFF+200H	;entries
 	ADD	HL,BC		;have next one
 	PUSH	HL		;pass to IY
 	POP	IY
 	POP	HL
 	JR	PUTHITX1	;next entry
 POSITIY	PUSH	IX		;pass to HL for compare
 	POP	DE
 	LD	A,E
 	ADD	A,5
 	LD	E,A		;point to name
 	LD	HL,DDIRBUFF+205H
 	LD	C,64
 POSITIY1	CALL	IFMATCH	;compare names
 	JR	Z,POSIYG	;go if match
 	PUSH	BC		;save count
 	LD	BC,20H		;point to next entries
 	ADD	HL,BC
 	POP	BC		;restore count
 	DEC	C
 	JR	NZ,POSITIY1	;continue
 	LD	HL,MSG24	;program error
 	JP	ERROR
 POSIYG	LD	A,L		;get dest LSB
 	AND	0E0H		;point to begin of entry
 	LD	L,A
 	PUSH	HL
 	POP	IY
 	RET			;IY => filename (dest)
 POSITS	PUSH	IY		;must save IY from use
 	PUSH	IX		;pass to IY
 	POP	IY
 	LD	DE,SDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save for postion use
 	CALL	POSIT		;position to IY file
 	POP	IY		;restore IY
 	RET
 POSITD	PUSH	IY		;save IY
 	LD	DE,DDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save it
 	CALL	POSIT		;position the file
 	POP	IY		;restore it
 	RET
 POSIT	LD	A,(IY+16H)	;get extent
 	CP	0FFH		;terminator?
 	SCF			;C = EOF
 	RET	Z		;return if end
 	CP	0FEH		;extension ?
 	JR	Z,POSEXT	;get the extent
 	LD	D,A		;else start track
 	LD	A,(IY+17H)	;get offset/grans
 	LD	E,0		;start with sector 0
 	BIT	5,A
 	JR	Z,POSIT2
 	LD	E,5		;else sector 5
 POSIT2	AND	1FH		;get gran counter
 	INC	A
 POSIT2A	LD	(CNTSAV),A	;save the counter
 	DEC	HL		;reduce posit count
 	LD	A,H
 	OR	L		;any bits left ?
 	RET	Z
 	CALL	NEXTGRAN
 	LD	A,0		;get count back
 CNTSAV	EQU	$-1
 	DEC	A		;reduce it
 	JR	NZ,POSIT2A
 	INC	IY		;next extent
 	INC	IY
 	JR	POSIT
 POSEXT	LD	A,(IY+17H)
 	PUSH	HL		;save position
 	LD	L,A
 	AND	7
 	LD	H,A		;relative to HIT table
 	LD	A,L
 	AND	0E0H
 	LD	L,A
 	LD	DE,0		;saved directory position
 SAVEDIR	EQU	$-2		;set from POSITS/POSITD
 	ADD	HL,DE		;point to the right byte
 	PUSH	HL
 	POP	IY
 	POP	HL		;restore count
 	JR	POSIT		;go some more
 NEXTGRAN	LD	A,E	;get sector
 	CP	5		;on the 2'nd gran?
 	JR	Z,NTRKGRN	;go to next track
 	LD	E,5		;else go to 5
 	RET
 NTRKGRN	LD	E,0
 	INC	D		;bump track
 	RET
 CREATWRITE	PUSH	HL
 	PUSH	BC		;save buffer
 	CALL	POSITD
 	POP	BC
 	LD	A,5		;5 sectors/gran
 	CALL	MWRITE		;multiple write
 	LD	HL,MSG9		;dest write error
 	JP	NZ,ERROR	;terminate
 	POP	HL		;restore position
 	INC	HL
 	LD	A,(COUNTER)
 	DEC	A		;reduce it
 	RET	Z		;done with this bunch
 	LD	(COUNTER),A
 	JR	CREATWRITE	;continue
 ;  **  MESSAGE TEXT  **
 FILMSG	DB	10
 SFILESA	DB	'xxx Files, '
 SGRANSA	DB	'xxx Grans to be copied.',10,0
 FILENAME	DB	'            ',0
 	DB	' / '
 GRANMSG	DB	'xxx Grans',11,0
 MSG00	DB	10,0		;linefeed
 MSG0	DB	1D,1EH,0	;clear current line
 MSG1	DB	31,'**  FILE TRANSFER UTILITY  **  -  by '
 KIM	DB	'Kim Watt'
 	DB	10,'(c)(p) 1981 Breeze/QSD, Inc.'
 	DB	10,'Inspired by Scott Adams                                     '
 	DB	10,10,'This program will copy the following files from this',10
 	DB	'diskette onto another single density diskette on any drive.',10,0
 MSG2AA	DB	'Disk Name/Date:  '
 MSG2	DB	'         -         ',10,0
 MSG3	DB	'                ',10,0
 MSG4	DB	1DH,'Mount SOURCE disk, key <ENTER>. ',0
 MSG5	DB	1DH,'Mount DESTINATION disk, key <ENTER>. ',0
 MSG6	DB	1DH,1EH,'Destination Drive ? ',0
 MSG7	DB	10,'SOURCE Disk READ ERROR !',10,0
 MSG8	DB	10,'DESTINATION Disk READ ERROR !',10,0
 MSG9	DB	10,'DESTINATION Disk WRITE ERROR !',10,0
 MSG10	DB	10,'Program TERMINATED in ERROR.',10,0
 MSG11	DB	10,'CANNOT LOCATE Destination Directory.',10,0
 MSG12	DB	'<< Copy it ? ',0
 MSG13	DB	10,'FILE SPACE FULL !',10,0
 MSG18	DB	'xxx Grans available on destination disk.',10,0
 MSG19	DB	'Key <ENTER> to proceed with copy. ',0
 MSG20	DB	'Key <ENTER> to BOOT drive 0. ',0
 MSG21	DB	10,'Destination Directory Update WRITE ERROR ! ',10,0
 MSG22	DB	'Copying File ==>> ',0
 MSG23	DB	'**  Copy Completed  **',10,0
 MSG24	DB	10,'Internal error.  Notify Breeze.',10,0
 MSG25	DB	'<< EXISTS, Replace it ? ',0
 MSG26	DB	10,'DISK SPACE FULL !',10,0
 MSG27	DB	'Updating Destination Directory.',10,0
 MSG28	DB	'Not enough grans on Destination Disk, Select files to copy.',10,0
 ;**  BUFFERS  **
 LOWEND	EQU	$&0FF00H	;get even page of memory
 SDIRBUFF	EQU	LOWEND+100H
 DDIRBUFF	EQU	SDIRBUFF+0A00H	;room for 10 secs
 DATABUFF	EQU	DDIRBUFF+0A00H	;for data I/O
 	END	ENTRY
