DVORAK 	ORG	7000H
 ; DVORAK/ASM
 ENTRY	LD	A,(HL)		;get a char
 	INC	HL		;look to next one
 	CP	13
 	JR	Z,NOTHIN
 	CP	20H
 	JR	Z,ENTRY
 	CP	','
 	JR	Z,ENTRY
 	CP	60H
 	JR	C,CHECK
 	AND	5FH
 CHECK	CP	'D'
 	JR	Z,SETD
 	CP	'Q'
 	JR	Z,SETQ
 	LD	HL,PARERR
 	CALL	4467H
 	JP	402DH
 SETD	XOR	A
 	JR	SETG
 SETQ	LD	A,1
 SETG	LD	(FLAG),A
 NOTHIN	LD	HL,(4049H)	;get topmem
 	LD	(TOPMEMO),HL	;save old topmem
 	LD	BC,LAST-FIRST	;length
 	OR	A
 	SBC	HL,BC		;get length
 	PUSH	HL		;save it
 	DEC	HL		;reduce by 1
 	LD	(4049H),HL	;save new topmem
 	LD	(TOPMEMN),HL	;save for reclaim space
 	LD	DE,-50		;set clear 50
 	ADD	HL,DE
 	LD	(40A0H),HL	;save string pointer
 	POP	DE		;get where to move to
 	LD	HL,DRIVER	;where driver is
 	PUSH	BC		;save length
 	PUSH	DE		;save dest
 	PUSH	HL		;save start
 	EX	DE,HL
 	OR	A
 	SBC	HL,DE
 	EX	DE,HL
 	LD	HL,(PASS1)
 	ADD	HL,DE
 	LD	(PASS1),HL	;pass to program
 	LD	HL,(PASS2)
 	ADD	HL,DE
 	LD	(PASS2),HL
 	LD	HL,(PASS3)
 	ADD	HL,DE
 	LD	(PASS3),HL
 	LD	HL,(PASS4)
 	ADD	HL,DE
 	LD	(PASS4),HL
 	LD	HL,(PASS5)
 	ADD	HL,DE
 	LD	(PASS5),HL
 	LD	HL,(PASS6)
 	ADD	HL,DE
 	LD	(PASS6),HL
 	LD	HL,(4016H)
 	LD	(CALL),HL
 	LD	HL,DRIVER
 	ADD	HL,DE
 	LD	(4016H),HL
 	LD	HL,MESG
 	CALL	4467H
 	POP	HL
 	POP	DE
 	POP	BC
 	LDIR
 	RET
 PARERR	DB	'Parameter Error !',13
 MESG	DB	10,'DVORAK / QWERTY Keyboard Driver by Kim Watt'
 	DB	10,'(C)(P) 1981 Breeze Computing Inc.'
 	DB	10,'Distributed by Quality Software - Dallas, Texas',13
 FIRST	DB	0
 DRIVER	CALL	0		;call original
 CALL	EQU	$-2
 	PUSH	AF		;save the key
 	CP	81H		;CLEAR BREAK?
 	JR	Z,QUIT
 	CP	95
 	JR	Z,TOGGLE
 	CP	0B0H
 	JR	NZ,NOKEY
 TOGGLE	LD	A,(FLAG)	;get type flag
 PASS3	EQU	$-2
 	XOR	1		;reverse bit 0
 	LD	(FLAG),A	;re-save it
 PASS4	EQU	$-2
 BACK	POP	AF
 	XOR	A
 	RET
 QUIT	LD	HL,MSG1
 PASS1	EQU	$-2
 	CALL	4467H
 	LD	HL,(CALL)	;put old driver back
 PASS6	EQU	$-2
 	LD	(4016H),HL
 	LD	DE,0
 TOPMEMN	EQU	$-2
 	LD	HL,(4049H)	;see if last driver in
 	OR	A
 	SBC	HL,DE
 	JR	NZ,DONE
 	LD	HL,0
 TOPMEMO	EQU	$-2		;old topmem pointer
 	LD	(4049H),HL	;set it up
 	LD	HL,RECLAIM
 PASS5	EQU	$-2
 	CALL	4467H
 DONE	JP	402DH
 NOKEY	LD	A,0
 FLAG	EQU	$-1		;on/off flag
 	RRCA
 	JR	C,DONT		;don't adjust it
 	POP	AF		;get key back
 	CP	20H		;control code ?
 	RET	C
 	CP	80H		;graphics ?
 	RET	NC
 	PUSH	BC		;save registers
 	SUB	20H
 	LD	C,A		;give to LSB
 	LD	B,0
 	PUSH	HL		;save all that's used
 	LD	HL,TABLE	;lookup table
 PASS2	EQU	$-2
 	ADD	HL,BC		;point to new value
 	LD	A,(HL)		;get the key
 	POP	HL		;restore 'em
 	POP	BC
 	RET
 DONT	POP	AF
 	RET
 TABLE	DB	' *"#$%&',27H,'()!Sw-vz6:753190248sW=VZ@'
 	DB	'AXJE.UIDCHTNMBRL?POYGK,QF;'
 	DB	5BH,5CH,5DH,5EH,5FH
 	DB	60H
 	DB	'axje>uidchtnmbrl/poygk<qf+'
 	DB	7BH,7CH,7DH,7EH,7FH
 MSG1	DB	10,'Cancelled.',3
 RECLAIM	DB	'  Memory Reclaimed.',3
 LAST	DB	0
 	END	ENTRY
 	DB	'AXJE.UIDCHTNMBRL?POYGK,QF;'
 	DB	5BH,5C