;BUSY/CMD originally by Robert Eden
;Enhanced by Richard VanHouten 01/31/89
;Enhancements:
;	Relocates to top of available memory.
;	Can be disabled by BUSY(N)
;	Ability to reclaim memory when disabled.
;	Adjusts length of module to length of message.
;Existing feature retained in this version:
;	Ability to change message by BUSY new message
;Nice things not yet added:
;	Ability to reuse previous space if it hasn't been
;	reclaimed.
;
NUL	EQU	00H
ETX	EQU	03H
LF	EQU	0AH
CR	EQU	0DH
WHERE	EQU	000BH
DSP	EQU	0033H
MODCHK	EQU	0125H
CLS	EQU	01C9H
INTVEC	EQU	4013H
EXIT	EQU	402DH
HIM1	EQU	4049H
BASHI	EQU	40B1H
HIM3	EQU	4411H
	ORG	5200H
INIT	OUT	(0E8H),A	;Master reset of UART
	LD	A,0ECH		;Set UART for 8/N/1
	OUT	(0EAH),A
	PUSH	HL		;Save pointer to command line
	CALL	CLS		;Clear screen
	LD	HL,INTRO	;and display intro
	CALL	VDLINE
	POP	HL		;Restore pointer
	LD	A,(HL)		;Read from command line
SKIPWS	CP	' '		;Skip spaces
	JR	NZ,SKIPIT
	INC	HL
	LD	A,(HL)
	JR	SKIPWS
SKIPIT	CP	CR		;Check for carriage return
	JP	Z,DEFLT		;If found, use default message
	CP	ETX		;Check for End of TeXt (03H)
	JP	Z,DEFLT
	CP	'('		;Check for (N) or (N
	JP	NZ,MVMES
	PUSH	HL		;Save pointer
	INC	HL
	LD	A,(HL)		;Convert to upper case
	AND	5FH
	CP	'N'
	JP	NZ,NODIS	;Not (N or (N), use as message
	INC	HL
	LD	A,(HL)
	CP	')'
	JR	Z,DISABL	;Matches, go disable driver
	CP	CR
	JR	Z,DISABL
	CP	ETX
	JR	NZ,NODIS
DISABL	POP	HL		;Drop pointer from stack
	LD	HL,(INTVEC)	;Get current interrupt vector
	PUSH	HL		;Save it for later
	LD	A,(HL)		;Check if it points to a copy
	CP	18H		;of our driver.
	JR	NZ,CANT		;Doesn't point to a module
				;header, abort.
	INC	HL		;Skip to module name length
	INC	HL
	INC	HL
	INC	HL
	LD	DE,NAME		;See if module is this one
	LD	B,5
FIND	LD	A,(DE)
	CP	(HL)
	JR	NZ,CANT		;Doesn't match, abort
	INC	HL
	INC	DE
	DJNZ	FIND
FOUND	DI			;Critical area, don't want an
				;interrupt now
	POP	HL		;Found it, get beginning again
	PUSH	HL		;Save it for later
	LD	DE,OLDVEC-DVR	;Offset to vector storage
	ADD	HL,DE		;Get vector out
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	LD	(INTVEC),HL	;Restore vector
	EI
	LD	HL,DONMES	;Say we did it
	CALL	VDLINE
	POP	HL		;get pointer to beginning
	DEC	HL		;point just before it
	LD	A,(MODCHK)	;check for model I/III
	CP	'I'
	JR	NZ,FOUND1
	LD	DE,(HIM3)	;Get top of memory pointer
	JR	MEMCHK
FOUND1	LD	DE,(HIM1)
MEMCHK	LD	A,E		;Compare it to beginning of module - 1
	CP	L
	JR	NZ,CNTREC	;If not the same, can't reclaim memory
	LD	A,D
	CP	H
	JR	Z,RECLAM
CNTREC	LD	HL,NORECL	;Say we can't, and exit
	CALL	VDLINE
	JP	EXIT
RECLAM	INC	HL		;Get end of module
	INC	HL
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	A,(MODCHK)	;Stuff it in hi memory pointer
	JR	Z,RECLM1
	LD	(HIM1),DE
	JR	RECLM2
RECLM1	LD	(HIM3),DE
RECLM2	LD	HL,RECL		;Say we did it and exit
	CALL	VDLINE
	JP	EXIT
CANT	POP	HL		;Say we can't do it and exit
	LD	HL,CANTMS
	CALL	VDLINE
	JP	EXIT
NODIS	POP	HL
MVMES	LD	DE,MES
	LD	(DE),A		;Move message from command line
MVMES2	INC	HL		;to message buffer
	INC	DE
	LD	A,(HL)
	LD	(DE),A
	CP	CR		;stop when we find a carriage
	JR	Z,MVMES1	;return
	CP	ETX		;or end of text
	JR	NZ,MVMES2
	LD	A,CR		;change end of text to cr
	LD	(DE),A
MVMES1	LD	A,LF		;Add a line feed and null
	INC	DE
	LD	(DE),A
	XOR	A
	INC	DE
	LD	(DE),A
	INC	DE		;DE points to end + 1
	JR	DEFLT1
DEFLT	LD	DE,DREND	;Point DE to 1 byte past end
DEFLT1	DI
	LD	HL,(INTVEC)	;Get current interrupt vector
	LD	(OLDVEC),HL	;save it for exiting
	LD	HL,DVR
	EX	DE,HL
	OR	A
	SBC	HL,DE		;Calculate length of driver
	LD	C,L
	LD	B,H		;Put it in BC for block move
	LD	A,(MODCHK)
	CP	'I'
	JR	Z,DEFLT2	;Go if model III
	LD	HL,(HIM1)	;Get top of memory
	LD	(ENDMOD),HL	;Save it in header
	XOR	A
	SBC	HL,BC
	LD	(HIM1),HL	;Reset himem to below driver
	JR	SKIP
DEFLT2	LD	HL,(HIM3)	;Do the same,
	LD	(ENDMOD),HL	;except for Model III
	XOR	A
	SBC	HL,BC
	LD	(HIM3),HL
SKIP	LD	(BASHI),HL	;set top of basic
	INC	HL
	LD	(INTVEC),HL	;save new interrupt vector
	EX	DE,HL		;to this module
	LD	HL,DVR		;and move the module
	LDIR
	EI			;We're done with
		;the nasty stuff, turn the interrupts back on
	JP	EXIT		;and go back to DOS
VDLINE	LD	A,(HL)		;display a string terminated
	INC	HL		;with 0Dh or 03h
	CALL	DSP
	CP	CR
	JR	Z,VDEND
	CP	ETX
	JR	NZ,VDLINE
VDEND	RET
;Credit display
INTRO	DB	'******************'
	DB	'******************',0AH
	DB	'**   BUSY -- BACKG'
	DB	'ROUND MESSAGES  **',0AH
	DB	'**        BY ROBER'
	DB	'T EDEN          **',0AH
	DB	'**  REVISED BY RIC'
	DB	'HARD VANHOUTEN  **',0AH
	DB	'******************'
	DB	'******************',0DH
NAME	DB	4,'BUSY'		;Module name
DONMES	DB	'BUSY disabled, memory ',ETX
NORECL	DB	'not '
RECL	DB	'reclaimed.',CR
CANTMS	DB	'Can''t disable BUSY.',CR
;
;Resident module starts here
;
DVR	JR	NUVEC		;LDOS compatible module header
ENDMOD	DW	$-$		;end of module
	DB	4		;module name
	DB	'BUSY'
NUVEC	PUSH	AF		;Code starts here
	PUSH	DE
	PUSH	HL
	CALL	WHERE		;get address of HERE
HERE	LD	DE,COUNT-HERE
	ADD	HL,DE		;compute address of COUNT
	PUSH	HL
	IN	A,(0E8H)	;GET STATUS
	BIT	5,A
	JR	Z,CDTCT		;GO IF CD
NOCD	XOR	A
	POP	HL
	PUSH	HL
	LD	(HL),A		;Zero count if end of string
	JR	CONT		;or Carrier not detected
CDTCT	BIT	4,A		;Carrier detected, check RI
	JR	NZ,LOSPD	;for high speed
	LD	A,77H	;1200 BAUD
	DB	21H		;dummy ld hl,xxxx
LOSPD	LD	A,55H	;300 BAUD
	OUT	(0E9H),A	;set baud rate
	IN	A,(0EAH)
	BIT	6,A		;check if transmit buffer is
	JR	Z,CONT		;ready
	POP	HL		;if it is, get next character
	PUSH	HL
	LD	A,(HL)
	INC	HL
	LD	E,A
	LD	D,00H
	ADD	HL,DE
	LD	A,(HL)
	OUT	(0EBH),A	;Send next character
	OR	A
	JR	Z,NOCD		;Reset count if end of string
	INC	E
	LD	A,E
	POP	HL
	PUSH	HL
	LD	(HL),A
CONT	POP	HL		;drop address
	POP	HL		;restore registers
	POP	DE
	POP	AF
	JP	$-$		;Follow interrupt chain
OLDVEC	EQU	$-2
COUNT	DB	0
;Default message:
MES	DB	'System busy.. Call back in 10 minutes',CR,LF,0
DREND	EQU	$
	END	INIT
