APD    ;#########################################
 ;#                                       #
 ;#  AUTOMATIC P-DRIVE (APD) PROGRAM FOR  #
 ;#   TRS-80 MOD I & MOD III, FOR USE     #
 ;#     WITH NEWDOS80 VERSION 2           #
 ;#                                       #
 ;#      BY HAL BROWN  11/17/81           #
 ;#                                       #
 ;#   FOR MOD III VERSION, MAKE CHANGES   #
 ;#    MARKED BY * IN COMMENTS FIELD.     #
 ;#                                       #
 ;#########################################
 HIMEM	EQU	4049H		;* 4411H IN MOD III
 DSKDRV	EQU	4308H		;* 427EH IN MOD III
 DOSBUF	EQU	4318H		;* 4225H IN MOD III
 	ORG	5200H
 INIT	LD	HL,(HIMEM)	;START OF RELOCATOR
 	LD	(LDCNT1+1),HL	;POKE RELOCATED COUNT
 	LD	(LDCNT2+1),HL	; ADDRESS INTO PROGRAM
 	EX	DE,HL
 	LD	BC,COUNT-START+1 ;GET BYTE LENGTH OF PROG
 	LD	HL,COUNT	;LOAD END-OF-PROG ADDRESS
 	LDDR			;RELOCATE
 	EX	DE,HL
 	LD	(HIMEM),HL	;RESET HIGH-MEMORY
 	INC	HL		;GET START ADDRESS AND
 	LD	(440AH),HL	; POKE TO ERROR VECTOR
 	LD	A,0C3H
 	LD	(4409H),A	;POKE JUMP CODE
 	JP	402DH		;BACK TO THE RANCH
 START	PUSH	AF		;SAVE STATUS
 	AND	3FH		;RESET HIGH BIT
 ZRSET	CP	11H		;DIRCTRY READ ERROR PRINT
 	JR	NZ,EXIT		;NO, EXIT
 	LD	A,(DSKDRV)	;GET DRIVE NUMBER
 	OR	A		;DRIVE 0PRINT
 	JR	Z,ZRSET		;YES, GO RESET Z FLAG
 LDCNT1	LD	HL,0		;GET RELOCATED COUNT ADDR
 	DEC	(HL)		;DECREMENT COUNT
 	JR	Z,ZRSET		;IF 0 GO RESET Z FLAG
 	LD	B,A		;DRIVE NUMBER => B
 	LD	A,7BH		;* 7BH TO 9BH FOR MOD III
 LOOP1	ADD	A,0AH		;ADD 10 TIMES DRIVE #
 	DJNZ	LOOP1
 	LD	E,A		;SAVE AS LSB
 	LD	D,43H		;* 43H TO 42H FOR MOD III
 	LD	B,0AH		;SET LOOP COUNTER TO 10
 LOOP2	DEC	HL		;CHANGE
 	DEC	DE		;  10-BYTE
 	LD	A,(DE)		;    P-DRIVE
 	XOR	(HL)		;       TABLE
 	LD	(DE),A		;         IN
 	DJNZ	LOOP2		;           MEMORY
 	POP	HL		;POP UNNEEDED STACK VALUE
 	LD	HL,DOSBUF	;POINT HL TO DOS BUFFER
 	CALL	4419H		;DOS-CALL
 	PUSH	AF		;SAVE STATUS
 EXIT	LD	A,02H		;RESET
 LDCNT2	LD	(0),A		; COUNT
 	LD	A,26H		;START OF ERROR ROUTINE
 	JP	NZ,440CH	;NOT-Z, GOTO ERROR RTN
 	POP	AF		;RECOVER STATUS
 	JP	402DH		;HOME AGAIN
 TABLE	DEFB	0,1CH,40H,0,18H,0,0,3,0,0 ;MOD I TBL
 ;* MOD III, CHNG TABLE ABOVE TO 0,6BH,0,0BH,18H,0,0,1,0,0
 COUNT	DEFB	2		;TRIAL COUNT STORAGE
 	END	INIT
                                                                                                                  