	;	PATCH ROUTINE FOR XT4 V:1.6.13
	;Mod.0	To bypass Rx buffer check on commands sent
	;	out during the first two characters of a Hayes command
	;	ie: 'AT' which are not echoed back until the two character
	;	command is issued.
	;	R. Cox 20/09/87
	;Mod.1	Add patch to change unused 600bd option to 1275bd
	;	R. Cox  22/09/87
	;Mod.2	Increase pause to 4000 because of problems with lower speed
	;	modems. At 300 baud the timing meant the characters had not
	;	been echoed back.
	;	R. Cox 25/09/87
	;Mod.3	Add patch to make Macro loop work, by jumping back to routine
	;	when [A-J] or [0-9] encountered.
	;	R. Cox 27/09/87
	;Mod.4	Add Heath-19 terminal emulation by diverting @DSP & @KBD
	;	routines to *SO/*SI and installing the Kermit terminal
	;	emulation filter on boot up. Heath-19 almost the same as
	;	the DEC VT52 with some additions.
	;	Add Call to HIGH$ to set LOW$ to patch start.
	;	R. Cox 04/10/87
	;Mod.5	Place code at end of main programme and set pointer for last
	;	byte up to new value. Remove call to LOW$ as unecessary.
	;	XT4 seems to crash when returning from an upload, maybe this
	;	will cure it if it is the patches that cause it. It is possible
	;	that HIGH$ are not being honoured and the filter is being
	;	overwritten, although I don't think that is the case. It is 
	;	also possible that XT4 is at fault. Who knows?
	;	R. Cox 16/10/87
	;Mod.6	Change <F1> from Modem Break, which I never use, to
	;	<L>ogon, which I do use. This is done by overwriting the
	;	call address in the Main drag. Plus change to *SO LD instruction.
	;	R. Cox 18/10/87
	;Mod.7	Change call to avoid recalling RAM from 4400H saved area since
	;	this is not always saved and it ends up putting the programme
	;	onto the screen, interesting but not very.
	;	R.Cox 14/12/87
	;Mod.8	Alter baud rates in initialization to 300/1275/7512/1200/
	;	2400/9600 (plus 19200 available but not displayed -
	;	option 7).
	;	R. Cox 31/12/87 Happy New Year....
	;Mod.9	NOP out compare and jump on zero for ^E - ENQ input to process
	;	Logon output. Cure for crashing eventually traced to the emulator
	;	filter which loads into 3000H and re-locates to EC9AH normally
	;	One of the jumps to the chained *DO task had an address that
	;	when relocated made the jump to the original programme at 3000H!
	;	so it worked fine until overwritten by another programme. This
	;	has now been patched out and seems to work fine.
	;	R. Cox 3/3/88 It's been a long time getting around to this!
	;Mod.10	The block counter uses a one byte counter so resets to zero
	;	every 256 blocks. This patch should increment a word to give
	;	up to 65,000+ (so who knows what 256*256 is).
	;	R. Cox 02/04/88
	;Mod.11	The end of the buffer seems to crash into the Heath filter
	;	before coming to an end. This mod will reduce the HIGH$ by
	;	a byte to make it safe. I've added a call to *SO at the
	;	start of the terminal main drag and another at the start of the
	;	Main menu drag to change the cursor from Block to Underline so
	;	that you can see when you're in the terminal mode. This means
	;	that you exit from the programme normally in underline mode.
	;	R. Cox 05/04/88
	;Mod.12	Change ATH to ATZ for Hangup command.
	;	R. Cox 09/04/88
	;Mod.13	Change A Modem Break to A Modem Reset
	;	R. Cox 01/09/88
	;
	;	We use this patch when the dialling command is issued
	;	and the Rx buffer is empty as shown by the pointers
	;	at 94BF and 94C1 are equal and the zero flag is set
	;	by the call to 94E7.
	;	In the test at 9415 we patch out to here.
	;	On entry:
	;	DE contains the address of the Rx buffer first character.
	;	HL contains the address of the Rx buffer last character.
	;	IX contains the address of the current character sent out.
	;
	;
	MAIN:	EQU	4400H		;XT4 Main start address
	DSP:	EQU	02H		;@DSP Display character to screen
	GET:	EQU	03H		;@Get from logical device
	PUT:	EQU	04H		;@PUT to logical device
	GTDCB:	EQU	52H		;@GTDCB Find specified DCB
	PAUSE:	EQU	10H		;@PAUSE SVC Call
	HIGHS:	EQU	64H		;@HIGH$ Read or alter HIGH$ or LOW$
	CKBRKC:	EQU	6AH		;@CKBRKC Check break character keyed
	SVC:	EQU	28H		;Supervisor reset address
	;
		ORG	0B500H		;Insert code beginning here and move
					;pointer up for last byte in main.
					;Mod.5
	GETSO:	EQU	$		;
		LD	DE,4F53H	;Look for the *SO DCB  Mod.6
	II:	EQU	$-1		;
		LD	A,GTDCB		;
		RST	SVC		;Gett DCB address
		JR	NZ,NOSO		;May not be there, I cannot think why
	NSORET:	LD	(TMODCB),HL	;Address in HL
	TT:	EQU	$-2		;
		LD	A,(II)		;Get contents
		CP	'I'		;check
		RET	Z		;Yes all done
		LD	A,'I'		;Get parms for *SI
		LD	(II),A		;and store them
		LD	HL,KMODCB	;
		LD	(TT),HL		;
		JR	GETSO		;Do it again
	NOSO:	LD	HL,0FFFFH	;Set switch up
		JR	NSORET		;for No *SO
	;
	PUTSO:	EQU	$		;
		PUSH	AF		;Mod.9 del save reg's IY,HL,BC
		LD	C,A		;Save character
		LD	DE,(TMODCB)	;Get DCB address
		LD	A,D		;Check to see if D=E It is almost 100%
		CP	E		;likely that =FFFF, dodgy but saves space
		JR	Z,DSPCH		;
		LD	A,PUT		;Send character out
		RST	SVC		;via SVC Mod.9 del save errnr code
	DRET:	POP	AF		;Unsave reg
		RET			;Mod.9 del unsave reg
	;
	DSPCH:	EQU	$		;
		LD	C,A		;
		LD	A,DSP		;Load display byte
		RST	SVC		;Call SVC
	;	POP	AF		;
		JR	DRET		;Get back to main
	;
	PUTSI:	EQU	$		;
		PUSH	DE		;
		LD	DE,(KMODCB)	;Get Device address
		LD	A,D		;Same routine as above, sorry!
		CP	E		;
		JP	Z,8CEFH		;Back to main
		LD	A,GET		;Get character from *SI
		RST	SVC		;Call SVC
		POP	DE		;char in A
		RET			;Done here
	;
	TMODCB:	DEFW	0FFFFH		;Init *SO to DSP
	KMODCB:	DEFW	0FFFFH		;Init *SI to KBD
	;
	PATCH:	EQU	$		;
		PUSH	AF		;Save present contents
		LD	A,(HAYSW)	;Get switch to test if Hayes command out
		CP	00H		;Test value
		JR	Z,NOHAY		;Not Hayes routine
	;
	;	Pause for awhile because modem cannot take characters
	;	more quickly.
		PUSH	BC		;Save to stack
		LD	BC,4000.	;Load pause count
		LD	A,PAUSE		;Load @PAUSE SVC
		RST	SVC		;Pause for 14.3*4000 micro-secs
		POP	BC		;Get BC back off stack
	;
		LD	A,'A'		;Load first Hayes command test
		CP	(IX)		;Check against the current character
		JR	Z,HAYCOM	;Yes it is a Hayes command
	NOHAY:	POP	AF		;Get original contents
		JP	942BH		;Jump back to main as not Hayes command
	;
	HAYCOM:	EQU	$		;
		LD	(HL),A		;Load Hayes character into Rx buffer
		POP	AF		;Get old AF back
		LD	A,(HL)		;Get the Hayes character back
		PUSH	AF		;and save to stack
		JP	941AH		;Jump back to main and process Rx buffer
					;which will Set Carry flag to indicate
					;that char. has been received by modem.
	;
	;Needs switch as Rx buffer check routine is called from a number of
	;differenct places. We don't need to test except if dialling/Hangup etc
	;
	SWITCH:	EQU	$		;
		PUSH	AF		;Save reg
		XOR	A		;Zero it
		LD	(HAYSW),A	;Zero buffer
		POP	AF		;Get reg back
		JP	0A0E7H		;Jump back to main
	;
	MACPAT:	EQU	$		;
		JP	Z,90A7H		;Jump back to main if next character
					;is '['.
		PUSH	AF		;Save to stack
		LD	A,CKBRKC	;Check <Break> key
		RST	SVC		;Call supervisor
		JR	NZ,BREAK	;Go if so
		POP	AF		;Get reg back
		DEC	HL		;Set back to '['
		JP	90B0H		;Jump back to reprocess new Macro
	BREAK:	EQU	$		;
		POP	AF		;Get reg back
		JP	8ED1H		;Error return in main
	;
	INCNBR:	EQU	$		;Mod.10
		LD	HL,(SAVNBR)	;Load old count
		LD	L,A		;Get current number
		INC	HL		;and bump it up one
		LD	(SAVNBR),HL	;Save it for later
		RET			;finished here today
	SAVNBR:	DEFW	$-$		;Init to zero
	;
	ZERONR:	EQU	$		;Mod.10
		LD	(0B442H),A	;Transferred code from main
		LD	HL,0		;Zero out
		LD	(SAVNBR),HL	;block number count
		RET			;finished
	;
	CURSOR:	EQU	$		;Mod.11
		LD	B,3		;Load count
		LD	HL,CHRS		;Point to start
	LOOP:	LD	A,(HL)		;Get character
		PUSH	HL		;Save positions
		PUSH	BC		;
		CALL	PUTSO		;Send it out
		POP	BC		;Unsave
		POP	HL		;
		INC	HL		;Bump pointer
		DEC	B		;Dec counter
		JR	NZ,LOOP		;Back for more
		RET			;Finished here today
	;
	CHRS:	DEFB	1BH		;Escape
	SWHTH:	DEFB	'x'		;Init to block
		DEFB	'4'		;Escape code for block U/L for Heath
	;
	HTHBLK:	EQU	$		;Mod.11
		LD	A,'x'		;Set to block
	MORE:	LD	(SWHTH),A	;load switch
		JR	CURSOR		;set cursor
	;
	HTHUL:	EQU	$		;Mod.11
		CALL	8FE0H		;Save screen (patched out from main)
		LD	A,'y'		;Set to Underline
		JR	MORE		;set it up on the screen
	;
	MODBRK:	EQU	$		;Mod.13
		LD	A,0FFH		;Set to Raise DTR/RTS
		OUT	(0EAH),A	;Send it out
		CALL	9B3DH		;Pause
		LD	A,0FCH		;Lower DTR/RTS
		OUT	(0EAH),A	;Send it out
		RET			;Return to main
	;
	L1:	EQU	$		;Finish byte here.
	;
		ORG	3238H		;
		DEFM	'LOGON STRING'	;Change startup message to new 
					;<F1> Key. Mod.6
	;
		ORG	4417H		;
		CALL	GETSO		;Overwrite unused <CKBRKC>
	;
		ORG	4560H		;
		DEFW	L1		;Enter new Main last byte pointer.Mod.5
	;
		ORG	463BH		;Mod.11
		LD	HL,(5C07H)	;Get HIGH$ into HL
		DEC	HL		;and reduce it by 1 byte to make it safe
		LD	(5C07H),HL	;Save it to buffer
		JP	8D4EH		;Jump into main
	;
		ORG	7AA5H		;
		DEFM	'1275'		;Display 1275 baud option
		ORG	7AAEH		;
		DEFM	'7512'		;Display 7512 baud option
		ORG	7AB8H		;
		DEFM	'1200'		;Display 1200 baud option
		ORG	7AC2H		;
		DEFM	'2400'		;Display 2400 baud option
	;
		ORG	8560H		;Mod.13
		DEFM	'A Disconnect Line '
	;
		ORG	8D5EH		;Mod.11
		CALL	HTHBLK		;Overwrite redundant <Break> check
	;
		ORG	8D9DH		;Mod.9
		NOP			;Zero out Jump to ^E processing
		NOP			;as it's such a pain.
		NOP			;
	;
		ORG	8DA0H		;Mod.9 
		CALL	PUTSO		;Jump out to alternate *SO screen
		NOP			;Plug extra byte
	;
	;	ORG	8DC3H		;Mod.9 (only calls *KI anyway!)
	;	CALL	PUTSI		;Jump out to @KBD routine via *SI
	;
		ORG	8E08H		;
		CALL	9039H		;Call Logon sequence and overwrite
					;Modem break call. Mod.6(Mod.7 was 9036)
	;
		ORG	9071H		;
		JP	MACPAT		;Jump to Macro Patch area
		NOP			;Blank out spare bit of code
	;
		ORG	90A2H		;Mod.Tmp
		NOP			;Blank out call to display
		NOP			;during logon calls
		NOP			;
	;
		ORG	9162H		;
		DEFB	17H		;Byte for Rx1200bd Tx75bd
		DEFW	1275.		;Store binary baud rate
		DEFB	71H		;Byte for Rx75bd Tx1200bd
		DEFW	7512.		;Store binary rate
		DEFB	77H		;Byte for Rx/Tx 1200bd
		DEFW	1200.		;Store binary baud rate
		DEFB	0AAH		;Byte for Rx/Tx 2400bd
		DEFW	2400.		;Store binary baud rate
	;
		ORG	9415H		;Patch out address
		JP	Z,PATCH		;Changed from 942BH
	;
		ORG	9505H		;Mod.11
		CALL	HTHUL		;Jump out to set underline
	;
		ORG	9B0EH		;Patch Modem Break to Modem Reset Mod.13
		CALL	MODBRK		;Jump out to reset <TR> <RS> lines
	;
		ORG	9D71H		;Mod.12
		DEFB	'Z'		;Change ATH to ATZ for hangup
	;
		ORG	9D91H		;Patch out the switch back in HAYSW
		JP	SWITCH		;
	;
		ORG	9DBCH		;Initialize the switch to zero on Boot up
	HAYSW:	DEFB	00H		;This is switch to 0FFH when Hayes cmd
					;is set up.
	;
	;
		ORG	0B3C5H		;Mod.10
		CALL	ZERONR		;Zero out HL
	;
		ORG	0B3FBH		;Mod.10
		CALL	INCNBR		;bump 16 bit block number count
	;
		END	MAIN		;Set PC to XT4 Main start
