	TITLE	'<WPFLT - Word Pro. Filter - 6>'
;
; This filter allows embeding of printer control codes
; in text.
;
; Written and copyrighted by:
;
;	Irwin B. Burton
;	5450 W. Rowland Ave.
;	Littleton, CO  80123
;	(303) 979-5911
;	All Rights Reserved. - April 11, 1988
;
; Permission is granted to use and distribute this
; program for non-commercial purposes, however, I would
; appreciate an acknowledgement from persons using it.
; (Please don't delete my name from the messages.)
;
; The syntax is:
;
;	SET *ps (parm=,parm=,parm=)]
;	FILTER *PR *ps
;
; The parameters are:
;
;	TOGGLE	Selects TOGGLE character that turns the
;		filter ON/OFF. Defaults to 7FH
;	ESCAPE	Selects ESCAPE character that signals a
;		printer command code. Defaults to '#'.
;	PAUSE	Selects PAUSE character that signals a
;		pause desired. Also allows input from
;		keyboard until <ENTER> pressed.
;		Defaults to '*'.
;
; Parameters may be entered as:  X'hh  or  ddd  or  "c".
;	and first letter abbriviations may be used.
;
;-------------------------------------------------------
	PAGE
;---------------
; Constants
;---------------
;
LF	EQU	10
CR	EQU	13
@KEY	EQU	01H
@DSPLY	EQU	0AH
@LOGOT	EQU	0CH
@PARAM	EQU	11H
@CHNIO	EQU	14H
@EXIT	EQU	16H
@GTMOD	EQU	53H
@HIGH$	EQU	64H
@FLAGS	EQU	65H
;
;---------------
; MACROs
;---------------
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
PRINT	MACRO	#ADDR
	LD	HL,#ADDR
	SVC	@DSPLY
	ENDM
;
;----------------
;
	ORG	3000H
;
;---------------
; Messages
;---------------
;
SIGNON	DB	'WPFLT - "Word Processing Filter" - '
	DB	'Version 6.1.8 - 04/11/88',LF
	DB	'For LS-DOS 6.x and '
	DB	'Epson MX 80/100 printer.',LF
CREDIT	DB	'Copyright (C) 1988 '
	DB	'by Irwin B. Burton - '
	DB	'All rights reserved.',LF,CR
SUCCESS	DB	'Installation successfully completed.',LF
	DB	'Use the FILTER command '
	DB	'to connect to *PR.',LF,CR
PRMERR$	DB	'Bad parameters!',CR
;
PRMTBL$	DB	80H
;
	DB	80H.OR.20H.OR.10H.OR.6
	DB	'TOGGLE'	;Parameter Word
TRESP	DB	0		;Response byte
	DW	TPARM+1		;Storge address
;
	DB	80H.OR.20H.OR.10H.OR.6
	DB	'ESCAPE'
ERESP	DB	0
	DW	EPARM+1
;
	DB	80H.OR.20H.OR.10H.OR.5
	DB	'PAUSE'
PRESP	DB	0
	DW	PPARM+1
;
	NOP			;End of PARM table
;
;-------------------------------------------------------
; Actual Filter
;-------------------------------------------------------
;
;---------------
; Filter Header
;---------------
;
BEGIN	JR	FIRST		;Branch around linkage
OLDHI	DW	$-$		;Last Byte use by Filter
NAMELEN	DB	MODDCB-FIRST-5
MODNAME	DB	'WPFLT_MX'	;Module Name
MODDCB	DW	00
	DW	00
;
FIRST	JP	START		;Jump over CODE TABLE
REL_1	EQU	$-2
FLAG1	DB	0
;
;---------------
; CONTROL CHARACTERS & CODES FOR EPSON MX 80/100
;---------------
;
*LIST	OFF
TABLE	DB	'A'	;ACCUTE ACCENT CONTROL Letter
	DB	83H	;Printer Code
	DB	0FFH	;End of Code signal
	DB	'a'
	DB	84H	;GRAVE ACCENT
	DB	0FFH
	DB	'B'
	DB	08H	;BACKSPACE
	DB	0FFH
	DB	'b'
	DB	07H	;BUZZER
	DB	0FFH
	DB	'C'
	DB	0FH	;COMPRESSED ON
	DB	0FFH
	DB	'c'
	DB	12H	;COMPRESSED OFF
	DB	0FFH
	DB	'D'
	DB	1BH	;DOUBLE ON
	DB	47H
	DB	0FFH
	DB	'd'
	DB	1BH	;DOUBLE OFF
	DB	48H
	DB	0FFH
	DB	'E'
	DB	1BH	;EMPHASIZED ON
	DB	45H
	DB	0FFH
	DB	'e'
	DB	1BH	;EMPHASIZED OFF
	DB	46H
	DB	0FFH
	DB	'F'	;'1/2'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'1'		;Print '1'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'2'		;Print '2'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'f'	;'1/4'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'1'		;Print '1'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'4'		;Print '4'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'G'
	DB	1BH	;PAPER OUT DIS-REGARD
	DB	38H
	DB	0FFH
	DB	'g'
	DB	1BH	;PAPER OUT REGARD
	DB	39H
	DB	0FFH
	DB	'H'
	DB	1BH	;HEAVY/EMPHASIZED ON
	DB	45H
	DB	0FFH
	DB	'h'
	DB	1BH	;HEAVY/EMPHASIZED OFF
	DB	46H
	DB	0FFH
	DB	'I'
	DB	1BH	;ITALIC ON
	DB	34H
	DB	0FFH
	DB	'i'
	DB	1BH	;ITALIC OFF
	DB	35H
	DB	0FFH
	DB	'J'
	DB	1BH	;1/8" LS
	DB	30H
	DB	0FFH
	DB	'j'
	DB	1BH	;1/6" LS
	DB	32H
	DB	0FFH
	DB	'K'
	DB	0DH	;CR
	DB	0FFH
	DB	'k'
	DB	1BH	;7/72" LS
	DB	31H
	DB	0FFH
	DB	'l'
	DB	0AH	;LF
	DB	0FFH
	DB	'M'
	DB	5EH	;CIRCUMFLEX
	DB	0FFH
	DB	'n'
	DB	82H	;OMLAUT
	DB	0FFH
	DB	'N'
	DB	7EH	;SIGN OR TILDE
	DB	0FFH
	DB	'O'
	DB	1BH	;UNIDIRECTIONAL ON
	DB	55H
	DB	01H
	DB	0FFH
	DB	'o'
	DB	1BH	;UNIDIRECTIONAL OFF
	DB	55H
	DB	00H
	DB	0FFH
	DB	'R'
	DB	1BH	;POWER ON RESET
	DB	40H
	DB	0FFH
	DB	'r'	;'3/4'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'3'		;Print '3'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'4'		;Print '4'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'S'
	DB	1BH	;SUPER-SCRIPT ON
	DB	53H
	DB	00H
	DB	0FFH
	DB	's'
	DB	1BH	;SUPER-SCRIPT OFF
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'U'
	DB	1BH	;UNDERLINE ON
	DB	2DH
	DB	01H
	DB	0FFH
	DB	'u'
	DB	1BH	;UNDERLINE OFF
	DB	2DH
	DB	00H
	DB	0FFH
	DB	'W'
	DB	1BH	;WIDE ON
	DB	57H
	DB	01H
	DB	0FFH
	DB	'w'
	DB	1BH	;WIDE OFF
	DB	57H
	DB	00H
	DB	0FFH
	DB	'X'
	DB	1BH	;SUB-SCRIPT ON
	DB	53H
	DB	01H
	DB	0FFH
	DB	'x'
	DB	1BH	;SUB-SCRIPT OFF
	DB	48H
	DB	0FFH
	DB	'Z'
	DB	5CH	;CARROT
	DB	0FFH
	DB	'z'
	DB	7CH	;RULE
	DB	0FFH
	DB	'<'
	DB	7BH	;LEFT CURLY BRACKET
	DB	0FFH
	DB	'>'
	DB	7DH	;RIGHT CURLY BRACKET
	DB	0FFH
	DB	'('
	DB	5BH	;LEFT SQUARE BRACKET
	DB	0FFH
	DB	')'
	DB	5DH	;RIGHT SQUARE BRACKET
	DB	0FFH
	DB	0FFH
*LIST	ON
;
;----------------------------------------------------
; DRIVER/CONVERSION ROUTINE
;
;   This routine will convert embeded commands to
;   control codes for printer use.
;----------------------------------------------------
;
START	JR	Z,FILTER	;Go if *PUT request
;
FLTPUT	PUSH	IX		;Save current pointer
	PUSH	BC		
	LD	IX,(MODDCB)	;P/u this module's DCB
REL_2	EQU	$-2
	SVC	@CHNIO		;Chain it
	POP	BC
	POP	IX
	RET
;
FILTER	EQU	$		;Actual Filter
	LD	A,C		;Get current character
TOGGLE	CP	7FH		;Is it TOGGLE Char.
	JR	NZ,SWITCH	;NO, go on
	LD	A,(SWITCH+1)	;YES, get SWITCH
REL_3	EQU	$-2
	XOR	0FFH		;Toggle SWITCH
	LD	(SWITCH+1),A	;Put back into SWITCH
REL_4	EQU	$-2
	JR	DONE
SWITCH	LD	A,0		;Defaults off
	OR	A		;Check switch status
	JR	Z,FLTPUT	;Filter OFF, so Go
;
	LD	A,(FLAG1)	;Get last character
REL_5	EQU	$-2
ESCP1	CP	'#'		;ESCAPE Flag Set?
	LD	A,C		;grab the output byte
	LD	(FLAG1),A	;Save character
REL_6	EQU	$-2
	JR	Z,SEARCH	;Go if in ESCAPE mode
ESCP2	CP	'#'		;ESCAPE Character?
	JR	NZ,DONE2	;NO, then done
DONE	LD	A,0		;Put a "dummy" Char in A
DONE2	LD	C,A		;Be sure prt char is in C
	JR	FLTPUT		;Print it
SEARCH	LD	HL,TABLE	;Setup TABLE Pointer
REL_7	EQU	$-2
;
PAWS	CP	'*'		;Check for PAUSE char
	JR	Z,PAUSE		;YES, then Jump to PAUSE
;
NEXT	LD	A,(FLAG1)	;Get CMD request char
REL_8	EQU	$-2
	CP	(HL)		;Find it?
	JR	Z,PRINT1	;YES, then PRINT CMD
	LD	A,0FFH		;End of CMD marker
NYLOOP	INC	HL		;Inc tbl pntr to next ctl
	CP	(HL)		;End of CMD?
	JR	NZ,NYLOOP	;End of CMD not found
	INC	HL		;Bump to next CMD
	CP	(HL)		;End of Table?
	JR	NZ,NEXT		;NO, loop again
ESCP3	LD	A,'#'		;Get ESCAPE Charater
	CALL	DONE2		;Print ESCAPE since this
REL_9	EQU	$-2		;  is invalid ESCAPE code
	LD	A,(FLAG1)	;Get present char
REL_10	EQU	$-2
	JR	DONE2		;Print it.
;
PRINT1	INC	HL		;Bump to CMD portion
PRINT2	LD	A,(HL)		;Get character to send
	CP	0FFH		;End of CMD?
	JR	Z,DONE		;YES, Done
	LD	C,A		;NO, load into C
	PUSH	HL		;Save table pointer
	CALL	FLTPUT		;Print CMD
REL_11	EQU	$-2
	POP	HL		;Retreve table pointer
	JR	PRINT1		;Ready for next CMD char
;
;---------------
; Special Functions
;---------------
;
PAUSE	SVC	@KEY		;Wait for response
	CP	CR		;Is it CR?
	JR	Z,DONE		;YES, Done
	CALL	DONE2		;Print the character
REL_12	EQU	$-2
	JR	PAUSE		;Do again
;
FLTEND	EQU	$-1
FLTLEN	EQU	$-BEGIN
;
;---------------
; Initialization Code
;---------------
;
INIT	EQU	$
;
;---------------
; Parameter parsing
;---------------
;
	PUSH	DE		;Save DCB
	LD	DE,PRMTBL$	;Grab user parms
	SVC	@PARAM
	JP	NZ,PRMERR
;
TPARM	LD	BC,7FH		;Init to DELETE
	LD	A,(TRESP)	;P/u the response
	OR	A		;  & see if any entry
	JR	Z,TDEFLT	;Default if none
	BIT	7,A		;Value entry?
	JR	NZ,TDEFLT	;Value is in reg C
	BIT	5,A		;String value?
	JP	Z,PRMERR	;ERROR if anything else
	LD	A,(BC)		;BC contains a pointer
	LD	C,A		;Shorter than a jump
TDEFLT	LD	A,C		;Xfer value to reg A
	LD	(TOGGLE+1),A
;
EPARM	LD	BC,'#'		;Init to NUMBER
	LD	A,(ERESP)	;P/u the response
	OR	A		;  & see if any entry
	JR	Z,EDEFLT	;Default if none
	BIT	7,A		;Value entry?
	JR	NZ,EDEFLT	;Value is in reg C
	BIT	5,A		;String value?
	JP	Z,PRMERR	;ERROR if anything else
	LD	A,(BC)		;BC contains a pointer
	LD	C,A		;Shorter than a jump
EDEFLT	LD	A,C		;Xfer value to reg A
	LD	(ESCP1+1),A
	LD	(ESCP2+1),A
	LD	(ESCP3+1),A
;
PPARM	LD	BC,'*'		;Init to ASTERIC
	LD	A,(PRESP)	;P/u the response
	OR	A		;  & see if any entry
	JR	Z,PDEFLT	;Default if none
	BIT	7,A		;Value entry?
	JR	NZ,PDEFLT	;Value is in reg C
	BIT	5,A		;String value?
	JP	Z,PRMERR	;ERROR if anything else
	LD	A,(BC)		;BC contains a pointer
	LD	C,A		;Shorter than a jump
PDEFLT	LD	A,C		;Xfer value to reg A
	LD	(PAWS+1),A
;
	POP	DE		;Recover DCB
;
;-------------------------------------------------------
;	The following code is based on
;    Hardin Brothers' Filter Installation Module
;	80-MICRO, September 1986, p. 109
;	I give him full credit for it.
;-------------------------------------------------------
;
	PUSH	DE
	LD	(MODDCB),DE
	PRINT	SIGNON
	LD	DE,MODNAME
	SVC	@GTMOD
	JR	NZ,VIASET
	LD	HL,INSTLD
;
ERR_OUT	SVC	@DSPLY
	LD	HL,-1
	SVC	@EXIT
;
;---------------
;   Installed with SET command?
;---------------
;
VIASET	SVC	@FLAGS
	BIT	3,(IY+'C'-'A')
	JR	NZ,SETHI
	LD	HL,NOSET
	JR	ERR_OUT
;
;---------------
;   RESET HIGH$
;---------------
;
SETHI	LD	HL,0
	LD	B,L
	SVC	@HIGH$
	LD	(OLDHI),HL
	JR	Z,RELOC
	LD	HL,MEMERR
	JR	ERR_OUT
;
;---------------
;  Resolve memory references
;---------------
;
RELOC	LD	IY,RELTAB
	LD	DE,FLTEND
	XOR	A
	SBC	HL,DE
	PUSH	HL
	POP	BC
;
RELOC1	LD	L,(IY+0)
	LD	H,(IY+1)
	LD	A,H
	OR	A
	JR	Z,MOVE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	ADD	HL,BC
	EX	DE,HL
	LD	(HL),D
	DEC	HL
	LD	(HL),E
	INC	IY
	INC	IY
	JR	RELOC1
;
;---------------
;  Move and protect the filter
;---------------
;
MOVE	LD	DE,(OLDHI)
	LD	HL,FLTEND
	LD	BC,FLTLEN
	LDDR
	EX	DE,HL
	LD	B,0
	SVC	@HIGH$
	INC	HL
;
;---------------
;   Set the DCB in TRSDOS
;---------------
;
	POP	IX
	LD	(IX),40H.OR.7
	LD	(IX+1),L
	LD	(IX+2),H
	PRINT	SUCCESS
	LD	HL,0
	SVC	@EXIT
;
INSTLD	DB	'Program already in memory -- '
	DB	'installation aborted.',LF,CR
;
NOSET	DB	'Program must be installed with the '
	DB	'SET command.',LF,CR
;
MEMERR	DB	'High memory not available for '
	DB	'installation.',LF,CR
;
;
;---------------
; Parameter error
;---------------
;
PRMERR	LD	HL,PRMERR$
	SVC	@LOGOT
	LD	HL,-1
	RET
;
RELTAB	DW	REL_1,REL_2,REL_3,REL_4,REL_5,REL_6
	DW	REL_7,REL_8,REL_9,REL_10,REL_11,REL_12
	DW	00
;
	END	INIT
