	TITLE	'<WPFLT - Word Pro. Filter - 5>'
;
; This filter allows embeding of printer control codes
; in text.
;
; Written and copyrighted by:
;
;	Irwin B. Burton
;	5450 W. Rowland Ave.
;	Littleton, CO  80123
;	(303) 979-5911
;
;	All Rights Reserved. - April 11, 1988
;
; Permission is granted to use and distribute this
; program for non-commercial purposes, however, I would
; appreciate an acknowledgement from persons using it.
; (Please don't delete my name from the messages.)
;
; The syntax is:
;
;	FILTER *PR WPFLT [(parm=,parm=,parm=)]
;
; The parameters are:
;
;	TOGGLE	Selects TOGGLE character that turns the
;		filter ON/OFF. Defaults to 7FH
;	ESCAPE	Selects ESCAPE character that signals a
;		printer command code. Defaults to '#'.
;	PAUSE	Selects PAUSE character that signals a
;		pause desired. Also allows input from
;		keyboard until <ENTER> pressed.
;		Defaults to '*'.
;
; Parameters may be entered as:  X'hh'  or  ddd  or  "c".
;	and first letter abbriviations may be used.
;
;-------------------------------------------------------
	PAGE
;
;---------------
; Constants
;---------------
;
LF	EQU	10
CR	EQU	13
@KEY	EQU	0049H
@EXIT	EQU	402DH
@ABORT	EQU	4030H	;error abort
HIGH$	EQU	4411H	;highest usable memory
@PARAM	EQU	4454H
@DSPLY	EQU	4467H	;display message
@LOGOT	EQU	428AH	;display & log message
;
;---------------
;
	ORG	5200H
;
;---------------
; Messages
;---------------
;
SIGNON	DB	'WPFLT - "Word Processing Filter" - '
	DB	'Version 5.1.8 - 04/11/1988',LF
	DB	'For LDOS 5.x and '
	DB	'Epson MX 80/100 printer.',LF
CREDIT	DB	'Copyright (C) 1988 '
	DB	'by Irwin B. Burton - '
	DB	'All rights reserved.',LF,CR
SUCCESS	DB	'Installation successfully completed.',CR
;
ERR	DB	'This filter is for output only!',CR
PRM_MSG	DB	'Bad Parameters!',CR
;
;---------------
; Parameter Table
;---------------
;
PARMTBL	DB	'TOGGLE'	;TOGGLE Parameter
	DW	TPARM+1
	DB	'T     '
	DW	TPARM+1
;
	DB	'ESCAPE'	;ESCAPE Parameter
	DW	EPARM+1
	DB	'E     '
	DW	EPARM+1
;
	DB	'PAUSE '	;PAUSE Parameter
	DW	PPARM+1
	DB	'P     '
	DW	PPARM+1
	NOP
;
;-------------------------------------------------------
; Actual Filter
;-------------------------------------------------------
;
;---------------
; Filter Header
;---------------
;
FIRST	JR	BEGIN		;Branch around linkage
OLDHI	DW	$-$		;Old HIGH$
NAMELEN	DB	MODDCB-FIRST-5
MODNAME	DB	'WPFLT_MX'	;Module Name
MODDCB	DW	00
	DW	00
;
BEGIN	JP	START		;Jump over CODE TABLE
REL1	EQU	$-2
FLAG1	DB	0
;
;---------------
; CONTROL CHARACTERS & CODES FOR EPSON MX 80/100
;---------------
;
*LIST	OFF
TABLE	DB	'A'	;ACCUTE ACCENT CONTROL Letter
	DB	83H	;Printer Code
	DB	0FFH	;End of Code Signal
	DB	'a'
	DB	84H	;GRAVE ACCENT
	DB	0FFH
	DB	'B'
	DB	08H	;BACKSPACE
	DB	0FFH
	DB	'b'
	DB	07H	;BUZZER
	DB	0FFH
	DB	'C'
	DB	0FH	;COMPRESSED ON
	DB	0FFH
	DB	'c'
	DB	12H	;COMPRESSED OFF
	DB	0FFH
	DB	'D'
	DB	1BH	;DOUBLE ON
	DB	47H
	DB	0FFH
	DB	'd'
	DB	1BH	;DOUBLE OFF
	DB	48H
	DB	0FFH
	DB	'E'
	DB	1BH	;EMPHASIZED ON
	DB	45H
	DB	0FFH
	DB	'e'
	DB	1BH	;EMPHASIZED OFF
	DB	46H
	DB	0FFH
	DB	'F'	;'1/2'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'1'		;Print '1'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'2'		;Print '2'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'f'	;'1/4'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'1'		;Print '1'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'4'		;Print '4'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'G'
	DB	1BH	;PAPER OUT DIS-REGARD
	DB	38H
	DB	0FFH
	DB	'g'
	DB	1BH	;PAPER OUT REGARD
	DB	39H
	DB	0FFH
	DB	'H'
	DB	1BH	;HEAVY/EMPHASIZED ON
	DB	45H
	DB	0FFH
	DB	'h'
	DB	1BH	;HEAVY/EMPHASIZED OFF
	DB	46H
	DB	0FFH
	DB	'I'
	DB	1BH	;ITALIC ON
	DB	34H
	DB	0FFH
	DB	'i'
	DB	1BH	;ITALIC OFF
	DB	35H
	DB	0FFH
	DB	'J'
	DB	1BH	;1/8" LS
	DB	30H
	DB	0FFH
	DB	'j'
	DB	1BH	;1/6" LS
	DB	32H
	DB	0FFH
	DB	'K'
	DB	0DH	;CR
	DB	0FFH
	DB	'k'
	DB	1BH	;7/72" LS
	DB	31H
	DB	0FFH
	DB	'l'
	DB	0AH	;LF
	DB	0FFH
	DB	'M'
	DB	5EH	;CIRCUMFLEX
	DB	0FFH
	DB	'n'
	DB	82H	;OMLAUT
	DB	0FFH
	DB	'N'
	DB	7EH	;SIGN OR TILDE
	DB	0FFH
	DB	'O'
	DB	1BH	;UNIDIRECTIONAL ON
	DB	55H
	DB	01H
	DB	0FFH
	DB	'o'
	DB	1BH	;UNIDIRECTIONAL OFF
	DB	55H
	DB	00H
	DB	0FFH
	DB	'R'
	DB	1BH	;POWER ON RESET
	DB	40H
	DB	0FFH
	DB	'r'	;'3/4'
	DB	1BH		;Turn on Super-Script
	DB	53H
	DB	00H
	DB	'3'		;Print '3'
	DB	08H		;Print backspace
	DB	1BH		;Turn off Super-Script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	1BH		;Turn on Sub-Script
	DB	53H
	DB	01H
	DB	'4'		;Print '4'
	DB	1BH		;Turn off sub-script
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'S'
	DB	1BH	;SUPER-SCRIPT ON
	DB	53H
	DB	00H
	DB	0FFH
	DB	's'
	DB	1BH	;SUPER-SCRIPT OFF
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'U'
	DB	1BH	;UNDERLINE ON
	DB	2DH
	DB	01H
	DB	0FFH
	DB	'u'
	DB	1BH	;UNDERLINE OFF
	DB	2DH
	DB	00H
	DB	0FFH
	DB	'W'
	DB	1BH	;WIDE ON
	DB	57H
	DB	01H
	DB	0FFH
	DB	'w'
	DB	1BH	;WIDE OFF
	DB	57H
	DB	00H
	DB	0FFH
	DB	'X'
	DB	1BH	;SUB-SCRIPT ON
	DB	53H
	DB	01H
	DB	0FFH
	DB	'x'
	DB	1BH	;SUB-SCRIPT OFF
	DB	48H
	DB	1BH
	DB	55H
	DB	00H
	DB	0FFH
	DB	'Z'
	DB	5CH	;CARROT
	DB	0FFH
	DB	'z'
	DB	7CH	;RULE
	DB	0FFH
	DB	'<'
	DB	7BH	;LEFT CURLY BRACKET
	DB	0FFH
	DB	'>'
	DB	7DH	;RIGHT CURLY BRACKET
	DB	0FFH
	DB	'('
	DB	5BH	;LEFT SQUARE BRACKET
	DB	0FFH
	DB	')'
	DB	5DH	;RIGHT SQUARE BRACKET
	DB	0FFH
	DB	0FFH
	DB	'# ',0FFH	;invalid ctl
*LIST	ON
;
;---------------
; DRIVER/CONVERSION ROUTINE
;    This routine will convert embedded commands
;    to control codes for printer use.
;---------------
;
START	JR	C,GETBYT	;jump if *GET request
;
FILTER	PUSH	AF		;Save flags
;
	LD	A,C		;Get current character
TOGGLE	CP	0		;Is it TOGGLE Char?
	JR	NZ,SWITCH	;NO, go on
	LD	A,(SWITCH1)	;Get SWITCH value
REL2	EQU	$-2
	XOR	0FFH		;Toggle SWITCH
	LD	(SWITCH1),A	;Put into SWITCH
REL3	EQU	$-2
	JR	DONE
;
SWITCH	LD	A,0		;Defaults OFF
SWITCH1	EQU	$-1
	OR	A		;Check SWITCH status
	JR	NZ,PUTBYT
	POP	AF
	JR	GETBYT		;Filter OFF, so GO
;
PUTBYT	LD	A,(FLAG1)
REL4	EQU	$-2
ESCP1	CP	'#'
	LD	A,C		;grab the output byte
	LD	(FLAG1),A
REL5	EQU	$-2
	JR	Z,SEARCH
ESCP2	CP	'#'		;FIRST PT OF CONTROL CHR
	JR	Z,DONE		;IF '# ' THEN PRINT IT
	POP	AF
	LD	A,(FLAG1)
REL6	EQU	$-2
	JR	DONE2
DONE	POP	AF
	LD	A,0
DONE2	LD	C,A
	JR	GETBYT
;
SEARCH	LD	HL,TABLE	;Set pointer to TABLE
REL7	EQU	$-2
;
PAWS	CP	'*'		;Check for PAUSE Char
	JR	Z,PAUSE		;YES, Go to PAUSE
;
NEXT	LD	A,(FLAG1)	;Get present character
REL8	EQU	$-2
	CP	(HL)		;FIND IT?
	JR	Z,PRINT1	;YES? Then Print
NOTYET	LD	A,0FFH
NYLOOP	INC	HL		;Inc tbl pntr to next ctl
	CP	(HL)		;End of CMD?
	JR	NZ,NYLOOP	;End of CMD not found
	INC	HL		;Bumpt to next CMD
	CP	(HL)		;End of Table?
	JR	NZ,NEXT		;NO, loop again
ESCP3	LD	A,'#'		;Get ESCAPE Character
	CALL	DONE2		;Print ESCAPE since this
REL9	EQU	$-2		;  is invalid ESCAPE code
	LD	A,(FLAG1)	;Get present character
REL10	EQU	$-2
	JR	DONE2		;Print it
;
PRINT1	INC	HL
PRINT2	LD	A,(HL)		;GET THE CHAR TO SEND TO
	CP	0FFH		;END OF COMAND?
	JR	Z,DONE
	POP	AF
	PUSH	AF
	LD	A,(HL)
	LD	C,A
	PUSH	HL		;SAVE TABLE POINTER
CALL	CALL	0000		;Print It and Return
	POP	HL		;RETREVE TABLE POINTER
	JR	PRINT1		;SEND NEXT CMD CHAR.
;
GETBYT	JP	0000		;Print it and go on
;
;---------------
; Special Functions
;---------------
;
PAUSE	CALL	@KEY
	CP	CR
	JR	Z,DONE
	LD	C,A
	POP	AF
	PUSH	AF
	LD	A,C
	PUSH	HL
	PUSH	BC
CALL1	CALL	0000		;SEND IT
	POP	BC
	POP	HL
	JR	PAUSE
;
FLTEND	EQU	$
;
;-------------------------------------------------
;
;---------------
; Installation code
;---------------
;
ENTRY	LD	A,(DE)		;get device type
	AND	2		;make sure its an
	JP	Z,NOGOOD	;output device
	PUSH	DE		;save device DCB
	PUSH	HL		;save command line
	LD	HL,SIGNON
	CALL	@DSPLY
	POP	HL		;restore command line
	LD	DE,PARMTBL
	CALL	@PARAM
	JP	NZ,PARMERR
;
TPARM	LD	BC,007FH	;DELETE Defaults
	LD	A,B
	CP	00H
	JR	NZ,TCONT
	LD	A,C
	JR	TSTUF
TCONT	LD	A,(BC)
TSTUF	LD	(TOGGLE+1),A
;
EPARM	LD	BC,0023H	;NUMBER Defaults
	LD	A,B
	CP	00H
	JR	NZ,ECONT
	LD	A,C
	JR	ESTUF
ECONT	LD	A,(BC)
ESTUF	LD	(ESCP1+1),A
	LD	(ESCP2+1),A
	LD	(ESCP3+1),A
;
PPARM	LD	BC,002AH	;ASTERIC Defaults
	LD	A,B
	CP	00H
	JR	NZ,PCONT
	LD	A,C
	JR	PSTUF
PCONT	LD	A,(BC)
PSTUF	LD	(PAWS+1),A
;
	POP	IX		;recover device DCB
	LD	L,(IX+1)	;xfer orig DCB vector
	LD	H,(IX+2)
	LD	(CALL+1),HL
	LD	(GETBYT+1),HL
	LD	(CALL1+1),HL
	LD	(REL9),HL
	LD	HL,(HIGH$)	;Reduce HIGH$
	LD	(OLDHI),HL	;Now end of module
	LD	BC,FLTEND-FIRST	;length of this driver
	XOR	A		;Clear the carry flag
	SBC	HL,BC		;Calculate new HIGH$
	LD	(HIGH$),HL	;Driver now protected
	INC	HL		;Inc HL to begin of Modul
	PUSH	HL
	LD	DE,FLAG1-FIRST	;Calculate pos of FLAG1
	OR	A
	ADD	HL,DE
	LD	(REL4),HL
	LD	(REL5),HL
	LD	(REL8),HL
	LD	(REL6),HL
	LD	(REL10),HL
	INC	HL		;Calculate pos of TABLE
	LD	(REL7),HL
	XOR	A
	LD	DE,START-TABLE	;Calculate pos of START
	ADD	HL,DE
	LD	(REL1),HL
	XOR	A
	LD	DE,SWITCH1-START
	ADD	HL,DE
	LD	(REL2),HL
	LD	(REL3),HL
	POP	HL
	PUSH	HL
	DI			;not during update
	LD	(IX+1),L	;Update DCB vector
	LD	(IX+2),H	;to filter entry
	POP	DE
	LD	HL,FIRST	;Load address of driver
	LDIR			;Move driver to top
	EI			;Enable interrupts again
	JP	@EXIT		;Return to LDOS Ready
;
;---------------
; ERROR Handling
;---------------
;
PARMERR	LD	HL,PRM_MSG
	JR	ERREXIT
NOGOOD	LD	HL,ERR
ERREXIT	CALL	@LOGOT
	JP	@ABORT
;
;
	END	ENTRY
