These is the remaining program fron Volumn 1, Number 6 (October 1982).

From Les Mikesell's column, Page 87.

The following CLFLT/FLT is a general purpose communications filter. It includes features to add nulls after carriage returns, a delay between characters, and a linefeed after every carriage return. It also provides a mask parameter to remove parity bits during ASCII file reception.

00100 ;Communications filter for LDOS RS232 drivers to provide
00110 ;testing for modem carrier, delay between characters,
00120 ;and linefeeds and nulls after carriage returns.
00130 ; Enter with parameters:
00140 ; CARRIER = ON or Y  /default is OFF
00150 ;       Setting ON will cause all input or output requests
00160 ;       to be ignored unless the modem is receiving a
00170 ;       carrier signal
00180 ; ADDLF = ON or Y   /default is OFF
00190 ;       Setting ON will add a linefeed after each carriage
00200 ;       return. 
00210 ; NULLS = 0 to 256  /default is 0
00220 ;       Number of nulls to send after each carriage return
00230 ; DELAY = 0 to X'FFFF' /default is 0
00240 ;       Variable timing delay between output characters to
00250 ;       allow sending to systems that cannot accept full
00260 ;       speed transmission.
00270 ; MASK = ON or OFF /default is OFF
00280 ;       Setting ON will strip the high bit from received
00290 ;       characters, removing parity bits that may have been
00300 ;       added by the sender.  Use only for transmissions in
00310 ;       the ASCII character range, not for 8-bit binary data.
00320 ; All parameters may be abbreviated with the first letter
00330 ;
00340 ; Hardware dependant EQUates.. Mod 1 addresses used
00350 RSHACK  EQU     -1      ;a logical TRUE for assembly
00360 LX80    EQU     0       ;logical FALSE (reverse for LX80)
00370 HIGH$   EQU     4411H   ;<=change to 4049H for Mod 1
00380 @PARAM  EQU     4454H   ;<= 4476H for Mod 1
00390 @LOGOT  EQU     428AH   ;<= 447BH for Mod 1
00400 ;
00410 ; General EQUates...
00420 @EXIT   EQU     402DH
00430 @ABORT  EQU     4030H
00440 @DSPLY  EQU     4467H
00450 @DELAY  EQU     60H
00460 LF      EQU     10      ;linefeed character
00470 CR      EQU     13      ;carriage return
00480 ;
00490 ; LDOS 'FILTER' command handler
00500 ;
00510         ORG     5200H           
00520 ENTRY:  PUSH    DE              ;save DCB pointer
00530         POP     IX              ;into IX register
00540         PUSH    HL              ;save cmd line pointer
00550         LD      A,(DE)          ;Pick up DCB type byte
00560         PUSH    AF
00570         LD      HL,SIGNON       ;=>Signon message
00580         CALL    @DSPLY          ;print it
00590         POP     AF              ;restore type byte
00600         BIT     3,A             ;Device routed to NIL?
00610         JP      NZ,ISNIL        ;Go if so
00620         BIT     4,A             ;Routed?
00630         JP      NZ,ROUTED       ;Go if so (error)
00640         AND     7               ;does driver handle I/O
00650         CP      7               ; and @CTL?
00660         JP      NZ,DEVERR       ;Go if not
00670         POP     HL              ;restore cmd line pointer
00680         LD      DE,PRMTBL       ;Scan parameters
00690         CALL    @PARAM
00700         JP      NZ,PRMERR       ;quit if error
00710 ;
00720 ;test parameter values and initialize filter
00730         LD      BC,$-$          ;value set by @PARAM call
00740 ADDLF   EQU     $-2             ;<=here
00750         LD      A,C
00760         OR      B               ;set flag
00770         LD      A,LF            ;load a line feed
00780         JR      Z,NXTST         ;go if not specified
00790         LD      (LFFLG),A       ;stuff byte if wanted
00800 ;
00810 NXTST:  LD      BC,$-$
00820 CARRY   EQU     $-2             ;<=setting for CARRIER
00830         LD      A,B
00840         OR      C
00850         JR      Z,CKMSK         ;no checking if zero
00860         LD      A,0FFH          ;Stuff FFH if check wanted
00870         LD      (CFLAG),A       ;for input request
00880 ;
00890 CKMSK:  LD      BC,$-$          ;MASK param
00900 MASK    EQU     $-2             ;set by @PARAM
00910         LD      A,B
00920         OR      C               ;zero?
00930         JR      Z,GETDVR        ; no masking wanted
00940         XOR     A               ; set zero
00950         LD      (MSK),A         ; set NOP instd of RET
00960 ;
00970 GETDVR: LD      H,(IX+2)        ;pull driver address from
00980         LD      L,(IX+1)        ;DCB of device
00990         LD      (DVRADD),HL     ;put where needed in filter
01000         LD      (DVR2),HL
01010         LD      (DVR3),HL
01020         LD      (DVR4),HL
01030         LD      HL,(HIGH$)      ;find top of available memory
01040         LD      (OLDMEM),HL     ;save in filter header
01050         PUSH    HL              ;save
01060         LD      BC,LAST         ;end of relocated code
01070         PUSH    BC              ;save
01080         XOR     A               ;clear carry
01090         SBC     HL,BC           ;find offset of move
01100         EX      DE,HL           ;put into DE
01110         LD      HL,(REL1)       ;relocate absolute memory
01120         ADD     HL,DE           ; references used in the
01130         LD      (REL1),HL       ;moved code...
01140         LD      HL,(REL2)       ;by..
01150         ADD     HL,DE           ;adding offset of move
01160         LD      (REL2),HL
01170         LD      HL,(REL3)
01180         ADD     HL,DE
01190         LD      (REL3),HL
01200         LD      HL,(REL4)
01210         ADD     HL,DE
01220         LD      (REL4),HL
01230         LD      HL,(REL5)
01240         ADD     HL,DE
01250         LD      (REL5),HL
01260         POP     HL              ;end of filter (now)
01270         POP     DE              ;old HIGH$
01280         LD      BC,LAST-FENTRY+1  ;length of relocated code
01290         LDDR                    ;move it
01300         LD      (HIGH$),DE      ;set new HIGH$
01310         INC     DE              ;point to filter entry point
01320         LD      (IX+1),E        ;Shove it in the DCB
01330         LD      (IX+2),D        
01340 ;*=*=*
01350 EXIT:   JP      @EXIT           ;Done
01360 ;*=*=*
01370 ;       Error handling
01380 ;*=*=*
01390 ISNIL:  LD      HL,ISNIL$
01400         JR      ERROUT
01410 DEVERR: LD      HL,DEVER$
01420         JR      ERROUT
01430 ROUTED: LD      HL,ROUTD$
01440         JR      ERROUT
01450 PRMERR: LD      HL,PRMER$       ;'Parameter error'
01460 ERROUT: CALL    @LOGOT          ;Display and log
01470         JP      @ABORT          ;Quit
01480 ;*=*=*
01490 ;       Data area
01500 ;*=*=*
01510 SIGNON: DB 'CL/FLT - LDOS communications Filter'
01520         DB LF,CR
01530 PRMER$: DB 'Parameter error!',CR
01540 ISNIL$: DB 'Device not active!',CR
01550 DEVER$: DB 'Incorrect device type!',CR
01560 ROUTD$: DB 'Device is routed!',CR
01570 ;
01580 PRMTBL: DB 'ADDLF '
01590         DW  ADDLF
01600         DB 'A     '
01610         DW  ADDLF
01620         DB 'CARRIE'
01630         DW  CARRY
01640         DB 'C     '
01650         DW  CARRY
01660         DB 'DELAY '
01670         DW  DELAY
01680         DB 'D     '
01690         DW  DELAY
01700         DB 'NULLS '
01710         DW  NULLS
01720         DB 'N     '
01730         DW NULLS
01740         DB 'MASK  '
01750         DW MASK
01760         DB 'M     '
01770         DW MASK
01780         DW      0       ;end of list
01790 ;
01800 ;*=*=*
01810 ;       Actual filter moved to high memory
01820 ;       LDOS style header...
01830 ;*=*=*
01840 FENTRY: JR      START           ;Branch around linkage
01850         DW      $-$             ;Last byte used
01860 OLDMEM  EQU     $-2             ;<=previous HIGH$ value
01870 ;
01880         DB      5,'CLFLT'
01890 ;
01900 ; actual filter routine
01910 ; the initialization code sets the flag byte to FFH if
01920 ; the test for carrier is wanted, 0 if not
01930 START:  LD      A,$-$    ;get flag for carrier test
01940 CFLAG   EQU     $-1      ;set according to params
01950         JR      C,INPUT  ;an input request
01960         JR      Z,OUTPUT ;output request from program
01970 ;  fall through if program called @CTL
01980 GSTAT:  OR      0FFH    ;reset C and Z so filter can...
01990                         ;call driver for status
02000 DRIVER: JP      $-$     ;go to old driver 
02010 DVRADD  EQU     $-2     ;stuff driver address here
02020 ;
02030 ;
02040 ; use a test that will set NZ if going directly to the driver
02050 INPUT:  INC     A         ;set Z if flag was FF for carrier
02060 ;
02070         CALL    Z,STAT    ;check for carrier if wanted
02080 REL1    EQU     $-2       ;call address is relocated
02090         JR      Z,IGNORE  ; no carrier, skip it
02100         SCF               ; input wanted
02110         CALL    $-$       ;driver address
02120 DVR2    EQU     $-2       ;stuffed by loader
02130 MSK:    RET               ;replaced w/NOP if MASK specified
02140         AND     7FH       ;strip parity bit
02150         RET
02160 ;
02170 ;  no carrier, so call driver to clear UART and buffer
02180 ;  then ignore any received characters
02190 ;
02200 IGNORE: OR      0FFH    ;be sure Z flag is off
02210         SCF             ;carry flag on
02220         CALL    $-$     ;get input from driver
02230 DVR3    EQU     $-2     ;driver address
02240         XOR     A       ;throw character away
02250         RET
02260 ;
02270 OUTPUT: PUSH    BC      ;save @PUT character
02280         INC     A       ;Test flag (zero to skip)
02290         CALL    Z,STAT  ;test carrier if flag was FF
02300 REL2    EQU     $-2
02310         POP     BC       ;restore character
02320         JR      Z,FAKEIT ;no carrier, dump output character
02330 ;
02340         PUSH    BC       ;save character
02350         CALL    SLOW     ;delay/send
02360 REL3    EQU     $-2      ;address is relocated
02370         POP     BC
02380         LD      A,CR      ;check for carriage return
02390         CP      C         ;being output
02400         JR      NZ,FAKEIT ;done if not
02410 ;
02420         LD      A,$-$     ;A 0 or LF (set when loaded)
02430 LFFLG   EQU     $-1     ;stuff byte according to parameter
02440         LD      DE,$-$  ;pick up NULL count
02450 NULLS   EQU     $-2     ;set by @PARAM
02460         PUSH    DE      ;save count
02470         LD      C,A     ;the @PUT char (0 or LF)
02480         OR      A       ;LF needed?
02490         JR      NZ,SEND ;output if so
02500 ;
02510         POP     DE      ;else restore NULL count
02520 NLOOP:  LD      A,D
02530         OR      E       ;test if done
02540         JR      Z,FINAL ;go if finished
02550         DEC     DE      ;else count down nulls
02560         PUSH    DE      ;save count
02570 SEND:   CALL    SLOW    ;pause/send character
02580 REL4    EQU     $-2     ;address goes here
02590         LD      C,0     ;load null to send
02600         POP     DE      ;restore count of nulls wanted
02610         JR      NLOOP   ;send until done
02620 ;
02630 SLOW:   PUSH    BC       ;save @PUT char 
02640         LD      BC,$-$   ;get DELAY value (loaded by @PARAM)
02650 DELAY   EQU     $-2      ;value stuffed by @PARAM
02660         LD      A,B
02670         OR      C        ;check for zero (default)
02680         CALL    NZ,@DELAY  ;(always sets Z flag)
02690         POP     BC       ;restore character
02700         CALL    $-$      ;driver, to output character
02710 DVR4    EQU     $-2
02720 ;
02730 FINAL:  LD      A,CR    ;Load the original @PUT char
02740         LD      C,A     ;into C and A in case other 
02750                         ;filters are active
02760 FAKEIT: CP      A       ;set Z flag for good return
02770         RET             ;done with output
02780 ;
02790 ;
02800 STAT:   LD      C,0     ;for status check
02810         CALL    GSTAT   ;call driver for status
02820 REL5    EQU     $-2     ;relocated when loaded
02830 ;
02840 ;the status call returns the modem status byte from the UART
02850 ;or SIO chip in register A, as well as the output status
02860 ;in the Z flag, but the bit values depend on the hardware
02870 ;
02880         IF RSHACK       ; this test applies to std Mod 1 or 3
02890         CPL             ; 0=ON in UART, so flip bits
02900         BIT     5,A     ;check for carrier signal bit
02910         ENDIF
02920 ;
02930         IF LX80
02940         NOP            ;patch space to modify
02950         BIT     3,A    ;carrier bit from LX80 SIO
02960         ENDIF
02970 ; Z=no carrier, NZ=carrier on...
02980         RET
02990 LAST    EQU     $-1   ;used for length calculation
03000 ;
03010         END     ENTRY
 