SETDAT ;*****  SETDATE6/ASM  -  Copyright 1985 by Jack Decker
 ;Version 6.0 for the Model 4 - creation date 7/6/85.
 
 ;This program eliminates the need to type in the date
 ;manually each time you power-up your computer (assuming
 ;your DOS can be forced to bypass the "DATE" prompt when
 ;it is booted up).
 
 ;This program MUST be assembled using the filename
 ;"SETDATE/CMD".  Normally, it is used by placing the
 ;filename as part of a DOS "AUTO" command.  You may AUTO
 ;a second program along with SETDATE by placing filename
 ;of the second program in same AUTO command line,
 ;immediately following the SETDATE command.  For example:
 
 ;		SETDATE PROGRAM2
 
 ;would first execute SETDATE, then PROGRAM2.
 
 ;If there appears to be a valid date already stored in
 ;memory (as might happen if the DOS is re-booted without
 ;first turning off the power to the system), SETDATE will
 ;simply clear the screen and exit.  However, you can
 ;force SETDATE to execute by placing a space and
 ;exclamation point immediately following the filename:
 
 ;		SETDATE !
 ;	or	SETDATE ! PROGRAM2
 
 ;When SETDATE executes, it will display the date used the
 ;last time SETDATE was executed.  You may advance or
 ;backspace the date using the arrow keys.  When the
 ;correct date is displayed, simply press the ENTER key,
 ;which will store the date in memory and also within the
 ;SETDATE program itself, for use the next time SETDATE
 ;is executed.
 
 ;Questions or comments MUST be accompanied by a self-
 ;addressed stamped envelope if you live in the U.S.A. or
 ;Canada (Canadian postage is O.K.) and wish a reply.
 
 ;		Jack Decker
 ;		1804 West 18th Street   Lot # 155
 ;		Sault Ste. Marie, Michigan  49783
 
 
 	ORG	3000H		;MUST end with 00H
 
 ;String and date storage area used by program
 
 TABLE	DEFW	SUN		;Table of string pointers
 	DEFW	MON		;  point to strings
 	DEFW	TUE		;  containing days of
 	DEFW	WED		;  the week
 	DEFW	THU
 	DEFW	FRI
 	DEFW	SAT
 	DEFW	JAN		;Table of string pointers
 	DEFW	FEB		;  point to strings
 	DEFW	MAR		;  containing months of
 	DEFW	APR		;  the year
 	DEFW	MAY
 	DEFW	JUN
 	DEFW	JUL
 	DEFW	AUG
 	DEFW	SEP
 	DEFW	OCT
 	DEFW	NOV
 	DEFW	DEC
 MARKER	DEFB	0FEH		;Start date storage area
 DATSTR	DEFB	85D		;Year storage
 	DEFB	1D		;Day storage
 	DEFB	7D		;Month storage
 	DEFB	1D		;Day of week storage
 CNTURY	DEFW	1900D		;Century storage
 SUN	DEFM	'Sunda'		;Strings containing days
 	DEFB	'y'+80H		;  of week
 MON	DEFM	'Monda'
 	DEFB	'y'+80H
 TUE	DEFM	'Tuesda'
 	DEFB	'y'+80H
 WED	DEFM	'Wednesda'
 	DEFB	'y'+80H
 THU	DEFM	'Thursda'
 	DEFB	'y'+80H
 FRI	DEFM	'Frida'
 	DEFB	'y'+80H
 SAT	DEFM	'Saturda'
 	DEFB	'y'+80H
 JAN	DEFM	'Januar'	;Strings containing
 	DEFB	'y'+80H		;  months of year
 FEB	DEFM	'Februar'
 	DEFB	'y'+80H
 MAR	DEFM	'Marc'
 	DEFB	'h'+80H
 APR	DEFM	'Apri'
 	DEFB	'l'+80H
 MAY	DEFM	'Ma'
 	DEFB	'y'+80H
 JUN	DEFM	'Jun'
 	DEFB	'e'+80H
 JUL	DEFM	'Jul'
 	DEFB	'y'+80H
 AUG	DEFM	'Augus'
 	DEFB	't'+80H
 SEP	DEFM	'Septembe'
 	DEFB	'r'+80H
 OCT	DEFM	'Octobe'
 	DEFB	'r'+80H
 NOV	DEFM	'Novembe'
 	DEFB	'r'+80H
 DEC	DEFM	'Decembe'
 	DEFB	'r'+80H
 MSG	DEFB	1CH		;1CH will home cursor
 	DEFB	1FH		;1FH will clear screen
 	DEFB	0FH		;0FH turns off cursor
 	DEFB	1AH		;1AH moves down one line
 	DEFB	10H		;10H activates rev. video
 	DEFM	'Please set correct date:'
 	DEFB	11H		;11H deselects rev. video
 	DEFB	0DH
 	DEFB	1AH
 	DEFB	1AH
 	DEFB	1AH
 	DEFM	'Please press one of the following keys:'
 	DEFB	0DH
 	DEFM	'<ENTER> if date is correct'
 	DEFB	0DH
 	DEFM	'<BREAK> to exit without setting date'
 	DEFB	0DH
 	DEFM	'<up-arrow> or <right-arrow> to advance date'
 	DEFB	0DH
 	DEFM	'<down-arrow> or <left-arrow> to backup date'
 	DEFB	0DH
 	DEFM	'<SHIFT> plus arrow key to change date at high speed'
 	DEFB	0DH
 	DEFB	1AH
 	DEFB	1AH
 	DEFB	1AH
 	DEFB	1AH
 	DEFB	1AH
 	DEFM	'SETDATE version 6.0 is a public domain program by Jack Decker.'
 	DEFB	0DH
 	DEFM	'Placed in the public domain courtesy of NORTHERN BYTES, the newsletter for'
 	DEFB	0DH
 	DEFM	'owners and users of the TRS-80 Models I, III, 4 and 4P.'
 	DEFB	0DH
 	DEFB	1AH
 	DEFM	'For information on how you may obtain current or back issues of NORTHERN BYTES,'
 	DEFB	0DH
 	DEFM	'please contact The Alternate Source, 704 North Pennsylvania Avenue,'
 	DEFB	0DH
 	DEFM	'Lansing, Michigan 48906 (U.S.A.) or telephone (517) 482-8270.'
 	DEFB	1CH		;1CH will home cursor
 	DEFB	10H		;Re-enable reverse video
 	DEFB	11H		;  but keep de-activated
 	DEFB	1AH		;1AH moves down one line
 	DEFB	1AH
 	DEFB	1AH+80H
 ENDYR	DEFB	1EH		;1EH clears to line end
 	DEFB	1DH+80H		;1DH moves to line start
 CLS	DEFB	1CH		;1CH will home cursor
 	DEFB	1FH+80H		;1FH will clear screen
 DATE	DEFM	'DATE'		;Used to execute DOS DATE
 	DEFB	0DH		;  command
 
 ;Start of actual machine-language program
 
 START	LD	A,(HL)		;Get argument (!) if any
 	SUB	'!'		;Is it exclamation point
 	CALL	Z,SKPSPC	;Bump HL past excl. point
 	LD	DE,CMDBFR	;Temporary command buffer
 	LD	BC,80D		;Number of bytes to move
 	LDIR			;Move rest of command ln
 	OR	A		;Re-test for !
 	JR	Z,USEPGM	;Skip date test if ! used
 	LD	HL,NUMBUF	;Point to dummy buffer
 	LD	A,12H		;Get date storage area
 	RST	28H
 	LD	A,(DE)		;Get year from memory
 	CP	100D		;Is it in range 00 - 99?
 	JR	NC,USEPGM	;Go if invalid year
 	INC	DE		;Point to day in memory
 	LD	A,(DE)		;Get day from memory
 	DEC	A		;Adjust valid to 0 - 30
 	CP	31D		;Is day 1 - 31 in memory?
 	JR	NC,USEPGM	;Go if invalid month
 	INC	DE		;Point to month in memory
 	LD	A,(DE)		;Get month from memory
 	DEC	A		;Adjust valid to 0 - 11
 	CP	12D		;Is month 1 - 12 in mem?
 	JP	C,EXIT2		;Go if memory date valid
 USEPGM	LD	HL,MSG		;Point to message
 	CALL	DSPMSG		;Display message
 RESTRT	LD	BC,DATSTR+3	;Point to day of wk byte
 	LD	A,(BC)		;Get day of week (0 - 6)
 	CALL	PRTSTR		;Print day of week string
 	CALL	PRTCOM		;Print comma and space
 	DEC	BC		;Point to month byte
 	LD	A,(BC)		;Get month (1 - 12)
 	ADD	A,6		;Offset for string table
 	CALL	PRTSTR		;Print month string
 	CALL	PRTSPC		;Print space character
 	DEC	BC		;Point to day byte
 	LD	A,(BC)		;Get day (1 - 31)
 	LD	L,A		;Put day in L
 	LD	H,0		;HL = day
 	PUSH	BC		;Save date storage pntr
 	CALL	PRTNUM		;Print day
 	POP	BC		;Restore date storage ptr
 	CALL	PRTCOM		;Print comma and space
 	DEC	BC		;Point to year byte
 	LD	A,(BC)		;Get year (0 - 99)
 	LD	C,A		;Put year in C
 	LD	B,0		;BC = last 2 digits year
 	LD	HL,(CNTURY)	;Get century offset
 	ADD	HL,BC		;HL = Year (all 4 digits)
 	CALL	PRTNUM		;Print year
 	LD	HL,ENDYR	;Point to ctrl chr string
 	CALL	DSPMSG		;Output it to video
 	LD	A,(CFLAG)	;Get shifted char flag
 	OR	A		;Test for zero byte
 	JR	Z,GETKEY	;If shifted char
 	LD	BC,8000H	;Delay amount
 DLY	DEC	BC		;Decrement delay count
 	LD	A,B		;Reached zero?
 	OR	C
 	JR	NZ,DLY		;If not zero yet
 GETKEY	LD	A,8H		;Get keystroke if any
 	RST	28H
 	JR	NZ,GETKEY	;If no key was pressed
 	CP	80H		;Was it the BREAK key?
 	JR	Z,EXIT		;Exit if BREAK
 	CP	0DH		;Was it the ENTER key?
 	JR	NZ,NOTCR	;Go if not ENTER
 	LD	HL,NUMBUF	;Point to dummy buffer
 	LD	A,12H		;Get date storage area
 	RST	28H
 	LD	HL,DATSTR	;Point to program date
 	PUSH	HL		;Save program date pntr
 	LD	BC,3		;Number of bytes to move
 	LDIR			;Move from program to mem
 	LD	B,0		;Logical Record Lngth=256
 	LD	DE,FCB		;File Control Block pntr
 	LD	HL,FILBUF	;File I/O Buffer pntr
 	LD	A,3BH		;DOS OPEN routine
 	RST	28H
 	JR	NZ,ERREXT	;Go if error
 	LD	A,43H		;READ sector 0 to buffer
 	RST	28H
 	JR	NZ,ERREXT	;Go if error
 	POP	HL		;Get program date pointer
 	PUSH	DE		;Save FCB pointer
 	LD	DE,MARKER-TABLE+4+FILBUF
 ;Above instruction points DE to first location in sector
 ;zero of disk file that can possibly contain MARKER byte
 FNDDAT	LD	A,(DE)		;Get byte frm disk sector
 	INC	DE		;Bump pointer to next loc
 	CP	0FEH		;MARKER byte found?
 	JR	NZ,FNDDAT	;Try again if not
 	LD	BC,4		;Move 4 bytes frm program
 	LDIR			;  storage to disk sector
 	POP	DE		;Restore FCB pointer
 	LD	A,44H		;Reset to sector zero
 	RST	28H
 	JR	NZ,ERREXT	;Go if error
 	LD	A,49H		;Write sector back to dsk
 	RST	28H
 	JR	NZ,ERREXT	;Go if error
 ;Do NOT attempt to CLOSE file after above procedure!!
 ;It is not necessary, and will truncate file if you do!
 	LD	HL,DATE		;Point to "DATE" string
 	LD	A,19H		;Execute DOS DATE command
 	RST	28H		;  to reset day bytes
 EXIT	LD	HL,CLS		;Point to clr screen msg
 	CALL	DSPMSG		;Display message
 EXIT2	LD	HL,CMDBFR	;Point to new command bfr
 	LD	A,18H		;Execute next DOS command
 	RST	28H		;  (if any) and exit
 ERREXT	OR	40H		;Display normal err msg
 	PUSH	AF		;Save error number
 	LD	C,1FH		;1FH=clr to end of screen
 	LD	A,2H		;Output byte to video
 	RST	28H
 	POP	AF		;Restore error code
 	LD	C,A		;Error number in C
 	LD	A,1AH		;Exit to error routine
 	RST	28H
 NOTCR	CP	5BH		;Was keystroke up-arrow?
 	LD	B,A		;Save keystroke in B
 	JR	Z,ARROW		;Go if up-arrow
 	OR	10H		;Make shifted=unshifted
 	CP	18H		;Invalid keystroke if
 	JR	C,GETKEY	;  less than ASCII 18H
 	CP	1CH		;Keystroke valid if less
 	JR	NC,GETKEY	;  than ASCII 1CH
 	XOR	B		;Check for shifted char
 ARROW	LD	(CFLAG),A	;Save shifted char flag
 	LD	A,B		;Restore original char
 	LD	HL,RESTRT	;RET addr for following
 	PUSH	HL		;Save it on stack
 	LD	HL,DATSTR+3	;Point to day-of-week
 	RRCA			;Shift bit 0 into carry
 	JR	NC,BACK		;If key was back/down arr
 ADV	INC	(HL)		;Increment day of week
 	LD	A,(HL)		;Get day of week
 	CP	7		;Is it greater than 6?
 	JR	C,SETDAY	;Go if valid day
 	LD	(HL),0		;Else reset to Sunday
 SETDAY	DEC	HL		;Point to month storage
 	LD	A,(HL)		;Get month
 	CALL	MAXDAY		;Get number days in month
 	DEC	HL		;Point to day storage
 	LD	A,(HL)		;Get current day
 	CP	C		;Compare with maximum
 	INC	(HL)		;Advance day of month
 	RET	C		;Finished if valid day
 	LD	(HL),1		;Else first of new month
 	INC	HL		;Point to month storage
 	LD	A,(HL)		;Get current month
 	CP	12D		;See if it's December
 	INC	(HL)		;Advance month count
 	RET	C		;Finished if valid month
 	LD	(HL),1		;Else January of new year
 	DEC	HL		;Bump pointer back down
 	DEC	HL		;  to year storage
 	LD	A,(HL)		;Get current year
 	CP	99D		;See if last of century
 	INC	(HL)		;Advance year count
 	RET	C		;Finished if valid year
 	LD	(HL),0		;Else reset year count
 	LD	DE,100D		;Add 100 years to century
 CHGCEN	LD	HL,(CNTURY)	;Get current century
 	ADD	HL,DE		;Adjust century offset
 	LD	(CNTURY),HL	;  and re-save it
 	RET			;Finished for sure
 BACK	DEC	(HL)		;Decrement day of week
 	JP	P,SETDA2	;Go if valid day
 	LD	(HL),6		;Else reset to Saturday
 SETDA2	DEC	HL		;Point to month storage
 	LD	A,(HL)		;Get month
 	DEC	HL		;Point to day storage
 	DEC	(HL)		;Decrement day of month
 	RET	NZ		;Finished if valid day
 	DEC	A		;Else A=# of previous mth
 	CALL	MAXDAY		;Get # days previous mnth
 	LD	(HL),C		;Day=last day prev. month
 	INC	HL		;Point to month storage
 	DEC	(HL)		;Decrement month count
 	RET	NZ		;Finished if valid month
 	LD	(HL),12D	;Else December prev. year
 	DEC	HL		;Bump pointer back down
 	DEC	HL		;  to year storage
 	DEC	(HL)		;Decrement year count
 	RET	P		;Finished if valid year
 	LD	(HL),99D	;Else last yr prev cntury
 	LD	DE,-100D	;Subtract 100 frm century
 	JR	CHGCEN		;Adjust century & finish
 PRTSTR	RLCA			;A=A*2 (2 byte pointers)
 	LD	L,A		;L=LSB string table addr
 	LD	H,TABLE<-8	;H=MSB string table addr
 	LD	A,(HL)		;A=LSB actual string addr
 	INC	HL		;Point to MSB string addr
 	LD	H,(HL)		;H=MSB actual string addr
 	LD	L,A		;HL=string location addr
 DSPMSG	LD	A,(HL)		;Get byte to display
 	OR	A		;See if zero terminator
 	RET	Z		;Finished if zero byte
 	PUSH	AF		;Save sign flag status
 	AND	7FH		;Mask off bit 7
 	CALL	VDSP		;Display it on video
 	POP	AF		;Restore sign flag
 	RET	M		;Finished if bit 7 set
 	INC	HL		;Advance string pointer
 	JR	DSPMSG		;Go print next byte
 PRTNUM	LD	DE,NUMBUF	;Point to number buffer
 	PUSH	DE		;Save number buffer ptr
 	LD	A,61H		;Convert number in HL to
 	RST	28H		;  ASCII
 	XOR	A		;Zero byte in A register
 	LD	(DE),A		;Mark end of number
 	POP	HL		;Restore buffer pointer
 	CALL	SKPSPC		;Skip leading space chrs
 	JR	DSPMSG		;Display converted number
 PRTCOM	LD	A,','		;Comma character in A
 	CALL	VDSP		;Display it on video
 PRTSPC	LD	A,' '		;Space character in A
 VDSP	PUSH	BC		;Save BC
 	LD	C,A		;Byte to display in C
 	LD	A,2H		;Output byte to video
 	RST	28H
 	POP	BC		;Restore BC
 	RET
 MAXDAY	LD	C,30D		;C=# days in some months
 	CP	4		;Is month April?
 	RET	Z		;Return if April
 	CP	6		;Is month June?
 	RET	Z		;Return if June
 	CP	9		;Is month September?
 	RET	Z		;Return if September
 	CP	11D		;Is month November?
 	RET	Z		;Return if November
 	INC	C		;C=31 (# days most mnths)
 	CP	2 		;Is month February?
 	RET	NZ		;Return if 31 day month
 	LD	C,28D		;C=# days in February
 	LD	A,(DATSTR)	;Get current year
 	AND	3		;Year divisible by 4?
 	RET	NZ		;If not leap year
 	INC	C		;C=29 (# days leap Feb.)
 	RET			;Finished
 SKPSPC	PUSH	AF		;Save AF
 SKPSP2	INC	HL		;Bump to next character
 	LD	A,(HL)		;Get character
 	CP	20H		;Is character a space?
 	JR	Z,SKPSP2	;Skip space characters
 	POP	AF		;Restore AF
 	RET	
 CFLAG	DEFB	0		;Shifted character flag
 FCB	DEFM	'SETDATE/CMD'	;File Control Block area
 	DEFB	3		;  with program filename
 	DEFS	20D		;  (total 32 bytes)
 FILBUF	DEFS	100H		;File I/O buffer area
 CMDBFR	DEFS	80D		;Store remaining DOS cmds
 NUMBUF	DEFS	8		;Scratch number storage
 	END	START
                 