;	  PARK/CMD
;	  By Mick Howland - Version 1.1 - 08-31-88
;	  Last modified on 08-31-88
;
	ORG	4000H
;
*GET EQUATES4
;
START	LD	HL,MSG0		;Say "Hello"!
	SVC	@DSPLY
;
	LD	A,00H		;Select drive 0
	LD	(DRVNUM),A	;and save it
LOOP0	LD	A,(DRVNUM)
	LD	C,A
	SVC	@GTDCT		;Get pointer to Drive Control Table
	LD	A,(IY)
	CP	0C9H		;Check to see if the drive is "awake"!
	CALL	NZ,PARKIT	;and try to park it if it's alive
	LD	A,(DRVNUM)	;otherwise go and try the next drive
	INC	A
	LD	(DRVNUM),A
	CP	07H		;Ummmmm, have all the drives been parked?
	JR	NZ,LOOP0	;No? Then go select the next drive
;
	SVC	@CLS		;Yes? Then say "Goodbye"!
	LD	HL,MSG1
	SVC	@DSPLY
LOOP1	JR	LOOP1		;and wait for machine to turn off!
;
PARKIT	LD	A,(IY+3)	;See if it's a hard drive and leave it
	BIT	3,A		;alone. Too many big numbers to worry
	RET	NZ		;about for hard drives.
;
	PUSH	AF		;Ok, it's not a hard drive so go
	LD	A,(DRVNUM)
	LD	C,A
	SVC	@RSTOR		;and try to Restore it to track 0
	POP	AF
	JR	NZ,ERROR	;ummmm, did the head get lost
	LD	A,(IY+6)	;No? Good then get # of tracks on the
	INC	A		;current drive and add 1 to it and hey
	PUSH	AF		;presto, we have the track to park on.
	LD	A,(DRVNUM)	;So select the drive
	LD	C,A
	POP	AF
	LD	B,A
LOOP2	SVC	@STEPI
	JR	NZ,ERROR	;and park it!
	DJNZ	LOOP2
	RET
;
ERROR	SET	6,A		;Suppress those bloody awfull
	RES	7,A		;extended error messages.
	LD	C,A
	SVC	@ERROR
;
MSG0	DM	'Floppy Disk Drive head park program (C) 1988 Mick Howland',CR
MSG1	DB	17H
	DC	12,LF
	DM	' Heads Parked. Please turn off machine!'
	DB	CUROFF
	DB	CR
DRVNUM	DB	00H
	END	START
                                                                                                                                                                                                                                           