;**********************************************
	TITLE	'<NAMEIT 1.0.0 - DISK RENAMING UTILITY>'
;			for LDOS 5.x and LS-DOS 6.x
;		       By Irwin B. Burton - 12/31/87
;**********************************************
;
;---------------
; Constants
;---------------
EXT	EQU	03H
CR	EQU	0DH
LF	EQU	0AH
;
;---------------
; 5.x Constants
;---------------
@KEY	EQU	0049H
@DSP	EQU	0033H
@KEYIN	EQU	0040H
@DODIR	EQU	4419H
@DSPLY	EQU	4467H
@EXIT	EQU	402DH
@RDSEC	EQU	4777H
@WRSEC	EQU	4763H
@WRSSC	EQU	4768H
@RDSSC	EQU	4B45H
;
CMD	MACRO	#NUM
	CALL	#NUM
	ENDM
;
;---------------
; 6.x Constants
;---------------
@KEY6	EQU	01
@DSP6	EQU	02
@KEYIN6	EQU	09
@DSPLY6	EQU	10
@EXIT6	EQU	22
@DODIR6	EQU	34
@RDSEC6	EQU	49
@WRSEC6	EQU	53
@WRSSC6	EQU	54
@RDSSC6	EQU	85
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
;---------------
; Program
;---------------
;
	ORG	5200H
;
;---------------
; Messages
;---------------
;
SIGNON	DB	1CH,1FH
	DB	LF,'NAMEIT 1.0.1 - Disk Renamer '
	DB	'for LDOS 5.x and LS-DOS 6.x',LF
	DB	'By Irwin B. Burton - 02/28/88',CR
;
MSG1	DB	LF,'DRIVE NUMBER? ',EXT
MSG2	DB	LF,'THE OLD DISK NAME IS: ',EXT
MSG3	DB	'NEW NAME - (DIR = `)? ',EXT
;
IOMSG	DB	LF,'DISK I/O ERROR - ABORTED!',CR
NDMSG	DB	LF,'- NOTHING DONE -',CR
;
GOOD	DB	LF,'Disk name successfully '
	DB	'changed to '
KEYBUF	DB	'         '
	DB	CR
AGAIN	DB	LF,'Do you want to rename another disk?',EXT
NDISK	DB	LF,'Mount new disk - Press <ENTER> when ready',CR
;
DOSFLG	DB	00	;'00' = 5.x, 'FF' = 6.x
DRIVE	DB	0	;Default to drive 0
DIRTRK	DB	20	;Default to cylinder 20
BUFFER	DS	256	;Disk sector buffer
;
;---------------
; Which DOS Is This Running On?
;---------------
;
START	PUSH	HL		;Save registers
	PUSH	DE
	LD	HL,(9)		;Get RST 8 vector address
	LD	DE,4000H
	XOR	A
	SBC	HL,DE
	JP	NZ,INTRO6	;LS-DOS 6 so go
;
MOD3	LD	A,(125H)
	CP	'I'
	JP	Z,INTRO5	;Mod3 so go
	LD	HL,4463H	;Stuff with Mod1 calls
	LD	(@DODIR1),HL
;
;---------------
; LDOS 5.x Program
;---------------
INTRO5	LD	HL,SIGNON
	CALL	PRINT
	CALL	GETDRV
NEXT	CALL	GETDIR
	CALL	GETSSC
	CALL	GETDOS
	CALL	OLDNAM
	CALL	INPUT
	CALL	MOVINP
	CALL	WRSSC
	CALL	GETSEC
	CALL	MOV1
	CALL	WRTSEC
;
SUCCESS	LD	HL,GOOD
	CALL	PRINT
;
EXIT	LD	HL,AGAIN
	CALL	PRINT
	CALL	@KEY
	CP	'Y'
	JR	Z,ND
	CP	'y'
	JR	Z,ND
	JP	@EXIT
ND	LD	HL,NDISK
	CALL	PRINT
	CALL	@KEY
	JR	NEXT
;
;---------------
; LDOS 5.x Routines
;---------------
ABRT	LD	HL,NDMSG
	CALL	PRINT
	JP	@EXIT
;
IOERR	LD	HL,IOMSG
	CMD	@DSPLY
	JP	@EXIT
;
PRINT	CMD	@DSPLY
	JP	NZ,IOERR
	RET
;
GETDRV	LD	HL,MSG1
	CALL	PRINT
	CMD	@KEY
	CP	128
	JP	Z,ABRT
	LD	C,A
	ADD	A,-30H
	LD	(DRIVE),A
	RET
;
GETDIR	CALL	COM1
	CMD	@RDSEC
	JP	NZ,IOERR
	LD	A,(IX+2)
	LD	(DIRTRK),A
	RET
;
GETSSC	CALL	COM2
	CMD	@RDSSC
	JP	NZ,IOERR
	RET
;
OLDNAM	CALL	COM3
	CALL	PRINT
	LD	HL,KEYBUF
	CALL	PRINT
	RET
;
INPUT	LD	HL,MSG3
	CALL	PRINT
	LD	HL,KEYBUF
	LD	B,8
	LD	C,0
	CMD	@KEYIN
	CALL	PADSPC
	JP	C,ABRT
	JP	NZ,IOERR
	LD	A,(KEYBUF)
	CP	60H	;<SHIFT><@>
	RET	NZ
DIR	LD	A,(DRIVE)
	LD	C,A
	LD	B,0
	CMD	@DODIR
@DODIR1	EQU	$-2
	JR	INPUT
;
WRSSC	CALL	COM4
	CMD	@WRSSC
	JP	NZ,IOERR
	RET
;
GETSEC	CALL	COM5
	CMD	@RDSEC
	JP	NZ,IOERR
	RET
;
WRTSEC	CALL	COM6
	CMD	@WRSEC
	JP	NZ,IOERR
	RET
;
;---------------
; Routines common to both DOSes
;---------------
;
COM1	LD	HL,BUFFER
	LD	IX,BUFFER
	LD	D,0
	LD	E,0
	LD	A,(DRIVE)
	LD	C,A
	RET
;
COM2	LD	A,(DIRTRK)
	LD	D,A
	LD	E,0
	LD	A,(DRIVE)
	LD	C,A
	LD	HL,BUFFER
	RET
;
GETDOS	LD	A,(BUFFER+0CBH)
	CP	5FH
	JR	C,DOS5
DOS6	LD	A,(BUFFER+0CDH)
	BIT	7,A
	JR	NZ,DOS5
	LD	A,0FFH
	LD	(DOSFLG),A
	RET
DOS5	LD	A,00
	LD	(DOSFLG),A
	RET
;
COM3	LD	DE,KEYBUF
	LD	HL,BUFFER+0D0H
	LD	BC,8
	LDIR
	LD	HL,MSG2
	RET
;
PADSPC	PUSH	AF
	LD	HL,KEYBUF
	LD	B,8
LOOP	LD	A,(HL)
	CP	13
	JR	NZ,CONT
LOOP2	LD	A,32
	LD	(HL),A
	INC	HL
	DJNZ	LOOP2
	JR	CONT2
CONT	INC	HL
	DJNZ	LOOP
CONT2	POP	AF
	RET
;
MOVINP	LD	HL,KEYBUF
	LD	DE,BUFFER+0D0H
	LD	BC,8
	LDIR
	RET
;
COM4	LD	A,(DIRTRK)
	LD	D,A
	LD	E,0
	LD	A,(DRIVE)
	LD	C,A
	LD	HL,BUFFER
	RET
;
COM5	LD	A,(DRIVE)
	LD	C,A
	LD	D,0
	LD	A,(DOSFLG)
	CP	00
	JR	NZ,DG6
DG5	LD	E,3
	JR	GET
DG6	LD	E,2
GET	LD	HL,BUFFER
	RET
;
MOV1	LD	HL,KEYBUF
	LD	A,(DOSFLG)
	CP	00
	JR	NZ,DM6
DM5	LD	DE,BUFFER+0D0H
	JR	MOV
DM6	LD	DE,BUFFER+10H
MOV	LD	BC,8
	LDIR
	RET
;
COM6	LD	A,(DRIVE)
	LD	C,A
	LD	D,0
	LD	A,(DOSFLG)
	CP	00
	JR	NZ,DW6
DW5	LD	E,3
	JR	WRT
DW6	LD	E,2
WRT	LD	HL,BUFFER
	RET
;
;--------------
; LS-DOS 6.x Program
;--------------
INTRO6	LD	HL,SIGNON
	CALL	PRINT6
	CALL	GETDRV6
NEXT6	CALL	GETDIR6
	CALL	GETSSC6
	CALL	GETDOS
	CALL	OLDNAM6
	CALL	INPUT6
	CALL	MOVINP
	CALL	WRSSC6
	CALL	GETSEC6
	CALL	MOV1
	CALL	WRTSEC6
;
SUCCES6	LD	HL,GOOD
	CALL	PRINT6
;
EXIT6	LD	HL,AGAIN
	CALL	PRINT6
	SVC	@KEY6
	CP	'Y'
	JR	Z,ND6
	CP	'y'
	JR	Z,ND6
	SVC	@EXIT6
ND6	LD	HL,NDISK
	CALL	PRINT6
	SVC	@KEY6
	JR	NEXT6
;
;--------------
; LS-DOS 6.x Routines
;--------------
ABRT6	LD	HL,NDMSG
	CALL	PRINT6
	SVC	@EXIT6
;
IOERR6	LD	HL,IOMSG
	SVC	@DSPLY6
	SVC	@EXIT6
;
PRINT6	SVC	@DSPLY6
	JP	NZ,IOERR6
	RET
;
GETDRV6	LD	HL,MSG1
	CALL	PRINT6
	SVC	@KEY6
	CP	128
	JP	Z,ABRT6
	LD	C,A
	ADD	A,-30H
	LD	(DRIVE),A
	RET
;
GETDIR6	CALL	COM1
	SVC	@RDSEC6
	JP	NZ,IOERR6
	LD	A,(IX+2)
	LD	(DIRTRK),A
	RET
;
GETSSC6	CALL	COM2
	SVC	@RDSSC6
	JP	NZ,IOERR6
	RET
;
OLDNAM6	CALL	COM3
	CALL	PRINT6
	LD	HL,KEYBUF
	CALL	PRINT6
	RET
;
INPUT6	LD	HL,MSG3
	CALL	PRINT6
	LD	HL,KEYBUF
	LD	B,8
	LD	C,0
	SVC	@KEYIN6
	CALL	PADSPC
	JP	C,ABRT6
	JP	NZ,IOERR6
	LD	A,(KEYBUF)
	CP	60H	;<SHIFT><@>
	RET	NZ
DIR6	LD	C,0AH
	SVC	@DSP
	LD	A,(DRIVE)
	LD	C,A
	LD	B,0
	SVC	@DODIR6
	LD	C,0AH
	SVC	@DSP
	JR	INPUT6
;
WRSSC6	CALL	COM4
	SVC	@WRSSC6
	JP	NZ,IOERR6
	RET
;
GETSEC6	CALL	COM5
	SVC	@RDSEC6
	JP	NZ,IOERR6
	RET
;
WRTSEC6	CALL	COM6
	SVC	@WRSEC6
	JP	NZ,IOERR6
	RET
;
;
	END	START
