;Master SVC File
	LIST	OFF
@get	EQU	03H
@put	EQU	04H
@msg	EQU	0DH
@key	EQU	01H
@kbd	EQU	08H
@keyin	EQU	09H
@dsp	EQU	02H
@dsply	EQU	0AH
@prt	EQU	06H
@print	EQU	0EH
@ipl	EQU	00H
@abort	EQU	15H
@exit	EQU	16H
@cmndi	EQU	18H
@cmndr	EQU	19H
@error	EQU	1AH
@debug	EQU	1BH
@dodir	EQU	22H
@ramdir	EQU	23H
@load	EQU	4CH
@run	EQU	4DH
@bank	EQU	66H
@date	EQU	12H
@time	EQU	13H
@high	EQU	64H
@decbin	EQU	60H
@bindec	EQU	61H
@hex8	EQU	62H
@hex16	EQU	63H
@mul8	EQU	5AH
@mul16	EQU	5BH
@div8	EQU	5DH
@div16	EQU	5EH
@fspec	EQU	4EH
@vdctl	EQU	0FH
@pause	EQU	10H
@sound	EQU	68H
@sort	EQU	7FH
@renam	EQU	38H
@remov	EQU	39H
@init	EQU	3AH
@open	EQU	3BH
@close	EQU	3CH
@fext	EQU	4FH
@fname	EQU	50H
@bksp	EQU	3DH
@ckeof	EQU	3EH
@loc	EQU	3FH
@lof	EQU	40H
@peof	EQU	41H
@posn	EQU	42H
@rew	EQU	44H
@skip	EQU	48H
@weof	EQU	4AH
@read	EQU	43H
@ver	EQU	49H
@write	EQU	4BH
@gtdcb	EQU	52H
svc	EQU	28H
	LIST	ON
;*************************************************
;Program to allow Model 3 files to be moved to
;the Model 4 BASIC without the usual hassles
;Note this program does not fix the PRINT@ or TAB
;<c> 1984 by Mel Patrick
;*************************************************
	ORG	3000h		;starting point
mod324	CALL	cls		;clear the video
	LD	HL,title	;point to title
	CALL	disply		;and show it
	LD	HL,quest1	;point to first filespec
	CALL	disply		;show it
	LD	HL,buffer	;point to buffer
	LD	B,20		;bytes to input
        LD      A,@keyin        ;lineinput for keyboard
        RST     svc             ;and do it
	JR	C,mod324	;back if break
	LD	A,B		;else get length
	OR	A		;0=nothing
	JR	Z,mod324	;go if nothing
	LD	HL,buffer	;else point to input
	LD	DE,file1	;point to initial file
        LD      A,@fspec        ;create a FCB
        RST     svc             ;and do it
	JP	NZ,bad		;go if bad filename
	LD	HL,quest2	;else point to second filename
	CALL	disply		;show it
	LD	HL,buffer	;point to buffer
	LD	B,20		;bytes to input
        LD      A,@keyin        ;lineinput for keyboard
        RST     svc             ;and do it
	JP	C,mod324	;back if break
	LD	A,B		;else get length entered
	OR	A		;test for 0
	JP	Z,mod324	;back if only enter
	LD	HL,buffer	;else point to buffer
	LD	DE,file2	;point to output file
        LD      A,@fspec        ;create a FCB
        RST     svc             ;and do it
	JP	NZ,bad		;go if bad filename
again	LD	HL,quest3	;insert necessary spaces?
	CALL	disply		;show it
	LD	A,@key		;wait for a key
	RST	svc		;now
	AND	5fh		;convert to UPPER CASE
	PUSH	AF		;save character
	LD	C,A		;move for display
	LD	A,@dsp		;display code
	RST	svc		;do it
	POP	AF		;get back character
	CP	'Y'		;yes
	JR	Z,setsp		;go if yes
	CP	'N'		;else No?
	JR	NZ,again	;redo til dummy gets a Y or N
	XOR	A		;else remove flag
	JR	setsp1		;and continue
setsp	LD	A,1		;set flag for spaces
setsp1	LD	(space),A	;turn it on
	LD	C,0dh		;and do a couple of lines
	LD	A,@dsp		;do it
	RST	svc		;on video
	LD	A,@dsp		;again
	RST	svc		;for the second time
	LD	HL,buff1	;point to dummy buffer number 1
	LD	DE,file1	;point to input file
	LD	B,00h		;set lrl=256
        LD      A,@open         ;open a file
        RST     svc             ;and do it
	JP	NZ,bad		;go if error
	LD	HL,buff2	;now point to buffer #2
	LD	DE,file2	;output filename
	LD	B,00h		;set lrl=256
        LD      A,@init         ;open a file
        RST     svc             ;and do it
	JP	NZ,bad		;go if error
;**************************************************
;now we have both files open and we have to check
;the first one to make sure it is a BASIC program
;if it is, the first byte of the file will 0FFH.
;************************************************
	CALL	read1		;read a byte from file 1
	CP	0ffh		;BASIC PROGRAM?
	JP	NZ,prgerr	;go if not
	CALL	write1		;else send it to disk
;**************************************************
;we have ascertained the the file is correct so now
;we read in the next line numbers address in memory
;and check to make sure it isn't zero (thats the
;end of program 000000.
;**************************************************
loop1	CALL	rdadd		;go read addresses
	LD	A,H		;get MSB
	OR	L		;0=end of program to read
	JP	Z,prgend	;go if end of reading
	CALL	wradd		;else write the addresses
;**************************************************
;we have read in the address and written it out
;now we have to read in the line number to work
;on
;**************************************************
	CALL	rdadd		;read in the line number (hl)
	LD	(linenm),HL	;save it for now
	LD	DE,lbuff	;point to line number buffer
	LD	A,@bindec	;convert HL to number
	RST	svc		;in buffer
	LD	HL,workln	;point to working on line...
	CALL	disply		;show it
	LD	HL,(linenm)	;now get back the line number
	CALL	wradd		;and write two bytes to the disk
	XOR	A		;remove any quote flags
	LD	(qflag),A	;now
;*************************************************
;now that the next line addresses are read in and
;written out, we have to concern ourselves with
;loading in the line of BASIC compressed text.
;this line will terminate with a 0 byte. We will
;convert until then.
;*************************************************
rdlp	CALL	read1		;read in one byte
	OR	A		;look for 0 (end of line)
	JR	NZ,proces	;go if not end of line
	CALL	write1		;else it is so we update other file
	XOR	A		;remove quote flag for literal text
	LD	(qflag),A	;in memory pointer
	JP	loop1		;and read the next line address
proces	LD	(byte),A	;else we can convert
	CP	'"'		;look for quotes (literal text)
	CALL	Z,quote		;go if found
	PUSH	AF		;now check for text in quotes
	LD	A,(qflag)	;0=process as normal 1=within quotes
	OR	A		;test for condition now
	JR	Z,cntpro	;go if to continue processing
	POP	AF		;else get back character
	JP	tabend		;just write out the byte and continue
cntpro	POP	AF		;get back character now for processing
	CP	7eh		;look for normal ASCII
	JP	C,tabend	;go if normal ASCII text
	LD	HL,abs		;point to table LSB model 4 
	INC	HL		;point to MSB MODEL 4
	INC	HL		;point to LSB model 3 (needed)
	LD	B,200		;just a rough guess
prolp	LD	A,(HL)          ;get LSB byte from table (model 3)
	OR	A		;look for end of table
	JR	Z,tabend	;go if end found (write byte normal)
	LD	A,(byte)	;else get byte to look for
	CP	(HL)		;check against memory
	JR	Z,match		;go if same
	LD	DE,8		;offset to next
	ADD	HL,DE		;find next one
	DJNZ	prolp		;loop through table now
	JP	mod324		;just a test
match	CALL	chkspc		;check for space needed
	LD	A,(HL)		;get back byte read
	CP	175		;look for LPRINT
	JP	Z,dolprt	;go if yes
	CP	188		;look for Model 3 tab
	JP	Z,dotab		;go if found
	CP	178		;look for PRINT
	JP	Z,doprt		;go if found
	DEC	HL		;back up to MSB model 4 byte
	LD	A,(HL)		;get a byte
	OR	A		;only single byte code?
	JR	Z,single	;go if yes
	PUSH	HL		;else move point to hl MSB first
	LD	A,(HL)		;get LSB code for Model 4 version
	CALL	write1		;write to disk
	POP	HL		;get back pointer
	DEC	HL		;point to LSB model 4 code
	LD	A,(HL)		;get MSB of code word
	CALL	write1		;send to disk
	CALL	chksp1		;check for needed space trailing
	JP	rdlp		;and loop til done
single	DEC	HL		;point to LSB byte of Model 4 table
sing1	LD	A,(HL)		;get byte from table
	CALL	write1		;and write it to disk
	CALL	chksp2		;check for trailing space
	JR	rdlp		;and continue
tabend	LD	A,(byte)	;byte not in table to write normal
	CALL	write1		;to disk
	JP	rdlp		;and continue til done
dotab	DEC	HL		;back up to MSB model 4 byte
	DEC	HL		;point to LSB model 4 byte
	LD	A,(HL)		;get a LSB model 4 byte
fndbrk	CALL	write1		;writes ( to disk file
	CALL	read1		;read next character
	CP	'9'+1		;look for number > 9
	JR	NC,exitrt	;patch back into main routine
	LD	HL,number	;point to buffer storage
	PUSH	HL		;save pointer
	LD	B,5		;erase buffer
clrbuf	LD	(HL),00h	;zero it for now
	INC	HL		;point to next
	DJNZ	clrbuf		;do til cleared
	POP	HL		;get back pointer
	LD	(HL),A		;store the number
	INC	HL		;point to next
rdval	CALL	read1		;read in next byte
	CP	')'		;got close bracket?
	JR	Z,allrd		;go if all read in
	LD	(HL),A		;store the character (number)
	INC	HL		;else step to next
	JR	rdval		;and loop til done
allrd	LD	HL,number	;point to string
	LD	A,@decbin	;convert to binary
	RST	svc		;do it
	LD	A,C		;get LSB tab position
	SRL	A		;shift right divide by 2
	SRL	A		;and divide by 4 total
	ADD	A,C		;and get new value
	LD	H,00h		;make MSB = 0
	LD	L,A		;make LSB = new tab position
	LD	A,@bindec	;convert to decimal
	LD	DE,number	;point to buffer
	RST	svc		;convert to decimal (ASCII)
	LD	A,0dh		;place terminator
	LD	(DE),A		;store in buffer
wrval	LD	A,(HL)		;get a byte
	CP	0dh		;look for terminator
	JR	Z,wrval1	;go if done
	CALL	write1		;else send value to disk
	INC	HL		;point to next
	JR	wrval		;loop til end of ASCII digit
wrval1	LD	A,')'		;now get a close bracket
	CALL	write1		;send to disk
	JP	rdlp		;and continue
dolprt	DEC	HL		;back up
	DEC	HL		;again
	LD	A,(HL)		;get LSB model 4 type
	CALL	write1		;send to file
lptspc	CALL	read1		;and read in next byte
	CP	' '		;look for space
	JR	Z,lptspc	;go if space
	CP	188		;else a TAB command?
	JP	NZ,proces	;go if not
	LD	A,209		;else replace with TAB (model 4)
	CALL	write1		;send to disk
	JP	rdlp		;and continue
exitrt	LD	(byte),A	;save whatever it is
	JP	proces		;and process it
doprt	DEC	HL		;step MSB model 4 byte
	DEC	HL		;step to MODEL 4 LSB byte
	LD	A,(HL)		;get it
	CALL	write1		;send to disk file
	CALL	read1		;read a byte
	LD	(byte),A	;save character for now
	CP	'@'		;look specifically for @ code
	JP	NZ,proces	;process as normal if not @
	CALL 	write1		;send @ to file
	CALL	read1		;read in first digit (number or VAR)
	LD	(byte),A	;save baddie
	CP	'9'+1		;look for variable
	JP	NC,prtlin	;leave if variable of bad cmd
	LD	HL,number	;point to buffer
	PUSH	HL		;save it
	LD	B,250		;bytes to clear out
clrbf1	LD	(HL),00h	;zero it for now
	INC	HL		;point to next
	DJNZ	clrbf1		;do til cleared
	POP	HL		;point to character
	LD	(HL),A		;save character
	INC	HL		;point to next
rddig	CALL	read1		;get a byte
	CP	'0'		;check for less than 0
	JR	C,rdlst		;leave if too low
	CP	'9'+1		;check for greater than 9
	JR	NC,rdlst	;go if too high
	LD	(HL),A		;else store in buffer
	INC	HL		;point to next
	JR	rddig		;look til not number
rdlst	CP	','		;MUST BE A COMMA to continue
	JR	Z,rdlst1	;go if yes else computations
	LD	(byte),A	;save this value then
	LD	(HL),0dh	;insert end of line marker
	LD	HL,number	;point to buffer full of junk
wrjunk	LD	A,(HL)		;get rubbish
	CP	0dh		;end of line?
	JR	Z,prtlin	;send line number to printer if done
	CALL	write1		;else write character to disk
	INC	HL		;point to next
	JR	wrjunk		;loop til C/R
prtlin	LD	HL,prtat	;point to text
	LD	A,@print	;send to printer
	RST	svc		;do it
	LD	HL,lbuff	;point to number of line
	LD	A,@print	;line print it
	RST	svc		;"	"
	LD	HL,prtend	;and give bad news
	LD	A,@print	;and line print it
	RST	svc		;do it
	LD	A,(byte)	;get back invalid character
	JP	proces		;and continue rubbish normally
rdlst1	LD	HL,number	;point to ASCII
	LD	A,@decbin	;convert to BINARY
	RST	svc		;BC=binary value
	PUSH	BC		;move BINARY value to HL
	POP	HL		;HL=print@ position
	LD	C,64		;divisor for number of rows
	LD	A,@div16	;do a divide
	RST	svc		;do it
	PUSH	AF		;save remainder
	PUSH	HL		;save ROW to use
	LD	A,' '		;send out a space now
	CALL	write1		;send out space
	LD	A,'('		;and a open bracket
	CALL	write1		;send it out
	POP	HL		;get back row number
	LD	DE,number	;point to number buffer
	LD	A,@bindec	;convert to DECIMAL ASCII
	RST	svc		;do it
	LD	A,0dh		;set in terminator byte
	LD	(DE),A		;save it in buffer
wrrow	LD	A,(HL)		;get a byte
	CP	0dh		;end of buffer?
	JR	Z,wrend		;go if yes
	CALL	write1		;else send to disk file
	INC	HL		;point to next
	JR	wrrow		;loop til done
wrend	LD	A,','		;write a comma between numbers
	CALL	write1		;send to disk
	POP	AF		;get remainder from previous
	LD	C,A		;save for add
	SRL	A		;divide by 2
	SRL	A		;divide by 4 total
	ADD	A,C		;and find new total
	LD	L,A		;move to LSB
	LD	H,00h		;reset MSB to 0
	LD	DE,number	;point to buffer
	LD	A,@bindec	;convert to ASCII DECIMAL
	RST	svc		;do it
	LD	A,0dh		;set end marker
	LD	(DE),A		;in buffer
wrcol	LD	A,(HL)		;get a byte
	CP	0dh		;end of buffer?
	JR	Z,colend	;go if done
	CALL	write1		;else write it out to file
	INC	HL		;point to next
	JR	wrcol		;loop til done
colend	LD	A,')'		;send out closing bracket
	CALL	write1		;send it out
	LD	A,','		;and finally a comma to send out
	CALL	write1		;do it
	JP	rdlp		;and continue
prgend	CALL	wradd		;write end bytes to file2
	LD	DE,file2	;point to file
	LD	A,@close	;and close it
	RST	svc		;all done now
	LD	HL,final	;point to final instructions now
	CALL	disply		;show them
	LD	HL,0000h	;reset any errors
	LD	A,@exit		;and back to DOS PLUS
	RST	svc		;now
read1	LD	DE,file1	;point to file 1
	LD	A,@get		;get a byte
	RST	svc		;from the file
	RET			;and go back
write1	LD	DE,file2	;point to output file
	LD	C,A		;move byte to write out
	LD	A,@put		;and write to disk
	RST	svc		;now
	RET			;and back to caller
rdadd	LD	DE,file1	;read addresses from file 1
	LD	A,@get		;read in a byte
	RST	svc		;now
	LD	L,A		;read in LSB first
	LD	DE,file1	;point again
	LD	A,@get		;and now second address byte
	RST	svc		;read it in
	LD	H,A		;and store in MSB
	RET			;and back to caller
wradd	LD	DE,file2	;point to output file
	LD	C,L		;move LSB over to write
	LD	A,@put		;and code to send
	RST	svc		;and write to disk
	LD	DE,file2	;and now for second part
	LD	C,H		;move for write
	LD	A,@put		;code to write
	RST	svc		;do it
	RET			;and go back
chkspc	LD	A,(space)	;test for wanted
	OR	A		;0=no NZ=yes
	RET	Z		;back if not
	PUSH	HL		;save pointer please
	INC	HL		;point to MSB model 3 code
	INC	HL		;point to LSB leading space code
chkrt	LD	A,(HL)		;get a byte
	OR	A		;0=no space NZ=space
	JR	Z,nospc		;go if not needed
	LD	A,' '		;else load a space
	CALL	write1		;send to file
nospc	POP	HL		;restore pointer
	RET			;and go back
chksp1	LD	A,(space)	;test for wanted
	OR	A		;0=no NZ=yes
	RET	Z		;back if not
	PUSH	HL		;just for later POP
	LD	DE,5		;offset to find trailing status
chksp3	ADD	HL,DE		;find it
	JR	chkrt		;and continue
chksp2	LD	A,(space)	;test for wanted
	OR	A		;0=no NZ=yes
	RET	Z		;back if not
	PUSH	HL		;just for later POP HL
	LD	DE,6		;offset for single byte conversion
	JR	chksp3		;and continue
quote	PUSH	AF		;save character
	LD	A,(qflag)	;get quote status
	XOR	01h		;toggle 0/1 for text within quotes
	LD	(qflag),A	;save result again
	POP	AF		;restore character
	RET			;and go back to caller
disply	LD	A,(HL)		;get a byte
	CP	03h		;end of message
	RET	Z		;back if yes
	LD	C,A		;else move for display
        LD      A,@dsp          ;display a character
        RST     svc             ;and do it
	INC	HL		;point to next
	JR	disply		;and continue
cls	LD	C,1ch		;home cursor
        LD      A,@dsp          ;display a character
        RST     svc             ;and do it
	LD	C,1fh		;now erase to end of frame
        LD      A,@dsp          ;display a character
        RST     svc             ;and do it
	RET			;and return to caller
prgerr	LD	HL,prgmsg	;point to wrong kind of program
	CALL	disply		;show it
	LD	HL,0000h	;reset any errors
	LD	A,@exit		;return code
	RST	svc		;and go back to DOS PLUS
bad	RES	7,A		;return to DOSPLUS on error
	LD	C,A		;move for display though
	LD	A,@error	;show the error
	RST	svc		;do it
;*************************************************
;This is the command table which allows files to
;be interchanged. The file consists of four bytes
;for each command word. The first two bytes are
;the command word. The next two bytes determine
;if there is a necessary space either before and/or
;after the keyword respectively.
;*************************************************
abs	DEFW	65414,217,1,1
and	DEFW	248,210,1,1
asc	DW	65429,246,1,1
atn	DW	65422,228,1,1
auto	DW	171,183,0,1
cdbl	DW	65438,241,0,0
chr 	DW	65430,247,0,0
cint	DW	65436,239,1,1
clear	DW	146,184,0,1
close	DW	195,166,0,1
clrscr	DW	159,132,0,0
cmd	DW	189,133,1,0
cont	DW	153,179,0,0
cos	DW	65420,225,0,0
csng	DW	65437,240,0,0
cvd	DW	65452,232,0,0
cvi	DW	65450,230,0,0
cvs	DW	65451,231,0,0
data	DW	132,136,0,1
def	DW	151,176,0,1
defdbl	DW	176,155,0,0
defint	DW	174,153,0,1
defsng	DW	175,154,0,1
defstr	DW	173,152,0,1
delete	DW	107,182,0,0
dim	DW	134,138,0,1
edit	DW	167,157,0,1
else	DW	162,149,1,1
end	DW	129,128,1,1
eof	DW	65453,233,0,0
erl	DW	215,194,0,1
err	DW	216,195,0,1
error	DW	168,158,0,1
exp	DW	65419,224,1,1
field	DW	192,163,0,1
fix	DW	65439,242,0,1
fn	DW	212,190,0,1
for	DW	130,129,0,1
fre	DW	65423,218,0,1
get	DW	193,164,0,1
gosub	DW	141,145,0,1
goto	DW	137,141,0,1
if	DW	139,143,0,1
inkey	DW	224,201,0,1
inp	DW	65424,219,0,0
input	DW	133,137,0,1
instr	DW	219,197,0,1
int	DW	65413,216,1,0
kill	DW	200,170,0,1
left	DW	65409,248,0,1
len	DW	65426,243,0,1
let	DW	136,140,0,1
line	DW	177,156,0,0
list	DW	147,180,0,1
llist	DW	158,181,0,1
load	DW	196,167,0,1
loc	DW	65454,234,0,0
lof	DW	65455,235,0,0
log	DW	65418,223,0,1
lprint	DW	157,175,0,1
lset	DW	201,171,0,1
mem	DW	225,200,0,1
merge	DW	197,168,0,1
mid	DW	65411,250,0,1
mkd	DW	65458,238,0,1
mki	DW	65456,236,0,1
mks	DW	65457,237,0,1
name	DW	199,169,0,1
new	DW	148,187,1,1
next	DW	131,135,1,1
not	DW	214,203,1,1
on	DW	149,161,1,1
open	DW	191,162,0,1
or	DW	249,211,1,1
out	DW	156,160,0,1
peek	DW	65431,229,0,1
poke	DW	152,177,0,1
pos	DW	65425,220,0,1
print	DW	145,178,0,1
put	DW	194,165,0,1
random	DW	187,134,0,0
read	DW	135,139,0,1
rem	DW	143,147,0,0
restor	DW	140,144,0,1
resume	DW	169,159,0,1
return	DW	142,146,0,0
right	DW	65410,249,0,1
rnd	DW	65416,222,0,1
rset	DW	202,172,0,1
run	DW	138,142,0,1
save	DW	203,170,0,1
sgn	DW	65412,215,0,1
sin	DW	65417,226,0,1
sqr	DW	65415,221,0,1
step	DW	210,204,1,1
stop	DW	144,148,0,0
str	DW	65427,244,0,1
string	DW	217,196,0,1
system	DW	189,174,0,1
tab	DW	209,188,0,1
then	DW	208,202,1,1
time	DW	226,199,0,0
to	DW	207,189,1,1
troff	DW	164,151,0,0
tron	DW	163,150,0,0
using	DW	218,191,0,1
usr	DW	211,193,0,1
val	DW	65428,245,0,1
varptr	DW	221,192,0,1
plus	DW	243,205,0,0
minus	DW	244,206,0,0
splat	DW	245,207,0,0
div	DW	246,208,0,0
uparow	DW	247,209,0,0
shft7	DW	220,251,0,0
gt	DW	240,212,1,1
eq	DW	241,213,1,1
lt	DW	242,214,1,1
last	DW	0,0,0,0
;************************************************
;This area is for the file buffers,messages etc
;************************************************
title	DEFM	'                 Basic Program File CONVERTER'
	DW	0d0dh
	DM	'    This program will take any BASIC program from the Model 3 or 1, providing'
	DB	0dh
	DM	'your DOS can read it, and convert it to the Model 4 format. The BASIC program'
        DB	0dh
	DM	'should not be saved in the usual ASCII format to do this. The MOD324 will work'
	DB	0dh
	DM	'on a normal COMPRESSED program only.'
	DW	0d0dh
	DM	'   As the conversion is happening, line numbers will be displayed on the video'
	DB	0dh
	DM	'as they are processed.'
	DW	0d0dh
	DB	03h
quest1	DM	'Model 1/3 Filename to convert: '
	DB	03h
quest2	DEFB	0dh
	DEFM	'Filename to SAVE it as: '
	DEFB	03h
quest3	DEFB	0dh
	DEFM	'Insert Necessary Spaces (Y/N) : '
	DEFB	03h
workln	DEFB	1dh		;erase line to reprint
	DEFM	'Working on Line <'
lbuff	DEFS	5		;ASCII storage
	DEFM	'>.'
	DEFB	03h
prtat	DEFM	'Check line <'
	DEFB	03h
prtend	DEFM	' for possible screen formatting errors!'
	DEFB	0dh
prgmsg	DEFW	0d0dh
	DEFM	'The File you selected to CONVERT is NOT a BASIC program.'
	DEFB	0dh
	DM	'File Conversion ABORTED!'
	DEFW	0d0dh
	DEFB	03h
final	DEFW	0d0dh
	DEFM	'Program Conversion Complete.'
	DEFW	0d0dh
	DEFM	'**NOTE** - before using the program, the Model 4 must perform some housekeeping'
	DEFB	0dh
	DEFM	'on it first. To do this, do the following command sequence:'
	DEFB	0dh
	DEFM	'---------------------------------------------------------'
	DEFB	0dh
	DEFM	'     BASIC <ENTER>      ; go to Basic (no files needed)'
	DEFB	0DH
	DEFM	'     LOAD"program"      ;load your converted program'
	DEFB	0dh
	DEFM	'     SAVE"program",A    ;now save it as an ASCII file'
	DEFB	0dh
	DEFM	'     LOAD"program"      ;reload the same program'
	DEFB	0dh
	DEFM	'     SAVE"program"      ;save the completed version.'
	DEFB	0dh
	DEFM	'---------------------------------------------------------'
	DEFW	0d0dh
	DEFM	'Mod324 <c> 1984 by Mel Patrick'
	DEFB	0dh
	DEFB	03h
linenm	DEFW	0000h		;line number storage
qflag	DEFB	00h		;0=normal 1=within quotes
space	DEFB	00h		;0=no spaces NZ=spaces
byte	DEFB	00h		;byte we read in
number	DEFS	250     	;for TAB storage
buffer	DEFS	50
file1	DEFS	50
file2	DEFS	50
buff1	DEFS	256
buff2	DEFS	256
	END	mod324
