{$No InOut}
program M4CharDemo (Kbd, Crt);

{R1V1 860614 jmo.
 R1V2 860615 jmo. Added IntroScreen, cleaned up various small items}

{Demonstration of some video control routines and Model 4 character sets}
{Based on a BASIC program by Carl Berger of NOVA BBS 813/544-8049       }

const
 SpecChar  = true;
 SpaceComp = false;

type tOption = (None, Quit, Change, Reverse, Normal, Disable, Small,
                Large, Redraw);
var
 Option: tOption;
 Kbd, Crt: text;

procedure ClearScreen; external;
procedure GotoXY(Col, Row: integer); external;
procedure WriteCh (Ch: char);external;
{$No List}
{$include 'm4vidlib/inc'}
{$List   }
procedure SetIO (var InputF, OutputF: text);
 procedure SetAcNm (var F: text; Name: string);external;

 begin
  SetAcNm (InputF, bldstr (':C')); reset (InputF);
  SetAcNm (OutputF, bldstr (':C')); rewrite (OutputF);
 end;{set io}

procedure IntroScreen;

const LM = 21;
       W = 38;
begin

 ClearScreen;
 CursOff;
 RVidOn;
 GotoXY (LM, 4);write (Crt, ' Model 4 Character  Set Demonstration':W);
 GotoXY (LM, 5);write (Crt, ' ':W);
 GotoXY (LM, 6);write (Crt, '             Joe  Oglesby':W);
 GotoXY (LM, 7);write (Crt, '           Nexial   Systems':W);
 GotoXY (LM, 8);write (Crt, '             813/866-9281':W);

 GotoXY (LM,10);write (Crt, '      Press ENTER to Continue':W);
 RVidOff;
 GotoXY (0,22);readln (Kbd);

end;

procedure PrintScreen;

 procedure Heading (Head: string);
  begin writeln (Crt, Head); dispose (Head) end;

 procedure PrintCh (FirstCh, LastCh: char);
  const Blank = ' ';
  var Ch: char;
  begin
   for Ch := FirstCh to LastCh do
    begin
     DispChar (Ch);
     WriteCh (Blank);
    end;
  end; {printch}
begin {print screen}

 GotoXY (0,1);
 Heading (bldstr ('Special Characters (0-31)'));
 PrintCh (chr(0), {to} chr(31));

 GoToXY (0,4);
 Heading (bldstr ('ASCII Characters (32-127)'));
 PrintCh (chr(32), {to} chr(127));

 GoToXY (0,10);
 Heading (bldstr ('Graphics Characters (128-191)'));
 PrintCh (chr(128), {to} chr(191));

 GoToXY (0,15);
 Heading (bldstr ('Special Characters 192-255'));
 PrintCh (chr(192), {to} chr(255));

end; {print screen}

procedure DispOption (Option: tOption);
var Prompt: string;
begin

 case Option of
  Quit    :Prompt := bldstr ('Q to end program');
  Change  :Prompt := bldstr ('C to toggle Special/Alternate Characters');
  Reverse :Prompt := bldstr ('R to Enable Reverse Video');
  Normal  :Prompt := bldstr ('N to turn-off Reverse Video');
  Disable :Prompt := bldstr ('D to Disable (reset) Reverse Video');
  Small   :Prompt := bldstr ('S for Small Character set (80 column)');
  Large   :Prompt := bldstr ('L for Large Character set (40 column)');
  ReDraw  :Prompt := bldstr ('@ to redraw screen');
 end;

 GotoXY (0,22);
 write (Crt, 'Press ', Prompt:73);
 dispose (Prompt);

end;
function Response: tOption;

const StopLoop = 1000;

var Ch: char; Ready: boolean;
    Loop: integer;

procedure InKey (var Ch: char;var Status: boolean);external;

begin

 Loop := 0;
 Response := None;

 repeat

  InKey (Ch, Ready);

  if Ready then
   case Ch of
    'Q', 'q': begin Response := Quit; Loop := pred (StopLoop) end;
    'C', 'c': AltChrTog;
    'R', 'r': RVidOn;
    'N', 'n': RVidOff;    {Turns Reverse Video Off. Does not reset.}
    'D', 'd': ResetVideo; {Turns Reverse Video Off and resets screen.}
    'S', 's': begin ClearScreen; PrintScreen end;
   {'T', 't': AltSpcTog;}
    'L', 'l': begin ClearScreen;Vid40;PrintScreen end;
    '@'     : begin ClearScreen;PrintScreen end;
   end;

  Loop := succ (Loop);

 until Loop = StopLoop;

end;  {response}
begin {main}

 SetIO (Kbd, Crt);
 IntroScreen;

 CursOff;
 CharSet (SpecChar);
 ClearScreen;
 PrintScreen;

 Option := Quit;
 repeat

  DispOption (Option);
  if Option = ReDraw then
   Option := Quit
  else
   Option := succ (Option)

 until Response = Quit;

 CursOn;
 CharSet (SpaceComp);

end.