KBMOD  ;Stand-alone control-arrow key keyboard enhancement
 ;for the Model 4 (for use in the Model III mode)
 
 ;Program written by:
 
 ;		Jack Decker
 ;		1804 West 18th Street  Lot # 155
 ;		Sault Ste. Marie, Michigan  49783
 ;		(906) 632-3248
 
 ;Copyright 1983 by Jack Decker
 
 ;Permission is granted to freely use and distribute this
 ;program for non-commercial purposes only, provided that
 ;these credit lines are left intact.  If you like this
 ;program, you may want to consider obtaining the full
 ;24 X 80 video driver package for use with the Model III
 ;mode of the TRS-80 Model 4.  Now you can run many of
 ;your Model III programs without conversion, and still
 ;enjoy the benefits of the 24 X 80 screen display. The
 ;program also copies the BASIC ROM into RAM and then
 ;patches it so that functions such as PRINT @, TABs,
 ;SET/RESET/POINT, the screen print routine, etc. will
 ;work properly with the 24 X 80 display.  Fully
 ;commented Editor-Assembler source code is included on
 ;the disk!  For further information regarding the 24 X 80
 ;video driver package, please contact:
 
 ;		The Alternate Source
 ;		704 North Pennsylvania Avenue
 ;		Lansing, Michigan  48906
 ;		(517) 482-8270
 
 ;USE OF THIS PROGRAM:  This program is fully
 ;self-relocating.  To initialize, from DOS READY type:
 ;	KBMOD		or		KBMOD F
 ;The second form (with the "F" argument) kicks in the
 ;fast clock speed of the Mod 4.  The program will
 ;relocate and initialize itself.  Thereafter, you may
 ;use the CTRL key along with any of the four arrow keys
 ;to move the cursor anywhere on the video display,
 ;without erasing the characters passed over by the
 ;cursor.  If you hold down the CTRL, SHIFT, and right
 ;arrow keys at the same time, the character at the
 ;current cursor position will be returned to the calling
 ;routine, as if it had been entered from the keyboard.
 ;This allows you to enter without re-typing anything
 ;on the video display.  For example, after you have
 ;displayed a disk directory, you can run the cursor over
 ;any /CMD filename using the CTRL/SHIFT/right arrow, and
 ;the DOS will think you typed in that filename and will
 ;proceed to run the program!  This routine has MANY uses,
 ;so experiment with it.  You may find it convenient to
 ;use an AUTO command to automatically run this program
 ;each time you boot your system.
 
 ;WARNINGS:  There are two things that can happen with
 ;this routine in use that might cause you some concern.
 ;The first is that if you use the CTRL-arrow function to
 ;pass the cursor over a zero byte on the display, it will
 ;turn off the cursor!  The first time this happens, you
 ;may think that something terrible has happened, but
 ;pressing BREAK or ENTER will usually bring back your
 ;cursor.  The problem is with the video driver, but you
 ;will find that under normal conditions, there will NEVER
 ;be a zero byte on the screen, since the video driver
 ;won't put one there.  However, a zero byte can be POKEd
 ;to the screen, but that isn't done very often.  Another
 ;warning is that if you use the CTRL/SHIFT/right arrow
 ;keys to input characters from the screen, and you pass
 ;over a graphics character in the range 0C0H - 0FFH, the
 ;space compression/special characters flag will
 ;automatically be set to special characters, to avoid
 ;printing unwanted tabs.  Similarly, the CTRL/SHIFT/right
 ;arrow routine will not pass over or input a character in
 ;the 00H - 1FH range, since it would be interpreted as
 ;a control character by the calling routine, with
 ;unpredictable results.
 
 ;This routine depends on the calling routine to echo the
 ;character.  Therefore, it cannot be used with INKEY type
 ;routines that do not echo characters to the video
 ;display.
 
 ;If you write regarding this program, please be sure to
 ;enclose a self-addressed, stamped envelope (U.S. or
 ;Canadian postage O.K.) if you wish a reply.  No replies
 ;will be sent within Canada or the U.S.A. unless the SASE
 ;is included with your correspondence.
 
 
 ;*****  INITIALIZATION & RELOCATION SEGMENT BEGINS  *****
 
 	ORG	7000H
 INTLZE	LD	A,(HL)		;Get argument if any
 	AND	0DFH		;Mask out lowercase
 	CP	'F'		;Set fast speed?
 	JR	NZ,SLOW		;If fast not specified
 	LD	A,(4210H)	;Bit mask for port ECH
 	OR	40H		;Set bit 6
 	OUT	(0ECH),A	;Output to port ECH
 	LD	(4210H),A	;Re-save bit mask
 SLOW	LD	HL,(4016H)	;Get current KB dvr addr
 	LD	(START+1),HL	;Patch into program
 	XOR	A		;Clear Carry flag
 	LD	DE,402DH	;RET address if DOS
 	POP	HL		;Get actual RET address
 	PUSH	HL		;Re-save it as well
 	SBC	HL,DE		;Result zero if under DOS
 	JR	NZ,NOTDOS	;If not under DOS
 	LD	HL,4411H	;Mod 3 DOS top-of-memory
 	LD	(MEMSIZ+2),HL	;Self-modify program
 	LD	(STRMEM+1),HL	;  memory pointers & put
 	LD	(GETMEM+1),HL	;  DOS addr in exit of
 	LD	(IEXIT+1),DE	;  initialization routine
 	DEC	A		;Flag as under DOS
 NOTDOS	LD	HL,END		;End of unrelocated pgrm
 MEMSIZ	LD	DE,(40B1H)	;End of unprotected mem
 	LD	BC,END-OFFST+1	;Length of main program
 	LDDR			;Move the program
 	EX	DE,HL		;New memory size in HL
 STRMEM	LD	(40B1H),HL	;Save new memory size
 	INC	A		;A=0 if under DOS
 	JR	Z,SKPCLR	;Skip CLEAR if under DOS
 	LD	SP,INTLZE+6	;Don't crash moved code
 	LD	HL,41BBH	;HL=1st byte DOS vector
 	LD	A,(HL)		;Save DOS vector in
 	EX	AF,AF'		; alternate A register
 	LD	A,0C9H		;Plug DOS vector with
 	LD	(HL),A		;  a RET instruction
 	LD	DE,32H		;"CLEAR 50"
 	CALL	1E83H		;& reset other pointers
 	EX	AF,AF'		;Get original DOS vector
 	LD	(HL),A		;Restore original vector
 GETMEM	LD	HL,(40B1H)	;Get new prgrm location
 SKPCLR	INC	HL		;HL=Entry point address
 	LD	(4016H),HL	;Put into keyboard DCB
 	LD	BC,1A18H	;For tape BASIC re-entry
 IEXIT	JP	19AEH		;Re-enter BASIC (or DOS)
 
 ;*****  MAIN PROGRAM (WILL BE RELOCATED) BEGINS  *****
 
 OFFST	EQU	$		;Used by relocator
 
 START	CALL	0		;Modified to call KB dvr
 	RET	Z		;Return if no character
 	LD	B,A		;Save char in A
 	LD	A,(3880H)	;Get CTRL key row
 	AND	4		;Mask out other keys
 	JR	NZ,CTRL		;Go if control char
 KBEXIT	LD	A,B		;Get original character
 	RET			;  & return
 CTRL	LD	A,(403CH)	;Arrow key row storage
 	AND	78H		;Arrow key pressed?
 	JR	Z,KBEXIT	;Go if not CTRL+arrow
 	LD	A,B		;Get original character
 	CP	0BH		;Greater than 0AH?
 	JR	NC,HICTRL	;Go if greater than 0AH
 	CP	8		;Less than 08H?
 	RET	C		;Return if so
 	OR	10H		;Make cursor ctrl char
 MVCRSR	CALL	0033H		;Output char to video
 NULRET	XOR	A		;Make null (zero) byte
 	RET			;Return with no char
 HICTRL	AND	0BFH		;Make 5BH same as 1BH
 	CP	1BH		;Was char CTRL+uparrow?
 	JR	Z,MVCRSR	;Send to video if so
 GETCHR	CP	19H		;CTRL+SHIFT+rt arrow?
 	JR	NZ,NULRET	;Return null chr if not
 	LD	A,(4022H)	;Get char under cursor
 	OR	A		;Check for valid char
 	JR	NZ,GOTCHR	;Go if valid character
 	LD	HL,(4020H)	;Get current cursor pos
 	LD	A,(HL)		;Get char at cursor
 GOTCHR	CP	20H		;Control character?
 	JR	C,NULRET	;Return null if control
 	CP	0C0H		;"Special" character?
 	RET	C		;Output if regular chr
 	RLA			;Set bit 1 of A register
 	LD	(4024H),A	;Set spec. chars flag
 	RRA			;Restore original char
 	RET
 
 END	EQU	$-1		;Used by relocator
 
 	END	INTLZE
                                                                                                  