10 'GREGORIAN->JULIAN->ORDINAL AND ORDINAL->JULIAN->GREGORIAN CONVERSION
20 '(1)  <Month_name> 3 letters to full name with space terminator. <Day-no.>
30 '     with comma terminator. Space character between comma and <Year> is
40 '     optional.
50 '(2)  MM-DD-YY Where MM & DD may be single digits, YY may be 4 digits
60 'ORDINAL TO JULIAN AND GREGORIAN FORMAT
70 'ORDINAL BASE IS 01-01-80 = 1
80 '                    Arnold Thomsen
90 '                    3811 N. 60 Place
100 '                   Scottsdale, Az 85251
110 '                                              09-16-82 = 990
120 DEFINT A-Z:DIM TBL(14)
130 WEEK$="MON TUE WED THU FRI SAT SUN "
140 MONTH$="JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC "
150 CLS
160 PRINT:PRINT "Conversion from various date formats to different formats"
170 PRINT "Notes:"
180 PRINT "Julian date is printed in all conversions"
190 PRINT "Gregorian examples: 'SEP 1, 1982' or 'SEPTEMBER 1,1982'"
200 PRINT "                           ^             ^^^^^^ 3 char min"
210 PRINT "                           ^ space char optional"
220 PRINT "MM AND DD may be 1 or 2 digits"
230 PRINT "YY may be the last 2 digits of year or all 4 digits"
240 PRINT "Ordinal Day 1 = Jan 1, 1980":PRINT
250 PRINT "TO Quit press ENTER or       type 0"
260 PRINT "FOR Gregorian     to Ordinal type 1"
270 PRINT "FOR MM-DD-YY      to Ordinal type 2"
280 PRINT "FOR DEC Ordinal to Gregorian type 3"
290 INPUT "FOR HEX Ordinal to Gregorian type 4:  ",T
300 :PRINT CHR$(17);
310 ON T GOTO 330,420,790,750
320 END
330 PRINT:LINE INPUT "Enter: <MONTH_NAME><SPACE><DAY>,^SPACE]<YEAR> ";IN$
340 IF LEN(IN$) = 0 GOTO 150
350 MM$ = LEFT$(IN$,3):MM = 13 'ASSUME ERROR
360 FOR G = 1 TO 12
370 IF MID$(MONTH$,4*G-3,3) = MM$ THEN MM = G
380 NEXT G
390 IF MM = 13 THEN PRINT:PRINT "MONTH NOT FOUND":GOTO 300
400 B = INSTR(IN$," "):IF B = 0 GOTO 330
410 C = INSTR(B+2,IN$,","):IF C = 0 GOTO 330 ELSE C = C + 1:GOTO 500
420 PRINT:INPUT "INPUT MONTH-DAY-YEAR (MM-DD-YY)";IN$
430 IF LEN(IN$) = 0 GOTO 150
440 IF MID$(IN$,2,1) = "-" THEN B = 3:GOTO 460
450 IF MID$(IN$,3,1) = "-" THEN B = 4 ELSE GOTO 420
460 IF MID$(IN$,4,1) = "-" THEN C = 5:GOTO 490
470 IF MID$(IN$,5,1) = "-" THEN C = 6:GOTO 490
480 IF MID$(IN$,6,1) = "-" THEN C = 7 ELSE GOTO 420
490 MM=VAL(LEFT$(IN$,2)):IF MM<1 OR MM>12 THEN PRINT "MONTH ERROR":GOTO 300
500 DD=VAL(MID$(IN$,B,3)):IF DD<1 OR DD>31 THEN PRINT "DAY ERROR":GOTO 300
510 YY=VAL(MID$(IN$,C,5)):IF YY < 100 THEN YY = YY + 1900
520 IF YY < 1980 THEN PRINT "YEAR ERROR":GOTO 300
530 GOSUB 620 'DECIDE LEAPNESS
540 J = TBL(MM)+DD
550 YY = YY - 1980
560 L = INT((YY+3)\4) 'LEAP YEAR DAYS
570 ORD = YY*365+L+J
580 PRINT "Julian Day = ";J
590 PRINT "Ordinal Day = ";ORD
600 GOTO 300
610 'DECIDE LEAPNESS SUBROUTINE
620 RESTORE
630 FOR K = 1 TO 13
640 READ TBL(K)
650 NEXT K
660 IF YY MOD 4 <> 0 THEN RETURN
670 IF YY MOD 400 = 0 THEN RETURN
680 FOR K = 1 TO 13
690 READ TBL(K)
700 NEXT K
710 RETURN
720 DATA 0,31,59,90,120,151,181,212,243,273,304,334,365
730 DATA 0,31,60,91,121,152,182,213,244,274,305,335,366
740 'ORDINAL TO GREGORIAN CONVERSION
750 PRINT:INPUT "INPUT HEX ORDINAL DAY NO. = ",ORD$
760 IF LEN(ORD$) = 0 GOTO 150
770 GOSUB 1030
780 IF EFLAG = 0 GOTO 860 ELSE GOTO 300
790 PRINT:INPUT "INPUT DEC ORDINAL DAY NO. = ",ORD$
800 IF LEN(ORD$) = 0 GOTO 150
810 EFLAG = 0
820 FOR Q = 1 TO LEN(ORD$):D = ASC(MID$(ORD$,Q,1))
830 IF D < 48 OR D > 57 THEN EFLAG = 1:PRINT "DEC NO. ERROR":Q = LEN(ORD$)
840 NEXT Q
850 IF EFLAG = 1 GOTO 300 ELSE ORD = VAL(ORD$)
860 LEAPSETS = INT(ORD\1461) 'LEAPSET = 366 + (3*365)
870 REMAIN = ORD MOD 1461
880 YY = 4*LEAPSETS + 1980
890 IF REMAIN < 367 GOTO 930
900 REMAIN = REMAIN - 366:YY = YY + 1
910 IF REMAIN < 366 GOTO 930
920 REMAIN = REMAIN - 365:YY = YY + 1:GOTO 910
930 PRINT "Julian Day No. =";REMAIN
940 GOSUB 620 'DECIDE LEAPNESS
950 MM = INT(REMAIN\30) +1
960 IF TBL(MM) => REMAIN THEN MM = MM - 1
970 DD = REMAIN - TBL(MM)
980 MM$ = MID$(MONTH$,4*MM-3,3)
990 WKDAY = (ORD MOD 7)+1
1000 WKDAY$ = MID$(WEEK$,4*WKDAY-3,4)
1010 PRINT "Gregorian date = ";WKDAY$;MM$;:PRINT USING " ##";DD;:PRINT ",";YY
1020 GOTO 300
1030 'HE\ TO DECIMAL CONVERSION SUBROUTINE
1040 EFLAG = 0:ORD = 0
1050 FOR Q = 1 TO LEN(ORD$)
1060 D = ASC(MID$(ORD$,Q,1)) - 48
1070 IF D < 0 OR D > 22 THEN EFLAG = 1:GOTO 1110
1080 IF D > 9 AND D < 17 THEN EFLAG = 1:GOTO 1110
1090 IF D > 9 THEN D = D - 7
1100 ORD = 16*ORD + D
1110 NEXT Q
1120 IF EFLAG = 1 THEN PRINT "HEX NO. ERROR"
1130 RETURN
