       ; SYSINTV2/ASM 
 ; ASSEMBLE TO SYS1/CMD OR SYS4/CMD
 ;
 ;*******************************************************
 LNW	EQU	0	; 1=LNW 0=MODEL 4
 MOD4	EQU	LNW-1
 ;*******************************************************
 ;		Lnw - Model 4
 ; IF WE BOOT ON:
 ;	Z80 System 
 ;		IF LNW: Load Rom to Ram
 ;		If Filespec Then Load File to Ram
 ;
 ;	HD64180 System
 ;	    If Ram Based & HDROM is Active - Do Nothing
 ;		Else
 ;		Load Defult File to Ram
 ;	    If Filespec Then Load filespec to ram
 ;
 ;*******************************************************
 ; WRITTEN BY Dave Huffman
 ; CREATED 09/20/83
 ; UPDATED 01/11/87
 ;********************************************************
 ;
 ;
 ;
 ;*******************************************************
 ;	Find Type of Processor We are Running
 ;
 	ORG	5200H
 START	DEFB	0EDH,38H,18H ; HD64180 INO (18H),A
 	DEFB	3H	     ; IF HD64180 THEN INC BC
 	JP	HD64	; HD64180 SYSTEM
 ;
 	JP	Z80	; Z80 SYSTEM
 ;
 ;
 HD64	LD	A,10
 	LD	(FLAG),A	; 10=HD64180 SYSTEM
 	JP	DOIT 
 ;
 Z80	LD	A,0
 	LD	(FLAG),A	; 0=Z80 SYSTEM
 	JP	DOIT 
 ;
 FLAG	DEFB	0   ; 0=Z80 1=HD64180
 RR	DEFB	0   ; 0=RAM BASED SYSTEM 1=RAM TO ROM
 FILE	DEFB	0   ; 0=NOTHING 1=FILESPEC LOADED TO RAM
 ;
 ;********************************************************
 ;	Ok Now Do It ..................
 ;
 	ORG	7000H
 DOIT 	LD	A,(HL)	;GET DOS BUFFER LAST BYTE
 	CP	0DH
 	JR	Z,CKZ80 	; GO CHECK IF Z80
 ; Look for Filespec
 LOOP	LD	A,(HL)
 	CP	20H
 	INC	HL
 	JR	Z,LOOP
 	DEC	HL
 ; HL NOW EQUALS START OF FILESPEC
 	LD	DE,CMDFL		; BUFFER 
 	LD	BC,13			; Move 13 Max
 	LDIR		; MOVE IT TO BUFFER
 ; 
 GETFLE	LD	HL,CMD	; LOAD HDROM LNW/MODEL4
 	CALL	4419H
 	JP	NZ,4409H
 	DI
 	IF	LNW
 	LD	A,02  ; Remove Write protect & Ram enable
 	OUT	(1FH),A
 	ENIF
 ;
 	IF	MOD4
 	LD	A,1	; SWITCH IN RAM
 	OUT	(84H),A
 ;
 	IN	A,(148)	; Get WP mask
 	RES	6,A
 	OUT	(148),A	; Reset it
 ;
 	ENIF
 ;
 	LD	DE,0
 	LD	HL,8000H
 ;
 	IF	LNW
 	LD	BC,3600H	; Length of Rom
 	ENIF
 ;
 	IF	MOD4
 	LD	BC,3800H	; Length of Rom
 	ENIF
 ;
 	LDIR			; Move it Down
 ;
 	IF	LNW
 	LD	A,82H		; Set Write Protect
 	OUT	(1FH),A
 	ENIF
 ;
 	IF	MOD4
 	IN	A,(148)		; Get Mask
 	SET	6,A		; Set Write Protect
 	OUT	(148),A
 	ENIF
 ;
 	LD	A,10	; FILE FLAG
 	LD	(FILE),A
 	LD	A,0
 	LD	(RR),A	; SET RAM BASED SYSTEM
 ; OK We loaded filespec to ram now  CHECK FLAG
 	LD	A,(FLAG)
 	CP	0		; ? Z80
 	JP	Z,DISPLAY	; Display messages
 ; OK MUST BE HD64180
 	JP	INTHD	; Initalize HD64180
 ;
 ;
 CKHDROM	LD	A,(3)	; JUMP VECTOR
 ;
 	IF	LNW
 	CP	35H	; IS IT ACTIVE
 ; JP 3500H should be in the Rom for the Emulator Code.
 	ENIF
 ;
 	IF	MOD4
 	CP	0A9H	; 02A9H JUMP Address.
 ; Jerrys Rom Has the HDEMUL Code in it so We Know if this
 ; is the New Rom.
 	ENIF
 ;
 	JR	NZ,GETFLE	; GO LOAD FILE
 	LD	A,0
 	LD	(RR),A	; RAM BASED SYSTEM
 	LD	(FILE),A; FILE NOT LOADED
 	JP	INTHD	; GO INIT HD64180
 ;
 CKZ80	LD	A,(FLAG)	; ?Z80
 	CP	0
 	JP	NZ,CKHDROM	; GO CHECK IF HD ROM 
 ;					HD64180
 ;
 ;*********** Z80 LOAD ROM TO RAM **********************
 	IF	LNW
 ; CHECK IF LNW RAM BASED
      	LD	HL,3000H
 	LD	A,(HL)
 	NEG
 	LD	(HL),A
 	CP	(HL)	; IS IT RAM ?
 	JR	Z,DRAM	; YES GO
 ; IS ROM NOW SWAP IN RAM
 	ENIF
 	IF	MOD4
 ; We Will always Reload to Ram.
 	ENIF
 ;
 RELOAD	DI
 ;
 	XOR	A
 	IF	LNW
 	OUT	(1FH),A	; Make sure is ROM/Standard 32k
 	ENIF
 ;
 	IF	MOD4
 	OUT	(84H),A		; Make Sure Rom based
 	ENIF
 ;
 	LD	HL,0
 	LD	DE,8000H
 ;
 	IF	LNW
 	LD	BC,3000H	; Length of Rom
 	ENIF
 ;
 	IF	MOD4
 	LD	BC,3800H	; length of Rom
 	ENIF
 ;
 	LDIR		; MOVE ROM IMAGE TO 8000H
 ;
 	IF	LNW
 	LD	A,2
 	OUT	(1FH),A ; Bank to Ram Based
 	ENIF
 ;
 	IF	MOD4
 	LD	A,1
 	OUT	(84H),A	; Bank to Ram
 	ENIF
 ;
 	LD	HL,8000H
 	LD	DE,0
 ;
 	IF	LNW
 	LD	BC,3000H
 	ENIF
 ;
 	IF	MOD4
 	LD	BC,3800H
 	ENIF
 ;
 	LDIR		; MOVE IMAGE TO LOWER MEMORY
 ;
 	IF	LNW
 	LD	A,82H
 	OUT	(1FH),A ; SET WRITE PROTECT
 	ENIF
 ;
 	IF	MOD4
 	IN	A,(148)	; Get Port Mask
 	SET	6,A	; Set Write Protect
 	OUT	(148),A
 	ENIF
 ;
 	EI
 	LD	A,10	; 10 = ROM TO RAM
 	LD	(RR),A
 	JR	DISPLAY
 ; Enter Here if LNW and Ram based to Check for HD Rom
 DRAM	NEG		; PUT IT BACK
 	LD	(HL),A
  ; NOW CHECK IF THE HD64180 RAM IMAGE IS IN
 	LD	A,(3)	; Address for HD Vector Jump
 	CP	35H	; JUMP VECTOR
 	JR	Z,RELOAD	; GET RID OF IT
 	LD	A,0	; 0=RAM BASED SYSTEM
 	LD	(RR),A
 	JR	DISPLAY
 ;*******************************************************
 ;           HD64180 Setup Routine.
 ;        Wait State Ininalization Memory-I/O
 	IF	LNW
 INTHD  	LD	A,0	; 0 Memory WAIT - 0 I/O Wait
 	ENIF
 ;
 	IF	MOD4
 INTHD	LD	A,16	; 0 Memory Wait - 2 I/O Wait
 	ENIF
 ;
 	DEFB	0EDH,39H,32H	; OUTO (32H),A
 ;          HD64180 Refresh Initialization
 ;
 	IF	LNW
      	LD	A,131	; 13.3us For 6 mhz No Wait states
 	ENIF
 ;
 	IF	MOD4
 	LD	A,130	; 10.0us For 4 Mhz No Wait states
 	ENIF
 ;
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	36H	; PORT 36H
 DISPLAY	LD	HL,SETDIS
 	CALL	4467H		; SETUP DISPLAY
 	LD	HL,HDME
 	CALL	4467H
 ;
 	LD	A,(FLAG)	; CK PROCESSOR TYPE
 	CP	0
 	JR	NZ,DS1		; AH HD64180
 	LD	HL,MESSZ80
 	CALL	4467H
 	LD	A,(RR)	
 	CP	10		; ROM TO RAM ?
 	JR	Z,DS0
 	LD	HL,MESRAM	; Ram based system
 	CALL	4467H
 	JR	DS1A
 DS0	LD	HL,MESROM	; Rom moved to ram
 	CALL	4467H
 	JR	DS1A
 DS1	LD	HL,HDMEHD	; HD64180 system
     	CALL	4467H
 ;
 DS1A	LD	A,(FLAG)	; CK SYSTEM
 	CP	0
 	JR	Z,DS2		; Z80 SYSTEM
 	LD	HL,HDME2
 	CALL	4467H
 	LD	HL,HDME3
 	CALL	4467H
 	CALL	MOVMES
 	LD	HL,FLMES
 	CALL	4467H
 DISEN	LD	HL,HDME
 	CALL	4467H
 	JP	402DH
 ;
 DS2	LD	A,(FILE)	; CK FILE LOAD
 	CP	10
 	JR	NZ,DISEN	; GO DISPLAY END
 	CALL	MOVMES
 	LD	HL,FLMES	; DISPLAY FILE LOAD MESS
 	CALL	4467H
 	JR	DISEN
 ;
 ;
 ;  MOVE FILESPEC TO MESSAGE DISPLAY
 ;
 MOVMES	LD	HL,CMDFL
 	LD	DE,FLMES1	; POS OF FILE
 	LD	B,12		; MAX LENGTH
 MOVLP	LD	A,(HL)
 	CP	0DH
 	RET	Z		; DONE
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	MOVLP	; GO 12 TIMES
 	RET
 ;
 CMD	DEFM	'LOAD '
 	IF	LNW
 CMDFL	DEFM	'HDROM/CIM',0DH
 	ENIF
 ;
 	IF	MOD4
 CMDFL	DEFM	'HDROM4/CIM',0DH
 	ENIF
 ;
 	DEFS	10
 MESSZ80	DEFM	'*         Z80 Based System          *',0DH
 HDMEHD	DEFM	'*        HD64180 Based System       *',0DH
 HDME	DEFM	'*************************************',0DH
 	IF	LNW
 HDME2	DEFM	'*  Wait States - Mem = 0   I/O = 1  *',0DH
 HDME3	DEFM	'*      Memory Refresh = 13.3us      *',0DH
 	ENIF
 ;
 	IF	MOD4
 HDME2	DEFM	'*  Wait States - Mem = 0   I/O = 2  *',0DH
 HDME3	DEFM	'*      Memory Refresh = 10.0us      *',0DH
 	ENIF
 FLMES	DEFM	'*    Rom Image used is '
 FLMES1	DEFM	'             *',0DH
 SETDIS	DEFB	27
 	DEFB	29
 	DEFB	31	; CLEAR TO END
 	DEFB	03H
 ;
 MESRAM 	DEFM	'*         RAM Based System          *',0DH
 MESROM 	DEFM	'*      ROM Image Moved to RAM       *',0DH
 	END	START
