100 REM -- HALLEY SEARCH --
110 REM Original program by Harald Schenk and John Port
120 REM Version 3.6 by John J. Anderson
130 REM (c) 1985 Creative Computing Magazine
140 REM This version runs without alteration on Macintosh, IBM, Tandy desktops.
150 REM Color Computer requires print format changes only.
160 REM For Atari, Commodore 64, 128, CBM, Expanded Vic, Tandy Model 100, NEC
170 REM 8201 and Olivetti M-10, see accompanying figure for amendments.
180 CLS:PRINT "Daylight or Standard Time (D/S)";:INPUT T$:PRINT
190 IF T$="D" OR T$="d" THEN T5=13:T$=" Daylight":GOTO 220
200 IF T$="S" OR T$="s" THEN T5=12:T$=" Standard":GOTO 220
210 GOTO 180
220 PRINT"Month ---------(1-12)";:INPUT M:IF M<1 OR M>12 THEN GOTO 220
230 PRINT"Day -----------(1-31)";:INPUT D:IF D<1 OR D>31 THEN GOTO 230
240 PRINT"Year ---(in entirety)";:INPUT Y:IF Y<0 THEN GOTO 240
250 READ A,E,P,I,N,L,F1,F2,M1,M2,M3,P$
260 DATA 17.9435,.967267,27762.4,2.8316,1.014827,2.96725,725412,.144
270 DATA 4.6,14,5,"COMET HALLEY",1,.01672,365.2564,0,0,721356,.5385
280 M0=M:Y0=Y:D0=D
290 REM Finds Number for date entered and day of week
300 IF M>2 THEN 320
310 F=365*Y+INT(D)+31*(M-1)+INT((Y-1)/4)-INT(3/4*INT((Y-1)/100+1)):GOTO 330
320 F=365*Y+INT(D)+31*(M-1)-INT(.4*M+2.3)+INT(Y/4)-INT(3/4*INT(Y/100+1))
330 D$="Saturday Sunday   Monday   Tuesday  WednesdayThursday Friday   "
340 W$=MID$(D$,9*(F-INT(F/7)*7)+1,9):CLS
350 REM Prints Heading
360 PRINT P$:PRINT "-------------------------------------"
370 PRINT W$;" ";M0;"/";INT(D0);"/";Y0; " ";(D0-INT(D0))*24;"HRS (U.T.)":PRINT
380 F0=F:D0=D0-INT(D0)
390 IF F0>725411! THEN M2=5.5
400 GOSUB 1080
410 GOSUB 1300
420 X2=X:Y2=Y:Z2=Z
430 GOSUB 1530
440 PRINT"Distance from Sun: ";R/1000;" AU"
450 M9=M1+M2*LOG(R/1000)/LOG(10)
460 REM Read Orbital Elements for Earth
470 READ A,E,P,I,N,F1,F2
480 L=1.79065+.000244*(Y0+(M0-1)/12-1980)
490 GOSUB 1080
500 GOSUB 1300
510 X1=X:Y1=Y:Z1=Z
520 GOSUB 1530
530 X3=X2-X1:Y3=Y2-Y1:Z3=Z2-Z1
540 R=SQR(X3*X3+Y3*Y3+Z3*Z3)*1000
550 GOSUB 1530
560 PRINT"Distance from Earth: ";R/1000;" AU":PRINT
570 R=10*(M9+M3*LOG(R/1000)/LOG(10)):GOSUB 1530
580 PRINT "Magnitude: ";R/10:PRINT
590 REM Find Right Ascension (R) and Declination (D1)
600 Q=1: IF X3<0 THEN Q=-1
610 U=1.5708-Q*ATN(Y3/X3)
620 S=Z3/SQR(X3*X3+Y3*Y3+Z3*Z3)
630 IF ABS(S+1)<.000001 THEN I=-1.5708:GOTO 660
640 IF ABS(S-1)<.000001 THEN I=1.5708:GOTO 660
650 I=ATN(S/SQR(1-S*S))
660 T=1.5708-I:C=.917465*COS(T)+.397817*SIN(T)*COS(U)
670 GOSUB 1580
680 D1=1.5708-I
690 C=(COS(T)-.917465*COS(I))/(.397817*SIN(I))
700 GOSUB 1580
710 R=18+Q*I*24/6.28318:R1=R
720 GOSUB 1450
730 PRINT"Right Ascension: ";H;" HRS.";M;" MIN."
740 REM Converts Declination for Display
750 H=D1*57.2958
760 R=(ABS(H)-INT(ABS(H)))*60
770 GOSUB 1530
780 M=R:H=INT(H):IF H<0 THEN H=H+1
790 IF M=60 AND H>=0 THEN H=H+1:M=0
800 IF M=60 AND H<0 THEN H=H-1:M=0
810 IF H=0 THEN M=M*SGN(D1)
820 PRINT "Declination: ";H;" DEG.";M;" MIN.":PRINT
830 E0=(F0-722894!-.2236+D0)*.0172028*24/6.28318-.123333
840 IF ABS(E0)>=24 THEN E0=E0-SGN(E0)*24
850 IF ABS(E0)>=24 THEN 840
860 IF E0<0 THEN E0=E0+24
870 IF R1>=24 THEN R1=R1-24
880 T0=T5+R1-E0
890 IF T0>=24 THEN T0=T0-24
900 IF T0<0 THEN T0=T0+24
910 H=(-.00995-COS(1.5708-D1)*.656059)/(SIN(1.5708-D1)*.75471)
920 IF H<=-1 THEN PRINT"Halley is Above Horizon All Day.":GOTO 1730
930 IF H>=1 THEN PRINT"Halley is Below Horizon All Day.":GOTO 1730
940 C=H:GOSUB 1580
950 H=I/6.28318*24
960 R=T0-H-.066666
970 S=T0+H-.066666
980 IF R<0 THEN R=R+24
990 GOSUB 1450
1000 GOSUB 1660
1010 PRINT"Rises: ";H$;":";M$;" Eastern ";T$;" Time"
1020 R=S:IF R<0 THEN R=R+24
1030 IF R>=24 THEN R=R-24
1040 GOSUB 1450
1050 GOSUB 1660
1060 PRINT "Sets: ";H$;":";M$;" Eastern ";T$;" Time"
1070 END
1080 REM Finds Orbital Motion Since Perihelion
1090 A5=3.14159*A*SQR(A*A*(1-E*E))
1100 A0=A5*(F0-F1-F2+D0)/P
1110 IF ABS(A0)>A5 THEN A0=A0-SGN(A0)*A5
1120 IF ABS(A0)>A5 THEN 1110
1130 IF A0<0 THEN A0=A0+A5
1140 R=A*A*(1-E*E)*(1-E*E)/2
1150 T=2/((E*E-1)*SQR(1-E*E))
1160 K1=3.14159:K=3.14159
1170 K1=K1/2
1180 S=E*SIN(K)/((E*E-1)*(1+E*COS(K)))
1190 U=SQR(1-E*E)*TAN(K/2)/(1+E)
1200 V=ATN(U)
1210 IF U<=0 AND K>3.14159 THEN V=V+3.14159
1220 A1=R*(S-T*V)
1230 IF K>6.28318 THEN A1=A1+(3.14159*A*SQR(A*A*(1-E*E)))
1240 IF K1<.000001 THEN 1270
1250 IF A1<A0 THEN K=K+K1:GOTO 1170
1260 IF A1>A0 THEN K=K-K1:GOTO 1170
1270 IF K=6.28318 THEN K=0
1280 R0=A*(1-E*E)/(1+E*COS(K))
1290 RETURN
1300 REM Computes (X,Y,Z) Coordinates
1310 A1=L-N+K
1320 IF A1>6.28318 THEN A1=A1-6.28318
1330 IF A1>3.14159 THEN A1=A1-6.28318
1340 Q=1:IF A1<0 THEN Q=-1
1350 C=SIN(A1)*COS(1.5708-I):IF I>1.5708 THEN Q=-Q
1360 GOSUB 1580
1370 A2=I
1380 C=COS(A1)/SIN(A2)
1390 GOSUB 1580
1400 Z=R0*SIN(1.5708-A2)
1410 Y=R0*COS(1.5708-A2)*SIN(N+Q*I)
1420 X=R0*COS(1.5708-A2)*COS(N+Q*I)
1430 R=SQR(X*X+Y*Y+Z*Z)*1000
1440 RETURN
1450 REM Converts R.A. For Display
1460 R1=R 
1470 H=R:R=(H-INT(H))*600
1480 GOSUB 1530
1490 M=R/10
1500 IF M=60 THEN H=H+1:IF M=60 THEN M=0
1510 K1=-1:H=INT(H):H=H+K1:IF H>24 THEN H=H-24
1520 RETURN
1530 REM Rounds to the Nearest Integer
1540 R9=R-INT(R)
1550 IF R9>=.5 THEN R=R+1
1560 R=INT(R)
1570 RETURN
1580 REM Inverse Cosine Subroutine
1590 IF ABS(C-0)<.000001 THEN I=3.14159/2:RETURN
1600 IF ABS(C-1)<.000001 THEN I=0:RETURN
1610 IF ABS(C+1)<.000001 THEN I=3.14159:RETURN
1620 I=ATN(SQR(1-C*C)/C)
1630 IF I=0 THEN I=3.14159/2:RETURN
1640 IF C<0 THEN I=I+3.14159
1650 RETURN
1660 REM Converts Hours and Minutes to String$
1670 R=M:GOSUB 1530
1680 M=R:IF M=60 THEN H=H+1: IF M=60 THEN M=0
1690 H$=STR$(H)
1700 M$=RIGHT$(STR$(M),LEN(STR$(M))-1)
1710 IF LEN(M$)<2 THEN M$="0"+M$
1720 RETURN
1730 END
