;An example program which uses a number guessing
;game. Copyright 1988 by Mel Patrick
;Filename - GUESS1/ASM
;
	ORG	3000H		;starting point of program
	GET	MASTER/SVC	;all the @SVC codes (EQUates)
delay	EQU	12000		;delay time for blink
scrbuf	EQU	0F800H		;video memory location
;
begin	LD	A,@cls		;clear video first
	RST	svc		;so we can present some instructions
	LD	HL,inst		;point to instructions to show
	CALL	disply		;and print them on the screen
retry	LD	H,10		;set row column to clear bottom
	LD	L,0		;of display
	LD	B,3		;set cursor here
	LD	A,@vdctl	;do it
	RST	svc
	LD	C,1FH		;clear to bottom of display
	LD	A,@dsp
	RST	svc		;now
	CALL	set22		;set to bottom of video
	LD	HL,ok		;message "I am thinking..."
	CALL	disply		;print it so we know what its doing
	CALL	random		;reseed the pseudo number generator
	CALL	rnd		;get a number from 1-255
	XOR	A		;remove old trys number
	LD	(trys),A	;save it
	LD	H,14		;line to print on
	LD	L,0
	LD	B,3		;move cursor to HL
	LD	A,@vdctl
	RST	svc		;we show status line here
	LD	HL,status	;then display status line
	CALL	disply		;show it
;
gloop	CALL	set22		;set cursor for row 22 on video
	LD	HL,what		;ok, WHAT IS YOUR GUESS
	CALL	disply		;get it
	LD	HL,guess	;point to guessing buffer
	LD	B,3		;maximum 3 numbers for input
	LD	A,@keyin	;do an INPUT
	RST	svc
	JP	C,todos		;on BREAK we exit to DOS Ready
	LD	A,B		;B=length we typed in, Z=just enter
	OR	A		;see if A=0
	JR	Z,gloop		;redo on null entry
	LD	HL,guess	;else point to the ASCII number
	LD	A,@decbin	;convert to BINARY to check our number
	RST	svc		;number comes back in BC, but we need C
	LD	A,C		;get number we entered
	LD	(input),A	;save it
	OR	A		;if it was not a number, give error
	JP	Z,range0	;go if not a number
	CP	81		;see if its within range
	JP	NC,range	;too darn high
	LD	A,(seed)	;check against our random number
	CP	C		;if SAME we guess it!
	JR	Z,right		;go if correct guess
	JR	C,toohi		;else your number was too hi, go lower
	CALL	sndlow		;play a low sound
	LD	HL,low		;else your number was TOO LOW
again	CALL	redo		;display message and blink
	LD	A,(trys)	;get the times we have tried to guess
	INC	A		;add one to total
	LD	(trys),A	;save it again
	JR	gloop		;and keep going
toohi	CALL	sndhi		;play a high sound
	LD	HL,high		;your number was TOO HIGH, try lower
	JR	again		;display msg, add 1 to trys, retry
right	CALL	slide		;make a noise
	LD	HL,hooray	;you got it
	CALL	redo		;show it on the video display!
	LD	A,(trys)	;get times it took
	LD	L,A		;move to HL to convert to DECIMAL
	LD	H,0		;hopefully you got it sooner than 255
	LD	DE,total	;point to buffer to receive number
	LD	A,@bindec	;convert binary to DECIMAL
	RST	svc
	CALL	set22		;show it here
	LD	HL,only		;only took you X tries msg
	CALL	disply
	LD	HL,quest	;want to try again?
	CALL	disply
	LD	A,@key		;wait for a key
	RST	svc
	AND	5FH		;convert to upper case
	CP	'Y'		;must be Y or abort
	JP	Z,retry		;go if yes
	CALL	melt		;dissolve the video display
	CALL	set22		;set bottom of display for screen
	LD	HL,thanks	;else thanks for playing
	CALL	disply
;
todos	LD	HL,0		;reset all ERROR codes first
	LD	A,@exit		;and exit to DOS
	RST	svc
;
range0	CALL	set22		;set cursor
	LD	HL,wayout	;not a number or a 0
	JR	rng		;and display to continue
;
range	CALL	set22		;set for our line
	LD	HL,out		;point to out of range
rng	CALL	disply		;show its out of range
	LD	A,@key		;wait for a key
	RST	svc
	JP	gloop		;no error if out of range
;
samerr	CALL	set22		;set for bottom of display
	LD	HL,ohoh		;show we already guessed than number
	JR	rng		;and continue
;
random	LD	A,R		;read a value from the REFRESH reg
	LD	(seed),A	;it will be from 0-127, store it
	RET			;and go back
;
rnd	LD	B,24		;bits to shift through
	LD	IX,seed		;point to seed byte
rndlp	LD	A,(IX)		;read in a byte
	RLA			;and we start the shifting to get number
	RLA
	RLA
	RLA
	RLA			;use shift to get number
	XOR	(IX)		;xor bit 18 and bit 23
	RLA			;result to carry flag
	RL	(IX+2)		;shift according to carry
	RL	(IX+1)		;to propagate
	RL	(IX)		;through the seed
	DJNZ	rndlp		;loop for 24 bits
	LD	A,(seed)	;this is the number we really want
	OR	A		;test for 0
	JR	Z,rnd		;redo if we ended up with a 0
	CP	81		;must be less that 81 to fit video)
	RET	C		;go back if its lower
	JR	rnd		;else do it again
;
set22	LD	H,22		;set cursor to line 22
	LD	L,0		;column 0
	LD	B,3		;for display
	LD	A,@vdctl
	RST	svc
	RET			;and then go back
;
redo	PUSH	HL		;move HI or LOW to IX
	POP	IX		;for display
	LD	H,14		;see if we already guessed this one
	LD	A,(input)	;get it
	DEC	A		;adjust for 80 column screen
	LD	L,A		;move to the column we want to check
	LD	B,1		;read char from HL position
	LD	A,@vdctl	;from the video
	RST	svc
	CP	'+'		;must be a + or we guess it already
	JR	Z,newone	;go if a new guess
	POP	AF		;else remove return address from stack
	JP	samerr		;and deliver same message
newone	LD	H,10		;starting row for display
	LD	A,(input)	;get the number you guessed
	DEC	A		;screen goes from 0-79, so we adjust
	LD	L,A		;move the column to L
redolp	LD	A,(IX)		;get character
	CP	3		;end of string?
	JR	Z,done		;go if yes
	LD	C,A		;else move for display
	LD	B,2		;display char in C at HL (row/column)
	LD	A,@vdctl	;video control
	RST	svc
	INC	H		;add 1 to row only (column the same)
	INC	IX		;point to next
	JR	redolp		;and loop til end of string
done	LD	B,5		;blink this many
done0	PUSH	BC		;save it for now
	LD	C,' '		;then we blink a graphic block
	LD	B,2		;show space first
	LD	A,@vdctl	;at HL (on +++ line)
	RST	svc
	LD	BC,delay	;delay between blinks
	LD	A,@pause
	RST	svc
	LD	C,191		;then show a graphic block
	LD	B,2		;at HL
	LD	A,@vdctl	;do it now
	RST	svc
	LD	BC,delay	;then a delay
	LD	A,@pause
	RST	svc		;so we can see blink...blink...
	POP	BC		;get back outside loop
	DJNZ	done0		;and loop til its done
	RET			;then go back
;
sndlow	LD	B,7		;LOW sound
sound	LD	A,@sound	;beep it
	RST	svc
	RET			;and go back
sndhi	LD	B,0		;HI sound
	JR	sound		;do it
slide	LD	B,8		;slide sound
	LD	C,0		;sound to play
slid	LD	A,C		;get sound
	AND	7		;mask it for 0-7
	LD	C,A
	PUSH	BC		;save count and sound
	LD	B,C		;move for sound
	LD	A,@sound
	RST	svc
	POP	BC		;get back counter
	INC	C		;add 1 to C
	DJNZ	slid		;slide tones
	RET			;and go back
;
vidin	LD	A,134		;direct video access
vidin1	OUT	(132),A
	LD	(120),A
	RET			;and go back
vidout	LD	A,135
	JR	vidin1		;and continue after restore
;
melt	CALL	vidin		;toggle in video
melt1	LD	HL,scrbuf	;point to buffer now
	LD	DE,0		;reset flag counter
	LD	BC,1920		;bytes to toggle
meltlp	LD	A,(HL)		;get a byte
	CP	' '		;look for space
	JR	Z,skip		;go if already space
	DEC	(HL)		;save it
	LD	E,1		;set flag byte
skip	INC	HL		;point to next
	DEC	BC		;minus 1 from count
	LD	A,B		;get MSB
	OR	C		;test for all done
	JR	NZ,meltlp	;loop til done
	XOR	A		;zero out a
	CP	E		;if E=A then done
	JR	NZ,melt1	;loop back if not done
	CALL	vidout		;toggle to normal
	LD	B,3		;time delay
dly	PUSH	BC
	LD	BC,0
	LD	A,@pause
	RST	svc
	POP	BC
	DJNZ	dly		;loop for awhile
	RET			;and go back now
;
disply	LD	A,(HL)		;read a character of text
	CP	3		;3=end of text
	RET	Z		;back if we have printed all chars
	LD	C,A		;else move to C for display
	LD	A,@dsp		;single byte display routine
	RST	svc
	INC	HL		;point to next char in message
	JR	disply		;always ends with a 3
;
inst	DM	'                                 GUESS/CMD',13,13
	DM	'  This simple program is a game which works on the same principle as the',13
	DM	'original BASIC game of HI/LOW. In effect this program will generate a random',13
	DM	'number between 1 and 80 and you will guess it. It will record the number of',13
	DM	'tries it takes you to guess the actual number it had and will tell you after',13
	DM	'each guess if you are HIGH or LOW in respect to the actual number. As with',13
	DM	'all programs, this is the one with the bells and whistles. As any programmer',13
	DM	'will tell you, they are never satisfied with a program.',13,13,3
;
ok	DM	'I am thinking of a number',3
what	DM	1DH,1EH,'What is your guess : ',3
high	DM	'HIGH',3
low	DM	' LOW',3
hooray	DB	191,191,191,191,3
only	DM	1DH,1EH,'It only took you '
total	DM	'.....'
	DM	' trys to get it!....',3
quest	DM	'Do you want to play again (Y/N) : ',3
out	DM	1DH,1EH,'Your number is higher than 80! Please use numbers from 1..80!  Press [ENTER]',3
wayout	DM	1DH,1EH,'Your entry does not make sense...please try again!  Press [ENTER]',3
ohoh	DM	1DH,1EH,'You already guessed that number! Enter a DIFFERENT number!   Press [ENTER]',3
thanks	DM	13,'Thanks for playing!',3
status	DM	'++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
	DM	'12345678911111111112222222222333333333344444444445555555555666666666677777777778'
	DM	'         01234567890123456789012345678901234567890123456789012345678901234567890',3
;
guess	DS	5		;buffer for number we enter to guess
seed	DB	6,0B0H,65H	;random number start seed
trys	DB	0		;trys to guess the number
input	DB	0		;number we guess
;
	END	begin		;auto execution address
