10 FG=0:
20 GOTO 2770
30 '
40 '  ******
50 '
60 '  This module computes the look Azimuth and Elevation from a specified
70 '  position on the earth to a Synchronous Satellite.
80 '
90 '  ******
100 '
110 '  Azimuth is in Y
120 '  Elevation is in EL
130 '
140 '  First compute the proper Longitude Difference
150 '
160 T = M2 - M1
170 TA = ABS(T)
180 IF TA <= 180 THEN GOTO 210
190 TS = SGN(T)
200 T = -1 * ((TS * 360) - T)
210 EP = T
220 '
230 '  Now convert Angles into Radians
240 '
250 T = T / RD:L1 = L1 / RD:EP = EP / RD
260 '
270 '  Now compute MODIFIED receiver latitude
280 '
290 X = SQR (1 - .5 * (COS(L1) + COS(EP)))
300 ML = 2 * FN ARCSYN(X)
310 '
320 '  Now compute elevation look angle
330 '
340 EL = (PI / 2) - (ML + ATH(R * SIN(ML) / (R * (1 - COS(ML) * H))))
350 '
360 '  Now compute look azimuth
370 '
380 IF EP = 0 THEN YA = PI:GOTO 450
390 ZA = 1 / TAN(EP / 2)
400 ZB = TAN(L1 / 2)
410 YA = ATN(ZA * ZB) + ATN (ZA * (1 / ZB))
420 '
430 '  Now convert angles back to degrees
440 '
450 YA = YA * RD:EL = INT(EL * RD):L1 = L1 * RD
460 '
470 '  Correct look Azimuth for North/South Hemisphere
480 '
490 ZF = 360
500 IF L1 < 0 THEN GOTO 540
510 YA = 360 + YA
520 Y = FN MUD(YA)
530 RETURN
540 Y = INT(180 + YA)
550 RETURN
560 '
570 '  ******
580 '
590 '  Module to get city Name,Latitude and Longitude.
600 '
610 '  ******
620 '
630 CLS::CLS:PRINT @ (2,0),"";
640 INPUT "What is the name of the city ? ",NC$
650 PRINT @ (6,0),"";
660 INPUT "Enter the CITY Latitude using SPACES to seperate DEGREES, MINUTES,  and N(orth) or S(outh). ",DL$
670 '
680 '  Now decompose DL$ into degrees,minutes and N or S
690 '  Do degrees first
700 '
710 LE = LEN(DL$)
720 I = 1
730 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 850
740 IF (I = LE) THEN GOTO 800
750 I = I + 1:GOTO 730
760 '
770 '  Data is not in proper format
780 '  Send error message and do again
790 '
800 PRINT @ (19,0),"";:PRINT "When you enter the Latitude, be sure to use spaces to seperate the entries. ":PRINT @ (23,26),"";:INPUT"Press any key to continue!",KB$
810 PRINT @ (6,0),"";:CLS:GOTO 660
820 '
830 '  Get degrees
840 '
850 J = I - 1
860 DG = VAL(MID$(DL$,1,J))
870 '
880 '  Now look for minutes
890 '
900 MN = 0:KK = 0
910 I = I + 1
920 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 980
930 IF (I = LE) THEN GOTO 800
940 I = I + 1:KK = 1:GOTO 920
950 '
960 '  Get minutes
970 '
980 JK = I - 1
990 IF KK <> 0 THEN MN = VAL(MID$(DL$,J + 1,JK))
1000 '
1010 '  Degrees between 0-90 and minutes between 0-60?
1020 '
1030 IF NOT (DG > 90 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 1120
1040 '
1050 '  Deg,min between correct limits
1060 '
1070 PRINT @ (19,0),"";:PRINT "Degrees are between 0 and 90 and Minutes are between 0 and 60.":INPUT "Any key to continue ";K$
1080 CLS:PRINT @ (6,0),"";:GOTO 660
1090 '
1100 '  Convert to decimal
1110 '
1120 L1 = DG + (MN / 60)
1130 '
1140 '  N or S?
1150 '
1160 I = I + 1
1170 NS$ = MID$(DL$,I,1)
1180 IF NS$ = "N" OR NS$ = "n" OR NS$ = "S" OR NS$ = "s" THEN GOTO 1270
1190 '
1200 '  Must be North or South
1210 '
1220 PRINT @ (19,0),"";:INPUT "Enter either N for North or S for South. Any key to continue. ";K$
1230 CLS:PRINT @ (6,0),"";:GOTO 660
1240 '
1250 '  Put in correct sigh for latitude
1260 '
1270 IF NS$ = "S" OR NS$ = "s" THEN L1 = -L1
1280 '
1290 '  Now get city longitude
1300 '
1310 PRINT @ (10,0),"";
1320 INPUT "Enter the city longitude  using SPACES to seperate DEGREES, MINUTES, and E(ast) or W(est). ",DL$
1330 '
1340 '  Now decompose Dl$ into degrees, minutes and E or W
1350 '  Do degrees first
1360 '
1370 LE = LEN(DL$)
1380 I = 1
1390 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 1510
1400 IF (I = LE) THEN GOTO 1460
1410 I = I + 1:GOTO 1390
1420 '
1430 '  Data is not in proper format
1440 '  Send error message and do again
1450 '
1460 PRINT @ (19,0),"";:PRINT"When you enter the longitude, be sure to use spaces to seperate the entries. ":PRINT @ (23,26),"";:INPUT"Press any key to continue!",KB$
1470 CLS;PRINT @ (10,0),"";:GOTO 1310
1480 '
1490 '  Get degrees
1500 '
1510 J = I - 1
1520 DG = VAL(MID$(DL$,1,J))
1530 '
1540 '  Now look for minutes
1550 '
1560 MN = 0:KK = 0
1570 I = I + 1
1580 IF MID$(DL$,I,1) = CHR$(32) THEN GOTO 1640
1590 IF (I = LE) THEN GOTO 1460
1600 I = I + 1:KK = 1:GOTO 1580
1610 '
1620 '  Get minutes
1630 '
1640 JK = I - 1
1650 IF KK <> 0 THEN MN = VAL(MID$(DL$,J + 1,JK))
1660 '
1670 '  Degrees between 0-180 and minutes between 0-60?
1680 '
1690 IF NOT (DG > 180 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 1780
1700 '
1710 '  Deg,min between correct limits
1720 '
1730 PRINT @ (19,0),"";:PRINT"Degrees are between 0 and 180 and Minutes are between 0 and 60.";:INPUT K$
1740 CLS:PRINT @ (10,0),"";:GOTO 1310
1750 '
1760 '  Convert to decimal
1770 '
1780 M1 = DG + (MN / 60)
1790 '
1800 '  E or W
1810 '
1820 I = I + 1
1830 EW$ = MID$(DL$,I,1)
1840 IF EW$ = "E" OR EW$ = "e" OR EW$ = "W" OR EW$ = "w" THEN GOTO 1930
1850 '
1860 '  Must be East or West
1870 '
1880 PRINT @ (19,0),"";:PRINT"Enter either E(ast) or W(est). ":INPUT"Any key to continue ";K$
1890 CLS:PRINT @ (10,0),"";:GOTO 1310
1900 '
1910 '  Put in correct sign for longitude
1920 '
1930 IF EW$ = "W" OR EW$ = "w" THEN M1 = -M1
1940 RETURN
1950 '
1960 '  ******
1970 '
1980 '  Module to get satellite name and longitude.
1990 '
2000 '  ******
2010 '
2020 CLS:PRINT @ (2,0),"";
2030 INPUT"What is the name of the satellite ? ",NS$
2040 PRINT @ (4,0),"";
2050 INPUT "Enter the Satellite longitude using SPACES to seperate DEGREES, MINUTES, and    E(ast) or W(est). ",SL$
2060 '
2070 '  Now decompose SL$ into degrees, minutes and E or W
2080 '  Do degrees first
2090 '
2100 LE = LEN(SL$)
2110 I = 1
2120 IF MID$(SL$,I,1) = CHR$(32) THEN GOTO 2240
2130 IF (I = LE) THEN GOTO 2190
2140 I = I + 1:GOTO 2120
2150 '
2160 '  Data is not in proper format
2170 '  Give error message and do again
2180 '
2190 PRINT @ (19,0),"";:PRINT"When you enter the longitude, be sure to use SPACES to seperate the entries. ":PRINT @ (23,26),"";:INPUT"Press Any key to continue!",KB$
2200 CLS:PRINT @ (10,0),"";:GOTO 1310
2210 '
2220 '  Get degrees
2230 '
2240 J = I - 1
2250 DG = VAL(MID$(SL$,1,J))
2260 '
2270 '  Now look for minutes
2280 '
2290 MN = 0:KK = 0
2300 I = I + 1
2310 IF MID$(SL$,I,1) = CHR$(32) THEN GOTO 2370
2320 IF (I = LE) THEN GOTO 2060
2330 I = I + 1:KK = 1:GOTO 2310
2340 '
2350 '  Get minutes
2360 '
2370 JK = I - 1
2380 IF KK <> 0 THEN MN = VAL(MID$(SL$,J + 1,JK))
2390 '
2400 '  Degrees between 0-180 and minutes between 0-60?
2410 '
2420 IF NOT (DG > 180 OR DG < 0 OR MN > 60 OR MN < 0) THEN GOTO 2510
2430 '
2440 '  Deg,min between correct limits
2450 '
2460 PRINT @ (19,0),"";:PRINT "Degrees are between 0 and 180 and minutes are between 0 and 60. ":INPUT "any key to continue ";K$
2470 CLS:PRINT @ (4,0),"";:GOTO 2050
2480 '
2490 '  Convert to decimal
2500 '
2510 M2 = DG + (MN / 60)
2520 '
2530 '  E or W
2540 '
2550 I = I + 1
2560 EW$ = MID$(SL$,I,1)
2570 IF EW$ = "E" OR EW$ = "e" OR EW$ = "W" OR EW$ = "w" THEN GOTO 2660
2580 '
2590 '  Must be east or west
2600 '
2610 PRINT @ (19,0),"";:PRINT "Enter either E(ast) or W(est). ":INPUT "Any key to continue ";K$
2620 CLS:PRINT @ (10,0),"";:GOTO 1310
2630 '
2640 '  Put in correct sign for longitude
2650 '
2660 IF EW$ = "W" OR EW$ = "w" THEN M2 = -M2
2670 RETURN
2680 '
2690 '  ******
2700 '
2710 '  Header module
2720 '
2730 '  ******
2740 '
2750 '  This module does the header and gives instructions as needed
2760 '
2770 :CLS
2780 PRINT @ (9,19),"";::PRINT"Geosynchronous Communications Satellite"::
2790 PRINT @ (12,26),"";:PRINT "Look Angle Calculator"
2800 FOR I = 1 TO 2000:NEXT I
2810 CLS:PRINT @ (0,31),"";::PRINT"G E O S A T"::
2820 PRINT @ (7,0),"";
2830 PRINT "This program will allow you to determine where you must  point your antenna to"
2840 PRINT "permit reception of signals transmitted from a Geosynchronous satellite."
2850 PRINT
2860 PRINT "If you need instructions on the operation of this program, press the <ESC> key,"
2870 PRINT "otherwise press the <RTN> key to start the program."
2880 PRINT @ (22,3),"";:PRINT"Press <ESC> to display the Instructions, or <RTN> to start the Program!";
2890 '
2900 '  What was entered?
2910 '
2920 KB$=INKEY$:IF KB$="" THEN 2920
2930 IF KB$=CHR$(27) THEN 2970 ELSE 3400
2940 '
2950 '  Give instructions
2960 '
2970 CLS:PRINT @ (0,0),"";::PRINT TAB(34)"INSTRUCTIONS"::PRINT
2980 PRINT "    Whenever  there  are  parentheses around words or groups of letters in the "
2990 PRINT "instructions, this  means  that  the items inside the parentheses are optional."
3000 PRINT "Items inside the symbols < > are required operations or entries."
3010 PRINT
3020 PRINT TAB(28)"<SP>  is the space key."
3030 PRINT TAB(28)"<RTN> is the return key."
3040 PRINT TAB(28)"<ESC> is the escape key."
3050 PRINT:PRINT "    As a part of this program, there are 2 data sets.  One consists of a number"
3060 PRINT "of satellites and their longitudes.   The other is a number of cities and their"
3070 PRINT "latitudes and longitudes. For each data set, you will be asked whether you wish"
3080 PRINT "to use the information already in the program or wish to enter new information."
3090 PRINT "If you  choose to use the information  already in the program, simply enter the"
3100 PRINT "number that corresponds to the city or satellite you desire and press the <RTN>"
3110 PRINT "key."
3120 PRINT
3130 PRINT "   If you wish to enter your own city or satellite, press any key that does not"
3140 PRINT "correspond to a city or satellite and press <RTN>.  You will then be asked sev-"
3150 PRINT "eral questiones.  For NAMES OF SATELITES,  enter whatever you wish.  Use spaces"
3160 PRINT "and not commas as seperators if needed."
3170 PRINT:PRINT TAB(28)"Press <RTN> to continue!";
3180 KB$=INKEY$:IF KB$="" THEN 3180
3190 CLS:PRINT @ (0,0),"";::PRINT TAB(34)"INSTRUCTIONS"::PRINT
3200 PRINT "    When LATITUDE information is requested, enter the data in the format:"
3210 PRINT:PRINT TAB(22)"DEGREES <SP> MINUTES <SP> N or S <RTN>"
3220 PRINT:PRINT "N(orth) or S(outh) must be enter,  but if you wish to skip the DEGREE or MINUTE"
3230 PRINT "entry just enter a space instead of the number.  Complete the entry by pressing"
3240 PRINT "<RTN>.  The same format is used for LONGITUDE data.  Just replace  N or S  with"
3250 PRINT "E(ast) or W(est)."
3260 PRINT:PRINT"   If the Elevation prints as `***', the satellite is below the horizon and is"
3270 PRINT "not in the `line of sight' of your installation."
3280 PRINT @ (22,4),"";:PRINT"Press <ESC> to re-display the Instructions, <RTN> to start the Program!";
3290 KB$=INKEY$:IF KB$="" THEN 3290
3300 IF KB$ <> CHR$(27) THEN 3320 ELSE 2970
3310 '
3320 '  ******
3330 '
3340 '  Initialization module
3350 '
3360 '  ******
3370 '
3380 '  Some constants
3390 '
3400 CLS:PRINT @ (0,0),"";:R=6378:H=35500!:PI=3.14159
3410 RD=360/(2*PI)
3420 '
3430 '  Arcsin defination
3440 '
3450 DEF FN ARCSYN(X)=ATN(X/SQR(-X*X+1))
3460 '
3470 '  Modulus definition
3480 '
3490 DEF FN MUD(Z)=INT((Z/ZF-INT(Z/ZF))*ZF+.05)*SGN(Z/ZF)
3500 '
3510 '  Read in the satellite parameters
3520 '
3530 RESTORE
3540 '
3550 '  N is the number or satellites in the lins
3560 '
3570 READ N
3580 '
3590 '  SN$( is name array and SN( is longitude array
3600 '
3610 IF FG=1 THEN GOTO 3660
3620 DIM SN$(N),SN(N),DS$(N),DS(N),P$(24),S%(2)
3630 '
3640 '  P$( is printer buffer
3650 '
3660 FOR I=1 TO N
3670 READ SN$(I)
3680 READ SN(I)
3690 NEXT I
3700 SN(0)=N
3710 '
3720 '  A( is look azimuth array and E( is look elevation array
3730 '
3740 IF FG=1 THEN GOTO 3790
3750 DIM A(N),E(N)
3760 '
3770 '  Read in city parameters, m is number of cities
3780 '
3790 READ M
3800 '
3810 '  Cn$( is city name array, CL( is city latitude array
3820 '  CM( is city longitude array
3830 '
3840 IF FG=1 THEN GOTO 3860
3850 DIM CN$(M),CL(M),CM(M)
3860 FOR I=1 TO M
3870 READ CN$(I)
3880 READ CL(I)
3890 READ CM(I)
3900 NEXT I
3910 CL(0)=M
3920 '
3930 '  ******
3940 '
3950 '  This module gives the city list along with the option of choosing one
3960 '  of the stored cities or entering a new one
3970 '
3980 '  ******
3990 '
4000 CLS:PRINT @ (0,0),"";
4010 PRINT "These cities are available:":PRINT @ (4,0),"";
4020 '
4030 '  Get number of cities. If >30 then truncate.
4040 '
4050 M=CL(0)
4060 IF M>30 THEN M=30
4070 '
4080 '  Determine number of rows of dual column printing needed
4090 '
4100 M1=M/2:M2=INT(M1):MP=M1-M2
4110 '
4120 '  Default tab offset positions
4130 '
4140 HL=11:HR=51
4150 FOR I=1 TO M2
4160 J=I+M2
4170 '
4180 '  If MP=0 there will be 2 columns on each row.  Otherwise there will be
4190 '  an extra row.
4200 '
4210 IF MP<>0 THEN J=J+1
4220 '
4230 '  Gosub determines the number of digits in I,J
4240 '
4250 GOSUB 6350
4260 PRINT TAB(HL-H1);I;TAB(HL+2);CN$(I);TAB(HR-H2);J;TAB(HR+2);CN$(J)
4270 NEXT I
4280 IF MP<>0 THEN GOSUB 6350:PRINT TAB(HL-H1);I;TAB(HL+2);CN$(I)
4290 '
4300 '  Get choice of city.  only one at a time!!!
4310 '
4320 PRINT @ (20,0),"";:PRINT "Enter your choice by indicating:":PRINT
4330 PRINT "      A number between 1 and";M;:INPUT ", or press any other key for a new city! ",KB$
4340 '
4350 '  What is KB$
4360 '
4370 CK=VAL(KB$)
4380 IF CK<1 OR CK>M THEN GOSUB 630:CK=M+1
4390 '
4400 '  Now do satellite
4410 '
4420 '  ******
4430 '
4440 '  This module gives the satellite list along with the option of using
4450 '  all the stored names or entering a new one
4460 '
4470 '  ******
4480 '
4490 CLS:PRINT @ (1,0),"";:PRINT "These satellites are available:":PRINT @ (4,0),"";
4500 '
4510 '  Get number of satellites.  If >30 then truncate
4520 '
4530 N=SN(0)
4540 IF N>30 THEN N=30
4550 '
4560 '  Determine number of dual column printings needed
4570 '
4580 N1=N/2:N2=INT(N1):NP=N1-N2
4590 '
4600 '  Default tab offset positions
4610 '
4620 HL=11:HR=51
4630 FOR I=1 TO N2
4640 J=I+N2
4650 '
4660 '  If NP=0 then there will be 2 columns for each row.  Otherwise, an
4670 '  extra row is needed
4680 '
4690 IF NP<> 0 THEN J=J+1
4700 '
4710 '  Gosub determines the number of digits in I,J
4720 '
4730 GOSUB 6350
4740 PRINT TAB(HL-H1);I;TAB(HL+2);SN$(I);TAB(HR-H2);J;TAB(HR+2);SN$(J)
4750 NEXT I
4760 IF NP<>0 THEN GOSUB 6350:PRINT (HL-H1);I;TAB(HL+2);SN$(I)
4770 '
4780 '  Now get choice of which satellite(s) to use
4790 '
4800 PRINT @ (19,0),"";:PRINT "Enter your choice by indicating:":PRINT
4810 PRINT "A number between 1 and";N;:INPUT ", Zero(0) for all, or any other key to enter the name of a new Satellite! ",KB$
4820 '
4830 '  What is KB$
4840 '
4850 SQ=ASC(KB$)
4860 SK=VAL(KB$)
4870 '
4880 '  Go get a new satellite?
4890 '
4900 IF SK=0 AND (SQ<48 OR SQ>57) THEN GOSUB 2020:SK=N+1
4910 '
4920 '  ******
4930 '
4940 '  Setup City, Satellite parameters prior to AZ,EL Calculation
4950 '
4960 '  ******
4970 '
4980 '  Do city first
4990 '
5000 IF CK>M THEN DC$=NC$
5010 IF CK<=M THEN DC$=CN$(CK):L1=CL(CK):M1=CM(CK)
5020 '
5030 '  Do satellite.  First setup default name array
5040 '
5050 N=SN(0)
5060 FOR I=0 TO N
5070 DS$(I)=SN$(I)
5080 DS(I)=SN(I)
5090 NEXT I
5100 '
5110 '  If sk=0 use all
5120 '
5130 IF SK=0 THEN GOTO 5270
5140 '
5150 '  Distinguish between sk=1,n and sk>n
5160 '
5170 DS(0)=1
5180 IF SK>N THEN GOTO 5220
5190 DS$(1)=DS$(SK)
5200 DS(1)=DS(SK)
5210 GOTO 5270
5220 DS$(1)=NS$
5230 DS(1)=M2
5240 '
5250 '  Now do AZ,EL Calculation
5260 '
5270 MX=DS(0)
5280 FOR I=1 TO MX
5290 M2=DS(I)
5300 GOSUB 160
5310 A(I)=Y:E(I)=EL
5320 NEXT I
5330 '
5340 '  ******
5350 '
5360 '  This module does the screen display of the calculations results
5370 '
5380 '  ******
5390 '
5400 '  Some defaults:  lines/page;start line;stop line;AZ,EL tabs
5410 '
5420 LP=15:ST=1:SP=LP:HL=50:HR=60
5430 '
5440 '  Determine number of display pages
5450 '
5460 Z1=INT(N/15)
5470 ZP=Z1+1
5480 '
5490 '  Display page loop
5500 '
5510 FOR ZQ=1 TO ZP
5520 GOSUB 5850
5530 PRINT @ (7,0),"";
5540 IF DS(0)<SP THEN SP=DS(0)
5550 FOR ZR=ST TO SP
5560 I=A(ZR):J=E(ZR)
5570 GOSUB 6350
5580 PRINT TAB(22);DS$(ZR);TAB(HL-H1);I;:IF J >-0 THEN PRINT TAB(HR-H2);J:GOTO 5600
5590 PRINT TAB(HR-2)"***"
5600 NEXT ZR
5610 PRINT @ (23,18),"";:INPUT"Press <RTN> to continue or <CTRL><:> to print screen ",KB$
5620 '
5630 '
5640 '
5650 ST=SP+1:SP=SP+LP:CLS
5660 NEXT ZQ
5670 '
5680 '  Do another set?
5690 '
5700 PRINT @ (23,7),"";
5710 PRINT "Press <RTN> to run the program again, or <ESC> to exit to Basic.";
5720 KB$ = INKEY$:IF KB$ = "" THEN 5720
5730 IF KB$=CHR$(13) THEN FG=1:GOTO 3400
5740 IF KB$=CHR$(27) THEN GOTO 5760
5750 GOTO 5700
5760 CLS:PRINT @ (0,0),"";:END
5770 END
5780 '
5790 '  ******
5800 '
5810 '  Header subroutine
5820 '
5830 '  ******
5840 '
5850 CLS:PRINT @ (0,22),"";::PRINT "G E O - S A T E L L I T E   `Look  Angle'"::
5860 PRINT @ (2,9),"";:PRINT "From: ";DC$
5870 PRINT @ (4,50),"";:PRINT "Antenna"
5880 PRINT TAB(24);"To";TAB(46);"Azimuth";TAB(55);"Elevation"
5890 RETURN
5900 '
5910 '  ******
5920 '
5930 '  Data statements
5940 '
5950 '  ******
5960 '
5970 DATA 12
5980 DATA Comstar 3,-87
5990 DATA Westar 3,-91
6000 DATA Comstar 2,-95
6010 DATA Westar 1,-99
6020 DATA Anik 1,-104
6030 DATA Anik 2,-109
6040 DATA Anik 3,-114
6050 DATA Satcom 2,-119
6060 DATA Westar 2,-123.5
6070 DATA Comstar 1,-128
6080 DATA Satcom 3,-132
6090 DATA Satcom 1,-135
6100 DATA 17
6110 DATA Washington D.C.,39,-77
6120 DATA Los Angeles Cal.,34,-118
6130 DATA New York NY.,40.75,-74
6140 DATA Atlanta Ga.,33.5,-84.5
6150 DATA Miami Fl.,25.75,-80.25
6160 DATA Jacksonville Fl.,30.5,-81.5
6170 DATA Tampa Fl.,28,-82.75
6180 DATA Anchorage Al.,60.8,-147
6190 DATA Nome Al.,65,-165
6200 DATA Phoenix Arz.,33.5,-112
6210 DATA Little Rock Ark.,34.75,-92.25
6220 DATA Portland Ore,45.5,-122.75
6230 DATA Seattle Wash.,47.5,-122.5
6240 DATA San Francisco Cal.,37.75,-122.5
6250 DATA Chicago Ill.,41.75,-87.75
6260 DATA Milwaukee Wisc.,43,-87.9
6270 DATA San Diego Cal.,32.65,-117.3
6280 '
6290 '  ******
6300 '
6310 '  Tab positioning Routine
6320 '
6330 '  ******
6340 '
6350 H1=3:H2=3
6360 IF I<100 THEN H1=2
6370 IF I<10 THEN H1=1
6380 IF J<100 THEN H2=2
6390 IF J<10 THEN H2=1
6400 RETURN
6410 '
6420 '  ******
6430 '
6440 '  Printer routine
6450 '
6460 '  ******
6470 '
6480 '
