;------------------------------------------------------
; FIND -- Program to search a text file for a string
;         When the string is found, the line will be
;         displayed to the screen
;  Syntax:  FIND FILENAME "STRING"
;------------------------------------------------------
*LIST OFF
*GET MACLIB/ASM:1
*LIST ON
;------------------------------------------------------
	DEFINE	CR,0DH
	DEFINE	LF,0AH
	DEFINE	TAB,09H
	DEFINE	SPC,20H
;------------------------------------------------------
;  First check the command line for a file name
;    If not there abort with syntax message
;------------------------------------------------------
	ORG	3000H
FIND	LD	DE,FNAME	;DE=> buf for file name
FLOOP	LD	A,(HL)		;Get first char. cmd ln
	CP	CR		;Carriage return?
	JP	Z,SYNEXT	;yes--go
	CP	SPC		;Space=end of file name?
	JR	Z,FLPEND	;yes--go
	EX	DE,HL		;HL=>file name buff.
	LD	(HL),A		;Store character
	EX	DE,HL		;HL=>cmd line
	INC	DE		;Bump pointer
	INC	HL
	JR	FLOOP		;LOOP FOR NEXT CHARACTER
FLPEND	EX	DE,HL		;HL=> next buffer location
	LD	(HL),0
	EX	DE,HL		;HL=>cmd line
	DEC	HL		;Backspace one character
SKIPSP	INC	HL		;Point to next char cmdl
	LD	A,(HL)		;Get next character
	CP	' '		;Is is another sp?
	JR	Z,SKIPSP	;Yes, loop for next
	CP	'"'		;Is it "?
	JP	NZ,QUTEXT	;If not exit with err
	INC	HL		;Skip past "
	LD	A,(HL)		;Get next character
	CP	'"'		;No sub str. exit prog.
	JP	Z,QUTEXT
	LD	DE,SUBSTR	;DE==>Store substr addr
	LD	C,00H		;Zero counter
SLOOP	EX	DE,HL		;HL=>substring buffer
	LD	(HL),A		;Save char
	EX	DE,HL		;Get ready for next char
				;HL==>cmd line
	INC	DE		;Bump pointers
	INC	HL
	INC	C		;Count=count+1
	LD	A,(HL)		;Get next char.
	CP	'"'		;Is it closing Quote?
	JR	Z,PROCESS	;Yes go to process
	CP	CR		;Is it end of line?
	JR	Z,PROCESS	;yes--goto process
	JR	SLOOP		;Loop again
PROCESS LD	A,C		;Prepare to save counter
	LD	(SUBLEN),A	;Save len of sub string
	@@FSPEC	FNAME,FCB1
	JP	NZ,FEREXT
	@@OPEN	FBUFFER
	LD	DE,FCB1
PLOOP	LD	HL,LBUFFER
	LD	B,80		;Max screen line length
	CALL	LINEIN		;Read a line from file
	JR	Z,SEARCH	;Okay--go and search
	IFEQ_JR	1CH,PEXIT	;If EOF okay to go
	@@ERROR	A		;Else report error and quit
SEARCH	PUSH	DE		;Save FCB1 addrs.
      	LD	A,(SUBLEN)	;LD C WITH SUBSTRING LEN
	LD	C,A
	LD	HL,LBUFFER
	LD	DE,SUBSTR
	CALL	INSTR
	POP	DE		;Restore FCB1 addrs.
	IFEQ_JR 0,PLOOP		;Index returned in A
	@@DSPLY	LBUFFER		;Display line if found
	JR	PLOOP		;Get next line
FEREXT  @@DSPLY FNAMER
	@@EXIT
SYNEXT	@@DSPLY	SYNERR		;Display error msg
	@@EXIT
QUTEXT	@@DSPLY QUTMSG
	@@EXIT
PEXIT	@@CLOSE	FCB1
	@@EXIT
;------------------------------------------------------
; LINEIN
;	Read a line of input from an open file or device
;	Line is placed in a buffer and is not echoed to
;	the screen or printer
;
; ENTRY:	DE==>Open FCB or DCB
; 		HL==>Buffer to receive line (length B+1)
;		B ==>Maximum line length.
;
; RETURN:	Success, Z flag set
;		HL==>start of buffer (CR-terminated)
;		B == actual number of characters input
;		     including CR
;		Failure, NZ flag set
;		A = Error number
;
; MACROS:  DEFINE, @@GET, IFEQ_JR, IFLT_JR, SVC
;
; Routine alters C register
;
;------------------------------------------------------
LINEIN	PUSH	HL		;Save beginning of buff
	LD	C,0		;to count characters
*MOD
;------------------------------------------------------
;  Loop to pick up characters
;------------------------------------------------------
LOOP?	@@GET	FCB1
	JR	Z,NOERR?	;Go if no error reported
	IFEQ_JR	0,ERROR?	;Go if no character avail.
NOERR?	IFEQ_JR	TAB,SAVTAB?	;Keep Tab in line
	IFEQ_JR	CR,END?		;Keep CR in line
	IFEQ_JR	LF,END?		;and linefeed also
	IFLT_JR	' ',EOF?	;Go if not ASCII
;
SAVCHR?	LD	(HL),A		;Put char. in buff.
	INC	HL		;point to next space
	INC	C		;Add to count
	DJNZ	LOOP?		;Get next character
;
SAVTAB?	LD	A,' '		;Replace tab with sp
	JR	SAVCHR?		;Go to save char.
;
END?	LD	B,C		;Get count of char. saved
	INC	B		;Count terminating CR
	LD	(HL),CR		;Terminate string
	POP	HL		;Recover pointer
	XOR	A		;Set Z flag
	JR	OUT?		;and leave
;
EOF?	LD	A,C		;Get count
	OR	A		;Were any char. saved?
	JR	NZ,END?		;Yes -- normal end
	LD	A,1CH		;Else show EOF error
	OR	A
;
ERROR?	POP	HL		;Clear stack
	LD	B,0		;No valid characters
;
OUT?	RET
;------------------------------------------------------
;INSTR/ASM--Program to imitate BASIC's INSTR( function
;
;Purpose:  Search for the first occurrence of a substring
;	   within a string and return its starting index.
;	   If the substring is not found a 0 is returned.
;
; Entry:    Register pair HL = base address of string
;	    Register pair DE = base address of substring
;	    B contains length of string,
;	    C contains length of sub string
;
;	    A string is a maximum of 255 bytes long
;
; Exit:     If the substring is found the Register
;		 A = its starting index.
;	    Else
;		register A = 0
;
; Registers used:  AF,BC,DE,HL
;
;------------------------------------------------------
;
;Set up temporaries and exit if string or substring
;has zero length
INSTR	@@DEBUG	@@2,'BEGINING OF INSTR'
	DEC	HL		;Position one before string
	LD	(STRING),HL	;Save string address
	EX	DE,HL
	LD	(SUBSTG),HL
	LD	A,C		;Get length of substring
	OR	A
	JR	Z,NOTFND	;Exit if length of substring=0
	LD	(SUBLEN),A	;Save substring length
	LD	A,B		;Get length of string
	OR	A
	JR	Z,NOTFND	;Exit if length of string=0
	LD	(SLEN),A	;Save string length
;
; Number of searches = string length - substring length
; + 1.  After that, no use searching since there aren't
; enough characters left to hold substring
;
; If substring is longer than string, exit immediately and
; indicate substring not found
;
	SUB	C		;A=string length - substring length
	JR	C,NOTFND	;Exit if string shorter than substring
	INC	A		;Count = difference in lengths + 1
	LD	B,A
	SUB	A		;Initial starting index = 0
	LD	(INDEX),A
;
;	Search until remaining string shorter than substring
;
SLP1	LD	HL,INDEX	;Increment starting index
	INC	(HL)
	LD	HL,SUBLEN	;C = length of substring
	LD	C,(HL)
	LD	HL,(STRING)	;Increment to next byte of string
	INC	HL
	LD	(STRING),HL	;HL = next address in string
	LD	DE,(SUBSTG)	;DE = starting address of substring
				;C = current value of count
;
;	Try to match substring starting at index.  Match involves
;	comparing correspoinding characters one at a time
;
CMPLP	LD	A,(DE)		;Get a character of substring
	CP	(HL)		;Compare to character of string
	JR	NZ,SLP2		;Jump if not same
	DEC	C
	JR	Z,FOUND		;Jump if substring found
	INC	HL
	INC	DE
	JR	CMPLP
;
;	Arrive here if match fails, substring not yet found
;
SLP2	DJNZ	SLP1		;Try next higher index if enough
				;string left
	JR	NOTFND		;Else exit not found
;
; 	found substring, return its starting index
;
FOUND	LD	A,(INDEX)	;Substring found, A = starting index
	RET
;
;	Could not find substring, return 0 as index
;
NOTFND	SUB	A		;Substring not found, A = 0
	RET
;
;------------------------------------------------------
FNAME	DS	25		;len filename + marker
FCB1	DS	32
FBUFFER	DS	256
LBUFFER	DS	81
SUBSTR	DS	80
SYNERR	DB	'Syntax is FIND FILENAME "String to look for"',CR
QUTMSG	DB	'Use quotation marks around search string',CR
FNAMER	DB	'Invalid file name error',CR
STRING	DW	0000H		;Base address of string
SUBSTG	DW	0000H		;Base address of substring
SLEN	DB	00H		;Length of string
SUBLEN	DB	00H		;length of substring
INDEX	DB	00H		;Current index into string
;
;------------------------------------------------------
	END	FIND
