;------------------------------------------------------
;	BOOTDLY/ASM -- Program to delay command
;	execution
;
;	programmed by Aaron O'Neill
;	last revised, 07/04/92
;	released to public domain
;
;------------------------------------------------------
;	Macro commands and definitions
;------
ETX	EQU	03H
CR	EQU	0DH
LF	EQU	0AH
;
@CMNDI	EQU	18H
@DSP	EQU	02H
@DSPLY	EQU	0AH
@ERROR	EQU	1AH
@EXIT	EQU	16H
@HEXDEC	EQU	61H
@KBD	EQU	08H
@PARAM	EQU	11H
@PAUSE	EQU	10H
@VDCTL	EQU	0FH
;
;------
;	Invoke a TRSDOS 6 SVC.  If "CHECK" is specified,
;	exit through @ERROR if NZ flag is returned from
;	TRSDOS
;------
SVC	MACRO	#NUM,#CHECK
	LD	A,#NUM		;A = SVC number
	RST	28H		;Perform SVC
	IFGT	%%,1		;More than one argument?
	  JP	NZ,ERR_EXT	;Go, if error
	ENDIF
	ENDM
;
	ORG	3000H		;start above dos
;
START:	PUSH	HL		;save cmd line tail pointer
	LD	HL,SIGNON	;show opening message
	SVC	@DSPLY,CHECK
	POP	HL		;p/u cmd line tail
	LD	A,(HL)		;p/u possible param to parse
	CP	'('		;is it a paranthesis?
	JR	NZ,START1	;no go do comand using defaults
	LD	DE,PARAM_TBL	;parse parameters if any
	SVC	@PARAM,CHECK
	LD	A,(CMD_RES)	;see if cmd changed
	AND	00111111B	;mask off unnecessary flags
	JR	Z,START1	;no entry, or invalid param, go do defaults
	AND	00011111B	;Get len of entry
	JR	NZ,START1C	;has len < 31, go do command
	LD	HL,(CMD_VEC)	;else p/u addr of command
	LD	A,'"'
	CP	(HL)		;Ck for ", if so, null entry
	JR	Z,START1	;go on null entry, use default
START1C	LD	DE,CMD		;place to move new command
	LD	HL,(CMD_VEC)	;HL=>vector to new command
START1B	LD	A,(HL)		;p/u char
	CP	'"'
	JR	Z,START1A
	LD	(DE),A		;save char
	INC	HL		;bump pointers
	INC	DE
	JR	START1B		;and loop to end of command
START1A	LD	A,CR		;mark end of command
	LD	(DE),A
START1	LD	BC,-1		;Default is ON
VERBOSE	EQU	$-2		;show verbose list of commands
	LD	A,B		;test flag
	OR	C
	JR	Z,START2	;verbose flag off, skip showing commands
	LD	HL,SHOWCMD
	SVC	@DSPLY,CHECK	;display possible commands
	LD	A,LF		;skip down a line
	LD	C,A
	SVC	@DSP,CHECK
START2:	LD	HL,COMMAND
	SVC	@DSPLY,CHECK	;display command to be executed
	LD	BC,0		;p/u delay count
DEL_CNT	EQU	$-2
	LD	A,B		;test for user selected value
	OR	C
	JR	NZ,PAUSE	;yes, use parameter value else
	LD	BC,15		;set 15 second delay default
;
PAUSE:	PUSH	BC		;save delay count in BC
	LD	A,LF		;skip down a line
	LD	C,A
	SVC	@DSP,CHECK
	POP	BC		;p/u delay count in BC
PAUSELP	PUSH	BC		;save count for loop
	PUSH	BC		;save count for display
	SVC	@KBD		;ck for key press
	JR	Z,EXIT		;go exit, key pressed
	POP	HL		;p/u count to display
	LD	DE,COUNT	;buffer for hexdec call
	SVC	@HEXDEC
	LD	B,4		;get cursor pos
	SVC	@VDCTL
	LD	L,0		;Set to beginning of line
	LD	B,3		;set cursor pos
	SVC	@VDCTL
	LD	HL,COUNT$	;show new count
	SVC	@DSPLY,CHECK
	LD	BC,-1		;set pause to maximum
	SVC	@PAUSE
	POP	BC		;p/u count
	DEC	BC		;decrement count of seconds
	LD	A,B
	OR	C
	JR	Z,DOCMD
	JR	PAUSELP
;
EXIT:	LD	A,LF		;skip down a line
	LD	C,A
	SVC	@DSP,CHECK
	LD	HL,-1		;abort /jcl
	SVC	@EXIT		;quit program
;
DOCMD:	LD	HL,CMD		;hl==>command to do
	SVC	@CMNDI		;quit program to command
;
ERR_EXT:
	SET	6,A		;set short error message
	LD	C,A		;Put error code in C
	SVC	@ERROR		;exit through @ERROR
;
SIGNON	DB	LF,'BOOTDLY -- A pause utility written by Aaron O''Neill, July 4, 1992',LF
	DB	'and released to the public domain.',LF,CR
SHOWCMD	DB	'Useage:  BOOTDLY [(DELAY=###,COMMAND="execute",VERBOSE)]',LF
	DB	'Where: DELAY (abbreviated D) is the amount of time to wait',LF
	DB	'       (default is 15 seconds)',LF
	DB	'       COMMAND (abbreviated C) is the command to execute',LF
	DB	'       if no key is pressed (default is "DO = STARTUP")',LF
	DB	'       VERBOSE (abbreviated V) is a flag that suppress this'
	DB	LF,'       message (default is ON)',LF,LF
	DB	'All parameters are optional.',CR
COMMAND: DB	'The following command will execute unless a key is pressed',LF
	DB	'before Count == 0',LF,LF
CMD	DB	'DO = STARTUP',CR
	DS	66			;space for maximum command line of 80 
	DB	CR
;
COUNT$	DB	'Count =='
COUNT	DS	5
	DB	ETX
;
PARAM_TBL:
	DB	80H
	DB	10010101B	;set num ent, abrv.
	DB	'DELAY'
	DB	0
	DW	DEL_CNT
	DB	00110111B	;set string, abrv
	DB	'COMMAND'
CMD_RES	DB	0
	DW	CMD_VEC
	DB	01010111B	;set flag, abrv, 7 char long
	DB	'VERBOSE'
	DB	0
	DW	VERBOSE
	DB	0
CMD_VEC	DW	$-$
;
	END	START
