00100         TITLE  <SYSTEM ALIVE INDICATOR>
00110 ;
00120 ; ALIVE/ASM   SYSTEM ALIVE INDICATOR
00130 ;             WRITTEN BY EARL C. TERWILLIGER JR.
00140 ;
00150 ;             DEMONSTRATES  :
00160 ;                             PROGRAM RE-LOCATION
00170 ;                             ADDITION OF A TCB
00180 ;                             COMMAND BUFFER PARSE
00190 ;
00200         ORG    9000H         ;PROGRAM ORIGIN
00210 @ADTSK  EQU    4410H         ;TCB ADD ROUTINE
00220 @RPTSK  EQU    4416H         ;TCB REPLACE ROUTINE
00230 @RMTSK  EQU    4413H         ;TCB DELETE ROUTINE
00240 HIGH$   EQU    4049H         ;HIGH MEMORY POINTER
00250 @PARAM  EQU    4476H         ;COMMAND BUFFER PARSE
00260 DOS     EQU    402DH         ;LDOS RETURN ADDRESS
00270 DISP    EQU    033H          ;DISPLAY BYTE ON VIDEO
00280 START   EQU    $             ;START ADDRESS OF ALIVE
00290         LD     DE,TABLE      ;PARAMETER TABLE ADDRESS
00300         CALL   @PARAM        ;PARSE COMMAND BUFFER
00310         JP     Z,PARMOK      ;PARSE WAS SUCCESSFUL;
00320         JP     DOS           ;PARSE HAD TROUBLES
00330 PARMOK  EQU    $
00340         LD     HL,0000H      ;ADDR REPLACED BY PARSE
00350         LD     A,L           ;TEST FOR ON
00360         OR     H
00370         JR     NZ,TASKON     ;PARSE SAID ON
00380 PARMOF  EQU    $
00390         LD     HL,0000H      ;ADDR REPLACED BY PARSE
00400         LD     A,L           ;TEST FOR OFF
00410         OR     H
00420         JR     Z,PERROR      ;PARM ERROR
00430         LD     A,0           ;TCB SLOT ==> 0
00440         CALL   @RMTSK        ;REMOVE TCB
00450         JP     DOS           ;RETURN TO LAND OF OS
00460 PERROR  EQU    $
00470         LD     HL,PMSG       ;PARAMETER ERR MSG
00480 LOOP    EQU    $
00490         LD     A,(HL)        ;GET MSG BYTE
00500         OR     A             ;TEST FOR END
00510         JP     Z,DOS         ;BACK TO DOS IF END
00520         CALL   DISP          ;DISPLAY
00530         INC    HL            ;NEXT MSG BYTE
00540         JR     LOOP          ;TEST FOR END
00550 TASKON  EQU    $
00560         LD     HL,(HIGH$)    ;HIGH
00570         LD     BC,LAST-FIRST ;LENGTH OF TCB
00580         XOR    A             ;CLEAR A
00590         SBC    HL,BC         ;HL ==> LENGTH OF TCB
00600         LD     (HIGH$),HL    ;PROTECT NEW TCB
00610         INC    HL            ;POINT TO FIRST FREE BYTE
00620         PUSH   HL            ;SAVE ITS ADDRESS
00630         INC    HL            ;
00640         INC    HL            ;
00650         LD     (TCB),HL      ;SAVE ADDRESS+2 FOR TCB
00660         POP    HL            ;RESTORE ORIGINAL ADDRESS
00670         DI
00680         EX     DE,HL         ;DESTINATION FOR TCB MOVE
00690         LD     HL,FIRST      ;START OF TCB ROUTINE
00700         LDIR                 ;MOVE IT!
00710         EI
00720 BEGIN   LD     DE,(TCB)      ;TASK ADDR IN HIGH MEMORY
00730         DEC    DE            ;
00740         DEC    DE            ;TCB ADDR IN HIGH MEMORY
00750         LD     A,0           ;TCB SLOT NUMBER
00760         CALL   @ADTSK        ;ADD TCB TO CHAIN
00770         JP     DOS           ;RETURN TO MAGIC LAND
00780 FIRST   EQU    $
00790 TCB     DW     0000H
00800 TASK    CALL   @RPTSK        ;REPLACE TCB
00810         LD     A,'A'
00820         LD     (3C3BH),A
00830         CALL   @RPTSK        ;REPLACE TCB
00840         LD     A,'L'
00850         LD     (3C3CH),A
00860         CALL   @RPTSK        ;REPLACE TCB
00870         LD     A,'I'
00880         LD     (3C3DH),A
00890         CALL   @RPTSK        ;REPLACE TCB
00900         LD     A,'V'
00910         LD     (3C3EH),A
00920         CALL   @RPTSK        ;REPLACE TCB
00930         LD     A,'E'
00940         LD     (3C3FH),A
00950         CALL   @RPTSK        ;REPLACE TCB
00960         LD     A,' '
00970         LD     (3C3BH),A     ;ERASE ALIVE
00980         LD     (3C3CH),A
00990         LD     (3C3DH),A
01000         LD     (3C3EH),A
01010         LD     (3C3FH),A
01020         JR     TASK          ;START OVER
01030 LAST    EQU    $
01040 TABLE   EQU    $
01050         DEFM   'ON    '
01060         DEFW   PARMOK+1
01070         DEFM   'OFF   '
01080         DEFW   PARMOF+1
01090         NOP
01100 PMSG    DEFM   'ALIVE PARAMETER ERROR !'
01110         DEFB   00H
01120         END    START
O ERROR **":87:159: g 1,22ASDC$:DD$(,