*LIST OFF
;	TRSDOS 6.X - SYSTEM ENTRIES/EQUATES - 1.01
;	ASCII CONTROL EQUIVALENCES 
NUL	EQU	0	; FILLER
SOH	EQU	1	; START OF HEADING
STX	EQU	2	; START OF TEXT
ETX	EQU	3	; END OF TEXT
EOT	EQU	4	; END OF TRANSMISSION
ENQ	EQU	5	; ENQUIRY
ACK	EQU	6	; ACKNOWLEDGE
BEL	EQU	7	; BELL
BS	EQU	8	; BACKSPACE
HT	EQU	9	; HORIZONTAL TABULATION
LF	EQU	10	; LINE FEED
VT	EQU	11	; VERTICAL TABULATION
FF	EQU	12	; FORM FEED
CR	EQU	13	; CARRIAGE RETURN
SO	EQU	14	; SHIFT OUT
SI	EQU	15	; SHIFT IN
DLE	EQU	16	; DATA LINK ESCAPE
DC1	EQU	17	; DEVICE CONTROL 1
DC2	EQU	18	; DEVICE CONTROL 2
DC3	EQU	19	; DEVICE CONTROL 3
DC4	EQU	20	; DEVICE CONTROL 4
NAK	EQU	21	; NEGATIVE ACKNOWLEDGE
SYN	EQU	22	; SYNCHRONOUS IDLE
ETB	EQU	23	; END OF TRANSMISSION BLOCK
CAN	EQU	24	; CANCEL
EM	EQU	25	; END OF MEDIUM
SUB	EQU	26	; SUBSTITUTE
ESC	EQU	27	; ESCAPE
FS	EQU	28	; FILE SEPARATOR
GS	EQU	29	; GROUP SEPARATOR
RS	EQU	30	; RECORD SEPARATOR
US	EQU	31	; UNIT SEPARATOR
;	KEYBOARD/DISPLAY CHARS
CURON	EQU	14	; CURSOR DISPLAY ON
CUROF	EQU	15	; CURSOR DISPLAY OFF
BREAK	EQU	80H	; BREAK KEY
KEY_F1	EQU	81H	; FUNCTION KEY #1
KEY_F2	EQU	82H	; FUNCTION KEY #2
KEY_F3	EQU	83H	; FUNCTION KEY #3
;	SUPERVISOR ROUTINES
@IPL	EQU	0	; INITIAL PROGRAM LOAD
@KEY	EQU	1	; INPUT FROM KEYBOARD WITH WAIT
@DSP	EQU	2	; OUTPUT TO DISPLAY
@GET	EQU	3	; INPUT A BYTE FROM A DEVICE
@PUT	EQU	4	; OUTPUT A BYTE TO A DEVICE
@CTL	EQU	5	; OUTPUT A CONTROL BYTE
@PRT	EQU	6	; OUTPUT TO PRINTER
@WHERE	EQU	7	; RESOLVE RELOCATION ADDRESS
@KBD	EQU	8	; ACCEPT KEYBOARD INPUT
@KEYIN	EQU	9	; LINE INPUT ROUTINE
@DSPLY	EQU	10	; DISPLAY LINE HANDLER
@LOGER	EQU	11	; ISSUE A LOG MESSAGE
@LOGOT	EQU	12	; DISPLAY AND LOG A MESSAGE
@MSG	EQU	13	; MESSAGE LINE HANDLER
@PRINT	EQU	14	; PRINTER LINE HANDLER
@VDCTL	EQU	15	; DISPLAY CONTROL ROUTINE
@PAUSE	EQU	16	; SUSPEND PROGRAM EXECUTION
@PARAM	EQU	17	; SCAN OPTIONAL PARAMETERS
@DATE	EQU	18	; GET THE DATE IN DISPLAY CODE
@TIME	EQU	19	; GET THE TIME IN DISPLAY CODE
@CHNIO	EQU	20	; CHAIN CHARACTER I/O
@ABORT	EQU	21	; ABNORMAL PROGRAM EXIT
@EXIT	EQU	22	; NORMAL PROGRAM EXIT
@CMNDI	EQU	24	; EXECUTE COMMAND/@EXIT
@CMNDR	EQU	25	; EXECUTE COMMAND/RETURN
@ERROR	EQU	26	; POST AN ERROR MESSAGE
@DEBUG	EQU	27	; ENTER DEBUGGING PACKAGE
@CKTSK	EQU	28	; CHECK INTERRUPT TASK
@ADTSK	EQU	29	; ADD INTERRUPT TASK
@RMTSK	EQU	30	; REMOVE INTERRUPT TASK
@RPTSK	EQU	31	; REPLACE INTERRUPT TASK
@KLTSK	EQU	32	; KILL INTERRUPT TASK
@CKDRV	EQU	33	; CHECK DRIVE/LOC DIR
@DODIR	EQU	34	; DISPLAY FILE DIRECTORY
@RAMDIR EQU	35	; RAM/DIRECTORY ROUTINE
@DCSTAT EQU	40	; NO OPERATION (CHECK)
@SLCT	EQU	41	; SELECT DRIVE ROUTINE
@DCINIT EQU	42	; DRIVE INITIALIZATION
@DCRES	EQU	43	; CLEAR CONTROLLER
@RSTOR	EQU	44	; ISSUE FDC RESTORE CMD
@STEPI	EQU	45	; ISUE FDC STEP-IN CMD
@SEEK	EQU	46	; SEEK A CYLINDER
@RSLCT	EQU	47	; TEST DRIVE BUSY
@RDHDR	EQU	48	; READ SECTOR HEADER INFO
@RDSEC	EQU	49	; READ SECTOR COMAND
@VRSEC	EQU	50	; VERIFY IF SECTOR READABLE
@RDTRK	EQU	51	; ISSUE FDC CYL READ CMD
@HDFMT	EQU	52	; FORMAT THE DEVICE
@WRSEC	EQU	53	; WRITE A SECTOR
@WRSSC	EQU	54	; WRITE A SYSTEM SECTOR
@WRTRK	EQU	55	; ISSUE FDC CYL WRITE CMD
@RENAM	EQU	56	; RENAME DEVICE/FILE
@KILL	EQU	57	; KILL A DEVICE/FILE
@REMOV	EQU	57	; REMOVE A DEVICE/FILE(TRSDOS)
@INIT	EQU	58	; OPEN OR INITIALIZE A DEVICE/FILE
@OPEN	EQU	59	; OPEN AN EXISTING DEVICE/FILE
@CLOSE	EQU	60	; CLOSE A DEVICE/FILE
@BKSP	EQU	61	; BACKSPACE LOGICAL RECORD
@CKEOF	EQU	62	; CHECK FOR END-OF-FILE
@LOC	EQU	63	; CALC CURRENT LOGICAL RECORD NUMBER
@LOF	EQU	64	; CALC EOF LOGICAL RECORD NUMBER
@PEOF	EQU	65	; POSITION TO END-OF-FILE
@POSN	EQU	66	; POSITION TO LOGICAL RECORD
@READ	EQU	67	; READ A RECORD FROM A FILE
@REW	EQU	68	; REWIND A FILE
@RREAD	EQU	69	; FORCE A SECTOR RE-READ
@RWRIT	EQU	70	; FORCE A SECTOR RE-WRITE
@SEEKCS EQU	71	; POSITION TO DISK SECTOR
@SEEKSC EQU	71	; SEEK A SPECIFIED CYLINDER & SECTOR(TRSDOS)
@SKIP	EQU	72	; SKIP TO NEXT LOGICAL RECORD
@VER	EQU	73	; WRITE-VERIFY A RECORD TO A FILE
@WEOF	EQU	74	; WRITE AN END-OF-FILE MARK
@WRITE	EQU	75	; WRITE A RECORD TO A FILE
@LOAD	EQU	76	; LOAD A PROGRAM FILE
@RUN	EQU	77	; LOAD AND EXECUTE A PROGRAM FILE
@FSPEC	EQU	78	; FETCH A DEVICE/FILE SPECIFICATION
@FEXT	EQU	79	; SET UP A DEFAULT FILE EXTENSION
@FNAME	EQU	80	; RECOVER FILENAME/EXT
@GTDCT	EQU	81	; GET DRIVE TABLE
@GTDCB	EQU	82	; GET DEVICE BLOCK
@GTMOD	EQU	83	; GET MODULE
@RDSSC	EQU	85	; READ DIRECTORY SECTOR
@RDDIR	EQU	87	; READ DIRECTORY FOR FILE
@DIRRD	EQU	87	; READ DIRRECTORY FOR FILE(TRSDOS)
@WRDIR	EQU	88	; WRITE DIRECTORY FOR FILE
@DIRWR	EQU	88	; WRITE DIRECTORY FOR FILE(TRSDOS)
@MUL8	EQU	90	; SINGLE PRECISION MULTIPLY
@MUL16	EQU	91	; DOUBLE PRECISION MULTIPLY
@DIVD8	EQU	93	; SINGLE PRECISION DIVIDE
@DIV8	EQU	93	; SINGLE PRECISION DIVIDE(TRSDOS)
@DIVD16 EQU	94	; DOUBLE PRECISION DIVIDE
@DIV16	EQU	94	; DOUBLE PRECISION DIVIDE(TRSDOS)
@HEXD	EQU	95	; BINARY TO DECIMAL CONVERSION
@DECBIN EQU	96	; DECIMAL TO BINARY CONVERSION
@DECHEX	EQU	96	; DECIMAL TO BINARY CONVERSAION(TRSDOS)
@BINDEC EQU	97	; BINARY TO DECIMAL CONVERSION
@HEXDEC EQU	97	; BINARY TO DECIMAL CONVERSION(TRSDOS)
@HEX8	EQU	98	; BINARY TO HEX CONVERSION - 8 BIT
@HEX16	EQU	99	; BINARY TO HEX CONVERSION - 16 BIT
@HIGH	EQU	100	; FETCH/SET HIGH$ AND LOW$
@HIGH$	EQU	100	; FETCH/SET HIGH$ AND LOW$(TRSDOS)
@FLAGS	EQU	101	; FETCH SYSTEM INFO
@BANK	EQU	102	; MEMORY MANAGER
@BREAK	EQU	103	; SET BACKROUND BREAK VECTOR
@SOUND	EQU	104	; SOUND/BEEP ROUTINE
@CLS	EQU	105	; CLEAR SCREEN(TRSDOS)
@CKBRKC EQU	106	; CHECK FOR BREAK(TRSDOS)
@VDPRT	EQU	107	; SCREEN PRINT TO PRINTER
;	DOSPLUS EXTENDED SVC'S 
@DISKIO EQU	121	; GENERAL DISK I/O DRIVER
@LOCDCT EQU	122	; LOCATE DRIVE CTL TABLE
@LOCDCB EQU	123	; LOCATE DEVICE CTL BLOCK
@EVAL	EQU	124	; COMMAND LINE EVALUATION
@WILD	EQU	125	; WILD CARD PARSING
@LOCDEV EQU	126	; LOCATE DEVICE BY NAME
@SORT	EQU	127	; SORT MEMORY BLOCK
;
@SVC0	EQU	130
@SVC1	EQU	131
@SVC2	EQU	132
@SVC3	EQU	133
@SVC4	EQU	134
@SVC5	EQU	135
@SVC6	EQU	136
@SVC7	EQU	137
@SVC8	EQU	138
@SVC9	EQU	139
@SVC10	EQU	140
@SVC11	EQU	141
@SVC12	EQU	142
@SVC13	EQU	143
;
;
;	FLAGS
AFLAG	EQU	0
BFLAG	EQU	1
CFLAG	EQU	2
DFLAG	EQU	3
EFLAG	EQU	4
FFLAG	EQU	5
GFLAG	EQU	6
HFLAG	EQU	7
IFLAG	EQU	8
JFLAG	EQU	9
KFLAG	EQU	10
LFLAG	EQU	11
MFLAG	EQU	12
NFLAG	EQU	13
OFLAG	EQU	14
PFLAG	EQU	15
QFLAG	EQU	16
RFLAG	EQU	17
SFLAG	EQU	18
TFLAG	EQU	19
UFLAG	EQU	20
VFLAG	EQU	21
WFLAG	EQU	22
XFLAG	EQU	23
YFLAG	EQU	24
ZFLAG	EQU	25
;
;	PORTS
;
CASS	EQU	0FFH	; CASSETTE PORT
;
;	USER DEFINED EQUATES
;
VS	EQU	31
RV	EQU	16	; REVERSE VIDEO ON
RVR	EQU	17	; REVERSE VIDEO RESET
ENTER	EQU	0DH
;
SVC	MACRO	#SVC
	LD	A,#SVC
	RST	28H
	ENDM
LDU	MACRO	#RG1,#RG2
	IFEQ$	#RG2,IX
	DB	0DDH
	ENDIF
	IFEQ$	#RG2,IY
	DB	0FDH
	ENDIF
	DB	0E5H
	IFEQ$	#RG1,BC
	DB	0C1H
	ENDIF
	IFEQ$	#RG1,HL
	DB	0E1H
	ENDIF
	ENDM
MOVI	MACRO	#FM,#TO,#LEN
	LD	DE,#FM
	LD	HL,#TO
	LD	BC,#LEN
	LDIR
	ENDM
CPR	MACRO	#FLD
	PUSH	HL
	OR	A
	SBC	HL,#FLD
	POP	HL
	ENDM
*LIST ON
