; wdinit/asm - kjw/bqsd - 06/13/83
;
;	created 06/13/83 - kjw
;	revised 06/13/82 - kjw
;
;	system equates
;
CODE	EQU	6000H		;starting load address
HIMEM1	EQU	4409H		;topmem mod I
HIMEM3	EQU	4411H		;topmem mod III
VDLINE	EQU	4467H		;string to video
KBLINE	EQU	0040H		;string from keyboard
$GETDCT	EQU	478FH		;locate DCT address
DIVD1	EQU	44C4H		;divide mod I
DIVD3	EQU	4451H		;divide mod III
;
	ORG	CODE
;
ENTRY	LD	HL,HELLO	;sign on message
	CALL	@VDLINE		;string to video
;
;	check if driver installed via SYSTEM command
;
	PUSH	IY		;pass DCT to DE
	POP	DE		;DE => DCT
	LD	HL,ERR01	;'must be via "system"'
	LD	A,D		;get MSB
	CP	47H		;must be!
	JP	NZ,ERROR	;go if not
	LD	A,E		;get LSB
	CP	8*10		;max length
	JP	NC,ERROR	;go if not
	LD	IX,DRIVDAT	;driver data
;
;	prompt user for parameters
;
ASK1	LD	HL,MSG1		;'physical drive'
	CALL	INPUT		;prompt and get input
;
	LD	A,(HL)		;get user input
	SUB	'0'		;remove ascii
	JR	C,ASK1		;invalid!
	CP	4		;0-3?
	JR	NC,ASK1		;invalid!
	RLCA			;shift to middle bits
	RLCA
	RLCA
	AND	00011000B	;keep only
	LD	(IX+03),A	;to alt DCT
;
ASK18	LD	HL,MSG18	;'step rate'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK18	;invalid
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK18	;too big!
	LD	A,C		;get LSB
	CP	16		;0-15?
	JR	NC,ASK18	;too big!
	LD	A,(IY+04)	;get DCT data
	AND	0F0H		;drop low 4 bits
	OR	C		;combine with input
	LD	(IY+04),A	;update DCT
;
ASK2	LD	HL,MSG2		;'size = 8/5"'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input
;
	RES	5,(IY+03)	;set 5"
	CP	'5'		;5"?
	JR	Z,ASK3		;go if yes
	CP	'8'		;8"?
	JR	NZ,ASK2		;invalid!
	SET	5,(IY+03)	;set 8"
;
ASK3	LD	HL,MSG3		;'cylinder count'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK3		;go if out of range
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK3		;too big!
	LD	A,C		;get LSB
	CP	2		;0/1?
	JR	C,ASK3		;too small!
	CP	201		;200+?
	JR	NC,ASK3		;too big!
	DEC	A		;make highest cyl #
	LD	(IY+06),A	;to DCT
;
ASK4	LD	HL,MSG4		;'cylinder offset'
	CALL	INPUT		;get user input
	CALL	VALUE		;get user input
	JR	NZ,ASK4		;invalid input
	LD	(IX+00),C	;load cyl offset
	LD	(IX+01),B	;load cyl offset
;
ASK5	LD	HL,MSG5		;'directory cylinder'
	CALL	INPUT		;get user input
	LD	A,(IY+06)	;get highest cylinder
	INC	A		;cyl count
	SRL	A		;/2
	LD	(IY+09),A	;default directory middle
	LD	A,(HL)		;any input?
	CP	0DH		;nil?
	JR	Z,ASK6		;yes, default
	CALL	VALUE		;get user input
	JR	NZ,ASK5		;go if invalid
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK5		;too big!
	LD	A,C		;get LSB
	OR	A		;on 0?
	JR	Z,ASK5		;invalid cyl!
	CP	(IY+06)		;in range?
	JR	NC,ASK5		;out of range!
	LD	(IY+09),A	;load DCT
;
ASK6	LD	HL,MSG6		;'sectors / track'
	CALL	INPUT		;get user input
	CALL	VALUE		;get user input
	JR	NZ,ASK6		;invalid entry
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK6		;too big!
	LD	A,C		;get LSB
	OR	A		;0?
	JR	Z,ASK6		;too small
	CP	33		;0-32?
	JR	NC,ASK6		;too big!
	DEC	A		;highest sector
	LD	(IY+07),A	;load DCT
;
ASK7	LD	HL,MSG7		;'sector offset'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK7		;go if error
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK7		;to big
	LD	A,C		;get LSB
	LD	(IX+02),A	;load DCT
;
ASK8	LD	HL,MSG8		;'head count'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK8		;invalid input
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK8		;too big!
	LD	A,C		;get LSB
	OR	A		;0 heads?
	JR	Z,ASK8		;need min 1
	CP	9		;1-8?
	JR	NC,ASK8		;too big
	DEC	A		;correct 0 relative
	RRCA			;shift to high bits
	RRCA
	RRCA
	AND	11100000B	;high 3 only
	OR	(IY+07)		;combine with DCT
	LD	(IY+07),A	;update DCT
;
ASK9	LD	HL,MSG9		;'head offset'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK9		;invalid
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK9		;too big!
	LD	A,C		;get LSB
	CP	8		;0-7?
	JR	NC,ASK9		;too big!
	OR	(IX+03)		;combine with DCT data
	LD	(IX+03),A	;update DCT
;
ASK10	LD	HL,MSG10	;'sectors / gran'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK10	;invalid input
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK10	;too big
	LD	A,C		;get LSB
	OR	A		;0?
	JR	Z,ASK10		;too small!
	CP	33		;1-32?
	JR	NC,ASK10	;too big!
	DEC	A		;0 relative
	LD	(IY+08),A	;update DCT
;
ASK11	LD	HL,MSG11	;'grans/track'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK11	;invalid input
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK11	;too big!
	LD	A,C		;get LSB
	OR	A		;0?
	JR	Z,ASK11		;too small
	CP	9		;1-8?
	JR	NC,ASK11	;too big
	DEC	A		;0 relative
	RRCA			;to high 3 bits
	RRCA
	RRCA
	AND	11100000B	;high 3 only
	OR	(IY+08)		;combine with DCT
	LD	(IY+08),A	;update DCT
;
ASK12	LD	HL,MSG12	;'implied seeks'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input
	CALL	UCASE		;make upper case
;
	RES	4,(IY+03)	;set implied
	CP	'Y'		;yes?
	JR	Z,ASK13		;yes, go!
	CP	'N'		;no?
	JR	NZ,ASK12	;invalid input
	SET	4,(IY+03)	;set issue seeks
;
ASK13	LD	HL,MSG13	;'engage ECC'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input
	CALL	UCASE		;make upper case
;
	RES	7,(IX+03)	;set NO ecc
	CP	'N'		;no?
	JR	Z,ASK14		;go if not
	CP	'Y'		;yes?
	JR	NZ,ASK13	;invalid
	SET	7,(IX+03)	;set YES ecc
;
ASK14	LD	HL,MSG14	;'engage LOCK feature'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input value
	CALL	UCASE		;make upper case
;
	RES	6,(IY+04)	;set NO lock
	CP	'N'		;no?
	JR	Z,ASK17		;go if yes
	CP	'Y'		;yes?
	JR	NZ,ASK14	;invalid, ask again
	SET	6,(IY+04)	;set YES lock
;
ASK17	LD	HL,MSG17	;'de-select drive'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input response
	CALL	UCASE		;make upper case
;
	RES	2,(IY+03)	;set NO de-select
	CP	'N'		;no?
	JR	Z,ASK15		;continue
	CP	'Y'		;yes?
	JR	NZ,ASK17	;invalid, ask again
	SET	2,(IY+03)	;set YES de-select
ASK15	LD	HL,MSG15	;'sector skew factor'
	CALL	INPUT		;get user input
	CALL	VALUE		;get input value
	JR	NZ,ASK15	;go if invalid
	LD	A,B		;get MSB
	OR	A		;>256?
	JR	NZ,ASK15	;too big!
	LD	A,C		;get LSB
	OR	A		;0?
	JR	Z,ASK15		;too small
	LD	(IX+04),A	;init DCT
;
;	check for valid DCT information
;
;	check for highest head <8
;
CHKDCT	LD	HL,ERR02	;'head count exceeds 8'
	LD	A,(IY+5)	;get DCT data
	RLCA			;move high bits to low
	RLCA
	RLCA
	AND	00000111B	;A = start head #
	LD	B,A		;save temp
	LD	A,(IY+7)	;get DCT data
	RLCA			;move high to low
	RLCA
	RLCA
	AND	00000111B	;A = head count
	INC	A		;total head count
	ADD	A,B		;add to offset
	CP	9		;1-8?
	JP	NC,ERROR	;too many!
;
;	check for cylinder count < 201
;
	LD	HL,ERR03	;'cyl count >200'
	LD	A,(IY+6)	;get highest cylinder
	CP	200		;must be less
	JP	NC,ERROR	;go if too big
;
;	check for directory within disk limits
;
	LD	HL,ERR04	;'dir out of disk limit'
	CP	(IY+9)		;directory in range?
	JP	C,ERROR		;go if too big
;
;	check if #sectors over secs/gran = grans per cyl
;
	LD	A,(IY+7)	;get DCT data
	AND	00011111B	;A = highest sector
	INC	A		;A = sector count
	LD	L,A		;pass to L
	LD	H,0		;HL = sectors/track
	LD	A,(IY+7)	;get again
	RLCA			;align high bits to low
	RLCA
	RLCA
	AND	00000111B	;A = # heads-1
	INC	A		;A = # heads
	CALL	@MULT		;multiply it out
;
	EX	DE,HL		;DE = result
	LD	HL,ERR05	;'secs/heads > 256'
	INC	D		;D >< 0?
	DEC	D
	JP	NZ,ERROR	;too big, go!
	EX	DE,HL		;swap back
	LD	H,L		;align results
	LD	L,A		;HL = sectors/track*heads
;
	LD	A,(IY+8)	;get DCT data
	AND	00011111B	;A = secs/gran -1
	INC	A		;adjust to actual
	CALL	@DIVID		;divide it out
	OR	A		;any remainder?
	EX	DE,HL		;swap result to DE
	LD	HL,ERR06	;'secs/gran*grans <> secs
	JP	NZ,ERROR	;out of range
;
	INC	D		;D <> 0?
	DEC	D
	LD	HL,ERR07	;'secs/gran*grans > 256'
	JP	NZ,ERROR	;go if too big!
	LD	A,(IY+8)	;get DCT data
	RLCA			;align to low bits
	RLCA
	RLCA
	AND	00000111B	;A = grans/cyl -1
	INC	A		;adjust to actual
	CP	E		;must be equal!
	LD	HL,ERR08	;'secs/cyl*secsiz<>grans
	JP	NZ,ERROR	;invalid, go!
;
ASK16	LD	HL,MSG16	;'use existing driver'
	CALL	INPUT		;get user input
	LD	A,(HL)		;get input
	CP	0DH		;nil?
;
;	init params for new driver
;
	LD	HL,DRIVER	;driver start
	LD	BC,IODVRL	;driver length
	LD	DE,IODVR	;I/O driver address
	LD	IX,RELOA	;relocate table
	JR	Z,INSTALL	;install driver
;
	SUB	'0'		;drive number?
	JR	C,ASK16		;invalid
	CP	8		;0-7?
	JR	NC,ASK16	;invalid
	LD	C,A		;pass to C
	PUSH	IY		;save
	CALL	$GETDCT		;locate DCT address
;
	EX	DE,HL		;DE=driver start
	LD	A,(IY+00)	;get DCT flags
	CP	0C3H		;active drive?
	LD	HL,ERR09	;'invalid drive link'
	JR	NZ,ERROR-1	;go if bad
	LD	L,(IY+01)	;get vector
	LD	H,(IY+02)	;HL = driver address
	LD	BC,11		;offset to address
	ADD	HL,BC		;HL => driver vector
	LD	A,(HL)		;get LSB
	INC	HL		;bump
	LD	H,(HL)		;get MSB
	LD	L,A		;HL = vector
	EX	DE,HL		;HL=driver, DE=vector
	LD	BC,DRIVERL	;driver length
	LD	IX,RELOB	;0 relocation
	POP	IY		;restore DCT
;
;	all driver parameters OK, install driver
;
INSTALL	EX	DE,HL		;DE=start, HL=vector
	LD	(DRIVSTA+1),HL	;pass driver entry
	CALL	@GETMEM		;get high memory
	LD	(OLDTOP),HL	;save old topmem
;
;	allocate space for new driver in high memory
;
	OR	A		;clear carry flag
	SBC	HL,BC		;HL = new driver address
	LD	($),HL		;update topmem pointer
HIMEM	EQU	$-2
	INC	HL		;bump to free byte
	PUSH	HL		;leave on stack
	PUSH	DE		;save current address
;
	OR	A		;clear carry
	SBC	HL,DE		;HL = offset factor
	EX	DE,HL		;DE = offset factor
;
;	resolve internal references
;
RESOL	LD	L,(IX+0)	;get LSB
	LD	H,(IX+1)	;get MSB
	LD	A,H		;check for terminator
	AND	L
	INC	A		;HL = FFFF?
	JR	Z,RESOLD	;done, continue!
	LD	A,(HL)		;get LSB
	ADD	A,E		;add LSB offset
	LD	(HL),A		;update
	INC	HL		;point to MSB
	LD	A,(HL)		;get MSB
	ADC	A,D		;add MSB + overflow
	LD	(HL),A		;update
	INC	IX		;bump table
	INC	IX		;2 bytes each
	JR	RESOL		;continue
;
RESOLD	POP	DE		;DE = old address
	POP	HL		;HL = new address
	PUSH	HL		;back on stack
	EX	DE,HL		;DE=new address
	LDIR			;move to high memory
	POP	HL		;get new address
;
;	install driver
;
	LD	(IY+00),0C3H	;JP opcode
	LD	(IY+01),L	;LSB driver
	LD	(IY+02),H	;MSB driver
;
;	complete init of flags
;
	LD	A,(IY+03)	;get flags
	AND	10110100B	;drop DDEN/SIDE2/RIGID
	OR	01001000B	;set DDEN/RIGID
	LD	(IY+03),A	;update
	LD	A,(IY+04)	;get flags
	AND	10001111B	;drop DDEN/DCTL/ALIEN
	OR	00010000B	;set ALIEN
	LD	(IY+04),A	;update
;
;	driver completed, display message
;
	LD	HL,ERR00	;'completed'
;
;	exit program
;
ERROR	CALL	@VDLINE		;display to video
	XOR	A		;set Z flag
	LD	IY,0		;reset DCT pointer
	RET			;back to DOS!
;
;	fetch top memory
;
@GETMEM	LD	A,(ROMID)	;read rom ID address
	CP	MODIII		;mod III?
	LD	HL,HIMEM3	;topmem III
	JR	Z,$+5		;go if III
	LD	HL,HIMEM1	;topmem I
	LD	(MEMWHR),HL	;pass vector
	LD	(HIMEM),HL	;save for update
	LD	HL,($)		;get top memory
MEMWHR	EQU	$-2
	RET			;HL = topmem
;
;	fetch string from keyboard
;
@KBLINE	PUSH	IY		;save DCT
	CALL	KBLINE		;fetch string
	POP	IY		;restore DCT
	RET			;done!
;
;	display string to video
;
@VDLINE	PUSH	IY		;save DCT
	CALL	VDLINE		;display string
	POP	IY		;restore
	RET			;done!
;
;	divide subroutine
;
@DIVID	PUSH	HL		;save
	PUSH	AF		;save
	LD	A,(ROMID)	;ROM ID address
	CP	MODIII		;mod III?
	LD	HL,DIVD3	;vector mod III
	JR	Z,$+5		;go if yes
	LD	HL,DIVD1	;vector mod I
	POP	AF		;restore A
	EX	(SP),HL		;get HL, leave vector
	RET			;go vector!
;
;	$MULT - double precision multiply
;
@MULT	PUSH	HL		;save
	PUSH	AF		;save
	LD	A,(ROMID)	;read ROM
	CP	MODIII		;mod III?
	LD	HL,@MULT3	;III vector
	JR	Z,$+5		;go if III
	LD	HL,@MULT1	;I vector
	POP	AF		;restore A
	EX	(SP),HL		;leave vector, get HL
	RET			;go mult vector!
;
;	$VALUE - fetch input value from user
;
VALUE	LD	BC,0		;init value
VALLP	LD	A,(HL)		;get input value
	CP	0DH		;terminator?
	RET	Z		;yes, go!
	SUB	'0'		;remove ascii
	JR	C,VALBAD	;invalid!
	CP	10		;0-9?
	JR	NC,VALBAD	;invalid!
;
	PUSH	HL		;save subtotal
	LD	H,B		;pass to HL
	LD	L,C		;HL = subtotal
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,BC		;*5
	ADD	HL,HL		;*10
	LD	C,A		;new digit
	LD	B,0		;BC = new digit
	ADD	HL,BC		;add it
	LD	B,H		;update subtotal
	LD	C,L		;BC = subtotal
	POP	HL		;restore input pointer
	INC	HL		;bump to next
	JR	VALLP		;continue
;
VALBAD	OR	-1		;set error flag
	RET			;return in error
;
;	$INPUT - display prompt and get user input
;
INPUT	CALL	@VDLINE		;display prompt
	LD	HL,KEYBUFF	;key input buffer
	LD	B,10		;max input length
	CALL	@KBLINE		;get key input
	RET	NC		;go if no BREAK key
	POP	AF		;restore stack
	LD	HL,ERR10	;'aborted'
	JP	ERROR		;exit program
;
UCASE	CP	'a'		;in range?
	RET	C		;go if not
	CP	'z'+1		;in range?
	RET	NC		;go if not
	AND	5FH		;make upper case
	RET			;done
;
;	text storage area
;
HELLO	DEFB	1CH
	DEFB	1FH
	DEFM	'WDDVR2 - '
	DEFM	'Western Digital Rigid I/O Driver - '
	DEFM	'by Kim Watt'
	DEFB	0AH
	DEFM	'Copyright (C) 1983 - '
	DEFM	'Breeze/QSD, Inc. - '
	DEFM	'Dallas, Texas'
	DEFB	0AH
	DEFB	0AH
	DEFB	0DH
;
MSG1	DEFM	'Physical Drive Address (0-3)? '
	DEFB	03H
;
MSG2	DEFM	'Drive Size (5/8)? '
	DEFB	03H
;
MSG3	DEFM	'Cylinder Count (2-200)? '
	DEFB	03H
;
MSG4	DEFM	'Cylinder Offset (0-65535)? '
	DEFB	03H
;
MSG5	DEFM	'Directory Cylinder (<ENTER>=center)? '
	DEFB	03H
;
MSG6	DEFM	'Sectors per Track? '
	DEFB	03H
;
MSG7	DEFM	'Sector Offset (0-255)? '
	DEFB	03H
;
MSG8	DEFM	'Head Count (1-8)? '
	DEFB	03H
;
MSG9	DEFM	'Head Offset (0-7)? '
	DEFB	03H
;
MSG10	DEFM	'Sectors per Granule (1-32)? '
	DEFB	03H
;
MSG11	DEFM	'Grans per Cylinder (1-8)? '
	DEFB	03H
;
MSG12	DEFM	'Implied Seeks (Y/N)? '
	DEFB	03H
;
MSG13	DEFM	'Engage ECC (Y/N)? '
	DEFB	03H
;
MSG14	DEFM	'Engage Drive LOCK (Y/N)? '
	DEFB	03H
;
MSG15	DEFM	'Sector Skewing Factor (1-255)? '
	DEFB	03H
;
MSG16	DEFM	'Use Existing Driver (0-3) or <ENTER>'
	DEFM	' to install new driver? '
	DEFB	03H
;
MSG17	DEFM	'De-Select Drive After Access (Y/N)? '
	DEFB	03H
;
MSG18	DEFM	'Step Rate (0-15)? '
	DEFB	03H
;
;
;
ERR00	DEFM	'Driver Installed'
	DEFB	0DH
;
ERR01	DEFM	'Must Install Driver'
	DEFM	' via "SYSTEM" command'
	DEFB	0DH
;
ERR02	DEFM	'Head Count Exceeds 8'
	DEFB	0DH
;
ERR03	DEFM	'Cylinder Count Exceeds 200'
	DEFB	0DH
;
ERR04	DEFM	'Directory Beyond Disk Boundary'
	DEFB	0DH
;
ERR05	DEFM	'Sectors * Heads > 256'
	DEFB	0DH
;
ERR06	DEFM	'Sectors/Gran / Grans <> Sectors'
	DEFB	0DH
;
ERR07	DEFM	'Sectors/Gran * Grans > 256'
	DEFB	0DH
;
ERR08	DEFM	'Sectors/Cylinder / Sector Size <> Grans'
	DEFB	0DH
;
ERR09	DEFM	'Attempt To Link To Inactive Drive'
	DEFB	0DH
;
ERR10	DEFM	'Program Aborted'
	DEFB	0DH
;
;	data storage area
;
RELOA	DEFW	RELO1		;relocation table
	DEFW	RELO2
	DEFW	RELO3
	DEFW	RELO4
	DEFW	RELO5
	DEFW	RELO6
	DEFW	RELO7
	DEFW	RELO8
	DEFW	RELO9
	DEFW	RELO10
	DEFW	RELO11
	DEFW	RELO12
	DEFW	RELO13
	DEFW	RELO14
	DEFW	RELO15
	DEFW	RELO16
	DEFW	RELO17
	DEFW	RELO18
	DEFW	RELO19
	DEFW	RELO20
	DEFW	RELO21
	DEFW	RELO22
	DEFW	RELO23
	DEFW	RELO24
	DEFW	RELO25
	DEFW	RELO26
	DEFW	RELO27
	DEFW	RELO28
	DEFW	RELO29
	DEFW	RELO30
	DEFW	RELO31
	DEFW	RELO32
	DEFW	RELO33
	DEFW	RELO34
	DEFW	RELO35
	DEFW	RELO36
	DEFW	RELO37
	DEFW	RELO38
	DEFW	RELO39
	DEFW	RELO40
	DEFW	RELO41
	DEFW	RELO42
	DEFW	RELO43
	DEFW	RELO44
	DEFW	RELO45
	DEFW	RELO46
	DEFW	RELO47
	DEFW	RELO48
	DEFW	RELO49
	DEFW	RELO50
	DEFW	RELO51
	DEFW	RELO52
	DEFW	RELO53
	DEFW	RELO54
	DEFW	RELO55
	DEFW	RELO56
	DEFW	RELO57
	DEFW	RELO58
	DEFW	RELO59
	DEFW	RELO60
	DEFW	RELO61
	DEFW	RELO62
RELOB	DEFW	-1		;table terminator
;
KEYBUFF	DEFM	'xxxxxxxxxxx'	;key input buffer
;
*GET	WD1002			;actual driver code
;
_______	EQU	$		;end of program
;
	END	ENTRY
