; vt220m/asm	- DEC VT220 series terminal emulator
; Kim J. Watt	- 27-jan-87
;
ENTRY	DI			; disable ints
	IM	1		; interrupt mode 1
	LD	SP,STACK	; reset stack pointer
;
;	immediate interrupt FDC
;
	LD	A,0D8H		; immediate interrupt
;
	IF	MODI
	LD	(37ECH),A	; FDC command reg 1
	ENDIF
	IF	MODIII
	OUT	(0F0H),A	; FDC III
	ENDIF
;
RESFDC	LD	A,0D0H		; interrupt command
;
	IF	MODI
	LD	(37ECH),A	; FDC 1
	ENDIF
	IF	MODIII
	OUT	(0F0H),A	; FDC 3
	ENDIF
;
;	clear cassette latch, reset drive 1
;
	IF	MODI
	XOR	A		; byte 0
	LD	(37E4H),A	; set cassette #1
	ENDIF
	IF	MODIII
	XOR	A		; byte 0
	OUT	(0E4H),A	; disable NMI's
	LD	A,4		; enable RTC
	OUT	(0E0H),A	; enabled
	LD	A,28H		; video flags
	OUT	(0ECH),A	; enabled
	ENDIF
;
;	setup highspeed on Model III
;
	IF	MODIII
	LD	A,1		; ON command
	OUT	(0FEH),A	; to the port!
	ENDIF
;
;	setup the UART
;
	LD	A,0DH		; reset
	OUT	(0E8H),A	; master reset
	LD	A,55H		; 300 baud
	OUT	(0E9H),A	; to uart
	LD	A,0E5H		; even/8bit/1stop/par
	OUT	(0EAH),A	; to uart
;
	CALL	CLS		; clear video!
	CALL	REFRESH		; update video display
	CALL	UPDCURS		; write the cursor
;
;	add any additional setup here $$$
;
	LD	IY,KEYACT1	; point to action table
;
;	terminal loop - repeat 5 functions
;
START	CALL	READKI		; read keyboard hardware
	CALL	READCI		; read comms in hardware
	CALL	EXECKI		; execute any input keys
	CALL	EXECCI		; execute any comms input
	CALL	WRITCO		; write comms output buff
	CALL	WRITDO		; write display device
	JR	START
;
