; vt220k/asm	- DEC VT220 series terminal emulator
; Kim J. Watt	- 27-jan-87
;
;	this file performs 2 basic functions
; (1)	read keyboard hardware, place input into KIBUFF
; (2)	read KIBUFF and execute any input characters
; NOTE:	read keyboard hardware is stand-alone and
;	may be placed into an interrupt
;
;	READKI	- read keyboard hardware
;
READKI	LD	IX,KIDCB	; point to DCB
	BIT	4,(IY+1)	; repeat on/off?
	JR	Z,GONWKEY	; go if off!
;
;	check if any keys available
;
	LD	A,(387FH)	; get all row key
	OR	A	 	; set flags
	JR	NZ,ADDRPT	; yes, go!
;
;	reset first key counter
;
GONWKEY	LD	HL,600		; double speed value
	LD	(DLY1),HL	; insert delay
;
;	reset between key delay
;
CONTRPT	LD	HL,100		; double speed time
	LD	(DLY2),HL	; update
	JR	KIGO		; go single key
;
;	check for current same as last key
;
ADDRPT	CP	0		; same as last key?
LSTKEY	EQU	$-1
	LD	(LSTKEY),A	; update
	JR	NZ,GONWKEY	; go if not same key!
;
;	same key as last, check for first repeat time
;
	LD	HL,0		; get first key delay
DLY1	EQU	$-2
	LD	A,H		; get msb
	OR	L		; timed out?
	JR	Z,CKDLY2	; go if yes
	DEC	HL		; else decrement it
	LD	(DLY1),HL	; put it back
	JR	KIGO		; and continue
;
;	key is repeating, check for between key delay
;
CKDLY2	LD	HL,0		; get between key count
DLY2	EQU	$-2
	DEC	HL		; decrement
	LD	A,H		; get msb
	OR	L		; check if zero
	LD	(DLY2),HL	; update it
	JR	NZ,KIGO		; go if not time yet
;
;	time to repeat the character
;	clear out the key mask
;
	LD	HL,KEYBRD	; keyboard mask area
	LD	DE,KEYBRD+1	; 7 byte last key mask
	LD	BC,6		; length -1
	LD	(HL),0		; clear a zero
	LDIR			; clear all zeroes
	JR	CONTRPT		; reset counters
;
;	mask area all set for repeat, scan key matrix
;
KIGO	LD	HL,KEYBRD	; work area
	LD	BC,3801H	; keyboard memory
	LD	E,0		; row counter
;
NEXROW	LD	A,(BC)		; get key byte
	BIT	6,C		; last row?
	JR	Z,NLSROW	; go if not
	AND	11111001B	; strip break/clear
NLSROW	LD	D,A		; save unmasked
;
;	compare to mask area to see if it's a new key
;
	XOR	(HL)		; compare to last scan
	LD	(HL),D		; update new key
	AND	D		; same as last key?
	JR	NZ,HAVEIT	; have a new one!
;
;	not a new key, continue to next matrix row
;
	INC	E		; bump row count
	INC	HL		; bump mask byte
	RLC	C		; move key memory
	JP	P,NEXROW	; go if more
	RET			; done, Z flag set
;
;	have a new key, decode into ASCII char
;
HAVEIT	LD	A,E		; get row counter
	ADD	A,A		; *2
	ADD	A,A		; *4
	ADD	A,A		; *8
MKT1	RRC	D		; shift out a bit
	JR	C,MKT2		; go if have a bit
	INC	A		; else bump column #
	JR	MKT1		; and continue
;
;	have a key in A of 00 to 55
;	branch to appropriate key action table
;
MKT2	LD	E,A		; save the key val
	LD	A,(3880H)	; get shift key table
	LD	D,0		; clear msb key
	LD	B,D		; clear both
	AND	03H		; pressed?
	JR	Z,MKT3		; go if not
	DEC	B		; set FF for yes
;
MKT3	LD	A,(3840H)	; get last row key table
	AND	06H		; break/clear?
	JR	Z,KEYN		; go if normal
	BIT	1,A		; clear?
	JR	NZ,KEYC		; go if yes
;
KEYB	LD	HL,UBTBL	; unshifted break table
	RRC	B		; shifted?
	JR	NC,GOKEY	; go if not
	LD	HL,SBTBL	; shift break table
	JR	GOKEY		; and go
;
KEYN	LD	HL,SNTBL	; shift normal table
	RRC	B		; check shift key
	JR	C,GOKEY		; go if shift
	LD	HL,UNTBL	; unshift normal table
	BIT	3,(IY+2)	; key lock on?
	JR	Z,GOKEY		; go if not
	LD	HL,UNTBLL	; unshift normal locked
;
;	HL => data table for current key
;
GOKEY	ADD	HL,DE		; add offset to character
	LD	A,(HL)		; get data
	CALL	PUTBUFF		; write to buffer
	RET			; and exit
;
;	execute any key input data
;
EXECKI	LD	IX,KIDCB	; point to DCB
	CALL	GETBUFF		; any data in buffer?
	RET	NC		; no data available!
;
	OR	A		; set flags on data
	RET	Z		; go if 0?
	JP	P,GOKEY1	; go if not
	AND	7FH		; remove control bit
	LD	E,A		; pass to E
	LD	HL,NLTBL	; normal lookup table
	ADD	HL,DE		; HL => data
	LD	A,(HL)		; get command/offset
	OR	A		; check sign flag
	JP	P,GOMUL		; go multiple table
	ADD	A,A		; *2 for word table
;
;	have a command, lookup address and vector
;
GOCMD	LD	E,A		; pass to E
	LD	HL,CMDTBL	; start of table
	ADD	HL,DE		; HL => vector
	LD	A,(HL)		; get ls
	INC	HL		; bump to ms
	LD	H,(HL)		; get ms
	LD	L,A		; HL = vector
	JP	(HL)		; perform service
;
;	have a multiple data output, lookup address
;
GOMUL	LD	E,A		; pass to E
	LD	HL,MTABLE	; lookup table
	ADD	HL,DE		; HL => data, +0=length
	JR	GOKEYM		; and send data
;
KEYC	LD	HL,UCTBL	; unshifted clear table
	RRC	B		; shifted?
	JR	NC,GOKEY	; go if not
	LD	HL,SCTBL	; shifted clear table
	JR	GOKEY		; and go
;
GOKEY1	LD	A,1		; single key
	JR	OLOAD		; continue
GOKEYM	LD	A,(HL)		; get count
	INC	HL		; bump past
;
;	add the current character to the transmit queue
;
OLOAD	LD	B,H		; pass buffer pointer
	LD	C,L		; BC -> output
OLOADLP	EX	AF,AF'		; save char count
	LD	A,(BC)		; get next char
	INC	BC		; bump pointer
	LD	IX,CODCB	; comms output DCB
OLOADWT	CALL	PUTBUFF		; can add to output buff?
	JR	NC,OLOADWT	; wait for space
;
OLOADOK	BIT	5,(IY+0)	; echo on?
	JR	Z,OLOADNE	; go if not
	LD	IX,DODCB	; display dcb
LOADWV	CALL	PUTBUFF		; can add to output buff?
	JR	NC,LOADWV	; wait if not
;
OLOADNE	EX	AF,AF'		; get char count
	DEC	A		; less this char
	JR	NZ,OLOADLP	; go if more
	RET			; else exit
;
;	ring buffer services
;	IX -> current DCB to service
;
PUTBUFF	LD	E,(IX+6)	; get add offset
	LD	D,(IX+7)
	LD	L,(IX+2)	; get length
	LD	H,(IX+3)
	INC	DE		; bump pointer
	SCF			; set for adjust
	SBC	HL,DE		; check for ring end
	JR	NC,PUTBUF1	; go if not
	LD	DE,0		; else reset to beginning
;
PUTBUF1	LD	L,(IX+8)	; get take offset
	LD	H,(IX+9)
	OR	A		; clear carry
	SBC	HL,DE		; compare
	RET	Z		; NC = no room!
;
	LD	L,(IX+0)	; get buffer start
	LD	H,(IX+1)
	ADD	HL,DE		; add ring offset
	LD	(HL),A		; write the data
	LD	(IX+6),E	; update add offset
	LD	(IX+7),D
	INC	(IX+4)		; bump lsb char counter
	JR	NZ,PUTBUF2	; go if non wrap
	INC	(IX+5)		; bump msb counter
;
PUTBUF2	SCF			; set for char OK
	RET			; and exit
;
;	attempt to remove a character from a buffer
;	IX -> DCB to operate on
;
GETBUFF	LD	A,(IX+4)	; get chars in buffer
	OR	(IX+5)		; check msb
	RET	Z		; NCy = no chars!
;
	LD	E,(IX+8)	; get take offset
	LD	D,(IX+9)
	LD	L,(IX+2)	; get length
	LD	H,(IX+3)
	INC	DE		; bump ring pointer
	SCF			; set for adjust
	SBC	HL,DE		; check for ring end
	JR	NC,GETBUF1	; go if not wrap
	LD	DE,0		; else reset to beginning
;
GETBUF1	LD	L,(IX+0)	; get buffer start
	LD	H,(IX+1)
	ADD	HL,DE		; point to data
	LD	(IX+8),E	; update offset
	LD	(IX+9),D
;
	DEC	(IX+4)		; dec char counter
	LD	A,(IX+4)	; check for -1
	CP	-1		; wrap?
	JR	NZ,GETBUF2	; go if not
	DEC	(IX+5)		; else dec msb
;
GETBUF2	LD	A,(HL)		; get char data
	SCF			; set carry for OK
	RET			; and exit
;
;	&&&&&&
;
LOOKUP	INC	(HL)		; table term?
	JR	Z,LOOKNOT	; go if yes
	DEC	(HL)		; restore
	CP	(HL)		; this one it?
	INC	HL		; skip past control
	JR	Z,LOOKGET	; go if yes
	INC	HL		; past word vector
	INC	HL
	JR	LOOKUP		; and continue
;
LOOKGET	LD	A,(HL)		; get lsb vector
	INC	HL		; bump pointer
	LD	H,(HL)		; get msb
	LD	L,A		; HL = address
	OR	A		; clear carry
	RET			; and exit
;
LOOKNOT	DEC	(HL)		; restore data
	SCF			; set carry for error
	RET			; and exit
;
;	special function keys
;
SHIFTSP	LD	A,(IY+2)	; get key action flag
	XOR	01000000B	; toggle auto window
	LD	(IY+2),A	; update
	RET			; and exit
;
SHIFT0	LD	A,(IY+2)	; get current reading
	XOR	08H		; toggle the caps lock
	LD	(IY+2),A	; update data
	RET			; and exit
;
BREAKU	LD	A,(WINDOW+1)	; get current row
	OR	A		; at top?
	RET	Z		; go if yes
	SUB	8		; less 8 rows
	LD	(WINDOW+1),A	; update
	CALL	REFRESH		; refresh the video
	RET			; and exit
;
BREAKD	LD	A,(WINDOW+1)	; get current row
	CP	8		; at bottom?
	RET	Z		; yes, no change
	ADD	A,8		; else adjust
	LD	(WINDOW+1),A	; update
	CALL	REFRESH		; refresh the video
	RET			; and exit
;
BREAKR	LD	A,(WINDOW)	; get column
	OR	A		; at left?
	JR	Z,BREAKRU	; go if yes, ok
	BIT	1,(IY+0)	; 132 column?
	RET	Z		; nope, cannot go more!
	CP	64*2		; far right now?
	RET	Z		; yes, cannot go more
BREAKRU	ADD	A,32		; else 16 columns
	LD	(WINDOW),A	; update
	CALL	REFRESH		; update display
	RET			; and exit
;
BREAKL	LD	A,(WINDOW)	; get column
	OR	A		; at left?
	RET	Z		; go if yes
	SUB	32		; less 16 columns
	LD	(WINDOW),A	; update
	CALL	REFRESH		; update display
	RET			; and exit
;
;	keycode lookup tables
;
UNTBL	EQU	$		; unshifted normal table
	DB	'@abcdefghijklmnopqrstuvwxyz'
	DB	0,0,0,0,0
	DB	'0123456789:;,-./'
	DB	0DH,0,0,80H,81H,82H,83H,' '
;
UNTBLL	EQU	$		; unshifted/locked table
	DB	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	DB	0,0,0,0,0
	DB	'0123456789:;,-./'
	DB	0DH,0,0,80H,81H,82H,83H,' '
;
SNTBL	EQU	$		; shifted normal table
	DB	84H,'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	DB	0,0,0,0,0
	DB	85H,'!"#$%&',27H,'()*+<=>?'
	DB	86H,0,0,87H,88H,89H,8AH,8BH
;
UCTBL	EQU	$		; unshifted clear table
	DB	8CH,01H,02H,03H,04H,05H,06H,07H
	DB	08H,09H,0AH,0BH,0CH,0DH,0EH,0FH
	DB	10H,11H,12H,13H,14H,15H,16H,17H
	DB	18H,19H,1AH,0,0,0,0,0
	DB	8DH,8EH,8FH,90H,91H,92H,93H,94H
	DB	95H,96H,0,0,97H,0AEH,98H,0
	DB	0AFH,0,0,99H,9AH,0,0,1BH
;
SCTBL	EQU	$		; shifted clear table
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,7CH,7EH,5EH,0,0,0,60H
	DB	5BH,5DH,0,0,7BH,5FH,7DH,5CH
	DB	0,0,0,0,0,0,0,0
;
UBTBL	EQU	$		; unshifted break table
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	9BH,0B0H,0B1H,0B2H,0B3H,0,9CH,9DH
	DB	9EH,9FH,0,0,0,0,0,0
	DB	0,0,0,0A0H,0A1H,0A2H,0A3H,0
;
SBTBL	EQU	$		; shifted break table
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
	DB	0A4H,0A5H,0A6H,0A7H,0A8H,0A9H,0AAH,0ABH
	DB	0ACH,0ADH,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
;
;	command table references
;
CMDTBL	DW	SHIFT0	; C0
	DW	SHIFTSP	; C1
	DW	BREAKU	; C2
	DW	BREAKD	; C3
	DW	BREAKL	; C4
	DW	BREAKR	; C5
;
;	multiple key output table
;
CSI	EQU	9BH
SS3	EQU	8FH
;
MTABLE	EQU	$
M0	DB	2,CSI,'A'
M1	DB	2,CSI,'B'
M2	DB	2,CSI,'D'
M3	DB	2,CSI,'C'
M4	DB	4,CSI,'2','1',7EH
M5	DB	2,0DH,0AH
M6	DB	3,CSI,'5',7EH
M7	DB	3,CSI,'6',7EH
M8	DB	1,7FH
M9	DB	1,09H
M10	DB	3,CSI,'4',7EH
M11	DB	2,SS3,'p'
M12	DB	2,SS3,'q'
M13	DB	2,SS3,'r'
M14	DB	2,SS3,'s'
M15	DB	2,SS3,'t'
M16	DB	2,SS3,'u'
M17	DB	2,SS3,'v'
M18	DB	2,SS3,'w'
M19	DB	2,SS3,'x'
M20	DB	2,SS3,'y'
M21	DB	2,SS3,'l'
M22	DB	2,SS3,'n'
M23	DB	3,CSI,'2',7EH
M24	DB	3,CSI,'3',7EH
M25	DB	4,CSI,'2','1',7EH
M26	DB	4,CSI,'1','7',7EH
M27	DB	4,CSI,'1','8',7EH
M28	DB	4,CSI,'1','9',7EH
M29	DB	4,CSI,'2','0',7EH
M30	DB	4,CSI,'3','4',7EH
M31	DB	4,CSI,'2','3',7EH
M32	DB	4,CSI,'2','4',7EH
M33	DB	4,CSI,'2','5',7EH
M34	DB	4,CSI,'2','6',7EH
M35	DB	4,CSI,'2','8',7EH
M36	DB	4,CSI,'2','9',7EH
M37	DB	4,CSI,'3','1',7EH
M38	DB	4,CSI,'3','2',7EH
M39	DB	4,CSI,'3','3',7EH
M40	DB	2,SS3,'m'
M41	DB	2,SS3,'M'
M42	DB	2,SS3,'P'
M43	DB	2,SS3,'Q'
M44	DB	2,SS3,'R'
M45	DB	2,SS3,'S'
;
;	multiple output lookup table
;
NLTBL	DB	M0-MTABLE	; 80
	DB	M1-MTABLE	; 81
	DB	M2-MTABLE	; 82
	DB	M3-MTABLE	; 83
	DB	M4-MTABLE	; 84
	DB	80H		; 85
	DB	M5-MTABLE	; 86
	DB	M6-MTABLE	; 87
	DB	M7-MTABLE	; 88
	DB	M8-MTABLE	; 89
	DB	M9-MTABLE	; 8A
	DB	81H		; 8B
	DB	M10-MTABLE	; 8C
	DB	M11-MTABLE	; 8D
	DB	M12-MTABLE	; 8E
	DB	M13-MTABLE	; 8F
	DB	M14-MTABLE	; 90
	DB	M15-MTABLE	; 91
	DB	M16-MTABLE	; 92
	DB	M17-MTABLE	; 93
	DB	M18-MTABLE	; 94
	DB	M19-MTABLE	; 95
	DB	M20-MTABLE	; 96
	DB	M21-MTABLE	; 97
	DB	M22-MTABLE	; 98
	DB	M23-MTABLE	; 99
	DB	M24-MTABLE	; 9A
	DB	M25-MTABLE	; 9B
	DB	M26-MTABLE	; 9C
	DB	M27-MTABLE	; 9D
	DB	M28-MTABLE	; 9E
	DB	M29-MTABLE	; 9F
	DB	82H		; A0
	DB	83H		; A1
	DB	84H		; A2
	DB	85H		; A3
	DB	M30-MTABLE	; A4
	DB	M31-MTABLE	; A5
	DB	M32-MTABLE	; A6
	DB	M33-MTABLE	; A7
	DB	M34-MTABLE	; A8
	DB	M35-MTABLE	; A9
	DB	M36-MTABLE	; AA
	DB	M37-MTABLE	; AB
	DB	M38-MTABLE	; AC
	DB	M39-MTABLE	; AD
	DB	M40-MTABLE	; AE
	DB	M41-MTABLE	; AF
	DB	M42-MTABLE	; B0
	DB	M43-MTABLE	; B1
	DB	M44-MTABLE	; B2
	DB	M45-MTABLE	; B3
