; vt220d/asm	- DEC VT220 series terminal emulator
;
;	define data area : #####
;
	DS	100H		; stack area
STACK	EQU	$		; top of stack
VIDEO	DS	24*128*2	; rows*cols*bytes/char
;
; NOTE:	IY always points to following byte for indexing
;	for duration of program, DO NOT ALTER IY!!!
;
;	keyboard action table 1
;	7 keyboard action	1=locked, 0=unlocked
;	6 insert/replace	1=insert, 0=replace
;	5 send/receive		1=on, 0=off
;	4 linefeed/newline	1=newline, 0=linefeed
;	3 cursor key		1=application, 0=cursor
;	2 ANSI/VT52		1=N/A, 0=VT52
;	1 Column		1=132, 0=80
;	0 Scrolling		1=Smooth, 0=Jump
KEYACT1	DB	00000000B	; action table 1
;
;	keyboard action table 2
;
;	7 Screen		1=Reverse, 0=Normal
;	6 Origin		1=Origin, 0=Absolute
;	5 Auto Wrap		1=On, 0=Off
;	4 Auto Repeat		1=On, 0=Off
;	3 Print Form Feed	1=On, 0=Off
;	2 Print Extent		1=Full, 0=Scroll Region
;	1 Text Cursor Enable	1=Off, 0=On
;	0 Keypad		1=Application, 0=Numeric
KEYACT2	DB	00010000B	; action table 2
;
;	keyboard action table 3
;
;	7 Character Set		1=National, 0=MultiNat.
;	6 Auto Window		1=Off, 0=On
;	5 ESC sequence		1=pending, 0=no
;	4 CSI sequence		1=pending, 0=no
;	3 caps lock		1=locked, 0=normal
;	2 DCS sequence		1=pending, 0=no
KEYACT3	DB	0		; action table 3
;
;	video display control table
;
CURSOR	DW	0		; row/column for cursor
WINDOW	DW	0		; row/column offset
CSIBUF	DB	0,0,0,0,0,0,0,0	; CSI sequence storage
ATTRIB	DB	0		; current char attribute
VCDATA	DB	' '		; real data under cursor
;
; +0 / 1 = VT100 output data, 2 = VT220 output data
; +1 / 8 = set at 80 columns, 2 = 132 column display
; +2 / ?
; +3 / ?
; +4 / A = application keyboard set, N = numeric
; +5 / K and k = successful key input, O = overflow
; +6 / T and t = successful xmit
; +7 / R and r = successful rcvr, P=par, O=orun,D=data
KEYBRD	DB	0,0,0,0,0,0,0	; key work area
;
;
;	I/O buffers
;
KIBUFF	DS	256
KIBUFFL	EQU	$-KIBUFF
;
CIBUFF	DS	256
CIBUFFL	EQU	$-CIBUFF
;
COBUFF	DS	256
COBUFFL	EQU	$-COBUFF
;
DOBUFF	DS	256
DOBUFFL	EQU	$-DOBUFF
;
;	device control blocks
; format:
; +00/01	- buffer address in memory
; +02/03	- buffer length in bytes
; +04/05	- current count of chars in buffer
; +06/07	- add to buffer offset
; +08/09	- take from buffer offset
; +10		- flags
;	7 - 0=enable, 1=pause
;
KIDCB	DW	KIBUFF
	DW	KIBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
CIDCB	DW	CIBUFF
	DW	CIBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
CODCB	DW	COBUFF
	DW	COBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
DODCB	DW	DOBUFF
	DW	DOBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
TSCROLL	DW	0		; top scroll line
BSCROLL	DW	23*256		; bottom scroll line
