; vt100m/asm	- DEC VT100 series terminal emulator
; Kim J. Watt	/ 25-Mar-87
;
ENTRY	DI			; disable ints
	IM	1		; interrupt mode 1
	LD	SP,STACK	; reset stack pointer
;
;	init interrupt vectors
;
	LD	A,0C3H		; JP opcode
	LD	(4012H),A	; jump
	LD	(4049H),A	; NMI vector
	LD	HL,TASK		; interrupt service
	LD	(4013H),HL	; load address
	LD	HL,NMI		; nmi service
	LD	(404AH),HL	; to vector
;
;	immediate interrupt FDC
;
	LD	A,0D8H		; immediate interrupt
;
	IF	MODI
	LD	(37ECH),A	; FDC command reg 1
	ENDIF
	IF	MODIII
	OUT	(0F0H),A	; FDC III
	ENDIF
;
RESFDC	LD	A,0D0H		; interrupt command
;
	IF	MODI
	LD	(37ECH),A	; FDC 1
	ENDIF
	IF	MODIII
	OUT	(0F0H),A	; FDC 3
	ENDIF
;
;	clear cassette latch, reset drive 1
;
	IF	MODI
	XOR	A		; byte 0
	LD	(37E4H),A	; set cassette #1
	ENDIF
	IF	MODIII
	XOR	A		; byte 0
	OUT	(0E4H),A	; disable NMI's
	LD	A,4		; enable RTC
	OUT	(0E0H),A	; enabled
	LD	A,28H		; video flags
	OUT	(0ECH),A	; enabled
	ENDIF
;
;	setup highspeed on Model III
;
	IF	MODIII
	LD	A,1		; ON command
	OUT	(0FEH),A	; to the port!
	ENDIF
;
;	setup the UART
;
; in E8 - master status register
; in E9 - config jumpers
; in EA - uart status
; in EB - uart receive data
; out E8 - master reset
; out E9 - baud
; out EA - control reg load / handshake latch
; out EB - uart transmit data
;
; 7 1=E/0=O    parity     rx ready    CTS
; 6 word 1     word 1     1=THRE      DSR
; 5 word 2     word 2     1=overrun   CD
; 4 0=1/1=2    stop       1=framing   Ring
; 3 0=Y/1=N    parity     1=parity    x
; 2 x          break      x           x
; 1 x          RTS        x           rx in
; 0 x          DTR        x           x
; IN E9        OUT EA     IN EA       IN E8
;
	LD	A,00001101B	; reset
	OUT	(0E8H),A	; master reset
	LD	A,01010101B	; 300 baud
	OUT	(0E9H),A	; to uart
	LD	A,01101101B	; 8bit/1stop/nopar
	OUT	(0EAH),A	; to uart
;
;	blank out the tab table
;	set tabs every 8 columns
;
	LD	HL,TABTBL	; start of table
	LD	C,0		; init col
;
TABINI1	LD	A,C		; get position
	AND	7		; every 8 stops
	JR	Z,TABINI2	; go if should set tab
	LD	A,80H		; else clear tab
TABINI2	LD	(HL),A		; write data
	INC	HL		; bump pointer
	INC	C		; bump col
	JP	P,TABINI1	; 128 cols
;
;	add any additional setup here $$$
;
	LD	IY,TABLE	; points to control table
	LD	IX,DODCB	; display DCB
	LD	A,8FH		; CLS code
	CALL	PUTBUFF		; write to buffer
	EI			; enable now
;
;	terminal loop - repeat 5 functions
;
START	DI
	CALL	READCI
	EI
	CALL	EXECCI
	DI
	CALL	READCI
	EI
	CALL	WRITDO
	DI
	CALL	READCI
	EI
	CALL	READKI
	DI
	CALL	READCI
	EI
	CALL	EXECKI
	DI
	CALL	READCI
	EI
	CALL	WRITDO
	DI
	CALL	READCI
	EI
	CALL	WRITCO
	JR	START
;
