; vt100i/asm	- DEC VT100 series terminal emulator
;
;	interrupt service handlers
;
NMI	RETN			; no non-maskable service
;
;	real time clock interrupt
;
TASK	PUSH	AF		; save
;
	IF	MODI
	LD	A,(37E0H)	; read int latch I
	BIT	6,A		; FDC making roster?
	JP	NC,FDCROST	; go if yes
	BIT	7,A		; valid interrupt?
	JP	Z,TSKNOT	; go if not
	ENDIF
	IF	MODIII
	IN	A,(0E0H)	; read int latch III
	BIT	2,A		; valid interrupt?
	JP	NZ,TSKNOT	; go if not
	ENDIF
;
;	valid interrupt received
;
	PUSH	IX		; save
	EXX			; save
;
	CALL	READCI		; get a comms input char
;
	EXX			; restore
	POP	IX		; restore
;
;	task completed
;
TSKNOT
;
	IF	MODI
	LD	A,(37E0H)	; clear interrupt latch
	ENDIF
	IF	MODIII
	IN	A,(0ECH)	; clear latch III
	ENDIF
;
	POP	AF		; restore
	EI			; re-enable
	RET			; and exit
;
	IF	MODI
FDCROST	LD	A,(37ECH)	; clear FDC
	JR	TSKNOT		; and exit
	ENDIF
;
