; vt100d/asm	- DEC VT100 series terminal emulator
;
;	define data area : #####
;
	DS	100H		; stack area
STACK	EQU	$		; top of stack
;
; NOTE:	IY always points to following byte for indexing
;
TABLE
;	for duration of program, DO NOT ALTER IY!!!
;
; +0	7 / 0=insert, 1=replace
; DO	6 / 0=send, 1=receive
;	5 / 0=linefeed, 1=newline
;	4 / 0=80 col, 1=132 col
;	3 / 0=auto wrap on, 1=off
;	2 / 0=auto window, 1=off
;	1 / 0=cursor on, 1=off
;	0 / 0=cursor visible, 1=invisible
	DB	11000000B
;
; +1	7 / 0=key repeat, 1=no
; KI	6 / 0=application, 1=numeric
;	5 / 0=caps lock, 1=off
;	4 / 0=KAM off, 1=on
	DB	01100001B
;
; +2	7 / 0=CSI pending, 1=yes
; CI	6 / 0=ESC pending, 1=yes
;	5 / 0=DCS pending, 1=yes
	DB	00000000B
	DB	0		; general use
;
;	control table
;
BCOL	DB	0		; buffer column
BROW	DB	0		; buffer row
BOFF	DW	0		; buffer offset
SBCOL	DB	0		; saved col
SBROW	DB	0		; saved row
SBOFF	DW	0		; saved offset
WCOL	DB	0		; window column
WROW	DB	0		; window row
WOFF	DW	0		; window offset
TSCROLL	DB	0		; scroll top row
BSCROLL	DB	23		; scroll bottom row
VCOL	DB	0		; video column
VROW	DB	0		; video row
VOFF	DW	0		; video offset
VDATA	DB	0		; video data
TABTBL	DS	128		; tab lookup table
;
;	memory allocation
;
VIDEO	EQU	3C00H		; video ram
BUFFER	EQU	5000H		; video buffer
;
;	miscellaneous data
;
CSIBUF	DS	33		; CSI sequence storage
KEYBRD	DB	0,0,0,0,0,0,0	; key work area
;
;	I/O buffers
;
KIBUFF	DS	1024
KIBUFFL	EQU	$-KIBUFF
;
CIBUFF	DS	1024
CIBUFFL	EQU	$-CIBUFF
;
COBUFF	DS	1024
COBUFFL	EQU	$-COBUFF
;
DOBUFF	DS	1024
DOBUFFL	EQU	$-DOBUFF
;
;	device control blocks
; format:
; +00/01	- buffer address in memory
; +02/03	- buffer length in bytes
; +04/05	- current count of chars in buffer
; +06/07	- add to buffer offset
; +08/09	- take from buffer offset
; +10		- flags
;	7 - 0=enable, 1=pause
;
KIDCB	DW	KIBUFF
	DW	KIBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
CIDCB	DW	CIBUFF
	DW	CIBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
CODCB	DW	COBUFF
	DW	COBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
DODCB	DW	DOBUFF
	DW	DOBUFFL
	DW	0
	DW	0
	DW	0
	DB	0
;
