TTU3   ; ttu3/asm
 DISMEM	LD	BC,DAMBUFF
 	LD	(DEFADDR),BC
 	CALL	GETADDR
 DOADDR	LD	(ADDRESS),BC	;save it here
 DISRETM	RST	8
 	DB	6,0		;clear screen
 DISMCON	CALL	SHOW		;display bytes
 DISMCON1	CALL	SHOWLF	;show addresses
 	LD	HL,SPACES
 	LD	DE,3C00H
 	LD	BC,3
 	LDIR
 DISMWT	LD	A,12		;flash counter
 	LD	(DISSM),A
 DISMWT1	CALL	INKEY		;wait for a key
 	JR	NZ,HASDM
 	LD	A,0
 DISSM	EQU	$-1
 	DEC	A
 	LD	(DISSM),A
 	JR	NZ,DISMWT1
 	LD	A,(3C00H)
 	CP	20H
 	LD	A,20H
 	JR	NZ,DISSMTT
 	LD	A,0B0H
 DISSMTT	LD	(3C00H),A
 	JR	DISMWT
 HASDM	PUSH	AF
 	CALL	UCASE
 	CP	20H		;check for control code
 	JR	NC,HASDMXX
 	LD	A,8FH		;use block instead
 HASDMXX	LD	(3C00H),A
 	POP	AF
 	LD	HL,(ADDRESS)	;pass address along
 	LD	DE,DISMTBL	;jump table
 	CALL	GOTABL		;is key there?
 DISMRET	LD	(ADDRESS),HL	;save address
 	JR	DISMCON		;continue
 DISMTBL	DB	5BH
 	DW	DMEMUP
 	DB	5CH
 	DW	DMEMDP
 	DB	5DH
 	DW	DMEMD
 	DB	5EH
 	DW	DMEMU
 	DB	18H
 	DW	DMEMDP
 	DB	19H
 	DW	DMEMUP
 	DB	1AH
 	DW	DMEMB
 	DB	1BH
 	DW	DMEMT
 	DB	'A'
 	DW	ASCIT
 	DB	'B'
 	DW	BINIT
 	DB	'D'
 	DW	DECIT
 	DB	'H'
 	DW	HEXIT
 	DB	'O'
 	DW	OCTIT
 	DB	'M'
 	DW	MODIFY
 	DB	'@'
 	DW	DECODE
 	DB	3
 	DW	NEWDISMEM
 	DB	0
 DMEMU	INC	HL
 	JR	DISMRET
 DMEMD	DEC	HL
 	JR	DISMRET
 DMEMUP	INC	H
 	JR	DISMRET
 DMEMT	LD	HL,(TOPMEM)
 DMEMDP	DEC	H
 	JR	DISMRET
 DMEMB	LD	HL,0
 	JR	DISMRET
 GETADDR	RST	8		;get address
 	DB	10,0
 GETADDR1	RST	8
 	DB	1EH,'Address ? ',0
 	LD	B,30
 	RST	10H		;get key input
 	LD	BC,(DEFADDR)	;default to end program
 	RET	Z		;default to 0
 	CALL	UCASE		;make it upper case
 	CP	'L'		;last address?
 	LD	BC,(ADDRESS)
 	RET	Z
 	CALL	VALUE		;get the value
 	JR	C,GETADDR1	;bad numeric value
 	RET			;else have it
 NEWDISMEM	RST	8
 	DB	5,0
 	JP	DISMEM
 DOBUILD	RST	8
 	DB	10,0
 DOBLD	RST	8
 	DB	1EH,'S>ingle or D>ouble density ? ',0
 	LD	B,1
 	RST	10H
 	LD	A,'S'
 	JR	Z,DECBLD	;decode answer
 	LD	A,(HL)		;get answer back
 DECBLD	CALL	CKCONF		;check for configuration
 	JR	NZ,DOBLD	;bad input
 	RST	8
 	DB	10,0
 BDTK	RST	8
 	DB	1EH,'Track ? ',0
 	LD	B,20
 	RST	10H
 	LD	A,0
 	JR	Z,BTKD
 	CALL	VALUE
 	JR	C,BDTK
 BTKD
 ;i*
 	IF	MODI
 	LD	(37EDH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F1H),A
 	ENDIF
 ;
 	CALL	CLRBUFF
 	CALL	BUILDTRK	;build the track
 	PUSH	BC		;save buffer
 	LD	H,B		;pass to HL
 	LD	L,C
 	LD	A,H		;get msb
 	RST	20H		;hex ascii
 	LD	(BTA),BC
 	LD	A,L
 	RST	20H
 	LD	(BTA+2),BC
 	RST	8
 	DB	10,'Key <ENTER> to display buffer at '
 BTA	DB	'xxxxH. ',0
 	CALL	ONEKEY
 	POP	BC		;get buffer back
 	JP	DOADDR		;display it
 GETSES	RST	8
 	DB	10,0
 	LD	HL,PGMEND
 	LD	(TEMP0),HL
 	LD	(TEMP2),HL
 	LD	HL,(TOPMEM)
 	DEC	HL
 	LD	(TEMP1),HL
 GETSES1	RST	8
 	DB	1EH,'Start, End, Start ? ',0
 	LD	B,30
 	RST	10H
 	RET	Z
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETSES1
 	LD	(TEMP0),BC	;save here
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETSES1
 	LD	(TEMP1),BC
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETSES1
 	LD	(TEMP2),BC
 	RET
 GETSE	RST	8
 	DB	10,0
 	LD	BC,PGMEND	;end of program +1
 	LD	(TEMP0),BC	;default to this
 	LD	BC,(TOPMEM)	;last byte +1
 	DEC	BC
 	LD	(TEMP1),BC	;default here
 GETSED	RST	8
 	DB	1EH,'Start, End ? ',0
 	LD	B,30
 	RST	10H
 	RET	Z
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETSED
 	LD	(TEMP0),BC
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETSED
 	LD	(TEMP1),BC
 	RET
 MOVMEM	CALL	INITCOUNT	;zero the counter
 	CALL	GETSES		;start,end,start
 	CALL	BYTECOUNT	;get length of block
 MOVMEML	LD	A,(HL)		;get source byte
 	LD	(DE),A		;save here
 	CALL	ADDCOUNT	;bump counter
 	INC	HL
 	INC	DE		;point to next
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,MOVMEML	;continue till end
 	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'bytes moved.',0
 	JP	GOBACK		;enter to continue
 BYTECOUNT	LD	HL,(TEMP1)	;get end
 	LD	BC,(TEMP0)	;start
 	OR	A		;clear carry
 	SBC	HL,BC		;get byte count
 	INC	HL		;true count
 	LD	B,H		;give to BC
 	LD	C,L
 	LD	HL,(TEMP0)	;get start
 	LD	DE,(TEMP2)	;get new start
 	RET
 EXCMEM	CALL	INITCOUNT
 	CALL	GETSES
 	CALL	BYTECOUNT
 EXCMEML	LD	A,(HL)		;get a byte from here
 	EX	AF,AF'		;save here
 	LD	A,(DE)		;get this one
 	LD	(HL),A		;swap it
 	EX	AF,AF'
 	LD	(DE),A
 	CALL	ADDCOUNT	;bump counter
 	INC	HL
 	INC	DE		;bump pointers
 	DEC	BC		;less byte count
 	LD	A,B
 	OR	C
 	JR	NZ,EXCMEML
 	CALL	SHOCOUNT	;show counter
 	RST	8
 	DB	'bytes exchanged.',0
 	JP	GOBACK
 REVMEM	CALL	INITCOUNT
 	CALL	GETSE		;start/end
 	CALL	BYTECOUNT	;compute length
 	PUSH	BC		;save this
 REVMEM0	CALL	ADDCOUNT	;bump counter
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,REVMEM0
 	POP	BC		;count back
 	OR	A		;clear carry
 	RR	B		;divide BC in half
 	RR	C
 	LD	DE,(TEMP1)	;get end address
 REVMEML	LD	A,(HL)		;get one byte
 	EX	AF,AF'
 	LD	A,(DE)
 	LD	(HL),A
 	EX	AF,AF'
 	LD	(DE),A
 	INC	HL
 	DEC	DE
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,REVMEML
 	CALL	SHOCOUNT
 	RST	8
 	DB	'bytes reversed.',0
 	JP	GOBACK
 JUMPMEM	LD	BC,4015H	;program restart
 	LD	(DEFADDR),BC
 	CALL	GETADDR
 	PUSH	BC		;go to it
 	LD	HL,4015H	;save in HL' for ret
 	PUSH	HL		;save a sec
 	EXX			;save in alt
 	POP	HL		;HL = address
 	EX	(SP),HL		;leave on stack
 	JP	(HL)		;HL = address
 FILLMEM	RST	8
 	DB	10,0
 	LD	HL,PGMEND
 	LD	(TEMP0),HL
 	LD	HL,(TOPMEM)
 	DEC	HL
 	LD	(TEMP1),HL
 	XOR	A
 	LD	(TEMP2),A
 FILLMEM1	RST	8
 	DB	1EH,'Start, End, Fill ? ',0
 	LD	B,42
 	RST	10H
 	JR	Z,FILLDEF	;zero unused memory
 	CALL	POSHL
 	JR	C,FILLDEF
 	CALL	VALUE
 	JR	C,FILLMEM1
 	LD	(TEMP0),BC
 	CALL	POSHL
 	JR	C,FILLDEF
 	CALL	VALUE
 	JR	C,FILLMEM1
 	LD	(TEMP1),BC
 	CALL	POSHL
 	JR	C,FILLDEF	;go
 	CALL	VALUE
 	JR	C,FILLMEM1
 	LD	(TEMP2),A
 FILLDEF	CALL	BYTECOUNT	;get byte count
 	PUSH	HL
 	POP	DE
 	INC	DE
 	LD	A,(TEMP2)
 	PUSH	BC		;save count
 	DEC	BC		;adjust to actual count
 	LD	(HL),A
 	PUSH	AF		;save byte
 	DI
 	LDIR
 	POP	AF
 	RST	20H
 	LD	(FILM4),BC
 	POP	HL
 	LD	IY,FILM3
 	CALL	WRLNO
 	EI
 	RST	8
 	DB	10
 FILM3	DB	'xxxxx bytes filled with '
 FILM4	DB	'xxH.',0
 	JP	GOBACK
 COMMEM	CALL	INITCOUNT	;initialize counter
 	CALL	GETSES		;start, end, start
 	CALL	BYTECOUNT	;setup registers
 COMMEML	LD	A,(DE)		;get source byte
 	CP	(HL)		;same as dest?
 	CALL	NZ,COMMEMB	;display address
 	INC	HL
 	INC	DE
 	CALL	PAUSE
 	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,COMMEML	;continue through loop
 	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'Non-Compares.',0
 	JP	GOBACK		;enter to continue
 COMMEMB	PUSH	BC		;save this from ascii
 	LD	A,H		;msb address
 	RST	20H		;hex ascii
 	LD	(CMM1),BC	;into string
 	LD	A,L
 	RST	20H
 	LD	(CMM1+2),BC
 	LD	A,D
 	RST	20H
 	LD	(CMM2),BC
 	LD	A,E
 	RST	20H
 	LD	(CMM2+2),BC
 	RST	8
 	DB	10
 CMM1	DB	'xxxxH and '
 CMM2	DB	'xxxxH DO NOT MATCH !',0
 	POP	BC
 	JP	ADDCOUNT	;bump counter
 TESTMEM	LD	HL,TESTMEM1	;can't test here
 	LD	A,H
 	RST	20H
 	LD	(CT1),BC
 	LD	A,L
 	RST	20H
 	LD	(CT1+2),BC
 	LD	HL,TESTMEM2	;end of can't test
 	LD	A,H
 	RST	20H
 	LD	(CT2),BC
 	LD	A,L
 	RST	20H
 	LD	(CT2+2),BC
 	RST	8
 	DB	10,'DO NOT test between '
 CT1	DB	'xxxxH and '
 CT2	DB	'xxxxH !!',0
 	CALL	INITCOUNT	;zero the counter
 	CALL	GETSE		;start end
 	CALL	BYTECOUNT	;setup registers
 	DI			;runs much faster
 	RST	8
 	DB	10,0
 TESTMEML	LD	DE,RET	;return instruction
 	LD	(TESTMEM3),DE	;put in code
 	LD	E,(HL)		;get the byte
 	LD	A,1		;start with bit 0
 	LD	D,0		;bad bit saver
 TESTMEM1	LD	(HL),A	;load the address
 	CP	(HL)		;still there?
 	CALL	NZ,BADMEM	;bad memory
 	XOR	0FFH		;reverse the bits
 	LD	(HL),A
 	CP	(HL)
 	LD	(HL),E		;put byte back
 TESTMEM2	CALL	NZ,BADMEM2
 	XOR	0FFH		;restore byte
 	RLCA			;shift test bit left
 	JR	NC,TESTMEM1	;do all bits
 	CALL	0		;display if bad byte
 TESTMEM3	EQU	$-2	;setup from others
 	INC	HL		;next byte
 	CALL	PAUSE
 	CALL	IFCLEAR
 	JR	C,TESTFINISH
 	DEC	BC		;less count
 	LD	A,B
 	OR	C
 	JR	Z,TESTFINISH
 	LD	A,L		;on an even page?
 	OR	A
 	JR	NZ,TESTMEML
 	LD	A,H		;get page number
 	PUSH	BC		;save counter
 	RST	20H
 	LD	(TMMSGG),BC
 	POP	BC		;can get it back now
 	RST	8
 	DB	1DH,'Testing Block '
 TMMSGG	DB	'xx00H.',0
 	JR	TESTMEML
 TESTFINISH	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'bad bytes.',0
 	EI
 	JP	GOBACK		;enter to continue
 BADMEM	OR	D		;add bad bit
 	LD	D,A		;re-save result
 	EX	AF,AF'		;save test bit here
 	EXX			;save registers
 	LD	HL,SHOBADMEM	;address display routine
 	LD	(TESTMEM3),HL	;put into code
 	EXX
 	EX	AF,AF'		;restore registers
 	RET			;done
 BADMEM2	XOR	0FFH		;restore byte
 	CALL	BADMEM		;set bad memory
 	XOR	0FFH		;correct byte
 	RET			;done
 SHOBADMEM	PUSH	BC	;save counter
 	LD	A,H		;get address
 	RST	20H
 	LD	(BMM1),BC
 	LD	A,L
 	RST	20H
 	LD	(BMM1+2),BC
 	RST	8
 	DB	1EH
 BMM1	DB	'xxxxH, bad bits =',0
 	LD	A,'7'		;start with bit 7
 	LD	B,8		;go for 8 bits
 BMM2	RLC	D		;check the bit
 	JR	NC,BMM3
 	LD	(BMM4),A
 	RST	8
 	DB	' '
 BMM4	DB	'x,',0
 BMM3	DEC	A		;ascii bit less 1
 	DJNZ	BMM2		;continue for all 8
 	LD	BC,(CURSOR)	;get cursor
 	LD	A,'.'		;put period at end
 	DEC	BC
 	LD	(BC),A
 	RST	8
 	DB	10,0
 	POP	BC		;restore it
 	JP	ADDCOUNT	;add to counter
 INPORT	RST	8
 	DB	10,0
 INPORTB	RST	8
 	DB	1EH,'Port ? ',0
 	LD	B,20
 	RST	10H
 	JR	Z,INPORTB
 	CALL	VALUE
 	JR	C,INPORTB
 	JR	NZ,INPORTB	;too big
 	IN	A,(C)		;get the byte
 	RST	20H		;make it hex ascii
 	LD	(INP1),BC	;into string
 	RST	8
 	DB	10,'Input byte is '
 INP1	DB	'xxH.',0
 	JP	GOBACK
 OUTPORT	RST	8
 	DB	10,0
 OUTPORTB	RST	8
 	DB	1EH,'Port, Byte ? ',0
 	LD	B,30
 	RST	10H
 	JR	Z,OUTPORTB
 	CALL	POSHL
 	JR	C,OUTPORTB
 	CALL	UCASE
 	CALL	VALUE
 	JR	C,OUTPORTB
 	JR	NZ,OUTPORTB
 	PUSH	BC		;save port in C
 	CALL	VALUE		;get byte
 	POP	BC		;get port back
 	JR	C,OUTPORTB	;bad number
 	JR	NZ,OUTPORTB	;too big
 	OUT	(C),A		;send it out
 	JP	GOBACK		;done
 MEM2SEC	CALL	INITCOUNT	;initialize counter
 	LD	HL,BUFFER	;default to buffer
 	LD	(DEFADDR),HL
 	CALL	GETADDR		;get address
 	PUSH	BC		;save it
 	CALL	GETDAT		;get drive,track,sector
 	CALL	GETCOUNT	;get sector count
 	POP	BC		;address to write from
 	RST	8
 	DB	10,0
 	CALL	COMPDATA
 	LD	(WRTYPE),A
 	CALL	DSTAT		;check status
 	JP	NZ,4018H
 MEM2SECL	PUSH	HL	;save count
 	RST	30H
 	POP	HL
 	CALL	NEXSEC		;next sector
 	JR	C,MEM2SECD
 	DEC	HL		;decrement counter
 	LD	A,H
 	OR	L
 	JR	NZ,MEM2SECL
 MEM2SECD	CALL	SHOCOUNT
 	RST	8
 	DB	'sectors NOT written.',0
 	JP	GOBACK
 SEC2MEM	CALL	INITCOUNT
 	CALL	GETDAT
 	CALL	GETCOUNT	;sector count
 	EXX			;save here
 	LD	HL,BUFFER	;default here
 	LD	(DEFADDR),HL
 	CALL	GETADDR		;load address
 	PUSH	BC		;pass to other set
 	EXX
 	POP	BC		;have everything
 	PUSH	BC		;save on stack
 	RST	8
 	DB	10,0
 	CALL	DSTAT		;check status
 	JP	NZ,4018H
 SEC2MEML	PUSH	HL
 	RST	28H
 	POP	HL
 	CALL	NEXSEC
 	JR	C,SEC2MEMD
 	DEC	HL
 	LD	A,H
 	OR	L
 	JR	NZ,SEC2MEML
 SEC2MEMD	CALL	SHOCOUNT
 	RST	8
 	DB	'sectors NOT loaded.',10
 	DB	'Key <ENTER> to display. ',0
 	CALL	ONEKEY
 	POP	BC		;load address
 	JP	DOADDR		;display it
 PUTBUILD	LD	BC,FBUFF
 	LD	(ADDRESS),BC
 	JR	MEM2TRKPUT
 MEM2TRK	LD	BC,FBUFF	;use format buffer
 	LD	(ADDRESS),BC
 	CALL	GETADDR		;get address
 MEM2TRKPUT	LD	(FMTBUFF),BC
 	CALL	GETDT		;drive track
 	CALL	DSTAT		;check status
 	JP	NZ,4018H
 ;i*
 	IF	MODI
 	CALL	SELDEN
 	ENDIF
 ;
 	CALL	SEEK		;move head to track
 	JR	NZ,MEM2TRKB
 	CALL	BUILDPUT	;write the track
 	JP	Z,GOBACK
 MEM2TRKB	RST	8
 	DB	10,'Error on Track Write.',0
 	JP	GOBACK
 TRK2MEM	LD	HL,FBUFF	;format buffer
 	LD	(DEFADDR),HL
 	CALL	GETDT		;get drive track
 	PUSH	DE
 	CALL	GETADDR
 	PUSH	BC		;save on stack
 	RST	8
 	DB	10,0
 ASKSYNC	RST	8
 	DB	1EH,'Synchronize to ID ? ',0
 	LD	B,3
 	RST	10H
 	LD	B,0E4H		;default NO
 	JR	Z,SYNCHAV
 	CALL	UCASE
 	CP	'N'
 	JR	Z,SYNCHAV
 	CP	'Y'
 	JR	NZ,ASKSYNC
 	LD	B,0E5H
 SYNCHAV	LD	A,B
 	LD	(SYNC),A
 	CALL	DSTAT
 	JP	NZ,4018H
 	POP	BC
 	POP	DE
 ;i*
 	IF	MODI
 	CALL	SELDEN
 	ENDIF
 ;
 	CALL	SEEK
 	JR	NZ,SYNCNO
 ;i*
 	IF	MODI
 	LD	DE,37EFH
 	PUSH	BC
 	DI
 	LD	(HL),0E4H
 SYNC	EQU	$-1
 	ENDIF
 ;iii*
 	IF	MODIII
 	PUSH	BC
 	CALL	SETNMI
 	LD	A,18H
 	LD	(RDIIIFIX),A
 	LD	A,0E4H
 SYNC	EQU	$-1
 	OUT	(0F0H),A	;read track command
 	ENDIF
 ;
 	CALL	RXFER
 	AND	98H		;error bits
 SYNCNO	CALL	NZ,TKBD		;bad read
 	IF	MODIII
 	LD	A,20H
 	LD	(RDIIIFIX),A
 	ENDIF
 	LD	BC,(TEMPFF)
 	DEC	BC		;point to last byte
 	PUSH	BC		;save it
 	LD	A,B
 	RST	20H
 	LD	(TKE),BC
 	POP	BC
 	LD	A,C
 	RST	20H
 	LD	(TKE+2),BC
 	POP	HL		;first byte
 	LD	A,H
 	RST	20H
 	LD	(TKS),BC
 	LD	A,L
 	RST	20H
 	LD	(TKS+2),BC
 	RST	8
 	DB	10,'Track in buffer from '
 TKS	DB	'xxxxH to '
 TKE	DB	'xxxxH.',10
 	DB	'Key <ENTER> to display. ',0
 	CALL	ONEKEY
 	LD	B,H
 	LD	C,L		;BC = address
 	JP	DOADDR		;display it
 TKBD	SCF
 	CALL	SHOWST		;display error
 	RST	8
 	DB	10,'Track Read Error.',0
 	RET
 GETDT	RST	8
 	DB	10,0
 	XOR	A
 	CALL	SETDRV		;default 0
 	LD	D,0		;same with track
 GETDT0	RST	8
 	DB	1EH,'Drive, Track ? ',0
 	LD	B,30
 	RST	10H
 	RET	Z
 	CALL	POSHL
 	RET	C
 	CALL	FIGDRV		;setup drive
 	JR	C,GETDT0
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETDT0
 	JR	NZ,GETDT0
 	LD	D,A
 	RET			;done
 BUILDPUT	LD	BC,(FMTBUFF)	;where buffer is
 	RST	8		;linefeed
 	DB	10,0
 	JP	SHOFMT		;display and write it out
