TTU0B  ; ttu0b/asm
 SHOREAD	CALL	DLOFF
 	RST	8
 	DB	1DH,'Reading    ',0
 	CALL	DLON
 	LD	HL,READ
 	PUSH	HL
 	LD	HL,BADRD
 	PUSH	HL
 	LD	HL,SHOREAD	;where source from
 	JR	SHORWCOM	;go common
 SHOWRITE	CALL	DLOFF
 	RST	8
 	DB	1DH,'Writing    ',0
 	CALL	DLON
 	LD	HL,WRITE
 	PUSH	HL
 	LD	HL,BADWRT
 	PUSH	HL
 	LD	HL,SHOWRITE
 	JR	SHORWCOM
 SHOVERIFY	CALL	SHOVERF
 	LD	HL,READ
 	PUSH	HL
 	LD	HL,BADRD
 	PUSH	HL
 	LD	HL,SHOVERIFY
 SHORWCOM	LD	(SHO003),HL
 	POP	HL
 	LD	(SHO002),HL
 	POP	HL
 	LD	(SHO001),HL
 	CALL	DLOFF
 	CALL	SHOWWH		;display drive,track,sec
 	CALL	DLON
 	CALL	0		;set from above
 SHO001	EQU	$-2
 	RET	Z		;successful
 	CALL	0		;error type
 SHO002	EQU	$-2
 	JP	C,ADDCOUNT	;bump counter
 	CALL	DSTAT		;check status again
 	RET	NZ		;skip
 	JP	0		;try again
 SHO003	EQU	$-2
 SHOVERF	CALL	DLOFF
 	RST	8
 	DB	1DH,'Verifying  ',0
 	CALL	DLON
 	RET
 SHOVERIFYX	CALL	SHOVERF
 	CALL	SHOWWH
 	CALL	READ		;read a sector
 	CALL	NZ,READ		;try again if not good
 	RET			;that's all
 SHOFMT
 ;i*
 	IF	MODI
 	LD	A,(37EDH)
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 ;
 	PUSH	BC		;save buffer
 	RST	18H
 	LD	(FTR),A
 	LD	(FTR+1),BC
 	CALL	DRVASC
 	LD	(FDR),A		;put in string
 	POP	BC
 	CALL	DLOFF
 	RST	8
 	DB	1DH,'Formatting Drive '
 FDR	DB	'x, Track '
 FTR	DB	'xxx.                ',0
 	CALL	DLON
 	CALL	WRITETR		;write the track
 	RET	Z		;successful
 	LD	HL,MEG0
 	BIT	6,A		;write protected?
 	JR	NZ,FMTER
 	LD	HL,MEG1
 	BIT	5,A		;write fault?
 	JR	NZ,FMTER
 	LD	HL,MEG2
 	BIT	2,A		;lost data?
 	RET	Z
 FMTER	PUSH	HL
 	JP	8
 MEG0	DB	10,'WRITE PROTECTED Disk !',0
 	OR	1
 	RET			;return with NZ flag
 MEG1	DB	10,'HARDWARE Write Fault !',0
 	OR	1
 	RET
 MEG2	DB	10,'DATA LOST on Track Write !',0
 	OR	1
 	RET
 VERSEC	CALL	GETDAT		;get drive,track,sector
 	CALL	GETCOUNT	;get sector count
 	CALL	DSTAT		;drive ready ?
 	JP	NZ,4018H
 	RST	8
 	DB	10,0
 	CALL	INITBAD1	;initialize non-stop
 	CALL	INITCOUNT	;zero error counter
 VERSECL	LD	BC,BUFFER	;I/O buffer
 	CALL	MVERIFY		;multiple read
 	LD	A,H		;any more sectors left?
 	OR	L
 	JR	NZ,VERSECL	;continue in loop
 VERSECQ	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'Bad Sectors.',0
 	JP	GOBACK		;wait for enter key
 SHOACOUNT	LD	HL,XACOUNT	;string
 	JR	SHOCOUNT+3
 SHOCOUNT	LD	HL,XCOUNT
 	RST	8
 	DB	10,0
 	CALL	POSHL
 	PUSH	HL
 	JP	8
 XCOUNT	DB	'xxxxxxxx ',0
 	RET
 XACOUNT	DB	'xxxxxxxx ',0
 	RET
 INITACOUNT	PUSH	HL	;must save it
 	LD	HL,XACOUNT
 	JR	INITCOUNT+4
 INITCOUNT	PUSH	HL
 	LD	HL,XCOUNT
 	PUSH	BC
 	LD	B,7
 	LD	A,20H		;fill with spaces
 	CALL	FILL		;load it
 	POP	BC
 	LD	(HL),'0'	;start with 0
 	POP	HL		;restore this
 	RET
 ADDACOUNT	PUSH	HL
 	LD	HL,XACOUNT+7
 	JR	ADDCOUNT+4
 ADDCOUNT	PUSH	HL
 	LD	HL,XCOUNT+7
 	PUSH	AF		;save this too
 ADDCLP	INC	(HL)		;add one to it
 	LD	A,(HL)		;get it back
 	CP	3AH		;past 9?
 	JR	C,ADDRET	;done if not
 	LD	(HL),'0'	;zero it out
 	DEC	HL		;next msb
 	LD	A,(HL)		;see if it's a space
 	CP	20H
 	JR	NZ,ADDCLP	;continue if not
 	LD	(HL),'0'	;start with a 0
 	JR	ADDCLP		;now continue
 ADDRET	POP	AF
 	POP	HL
 	RET			;done
 GETCOUNT	RST	8
 	DB	10,0
 BADCOUNT	RST	8
 	DB	1EH,'Sector Count ? ',0
 	PUSH	BC
 	LD	B,15
 	RST	10H
 	JR	Z,CNTOTAL	;default to total count
 	CALL	VALUE		;compute string value
 	LD	H,B		;give it to hl
 	LD	L,C
 	POP	BC		;restore this
 	JR	C,BADCOUNT	;bad input
 	RET
 CNTOTAL	OR	A		;get track count
 	CALL	GETTKS
 	LD	C,A		;give to BC
 	LD	B,0		;BC = track count
 	LD	HL,0		;start with 0
 	OR	A		;get type
 	CALL	GETTYPEA
 	PUSH	AF
 	BIT	7,A
 	JR	Z,CNTLP-2
 	LD	A,18
 	JR	CNTLP
 	LD	A,10
 CNTLP	ADD	HL,BC		;add 'em
 	DEC	A		;go till sector count
 	JR	NZ,CNTLP
 	POP	AF
 	POP	BC		;hl=#tracks * sectors/tk
 	RET
 MVERIFY	PUSH	HL		;save count
 	LD	HL,SHOVERIFY	;routine address
 	JR	MCOMM		;go common routine
 MREAD	PUSH	HL
 	LD	HL,SHOREAD
 	JR	MCOMM
 MWRITE	PUSH	HL
 	LD	HL,SHOWRITE
 MCOMM	LD	(MLADD),HL	;put in call code
 	POP	HL		;restore counter
 	LD	IX,DAMBUFF	;Data Address Marks
 MCLP	PUSH	HL		;save from call
 	CALL	INITBAD		;allow key input if bad
 	LD	A,(IX)		;get DAM
 	CP	0A0H
 	CALL	C,BADLMD	;bad write byte
 	CP	0C0H
 	CALL	NC,BADLMD	;this way bad too
 	LD	(WRTYPE),A	;pass to write command
 	CALL	0		;call the read/write/ver
 MLADD	EQU	$-2
 	POP	HL		;restore count
 	EX	AF,AF'		;get write byte
 	LD	(IX),A		;put in buffer
 	INC	IX		;bump buffer
 	EX	AF,AF'		;get result back
 	CALL	IFCLEAR
 	RET	C
 	DEC	HL
 	CALL	NEXSEC		;advance DE
 	JR	NC,MALDD00	;continue
 	LD	HL,0		;else done with track
 	SCF
 	RET
 MALDD00	LD	A,H
 	OR	L
 	RET	Z		;done if yes
 	CALL	BUFFEREND	;buffer at end of memory?
 	RET	Z		;at end of memory
 	CALL	PAUSE		;check for pause
 	JR	MCLP		;do some more
 COMSEC	RST	8		;message
 	DB	10,'Source.',0
 	CALL	GETDAT		;get drive/tk/sec
 	CALL	GETCOUNT	;get sector count
 	EXX			;save source here
 	LD	A,(DRIV)	;get binary drive
 	LD	(SDRIVE),A	;save source drive
 	RST	8
 	DB	10,'Compare to.',0
 	CALL	GETDAT
 	LD	A,(DRIV)	;get binary drive
 	LD	(DDRIVE),A	;save dest drive
 	EXX			;count into source HL
 	CALL	INITBAD1	;initialize non-stop
 	CALL	INITCOUNT	;initialize counter
 	CALL	INITACOUNT	;alternate counter
 	CALL	IFSAME		;same diskette?
 	RST	8
 	DB	10,0
 COMSECL	CALL	SSETUP
 	JP	NZ,4018H
 	LD	BC,BUFFER+100H	;buffer address
 	PUSH	HL		;save count
 	CALL	MREAD		;multiple read
 	LD	B,H		;remain count to BC
 	LD	C,L
 	POP	HL		;original count
 	SBC	HL,BC		;how many were read
 	PUSH	HL		;save result on stack
 	LD	H,B		;put back in HL
 	LD	L,C
 	EXX			;save in alt set
 	POP	HL		;get count
 	LD	BC,BUFFER+100H
 	CALL	DSETUP
 	JP	NZ,4018H
 	LD	IX,DAMBUFF	;DAM buffer
 COMSL	PUSH	HL		;save counter
 	PUSH	BC
 	LD	BC,BUFFER	;read buffer
 	CALL	PAUSE		;check for pause key
 	CALL	SHOVERIFY	;display it
 	CALL	IFCLEAR		;check for clear key
 	JR	C,COMFINISH
 	POP	HL		;source data buffer
 	PUSH	DE		;save from compare
 	EX	DE,HL		;DE = buffer
 	PUSH	DE		;save buffer address
 	LD	HL,BUFFER	;point to buffer
 	LD	B,0		;256 bytes
 	CALL	COMPARE		;compare 'em
 	CALL	COMNO
 	POP	BC		;old buffer address
 	POP	DE		;track/sector
 	CALL	NEXSEC		;bump sector
 	POP	HL		;get counter back
 	JR	C,COMFINISH	;end of disk
 	INC	B		;next buffer page
 	DEC	HL		;reduce counter
 	CALL	PAUSE		;check space bar
 	LD	A,H
 	OR	L
 	JR	NZ,COMSL
 	EXX			;get source back
 	LD	A,H
 	OR	L		;any more left
 	JR	NZ,COMSECL	;go outer loop
 COMFINISH	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'Data mismatches.',0
 	CALL	SHOACOUNT	;display alternate
 	RST	8
 	DB	'DAM mismatches.',0
 	JP	GOBACK			;wait for enter
 COMPARE	LD	A,(DE)		;get a byte
 	CP	(HL)
 	RET	NZ
 	INC	HL
 	INC	DE
 	DJNZ	COMPARE
 	RET
 COMNO	JR	Z,BADDAM	;check data marks
 	PUSH	BC
 	LD	A,L
 	RST	20H
 	LD	(COMNOSTR),BC
 	POP	BC
 	RST	8
 	DB	8,'-DATA-@'
 COMNOSTR	DB	'xxH-',0
 	CALL	ADDCOUNT
 	OR	1
 BADDAM	EX	AF,AF'		;check address mark
 	CP	(IX)		;same as source?
 	INC	IX
 	JR	Z,DAMOK		;dam is ok
 	RST	8
 	DB	' DAM-',0
 	CALL	ADDACOUNT
 	JR	ODKM
 DAMOK	JR	NZ,ODKM		;display error
 	EX	AF,AF'
 	RET	Z		;all OK
 ODKM	RST	8
 	DB	8,'.',10,0
 	RET
 IFSAME	LD	A,-1
 	LD	(MFLAG),A	;set as different disks
 	RST	8
 	DB	10,0		;linefeed
 ASKSAME	RST	8		;if source/dest same
 	DB	1EH,'Disk mount prompts ? ',0
 	PUSH	BC
 	PUSH	HL
 	LD	B,3
 	RST	10H
 	POP	HL
 	POP	BC
 	RET	Z		;no input, default NO
 	CALL	UCASE		;remove low case
 	CP	'N'		;no?
 	RET	Z		;already set
 	CP	'Y'		;yes ?
 	JR	NZ,ASKSAME	;bad input
 	XOR	A
 	LD	(MFLAG),A	;save in flag byte
 	RET			;done
 SMOUNT	PUSH	HL		;mount source disk
 	LD	HL,MOUNTSRC
 	JR	MOUNTC
 DMOUNT	PUSH	HL		;mount dest disk
 	LD	HL,MOUNTDES
 MOUNTC	LD	(MOUNTJ),HL	;save jump vector
 	POP	HL
 	LD	A,(MFLAG)	;get mount flag
 	INC	A		;-1 = no mount wait
 	RET	Z
 	JP	0		;else display prompt
 MOUNTJ	EQU	$-2
 DRVSAME	PUSH	BC		;save to use
 	LD	A,(SDRIVE)	;get source drive
 	LD	B,A
 	LD	A,(DDRIVE)	;dest drive
 	CP	B		;same?
 	POP	BC
 	RET			;that's all here
 PAUSE	LD	A,(3840H)	;check for space bar
 	AND	80H		;pressed?
 	RET	Z		;nope
 	LD	A,(3880H)	;shift key?
 	OR	A
 	JR	NZ,PAUSE	;wait here if yes
 PAUSEWT	LD	A,(3840H)	;check for enter key
 	AND	1
 	JR	Z,PAUSEWT
 	RET
 COPSEC	RST	8		;copy disk sectors
 	DB	10,'Source.',0
 	CALL	GETDAT		;get drive,track,sector
 	CALL	GETCOUNT	;get sector count
 	EXX			;save 'em here
 	LD	A,(DRIV)
 	LD	(SDRIVE),A	;save source drive
 	RST	8
 	DB	10,'Destination.',0
 	CALL	GETDAT
 	LD	A,(DRIV)
 	LD	(DDRIVE),A	;save dest drive
 	EXX			;back to source data
 	CALL	INITBAD1
 	CALL	INITCOUNT
 	CALL	IFSAME		;same diskette?
 	RST	8		;linefeed
 	DB	10,0
 COPSECL	CALL	SSETUP
 	JP	NZ,4018H
 	LD	BC,BUFFER	;I/O buffer
 	PUSH	HL		;save count
 	CALL	MREAD		;read as many as possible
 	LD	B,H		;save new count in BC
 	LD	C,L
 	POP	HL		;get original count
 	SBC	HL,BC		;how many were read
 	PUSH	HL		;save result
 	LD	H,B
 	LD	L,C		;get remaining secs to HL
 	EXX			;save int alt set
 	POP	HL		;count for write
 	LD	BC,BUFFER	;I/O buffer
 	CALL	DSETUP
 	JP	NZ,4018H
 	CALL	MWRITE		;write 'em back
 	EXX			;back to source data
 	LD	A,H		;any more sectors?
 	OR	L
 	JR	NZ,COPSECL	;continue if yes
 COPFINISH	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'Sectors NOT copied.',0
 	JP	GOBACK
 ZERSEC	RST	8
 	DB	10,'Be Careful !',0
 	CALL	GETDAT		;get drive track sector
 	CALL	GETCOUNT	;get sector count
 	CALL	INITBAD1	;turn off non-stop
 	CALL	INITCOUNT	;initialize counter
 	RST	8
 	DB	10,0
 	CALL	DSTAT		;check status
 	JP	NZ,4018H
 ZERSECL	LD	BC,BUFFER	;I/O buffer
 	CALL	ZBUFF		;zero it out
 	CALL	COMPDATA
 URHA	LD	(WRTYPE),A
 	PUSH	HL
 	RST	30H
 	POP	HL
 	JR	NZ,URHA+3
 	CALL	IFCLEAR
 	JR	C,ZERFINISH
 	CALL	NEXSEC
 	JR	C,ZERFINISH	;end of disk
 	DEC	HL		;reduce count
 	LD	A,H
 	OR	L		;any more?
 	JR	NZ,ZERSECL
 ZERFINISH	CALL	SHOCOUNT	;show error count
 	RST	8
 	DB	'Sectors NOT zeroed.',0
 	JP	GOBACK
 WRITETR	OR	A
 	CALL	GETTYPEB
 	AND	40H
 	RET	NZ
 	LD	A,6
 	LD	(WTRIES),A
 WTRIE	PUSH	BC
 	CALL	TRWRITE		;write the track
 	POP	BC		;load back
 	AND	0FFH
 	RET	Z		;done
 	EX	AF,AF'		;save result
 	LD	A,6
 WTRIES	EQU	$-1
 	DEC	A
 	LD	(WTRIES),A
 	JR	NZ,WTRIE
 	EX	AF,AF'
 	RET
 TRWRITE	CALL	SELECT		;try again
 	RET	NZ		;not ready
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get track
 	LD	D,A		;for density setup
 	CALL	SELDEN
 	LD	HL,37ECH	;point to FDC
 	LD	DE,37EFH	;data address
 	DI			;disable
 	LD	(HL),0F4H	;write track code
 	JP	WXFER		;write the data
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;get track
 	LD	D,A		;for density setup
 	CALL	SETNMI
 	LD	A,D
 	LD	DE,240H
 	LD	E,A
 	LD	BC,3F3H
 	LD	A,0F0H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 WX1	LD	A,E
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	B
 	JP	PO,WX1
 	OUTI
 WX2	LD	A,E
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	D
 	JR	Z,WX2
 	OUTI
 	LD	A,E
 WX3	OUT	(0F4H),A
 	OUTI
 	JP	WX3
 	ENDIF
 ;
 DAMARKS	CALL	GETDAT		;get drive,track,sector
 	CALL	GETCOUNT	;get sector count
 	RST	8
 	DB	10,0
 	EXX
 DAMK	RST	8
 ;i*
 	IF	MODI
 	DB	1EH,'S>td, R>ptc, D>dt, U>df ? ',0
 	ENDIF
 ;iii*
 	IF	MODIII
 	DB	1EH,'S>td, R>ptc ? ',0
 	ENDIF
 ;
 	LD	B,4
 	RST	10H
 ;i*
 	IF	MODI
 	LD	B,0A8H
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	B,0A0H
 	ENDIF
 ;
 	JR	Z,HADAM
 	CALL	UCASE		;make upper case
 	CP	'S'
 	JR	Z,HADAM
 	INC	B
 	CP	'R'
 	JR	Z,HADAM
 ;i*
 	IF	MODI
 	INC	B
 	CP	'D'
 	JR	Z,HADAM
 	INC	B
 	CP	'U'
 	JR	Z,HADAM
 	ENDIF
 ;
 	JR	DAMK
 HADAM	LD	A,B		;get address mark
 	LD	(DMSV),A	;save the type
 	OR	A
 	CALL	GETTYPEA
 	BIT	7,A
 	JR	Z,HYTDN
 	LD	A,(DMSV)
 	RES	1,A
 	LD	(DMSV),A
 HYTDN	EXX			;get everything back
 	CALL	INITBAD1
 	CALL	INITCOUNT
 	RST	8
 	DB	10,0
 	CALL	DSTAT		;check status
 	JP	NZ,4018H
 DAMSECL	LD	BC,BUFFER	;I/O buffer
 	PUSH	DE		;save track sector
 	PUSH	HL		;save count
 	CALL	MREAD		;multiple read
 	LD	B,H
 	LD	C,L		;remaining count
 	POP	HL		;original
 	SBC	HL,BC		;how many just read
 	POP	DE		;get start track/sector
 	PUSH	BC		;save how many left
 	EXX			;swap for setup
 	LD	HL,DAMBUFF	;DAM buffer
 	LD	DE,DAMBUFF+1
 	LD	BC,0FFH		;1 full sector
 	LD	(HL),0		;new DAM
 DMSV	EQU	$-1
 	LDIR			;fill the table
 	EXX			;get originals back
 	LD	BC,BUFFER	;use same one
 	CALL	MWRITE		;write 'em back
 	POP	HL		;get count back
 	LD	A,H		;any more?
 	OR	L
 	JR	NZ,DAMSECL	;continue in loop
 DAMFINISH	CALL	SHOCOUNT
 	RST	8
 	DB	'Sectors NOT altered.',0
 	JP	GOBACK
 BADLMD
 ;i*
 	IF	MODI
 	LD	A,0A8H
 	ENDIF
 ;iii*
 	IF	MODIII
 	LD	A,0A0H
 	ENDIF
 ;
 	RET
 BUFFEREND	LD	A,(TOPMEM+1)	;get msb topmem
 	CP	B		;test for buffer end
 	SCF			;must clear carry
 	CCF
 	RET			;back with Z flag
 EXCSEC	RST	8
 	DB	10,'Source.',0
 	CALL	GETDAT
 	CALL	GETCOUNT
 	EXX			;save data here
 	LD	A,(DRIV)
 	LD	(SDRIVE),A
 	RST	8
 	DB	10,'Exchange with.',0
 	CALL	GETDAT
 	LD	A,(DRIV)
 	LD	(DDRIVE),A
 	EXX			;swap back
 	CALL	INITBAD1
 	CALL	INITCOUNT
 	CALL	IFSAME		;same diskette?
 	RST	8
 	DB	10,0
 	CALL	SSETUP
 	JP	NZ,4018H
 EXCSECL	LD	BC,(MIDBUFF)	;middle buffer
 	LD	(EXCSAVE),DE	;save start track/sector
 	PUSH	HL		;save sector counter
 	CALL	MREAD		;multiple read
 	LD	B,H
 	LD	C,L		;remaining count to BC
 	POP	HL
 	SBC	HL,BC
 	PUSH	HL		;pass to alternate set
 	LD	H,B
 	LD	L,C
 	EXX			;save source in alt set.
 	POP	HL		;length just read
 	PUSH	HL		;save again
 	PUSH	DE		;save start of read
 	LD	BC,GATBUFF	;low buffer area
 	CALL	DSETUP
 	JP	NZ,4018H
 	CALL	SWAPDAM		;swap DAM save area
 	CALL	MREAD		;read these now
 	POP	DE		;get back start of read
 	POP	HL		;get sector count
 	LD	BC,(MIDBUFF)	;get other data
 	PUSH	HL		;save counter
 	CALL	SWAPDAM
 	CALL	MWRITE		;write the other data
 	EXX			;swap set back
 	CALL	SSETUP
 	JP	NZ,4018H
 	EX	(SP),HL		;save count
 	LD	DE,0		;get start sector
 EXCSAVE	EQU	$-2
 	LD	BC,GATBUFF
 	CALL	SWAPDAM
 	CALL	MWRITE		;write this back
 	POP	HL		;get counter back
 	LD	A,H
 	OR	L
 	JR	NZ,EXCSECL	;continue if more
 EXCFINISH	CALL	SHOCOUNT
 	RST	8
 	DB	'I/O errors on exchange.',0
 	JP	GOBACK
 SECDATA	RST	8
 	DB	10,'Source.',0
 	CALL	GETDAT
 	CALL	GETBYTE		;start byte
 	CALL	GETBCOUNT	;byte counter
 	EXX			;save here
 	LD	A,(DRIV)
 	LD	(SDRIVE),A	;save source drive
 	RST	8
 	DB	10,'Destination.',0
 	CALL	GETDAT		;drive,track,sector
 	CALL	GETBYTE		;start byte
 	LD	A,(DRIV)
 	LD	(DDRIVE),A	;save destination drive
 	EXX			;save here
 	CALL	INITBAD1	;turn off non-stop
 	CALL	INITCOUNT	;zero the counter
 	CALL	IFSAME		;same diskette?
 	RST	8
 	DB	10,0
 	JP	SECDATL		;go to it
 GETBYTE	RST	8
 	DB	10,0
 GETBYTE1	RST	8
 	DB	'Relative byte ? ',0
 	LD	B,20
 	RST	10H
 	LD	BC,0		;default to 0
 	JR	Z,GETBYTE2
 	CALL	POSHL
 	JR	C,GETBYTE2
 	CALL	VALUE
 	JR	C,GETBYTE1	;bad input
 	JR	NZ,GETBYTE1	;too big
 GETBYTE2	LD	H,B	;high byte must be 0
 	LD	L,C		;hl = byte position
 	RET
 GETBCOUNT	RST	8
 	DB	10,0
 	PUSH	HL		;save byte position
 GETBCOUNT1	RST	8
 	DB	'Byte count ? ',0
 	LD	B,20
 	RST	10H		;get the input
 	LD	BC,256		;default to 1 page
 	JR	Z,GETBCOUNT2
 	CALL	POSHL
 	JR	C,GETBCOUNT2
 	CALL	VALUE
 	JR	C,GETBCOUNT1
 GETBCOUNT2	POP	HL	;restore this
 	RET			;BC = byte count
 IFCLEAR	LD	A,(3840H)	;check for clear key
 	AND	2
 	SCF
 	RET	NZ
 	CCF
 	RET
 SWAPDAM	PUSH	HL
 	PUSH	DE
 	PUSH	BC
 	LD	HL,DAMBUFF
 	LD	DE,DAMBUFF+128
 	LD	B,128
 SWAPDAM0	LD	C,(HL)
 	LD	A,(DE)
 	LD	(HL),A
 	LD	A,C
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	DJNZ	SWAPDAM0
 	POP	BC
 	POP	DE
 	POP	HL
 	RET
 SECDATL	LD	(SBC01),BC	;save byte count
 	LD	(SBC02),BC
 	LD	BC,BUFFER
 	ADD	HL,BC		;HL = rel byte
 	LD	(SHL01),HL	;save relative byte
 	LD	(SHL02),HL
 SECDMORE	CALL	SSETUP
 	JP	NZ,4018H
 	LD	BC,BUFFER
 SECLO	RST	28H
 	JR	NZ,SECLO
 	LD	(SBC03),BC	;save buffer position
 	LD	BC,0		;get byte count
 SBC01	EQU	$-2
 	LD	HL,0		;relative byte
 SHL01	EQU	$-2
 SECLO1	DEC	BC		;byte count-1
 	LD	A,B
 	OR	C		;any more?
 	JR	Z,SECDPUT	;have enough source data
 	INC	L		;bump source position
 	JR	NZ,SECLO1	;finish this sector
 	LD	(SHL01),HL
 	LD	(SHL02),HL
 	CALL	NEXSEC		;next sector
 	JR	C,SECDPUT	;disk end
 	LD	BC,0		;get buffer
 SBC03	EQU	$-2
 	CALL	BUFFEREND
 	JR	NZ,SECLO	;do rest of it
 SECDPUT	EXX
 	CALL	DSETUP
 	JP	NZ,4018H
 	LD	BC,GATBUFF
 	LD	(SDE01),HL	;save relative byte
 PZ013	RST	28H
 	JR	NZ,PZ013
 	LD	BC,0		;get byte count
 SBC02	EQU	$-2
 	PUSH	DE		;save track/sector
 	LD	DE,0		;get relative byte
 SDE01	EQU	$-2
 	LD	HL,GATBUFF	
 	ADD	HL,DE		;point to rel byte
 	EX	DE,HL		;DE => rel byte
 	LD	HL,0		;get source start byte
 SHL02	EQU	$-2
 SHDMOV	LD	A,(HL)		;get a byte
 	LD	(DE),A		;put into dest
 	DEC	BC		;reduce byte count
 	LD	A,B		;any more?
 	OR	C
 	JR	Z,SHDWRT	;put it back
 	INC	E		;bump dest pointer
 	JR	Z,SHDWRT	;write back if end
 	INC	L		;bump source pointer
 	JR	NZ,SHDMOV	;continue if more source
 	PUSH	BC		;check for topmem
 	PUSH	HL
 	POP	BC
 	CALL	BUFFEREND
 	POP	BC		;Z = end of memory
 	JR	NZ,SHDMOV	;do some more
 SHDWRT	LD	(SBC01),BC	;save new byte count
 	LD	(SBC02),BC	;into both places
 	LD	(SHL02),HL	;save new source posit
 	POP	DE		;get track/sector
 	LD	BC,GATBUFF	;where data is
 PER810	RST	30H
 	JR	NZ,PER810
 	CALL	NEXSEC		;point to next sector
 	JR	C,SECDFIN
 	LD	HL,0		;relative byte 0 now
 	EXX
 	LD	BC,(SBC01)
 	LD	A,B
 	OR	C
 	JP	NZ,SECDMORE	;read some more source
 SECDFIN	CALL	SHOCOUNT	;display counter
 	RST	8
 	DB	'I/O errors on transfer.',0
 	JP	GOBACK
 SSETUP	LD	A,(SDRIVE)
 	CALL	SETDRV
 	CALL	SMOUNT
 	JP	DSTAT
 DSETUP	LD	A,(DDRIVE)
 	CALL	SETDRV
 	CALL	DMOUNT
 	JP	DSTAT
