TTU0A  ; ttu0a/asm
 CONFIG	LD	A,9
 	CALL	SETUPS
 	RST	8
 	DB	5,'  ',140,183,'  Configuration  ',187,140,10
 	DB	'    Dual=x, Graphics=x, Locase=x, PGAS=x, Linefeeds=x',10,0
 	LD	BC,0430H
 FIGLP1	LD	A,C
 	LD	(DVSHOW),A
 	RST	8
 	DB	'    x:'
 DVSHOW	DB	'x, Tracks=xxx, Dir=xxx, Step=x, Delay=x/4 sec, WP=x',10
 	DB	'         xxxxle Density, x Sectors/Gran, x Grans/Track, Mx',10,0
 	INC	C
 	DEC	B
 	JP	NZ,FIGLP1
 ASK1	CALL	SHOCONFIG	;display values
 	LD	HL,3C00H+322	;3rd video line display
 	CALL	ASKFIG		;get keyboard input
 	CALL	POSHL		;move HL to input
 	JP	C,ASK3		;nothing more
 	CALL	YESNO		;check for Y or N
 	JR	C,ASK1		;invalid input
 	LD	B,40H		;bit 6
 	JR	Z,ASK1A		;have it
 	LD	B,0
 ASK1A	LD	A,(FLAGA)	;read flag
 	AND	0BFH		;reset bit 6
 	OR	B		;set new condition
 	LD	(FLAGA),A
 	INC	HL
 	CALL	POSHL
 	JR	C,ASK3
 	LD	DE,FLAGB	;point to printer flag
 	CALL	YESNO		;check for Y or N
 	JR	C,ASK1
 	LD	BC,807FH
 	JR	Z,ASK2A
 	LD	B,0
 ASK2A	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO
 	JR	C,ASK1
 	LD	BC,40BFH
 	JR	Z,ASK2B
 	LD	B,0
 ASK2B	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO
 	JR	C,ASK1
 	LD	BC,20DFH
 	JR	Z,ASK2C
 	LD	B,0
 ASK2C	CALL	FIXFLG
 	JR	C,ASK3
 	CALL	YESNO
 	JR	C,ASK1
 	LD	BC,08F7H
 	JR	Z,ASK2E
 	LD	B,0
 ASK2E	CALL	FIXFLG
 ASK3	LD	HL,3C00H+258
 	LD	(TEMP4),HL	;pointer
 	CALL	INITDRVO	;all drives on
 	LD	DE,GETCF
 	LD	BC,4015H	;back to menu
 	JP	DRVCOMM
 GETCF	XOR	A
 	SCF
 	CALL	GETTRK
 	LD	HL,(TEMP4)
 	LD	BC,80H		;move up 2 lines
 	ADD	HL,BC
 	LD	(TEMP4),HL	;put it back
 GETCNF	LD	A,(DRIV)	;get current drive
 	PUSH	AF
 	CALL	SHOCONFIG
 	POP	AF
 	CALL	SETDRV
 	LD	HL,(TEMP4)	;get pointer
 	CALL	ASKFIG		;get response
 	CALL	POSHL		;anything
 	RET	C
 	LD	B,8
 	CP	'='
 	JR	Z,GETCNFA
 	LD	B,0
 	CP	'+'		;active drive?
 	JR	Z,GETCNFA
 	LD	B,80H
 	CP	'-'
 	JR	NZ,GETCNFB+1
 GETCNFA	OR	A
 	CALL	GETTYPEB
 	AND	77H		;remove 7 and 3
 	OR	B
 	SCF
 	CALL	GETTYPEB
 GETCNFB	INC	HL		;bump pointer
 	CALL	POSHL
 	RET	C
 	CALL	CKCONF
 	JR	NZ,GETCNF
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETCNF
 	SCF
 	CALL	GETTKS
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETCNF
 	SCF
 	CALL	GETDIR		;directory track
 	CALL	POSHL
 	RET	C		;no more
 	CALL	VALUE
 	JR	C,GETCNF
 	CP	4		;must be 0-3
 	JR	NC,GETCNF
 	LD	B,A
 	OR	A
 	CALL	GETTYPEB
 	AND	0FCH
 	OR	B
 	SCF
 	CALL	GETTYPEB	;put new step back
 	CALL	POSHL
 	RET	C
 	CALL	VALUE
 	JR	C,GETCNF
 	OR	A
 	JP	Z,GETCNF	;invalid
 	CP	5		;must be 1-4
 	JP	NC,GETCNF
 	AND	3
 	RLCA
 	RLCA
 	RLCA
 	RLCA			;align to bits 5,4
 	LD	B,A		;save here
 	OR	A
 	CALL	GETTYPEB	;carry is clear
 	AND	0CFH		;remove 5,4
 	OR	B
 	SCF
 	CALL	GETTYPEB	;is set now
 	CALL	POSHL		;any more?
 	RET	C		;nope if C
 	CALL	YESNO		;must be yes/no for WP
 	JP	C,GETCNF
 	LD	B,40H
 	JR	Z,GETCNFC
 	LD	B,0
 GETCNFC	OR	A
 	CALL	GETTYPEB
 	AND	0BFH
 	OR	B
 	SCF
 	JP	GETTYPEB	;insert and return
 FIXFLG	LD	A,(DE)		;get the flag
 	AND	C		;remove test bit
 	OR	B		;set if active
 	LD	(DE),A		;put it back
 	INC	HL		;bump pointer
 	JP	POSHL		;check for more
 ASKFIG	PUSH	HL
 	LD	HL,3D02H
 	LD	DE,63
 	LD	B,11
 ASKFIXX	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	ADD	HL,DE
 	DJNZ	ASKFIXX
 	POP	HL
 	LD	(HL),'='
 	INC	HL
 	LD	(HL),'>'
 	LD	HL,3C00H+898
 	LD	(CURSOR),HL	;move cursor to bottom
 	RST	8
 	DB	1EH,'? ',0	;prompt
 	LD	B,40		;length of input
 	RST	10H
 	RET
 YESNO	CALL	UCASE		;convert to upper case
 	CP	'Y'		;test for YES
 	RET	Z		;Z = yes
 	CP	'N'		;test for NO
 	SCF			;carry = bad
 	RET	NZ
 	OR	1
 	RET
 SHOW	PUSH	HL		;show hex and ascii
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;unstacker
 	PUSH	HL
 	LD	A,(FLAGA)
 	SET	2,A		;turn off "alive"
 	LD	(FLAGA),A
 	LD	A,(DISP1)	;show "decrypt"
 	LD	(3C00H+960),A
 	CP	'R'
 	JR	Z,SHRTT
 	CP	'S'
 	JR	Z,SHRTT
 	LD	A,(DISP3)
 	RST	20H
 	LD	(3C00H+961),BC
 	JR	SJRTT
 SHRTT	LD	A,(DISP2)
 	LD	(3C00H+961),A
 	LD	A,(DISP3)
 	CP	8
 	JR	C,SHUGH
 	LD	A,1
 	LD	(DISP3),A
 SHUGH	ADD	A,30H
 	LD	(3C00H+962),A
 SJRTT	LD	IX,(ADDRESS)
 	LD	IY,3C00H+8
 	LD	C,16
 SHOWLP	PUSH	BC
 	PUSH	IY
 	PUSH	IX
 	LD	L,8
 	LD	(IY-1),0AAH
 SHOWPL1	LD	H,2
 SHOWPL	LD	A,'*'
 SHFLG	EQU	$-1
 	CP	':'
 	LD	A,(IX)
 	CALL	Z,ADJBYTE
 	RST	20H
 	LD	(IY),C
 	INC	IY
 	LD	(IY),B
 	INC	IY
 	INC	IX
 	DEC	H
 	JR	NZ,SHOWPL
 	INC	IY
 	DEC	L
 	JR	NZ,SHOWPL1
 	POP	IX
 	LD	B,16
 	LD	(IY-1),95H
 SHOWPP	LD	A,(IX)
 	CALL	M00
 SHCCC	INC	IY
 	INC	IX
 	DJNZ	SHOWPP
 	POP	IY
 	LD	DE,40H
 	ADD	IY,DE
 	POP	BC
 	DEC	C
 	JR	NZ,SHOWLP
 	RET
 HEXCV	LD	B,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	C,A
 	LD	A,B
 	AND	0FH
 	CALL	HEXTST
 	LD	B,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 SHOWST	BIT	7,A
 	JR	Z,BIT6
 	RST	8
 	DB	10,'Drive TIME OUT !',10,0
 BIT6	JR	C,BIT4
 	BIT	6,A
 	JR	Z,BIT5
 	RST	8
 	DB	10,'WRITE PROTECTED Disk !',10,0
 BIT5	BIT	5,A
 	JR	Z,BIT4
 	RST	8
 	DB	10,'HARDWARE Write Fault !',10,0
 BIT4	BIT	4,A
 	JR	Z,BIT3
 	RST	8
 	DB	10,'Sector NOT FOUND !',10,0
 BIT3	BIT	3,A
 	JR	Z,BIT2
 	BIT	4,A
 	JR	Z,DATERR
 	RST	8
 	DB	10,'ID CRC Error !',10,0
 	JR	BIT2
 DATERR	RST	8
 	DB	10,'DATA CRC Error !',10,0
 BIT2	BIT	2,A
 	JR	Z,BIT1Z
 	RST	8
 	DB	10,'DATA LOST !',10,0
 BIT1Z	BIT	1,A
 	RET	Z
 	RST	8
 	DB	10,'Drive DROPPED READY.',10,0
 	RET
 SHOWWH	PUSH	AF
 	PUSH	BC
 	CALL	DRVASC
 	LD	(WHDR),A
 	LD	A,E
 	RST	18H
 	LD	(WHSC),A
 	LD	(WHSC+1),BC
 	LD	A,D
 	RST	18H
 	LD	(WHTR),A
 	LD	(WHTR+1),BC
 	RST	8
 	DB	'Drive '
 WHDR	DB	'x, Track'
 WHTR	DB	'xxx, Sector'
 WHSC	DB	'xxx.',0
 	POP	BC
 	POP	AF
 	RET
 SHOWMODE	LD	A,(MODE)
 	PUSH	BC
 	LD	B,A
 	SLA	A
 	ADD	A,B
 	LD	C,A
 	LD	B,0
 	LD	HL,MODTYP
 	ADD	HL,BC
 	PUSH	DE
 	LD	DE,3C40H
 	LD	BC,3
 	LDIR
 	POP	DE
 	POP	BC
 	RET
 SHOWLF	CALL	SHOWMODE
 	PUSH	BC
 	LD	BC,3
 	PUSH	DE
 	LD	HL,MODDRV
 	LD	A,(TYPE)
 	CP	2
 	PUSH	AF
 	JR	NZ,TYUT
 	LD	HL,MODMEM
 TYUT	LD	DE,3C00H+128
 	PUSH	BC
 	LDIR
 	POP	BC
 	POP	AF
 	JP	Z,SHOWNUMB
 	LD	HL,MODTRK
 	LD	DE,3C00H+256
 	PUSH	BC
 	LDIR
 	POP	BC
 	LD	HL,MODSEC
 	LD	DE,3C00H+384
 	PUSH	BC
 	LDIR
 	LD	A,(WRTYPE)
 	AND	1
 	LD	B,A
 	SLA	A
 	ADD	A,B
 	LD	C,A
 	LD	B,0
 	LD	HL,MODDAT
 	ADD	HL,BC
 	POP	BC
 	PUSH	BC
 	LD	DE,3C00H+576
 	LDIR
 	OR	A
 	CALL	GETTYPEA
 	BIT	7,A
 	LD	A,'S'
 	LD	H,'L'
 	LD	L,'G'
 	JR	Z,HASD
 	LD	A,'D'
 	LD	L,'B'
 HASD	LD	(3C00H+704),A
 	LD	(3C00H+705),HL
 	POP	BC
 	LD	HL,DENMGG
 	LD	DE,3C00H+768
 	LDIR
 	POP	DE
 	CALL	DRVASC
 	LD	(3C00H+193),A
 	LD	A,(SECTOR+1)
 	RST	18H
 	LD	(3C00H+320),A
 	LD	(3C00H+321),BC
 	LD	A,(SECTOR)
 	RST	18H
 	LD	(3C00H+448),A
 	LD	(3C00H+449),BC
 	LD	A,(ADDRESS)
 	LD	IY,3C00H+5
 NBLP	PUSH	AF
 	RST	20H
 	LD	(IY),C
 	LD	(IY+1),B
 	LD	BC,40H
 	ADD	IY,BC
 	POP	AF
 	ADD	A,16
 	JR	NZ,NBLP
 	POP	BC
 	RET
 SHOWNUMB	LD	HL,(ADDRESS)
 	LD	DE,40H
 	LD	IY,3C00H+3
 	LD	A,16
 SHOWNUMBL	PUSH	AF
 	LD	A,H
 	RST	20H
 	LD	(IY),C
 	LD	(IY+1),B
 	LD	A,L
 	RST	20H
 	LD	(IY+2),C
 	LD	(IY+3),B
 	ADD	IY,DE
 	POP	AF
 	LD	BC,10H
 	ADD	HL,BC
 	DEC	A
 	JR	NZ,SHOWNUMBL
 	POP	DE
 	POP	BC
 	RET
 MODTYP	DB	'HEXDECBINOCTASC'
 DENMGG	DB	'DEN'
 MODDRV	DB	'DRV'
 MODMEM	DB	'MEM'
 MODTRK	DB	'TRK'
 MODSEC	DB	'SEC'
 MODDAT	DB	'STDRPT'
 MODIFY	PUSH	HL
 	LD	IX,3C00H+8
 	LD	IY,3C00H+48
 	LD	DE,(ADDRESS)
 	LD	A,8FH
 	LD	(CRTPE),A
 MODWT	PUSH	DE
 	LD	HL,(ADDRESS)
 	EX	DE,HL
 	OR	A
 	SBC	HL,DE
 	LD	A,L
 	LD	(TEMP2),A
 	PUSH	BC
 	RST	20H
 	LD	(3C00H),BC
 	LD	A,5DH
 	LD	(3C00H+2),A
 	POP	BC
 	POP	DE
 MODWTXXX	LD	A,(CRTPE)
 	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 MOXLX	LD	A,12
 	LD	(MODCT),A
 MODLP	CALL	INKEY
 	JR	NZ,MODGOT
 	LD	A,0
 MODCT	EQU	$-1
 	DEC	A
 	LD	(MODCT),A
 	JR	NZ,MODLP
 	LD	A,0
 CRTPE	EQU	$-1
 	CP	(IX)
 	JR	NZ,MODWTXXX
 	CALL	MODFIX
 	JR	MOXLX
 MODFIX	LD	A,(SHFLG)
 	CP	':'
 	LD	A,(DE)
 	CALL	Z,ADJBYTE
 	RST	20H
 	LD	(IX),C
 	LD	(IX+1),B
 	LD	A,(DE)
 M00	CALL	ADJBYTE
 	CP	20H
 	JR	NC,N000
 	LD	A,'.'
 N000	LD	(IY),A
 	CP	(IY)
 	RET	Z
 	SUB	20H
 	LD	(IY),A
 	RET
 MODGOT	PUSH	AF
 	CALL	MODFIX
 	POP	AF
 	EX	DE,HL
 	LD	DE,MODWT
 	PUSH	DE
 	PUSH	AF
 	LD	A,(MODE)
 	CP	4
 	JR	Z,MODCONT
 	POP	AF
 	CP	'P'
 	JP	Z,FILLBYTES
 	CP	'G'
 	JP	Z,GOBYTE
 	CP	'p'
 	JP	Z,FILLBYTES
 	CP	'g'
 	JP	Z,GOBYTE
 	CP	'l'
 	JP	Z,FINDBYTE
 	CP	'L'
 	JP	Z,FINDBYTE
 	PUSH	AF
 MODCONT	POP	AF
 	LD	DE,MODTBL
 	CALL	GOTABL
 	JP	NUMBER
 MODTBL	DB	5DH
 	DW	MODL
 	DB	'>'
 	DW	INSBYTE
 	DB	'<'
 	DW	DELBYTE
 	DB	5EH
 	DW	MODR
 	DB	5BH
 	DW	MODU
 	DB	5CH
 	DW	MODD
 	DB	19H
 	DW	MODRE
 	DB	18H
 	DW	MODLE
 	DB	1AH
 	DW	MODDE
 	DB	1BH
 	DW	MODUE
 	DB	3
 	DW	MODTOP
 	DB	13
 	DW	UPDATE
 	DB	14
 	DW	CHWT
 	DB	0
 BLKS	DB	8FH,8FH,8FH
 CHWT	EX	DE,HL
 CHWT1	LD	HL,BLKS
 CHWT2	PUSH	DE
 	LD	DE,3C40H
 	LD	BC,3
 	LDIR
 	POP	DE
 	LD	A,12
 	LD	(CHWT4),A
 CHWT3	CALL	INKEY
 	JR	NZ,CHWT5
 	LD	A,0
 CHWT4	EQU	$-1
 	DEC	A
 	LD	(CHWT4),A
 	JR	NZ,CHWT3
 	LD	A,(3C40H)
 	CP	8FH
 	JR	NZ,CHWT1
 	LD	HL,SPACES
 	JR	CHWT2
 CHWT5	CALL	UCASE
 	CP	'H'
 	LD	B,0
 	JR	Z,CHAVE
 	INC	B
 	CP	'D'
 	JR	Z,CHAVE
 	INC	B
 	CP	'B'
 	JR	Z,CHAVE
 	INC	B
 	CP	'O'
 	JR	Z,CHAVE
 	INC	B
 	CP	'A'
 	JR	NZ,CHAVE1
 CHAVE	LD	A,B
 	LD	(MODE),A
 CHAVE1	JP	SHOWMODE
 DECODE	PUSH	HL
 	LD	HL,DECTXT
 	LD	DE,3C00H+768
 	LD	BC,4
 	LDIR
 	JR	DECOKG
 DECBAD	LD	HL,DECBTXT
 	LD	DE,3C00H+896
 	LD	BC,4
 	LDIR
 	LD	A,'+'
 	LD	(DISP1),A
 	LD	A,20H
 	LD	(DISP2),A
 	XOR	A
 	LD	(DISP3),A
 DECOKG	LD	HL,3C00H+832
 	LD	(CURSOR),HL
 	LD	B,16
 	RST	10H
 	PUSH	HL
 	EX	AF,AF'
 	LD	HL,SPACES
 	LD	BC,16
 	PUSH	HL
 	PUSH	BC
 	LD	DE,3C00H+832
 	LDIR
 	POP	BC
 	POP	HL
 	LD	DE,3C00H+896
 	LDIR
 	POP	HL
 	EX	AF,AF'
 	JR	Z,MNOTH
 	CALL	UCASE
 	CP	'!'
 	JP	Z,PERMDEC
 	CP	':'
 	CALL	Z,SETDEC
 	CP	'*'
 	CALL	Z,SETDEC
 	CP	5BH
 	JP	Z,DECCUP
 	CP	5CH
 	JP	Z,DECCDN
 	CP	'A'
 	JR	Z,DOAND
 	CP	'O'
 	JR	Z,DOAND
 	CP	'X'
 	JR	Z,DOAND
 	CP	'R'
 	JR	Z,DOROT
 	CP	'S'
 	JR	Z,DOROT
 	CP	'+'
 	JR	Z,MEXEX
 	CP	'-'
 	JR	NZ,MEXXE
 MEXEX	LD	(DISP1),A
 	INC	HL
 MEXXE	CALL	VALUE
 	JR	C,DECBAD
 	LD	(DISP3),A
 MDONEY	LD	A,20H
 	LD	(DISP2),A
 MDONE	LD	HL,SPACES
 	LD	DE,3C00H+768
 	LD	BC,16
 	LDIR
 	POP	DE
 	JP	RETMOD
 MNOTH	LD	A,'+'
 	LD	(DISP1),A
 	XOR	A
 	LD	(DISP3),A
 	LD	A,'*'
 	LD	(SHFLG),A
 	JR	MDONEY
 DOAND	LD	(DISP1),A
 	INC	HL
 	CALL	VALUE
 	JP	C,DECBAD
 	LD	(DISP3),A
 	JR	MDONEY
 DOROT	LD	(DISP1),A
 	INC	HL
 	LD	A,(HL)
 	CALL	UCASE
 	CP	'R'
 	JR	Z,DOROT1
 	CP	'L'
 	JP	NZ,DECBAD
 DOROT1	LD	(DISP2),A
 	INC	HL
 	CALL	VALUE
 	JP	C,DECBAD
 	CP	8
 	JP	NC,DECBAD
 	LD	(DISP3),A
 	JR	MDONE
 FGST	CALL	SHOWLF
 	LD	A,(DISP1)
 	LD	B,8
 	CP	'R'
 	RET	Z
 	CP	'S'
 	RET	Z
 	LD	B,0
 	RET
 GFST	LD	A,(DISP3)
 	ADD	A,C
 	CP	B
 	LD	(DISP3),A
 	RET
 SETDEC	LD	(SHFLG),A
 	INC	HL
 	CALL	POSHL
 	RET	NC
 	POP	HL
 	JP	MDONE
 DECCUP	CALL	GCOUNT
 	JP	C,DECBAD
 	CALL	FGST
 	LD	C,1
 DECCUP1	PUSH	BC
 	CALL	SHOW
 	CALL	DOSPEED
 	POP	BC
 	CALL	GFST
 	JR	NZ,DECCUP1
 	JP	MDONE
 DECCDN	CALL	GCOUNT
 	JP	C,DECBAD
 	POP	DE
 	PUSH	DE
 	CALL	FGST
 	LD	BC,0FFH
 DECCDN1	PUSH	BC
 	CALL	SHOW
 	CALL	DOSPEED
 	POP	BC
 	CALL	GFST
 	JR	NZ,DECCDN1
 	JP	MDONE
 GCOUNT	INC	HL
 	LD	BC,8000H
 	CALL	POSHL
 	JR	C,GCOUNT1
 	CALL	VALUE
 	RET	C
 	LD	B,C
 	LD	C,0
 GCOUNT1	LD	(DLYCNT),BC
 	OR	A
 	RET
 DOSPEED	LD	BC,0
 DLYCNT	EQU	$-2
 	CALL	DELAY
 	CALL	PAUSE
 	LD	A,(3801H)
 	BIT	0,A
 	RET	Z
 	POP	DE
 	JP	MDONE
 DECBTXT	DB	'ERR '
 DECTXT	DB	'DCR '
 PERMDEC	LD	HL,(ADDRESS)
 	LD	B,0
 PERMLXP	LD	A,(HL)
 	CALL	ADJBYTE
 	LD	(HL),A
 	INC	HL
 	DJNZ	PERMLXP
 	JP	MNOTH
 MODR	EX	DE,HL
 	CALL	MODRX
 	RET	NC
 	CALL	MODDX
 	JR	NC,MODLE+1
 MODRCONT	LD	A,(TYPE)
 	CP	2
 	SCF
 	RET	NZ
 	LD	HL,(ADDRESS)
 	LD	BC,16
 	ADD	HL,BC
 	LD	(ADDRESS),HL
 	EX	DE,HL
 	ADD	HL,BC
 	EX	DE,HL
 	CALL	AASHOW
 	JP	MODLE+1
 MODTOP	EX	DE,HL
 	LD	A,(TEMP2)
 	LD	B,A
 	OR	A
 	RET	Z
 MODTOPL	PUSH	BC
 	CALL	MODL+1
 	POP	BC
 	DJNZ	MODTOPL
 	RET
 MODRX	PUSH	IX
 	POP	HL
 	LD	A,L
 	AND	3FH
 	CP	2DH
 	SCF
 	RET	Z
 	INC	IX
 	INC	IX
 	INC	IY
 	INC	DE
 	LD	A,(IX)
 	CP	20H
 	SCF
 	CCF
 	RET	NZ
 	INC	IX
 	RET
 MODRE	EX	DE,HL
 	LD	A,16
 MODREX	EX	AF,AF'
 	CALL	MODRX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODREX
 	RET
 MODL	EX	DE,HL
 	CALL	MODLX
 	RET	NC
 	CALL	MODUX
 	JR	NC,MODRE+1
 MODLCONT	LD	A,(TYPE)
 	CP	2
 	SCF
 	RET	NZ
 	LD	HL,(ADDRESS)
 	LD	BC,16
 	OR	A
 	SBC	HL,BC
 	LD	(ADDRESS),HL
 	EX	DE,HL
 	OR	A
 	SBC	HL,BC
 	EX	DE,HL
 	CALL	AASHOW
 	JP	MODRE+1
 MODLE	EX	DE,HL
 	LD	A,16
 MODLEX	EX	AF,AF'
 	CALL	MODLX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODLEX
 	RET
 MODLX	PUSH	IX
 	POP	HL
 	LD	A,L
 	AND	3FH
 	CP	8
 	SCF
 	RET	Z
 	DEC	IX
 	DEC	IX
 	DEC	IY
 	DEC	DE
 	LD	A,(IX+1)
 	CP	20H
 	SCF
 	CCF
 	RET	NZ
 	DEC	IX
 	RET
 MODU	EX	DE,HL
 	CALL	MODUX
 	RET	NC
 	JP	MODLCONT
 MODUE	EX	DE,HL
 	LD	A,16
 MODUEX	EX	AF,AF'
 	CALL	MODUX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODUEX
 	RET
 MODUX	PUSH	IX
 	POP	HL
 	LD	BC,-40H
 	ADD	HL,BC
 	LD	A,H
 	CP	3CH
 	JR	C,MY
 	PUSH	HL
 	POP	IX
 	EX	DE,HL
 	LD	DE,-16
 	ADD	HL,DE
 	EX	DE,HL
 	PUSH	IY
 	POP	HL
 	LD	BC,-40H
 	ADD	HL,BC
 	PUSH	HL
 	POP	IY
 	OR	A
 	RET
 MODD	EX	DE,HL
 	CALL	MODDX
 	RET	NC
 	JP	MODRCONT
 MODDE	EX	DE,HL
 	LD	A,16
 MODDEX	EX	AF,AF'
 	CALL	MODDX
 	EX	AF,AF'
 	DEC	A
 	JR	NZ,MODDEX
 	RET
 MODDX	PUSH	IX
 	POP	HL
 	LD	BC,40H
 	ADD	HL,BC
 	LD	A,H
 	CP	40H
 	CCF
 	RET	C
 	PUSH	HL
 	POP	IX
 	EX	DE,HL
 	LD	DE,16
 	ADD	HL,DE
 	EX	DE,HL
 	PUSH	IY
 	POP	HL
 	LD	BC,40H
 	ADD	HL,BC
 	PUSH	HL
 	POP	IY
 	OR	A
 	RET
 MY	SCF
 	RET
 UPDATE	LD	A,(TYPE)
 	CP	2
 	JP	Z,RETMODM
 UPDATE1	RST	8
 	DB	5,'U>pdate, R>eturn to modify, C>ancel ? ',0
 	LD	B,1
 	RST	10H
 	RST	8
 	DB	1EH,0
 	JR	Z,PUTDATA
 	CALL	UCASE
 	CP	'U'
 	JR	Z,PUTDATA
 	CP	'R'
 	JR	Z,BAKMOD
 	CP	'C'
 	JR	NZ,UPDATE1
 	POP	DE
 	POP	DE
 REREAD	RST	8
 	DB	6,0
 	LD	A,(TYPE)
 	CP	1
 	LD	DE,(SECTOR)
 	JP	Z,DISKLP
 	CP	3
 	JP	Z,FILECT
 RETMOD	LD	A,(TYPE)
 	CP	1
 	JP	Z,DISCON
 	CP	2
 	JP	Z,DISMCON
 	CP	3
 	JP	Z,DFILELP
 	JP	DISKLP
 RETMODM	POP	DE
 	JP	DISRETM
 BAKMOD	RST	8
 	DB	6,0
 	POP	HL
 	EXX
 	POP	DE
 	EXX
 	CALL	AASHOW
 	EXX
 	PUSH	DE
 	EXX
 	JP	(HL)
 PUTDATA	LD	BC,(ADDRESS)
 	POP	HL
 	POP	DE
 	CALL	INITBAD
 	CALL	INITBAD1
 RT1	CALL	DSTAT
 	JP	NZ,4018H
 	CALL	WRITE
 	JR	Z,KUQP
 	CALL	NZ,BADWRT
 	JR	NZ,RT1
 KUQP	RST	8
 	DB	6,0
 	JP	REREAD
 BADRDCLS	LD	HL,BADRD
 	JR	BADWRTCLS+3
 BADWRTCLS	LD	HL,BADWRT
 	LD	(BADCLSD),HL
 	PUSH	AF
 	LD	A,(FLAGA)
 	RES	2,A
 	LD	(FLAGA),A
 	POP	AF
 	RST	8
 	DB	5,0
 	CALL	0
 BADCLSD	EQU	$-2
 	RST	8
 	DB	6,0
 	RET
 BADRD	NOP
 	RST	8
 	DB	10,10,'Disk READ ERROR !',10,0
 	SCF
 	JR	RWCNT1
 BADWRT	NOP
 	RST	8
 	DB	10,10,'Disk WRITE ERROR !',10,0
 	OR	A
 RWCNT1	PUSH	AF
 	CALL	SHOWWH
 	POP	AF
 	CALL	SHOWST
 	LD	A,(3840H)
 	AND	2
 	JR	Z,RWCNT
 	XOR	A
 	LD	(BWRTCPT),A
 	LD	(NONSTP),A
 RWCNT	OR	1
 BWRTCPT	NOP
 NONSTP	NOP
 RETRY	RST	8
 	DB	1EH,'R>etry, S>kip, C>ontinuous, N>onstop, Q>uit ? ',0
 	PUSH	BC
 	LD	B,1
 	PUSH	HL
 	RST	10H
 	POP	HL
 	POP	BC
 	JR	NZ,RETRY1
 	LD	A,'R'
 RETRY1	CALL	UCASE
 	CP	'S'
 	JR	Z,DOSKIP
 	CP	'R'
 	JR	Z,DORETRY
 	CP	'N'
 	JR	Z,NOSPT
 	CP	'Q'
 	JP	Z,4018H
 	CP	'C'
 	JR	NZ,RETRY
 	LD	A,0C9H
 	LD	(BWRTCPT),A
 DORETRY	OR	1
 	RST	8
 	DB	10,0
 	RET
 NOSPT	LD	A,0C9H
 	LD	(NONSTP),A
 	JR	DORETRY
 DOSKIP	INC	B
 	XOR	A
 	SCF
 	JR	DORETRY+2
 INITBAD	XOR	A
 	LD	(BWRTCPT),A
 	RET
 INITBAD1	XOR	A
 	LD	(NONSTP),A
 INITBAD3	LD	(BADRD),A
 	LD	(BADWRT),A
 	RET
 INITBAD2	LD	A,0C9H
 	JR	INITBAD3
 NUMBER	EX	DE,HL
 	PUSH	AF
 	LD	A,(MODE)
 	CP	4
 	JR	Z,ASCNUM
 	LD	HL,MODELN
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)
 	INC	HL
 	LD	C,(HL)
 	POP	AF
 	LD	HL,STRING
 	JR	NUMHAV
 MODELN	DB	2,'H'
 	DB	3,'D'
 	DB	8,'B'
 	DB	3,'O'
 	DB	1,'A'
 ASCNUM	POP	AF
 NUMRET	LD	(DE),A
 	CALL	MODFIX
 	JP	MODR+1
 NUMON	LD	A,0B0H
 NUMOFF	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 	LD	A,12
 	LD	(NUMCNT),A
 NUMBLP	CALL	INKEY
 	JR	NZ,NUMBHV
 	LD	A,0
 NUMCNT	EQU	$-1
 	DEC	A
 	LD	(NUMCNT),A
 	JR	NZ,NUMBLP
 	LD	A,(IX)
 	CP	0B0H
 	JR	NZ,NUMON
 	LD	A,20H
 	JR	NUMOFF
 NUMBHV	CALL	UCASE
 	CP	13
 	JR	Z,DECNUM
 	CP	30H
 	RET	C
 	CP	3AH
 	JR	C,NUMHAV
 	CP	'A'
 	RET	C
 	CP	'G'
 	RET	NC
 NUMHAV	LD	(HL),A
 	INC	HL
 	DJNZ	NUMON
 DECNUM	LD	(HL),C
 	INC	HL
 	LD	(HL),13
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C
 	RET	NZ
 	JR	NUMRET
 ADJBYTE	EX	AF,AF'
 	PUSH	BC
 	LD	A,(DISP3)
 	LD	B,A
 	LD	A,(DISP2)
 	LD	C,A
 	LD	A,(DISP1)
 	CP	'+'
 	JR	Z,SHODIS
 	CP	'-'
 	JR	Z,SHODISM
 	CP	'A'
 	JR	Z,EFAND
 	CP	'O'
 	JR	Z,EFOR
 	CP	'X'
 	JR	Z,EFXOR
 	CP	'R'
 	JR	Z,EFROT
 	CP	'S'
 	JR	Z,EFSHIFF
 	EX	AF,AF'
 ADJF	POP	BC
 	RET
 EFSHIFF	LD	A,C
 	LD	C,27H
 	CP	'L'
 	JR	Z,SIT
 	LD	C,2FH
 	JR	SIT
 EFROT	LD	A,C
 	LD	C,7
 	CP	'L'
 	JR	Z,SIT
 	LD	C,0FH
 SIT	LD	A,C
 	LD	(COMB2),A
 	EX	AF,AF'
 COMB1	DB	0CBH
 COMB2	DB	0
 	DJNZ	COMB1
 	JR	ADJF
 SHODIS	EX	AF,AF'
 	ADD	A,B		;add 'em
 	JR	ADJF
 SHODISM	EX	AF,AF'		;original
 	SUB	B		;subtract 'em
 	JR	ADJF
 EFAND	EX	AF,AF'
 	AND	B
 	JR	ADJF
 EFOR	EX	AF,AF'
 	OR	B
 	JR	ADJF
 EFXOR	EX	AF,AF'
 	XOR	B
 	JR	ADJF
 CKCONF	CALL	UCASE
 	CP	'S'
 	JR	Z,SNGCON
 	CP	'D'
 	RET	NZ
 	CALL	GETTYPEA
 	SET	7,A		;double density
 	JR	CONFSCM		;finish up
 	RET
 SNGCON	CALL	GETTYPEA
 	RES	7,A		;single density
 CONFSCM	SCF			;put back in table
 	CALL	GETTYPEA	;do it
 	INC	HL		;next character
 	XOR	A		;set Z flag
 	RET
 FINDBYTE	CALL	CHMODTYPE
 	INC	HL		;bumped each loop
 FBON	LD	A,191		;big block
 	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 FBOFF	LD	A,12
 	LD	(FBCOUNT),A
 FBLP	CALL	INKEY		;check keyboard
 	JR	NZ,FBHAV
 	LD	A,0
 FBCOUNT	EQU	$-1
 	DEC	A
 	LD	(FBCOUNT),A
 	JR	NZ,FBLP
 	LD	A,(IX)
 	CP	191
 	JR	NZ,FBON
 	PUSH	HL
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	HL
 	JR	FBOFF
 FBHAV	PUSH	AF		;save key
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	AF
 	CP	'L'
 	JP	Z,LASTBYTE	;use last byte
 	CP	'l'
 	JP	Z,LASTBYTE
 	LD	(HL),A		;else put in buffer
 	CP	13
 	DEC	HL
 	JR	Z,FBDECN
 	INC	HL
 	DJNZ	FBON-1
 FBDECN	LD	A,(MODE)	;ascii ?
 	CP	4
 	LD	A,(HL)
 	JR	Z,FBGO
 	INC	HL		;point to next byte
 	LD	(HL),C		;else put in term.
 	INC	HL
 	LD	(HL),13
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C		;bad input
 	RET	NZ		;too big
 FBGO	PUSH	AF		;save character
 	CALL	MODFIX		;cursors off
 	POP	AF
 	LD	(LASTB),A	;save this byte
 	LD	C,A		;save byte in C
 	LD	A,(TEMP2)	;get position
 	LD	B,A
 	CP	0FFH
 	RET	Z		;at end already
 	XOR	A
 	SUB	B
 	DEC	A
 	LD	B,A
 FIGO1	PUSH	BC		;save counter
 	CALL	MODR+1		;check next char
 	POP	BC
 	LD	A,(DE)		;get buffer byte
 	CP	C		;same as one wanted?
 	RET	Z		;yep
 	DJNZ	FIGO1		;else continue
 	RET			;done
 LASTBYTE	LD	A,(LASTB)	;get last one
 	JR	FBGO		;find it
 AASHOW	PUSH	IX
 	PUSH	IY
 	EXX
 	CALL	SHOW
 	CALL	SHOWLF
 	EXX
 	POP	IY
 	POP	IX
 	RET
 INSBYTE	PUSH	HL		;HL=> buffer posit
 	EX	DE,HL		;to DE
 	LD	HL,(ADDRESS)	;start of buffer
 	DEC	L		;end of buffer
 	OR	A		;clear carry
 	SBC	HL,DE		;HL=length
 	LD	B,H		;give to BC
 	LD	C,L
 	LD	HL,(ADDRESS)
 	DEC	L
 INSDOIT0	LD	D,H
 	LD	E,L
 	DEC	HL
 	LDDR
 	POP	HL
 	LD	(HL),0
 	EX	DE,HL
 	JP	AASHOW
 DELBYTE	PUSH	HL
 	EX	DE,HL
 	LD	HL,(ADDRESS)
 	DEC	L
 	OR	A
 	SBC	HL,DE
 	LD	B,H
 	LD	C,L
 	POP	HL
 	PUSH	HL
 	LD	D,H
 	LD	E,L
 	INC	HL
 	PUSH	AF
 	LDIR
 	POP	AF
 	POP	DE
 	JP	NZ,AASHOW
 	LD	HL,(ADDRESS)
 	DEC	L
 	LD	(HL),0
 	JP	AASHOW
 FILLBYTES	EX	DE,HL
 	LD	HL,MODELN
 	LD	A,(MODE)
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)
 	INC	HL
 	LD	C,(HL)
 	LD	HL,STRING-1
 	INC	HL
 FILLON	LD	A,0B3H
 	PUSH	HL
 	LD	HL,0B7BBH
 	LD	(IX),H
 	LD	(IX+1),L
 	POP	HL
 	LD	(IY),A
 FILLOFF	LD	A,12
 	LD	(FLXXCOUNT),A
 FLBLP	CALL	INKEY
 	JR	NZ,FLBHAV
 	LD	A,0
 FLXXCOUNT	EQU	$-1
 	DEC	A
 	LD	(FLXXCOUNT),A
 	JR	NZ,FLBLP
 	LD	A,(IY)
 	CP	0B3H
 	JR	NZ,FILLON
 	PUSH	HL
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	HL
 	JR	FILLOFF
 FLBHAV	PUSH	AF
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	AF
 	LD	(HL),A
 	CP	13
 	DEC	HL
 	JR	Z,FLBDECDN
 	INC	HL
 	DJNZ	FILLON-1
 FLBDECDN	LD	A,(MODE)
 	CP	4
 	LD	A,(HL)
 	JR	Z,FLGBO
 	INC	HL
 	LD	(HL),C
 	INC	HL
 	LD	(HL),13
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C
 	RET	NZ
 	OR	A
 	RET	Z
 FLGBO	PUSH	AF
 	CALL	MODFIX
 	POP	AF
 	LD	C,A
 	LD	B,0
 	PUSH	DE
 	EX	DE,HL
 	LD	D,H
 	LD	E,L
 	INC	DE
 	LDIR
 	POP	DE
 	JP	AASHOW		;redisplay and return
 CHMODTYPE	EX	DE,HL	;DE=> buffer
 	LD	HL,MODELN	;length of input
 	LD	A,(MODE)
 	SLA	A
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	LD	B,(HL)		;keys to be input
 	INC	HL
 	LD	C,(HL)		;ascii terminator
 	LD	HL,STRING-1	;input buffer
 	RET			;done
 GOBYTE	CALL	CHMODTYPE	;setup
 	INC	HL
 GOBON	LD	A,5BH		;start cursor
 GOBOFF	LD	(IX),A
 	LD	(IX+1),A
 	LD	(IY),A
 	LD	A,5
 	LD	(GOBCOUNT),A
 GBLP	CALL	INKEY
 	JR	NZ,GOBHAV
 	LD	A,0
 GOBCOUNT	EQU	$-1
 	DEC	A
 	LD	(GOBCOUNT),A
 	JR	NZ,GBLP
 	LD	A,(IX)
 	INC	A
 	CP	5FH
 	JR	C,GOBOFF
 	JR	GOBON
 GOBHAV	PUSH	AF
 	PUSH	BC
 	CALL	MODFIX
 	POP	BC
 	POP	AF
 	LD	(HL),A
 	CP	13
 	JR	Z,GOBDECN+1
 	CP	'L'
 	JR	Z,GOBLST
 	CP	'l'
 	JR	Z,GOBLST
 	DJNZ	GOBON-1
 GOBDECN	INC	HL
 	LD	(HL),C		;put number base
 	INC	HL
 	LD	(HL),13		;put terminator
 	LD	HL,STRING
 	PUSH	IX
 	CALL	VALUE
 	POP	IX
 	RET	C
 	RET	NZ		;too big
 GOBGO	PUSH	AF
 	CALL	MODFIX
 	POP	AF
 	LD	IX,3C00H+8
 	LD	IY,3C00H+48
 	LD	DE,(ADDRESS)
 	LD	C,A		;counter
 	LD	(GBLST),A
 	OR	A		;check if at 0
 	RET	Z		;done
 GOBGO1	PUSH	BC
 	CALL	MODR+1		;move right 1 space
 	POP	BC
 	DEC	C
 	JR	NZ,GOBGO1
 	RET			;done
 GOBLST	LD	A,0
 GBLST	EQU	$-1
 	JR	GOBGO
 CKTRAKS	LD	A,(HL)
 	CP	'='
 	SCF
 	CCF
 	RET	NZ
 	INC	HL
 	CALL	VALUE
 	RET	C
 	SCF
 	RET	NZ
 	CALL	GETTKS		;setup tracks
 	XOR	A
 	RET
