TTU0   ; ttu0/asm
 KIMCHK	DB	'K'+80H,'i'+80H,'m'+80H,' '+80H
 	DB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
 READ	LD	HL,READ1	;where to go
 	JR	WRITE+3		;go common
 WRITE	LD	HL,WRITE1
 	LD	(RWRTCALL),HL	;put into code
 	LD	A,4		;retries
 	LD	(RETRC),A	;put into counter byte
 RWLOOP	PUSH	BC		;save load address
 ;i*
 	IF	MODI
 	CALL	SELDEN
 	ENDIF
 ;
 	CALL	0		;call read/write
 RWRTCALL	EQU	$-2
 	POP	HL		;get load address
 	RET	Z		;return if OK
 	BIT	4,A		;not found error?
 	PUSH	AF		;save error
 	CALL	NZ,FLIPDEN	;toggle density
 	POP	AF
 	EX	AF,AF'		;save error
 	LD	A,0D0H		;force interrupt
 ;i*
 	IF	MODI
 	LD	(37ECH),A
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F0H),A
 	ENDIF
 ;
 	LD	B,H		;restore load address
 	LD	C,L
 	LD	A,0		;get retry count
 RETRC	EQU	$-1
 	DEC	A
 	LD	(RETRC),A	;put it back
 	JR	NZ,RWLOOP	;try again
 	EX	AF,AF'		;get error back
 	RET
 FLIPDEN	OR	A		;clear carry flag
 	CALL	GETTYPEA	;get drive type
 	XOR	80H		;reverse density
 	SCF			;put back in table
 	JP	GETTYPEA
 READ1	CALL	SEEK		;move the head to track
 	RET	NZ		;bad
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to I fdc
 	CALL	SELECT		;turn on drive
 	RET	NZ		;not in system
 	DI			;can't be interrupted
 	LD	(HL),88H	;give read command to FDC
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;data transfer address
 	CALL	RXFER		;transfer the data
 	POP	DE		;restore track/sector
 	ENDIF
 ;iii*
 	IF	MODIII
 	CALL	SELECT		;activate drive
 	RET	NZ		;deactivated
 	CALL	SETNMI		;setup NMI return
 	LD	A,80H		;get read type
 	OUT	(0F0H),A	;give to FDC
 	CALL	RXFER		;transfer the bytes
 	ENDIF
 ;
 	PUSH	AF		;save result
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	1
 ;i*
 	IF	MODI
 	OR	0A8H		;make write command
 	ENDIF
 ;iii*
 	IF	MODIII
 	OR	0A0H
 	ENDIF
 ;
 	LD	(WRTYPE),A	;that will produce the
 	EX	AF,AF'		;pass it here
 	POP	AF		;put write byte in af'
 	AND	9FH		;check for error
 	RET
 IOCOMM	PUSH	AF		;save it
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get track
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;III track register
 	ENDIF
 ;
 	SCF			;carry = put in table
 	CALL	GETTRK		;save current track
 	POP	AF		;restore result
 	RET			;done
 WRITE1	CALL	SEEK		;move head
 	RET	NZ		;error occured
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;turn on drive
 	RET	NZ		;not in system
 ;i*
 	IF	MODI
 	LD	A,(HL)		;read I status
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;read III status
 	ENDIF
 ;
 	AND	40H		;write protected?
 	RET	NZ		;error if yes
 	CALL	GETTYPEB	;check for soft WP
 	AND	40H		;bit 6 has it
 	RET	NZ		;return with error
 ;i*
 	IF	MODI
 	DI			;can't interrupt this
 	LD	(HL),0A8H	;give write command
 WRTYPE	EQU	$-1
 	PUSH	DE		;save track/sector
 	LD	DE,37EFH	;FDC transfer addr.
 	CALL	WXFER		;write data to the disk
 	POP	DE		;restore track/sec
 	ENDIF
 ;iii*
 	IF	MODIII
 	CALL	SETNMI		;setup NMI return
 	LD	A,0A0H		;write type
 WRTYPE	EQU	$-1
 	OUT	(0F0H),A	;give to FDC
 	CALL	WXFER		;transfer the bytes
 	ENDIF
 ;
 	AND	0FFH		;check for error
 	RET
 SEEK
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;point to FDC
 	RET	NZ
 	CALL	GETTRK		;get track from table
 	JR	NZ,SEKCNT	;continue if not
 	CALL	RESTORE		;restore disk drive
 	RET	NZ		;not in system
 	XOR	A		;set track 0
 ;i*
 	IF	MODI
 SEKCNT	LD	(37EDH),A	;give to FDC track
 	LD	A,D		;desired track
 	CALL	SEEKWHAT	;check for double step
 	LD	(37EFH),A	;give to FDC
 	LD	A,E		;get sector
 	LD	(37EEH),A	;give to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 SEKCNT	OUT	(0F1H),A	;give current track
 	LD	A,D		;get track desired
 	CALL	SEEKWHAT	;check for double step
 	OUT	(0F3H),A	;give to FDC
 	LD	A,E		;get sector
 	OUT	(0F2H),A	;give to FDC
 	ENDIF
 ;
 	JP	DOSEEK		;seek the track
 SELECT	OR	A		;clear carry
 	CALL	GETTYPEB	;check if active
 	AND	80H		;active ?
 	RET	NZ		;skip it
 SELLOOP
 ;i*
 	IF	MODI
 	LD	A,(37ECH)	;read FDC status
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;FDC Mod III
 	ENDIF
 ;
 	AND	80H		;motor on now?
 	LD	A,0		;get bit pattern
 DRIVE	EQU	$-1
 ;i*
 	IF	MODI
 	LD	(37E1H),A	;give to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F4H),A	;FDC III
 	ENDIF
 ;
 	RET	Z		;return if motor on
 	PUSH	BC		;save from decrement
 	CALL	GETTYPEB	;carry cleared
 	RLCA			;move bits 5,4
 	RLCA			;to 7,6
 	AND	0C0H		;top 2 bits only
 	LD	B,A		;give to B for count
 	LD	C,0		;zero the LSB
 	CALL	DELAY		;countdown till BC=0
 	POP	BC		;restore this
 	JR	SELLOOP		;re-select
 DSKSLO	EX	(SP),HL		;short delay to allow
 	EX	(SP),HL		;the FDC to present a
 	EX	(SP),HL		;valid status byte
 	EX	(SP),HL		;after a command has
 	EX	(SP),HL		;been issued
 	EX	(SP),HL
 	RET
 DELAY	PUSH	AF		;save from use
 DELAYX	DEC	BC		;decrement the count
 	LD	A,B		;any bits on?
 	OR	C
 	JR	NZ,DELAYX	;continue if yes
 	POP	AF
 	RET
 GETTRK	PUSH	HL		;save all registers
 	LD	HL,TRACK	;current track
 	JR	GETCOMM		;go common
 GETDIR	JR	C,GETDIR0	;put in table
 	CALL	GETTYPEA	;carry is clear
 	BIT	7,A		;double den?
 	LD	A,10		;10 sectors single den
 	PUSH	AF		;save flags
 	CALL	GETDIR0		;get directory track
 	LD	D,A		;give to DE
 	LD	E,0		;starting sector 0
 	POP	AF		;get result back
 	RET	Z		;got it all
 	LD	E,1		;first sector III
 	LD	A,18		;sector count dir
 	RET
 GETDIR0	PUSH	HL
 	LD	HL,DIRTRK	;directory trak table
 	JR	GETCOMM
 GETTYPEA	PUSH	HL
 	LD	HL,TYPEA
 	JR	GETCOMM
 GETTYPEB	PUSH	HL
 	LD	HL,TYPEB
 	JR	GETCOMM
 GETTKS	PUSH	HL
 	LD	HL,TRACKS
 GETCOMM	PUSH	AF		;save carry flag
 	LD	A,0		;get binary drive
 DRIV	EQU	$-1
 	AND	3		;drives 0-3 only
 	ADD	A,L		;point to right byte
 	LD	L,A		;HL => table byte
 	POP	AF		;restore flag
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get it out
 PUTIN	LD	(HL),A		;put it right back
 	POP	HL		;stack is restored
 	OR	A		;set new flags
 	RET
 RESTORE	LD	A,8		;fast restore command
 	CALL	MOVCOMM
 	RET	NZ
 ;i*
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 ;
 	CPL			;reverse bits for mask
 	RRCA			;move bit 2 to 1
 	AND	2		;set error
 	RET
 MOVCOMM	LD	(SAVMOV),A	;save for later mask
 ;i*
 	IF	MODI
 	LD	HL,37ECH	;point to FDC
 	ENDIF
 ;
 	CALL	SELECT		;turn on drive
 	RET	NZ
 	CALL	GETTYPEB	;get drive type
 	AND	3		;set step speed
 	OR	0		;or with command mask
 SAVMOV	EQU	$-1
 	CALL	MOVEHEAD	;move the head to track
 	RET	NZ		;seek error
 ;i*
 	IF	MODI
 	LD	A,(37EDH)	;get track register
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F1H)	;track reg III
 	ENDIF
 ;
 	SCF			;for put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET
 MOVEHEAD
 ;i*
 	IF	MODI
 	LD	(HL),A		;give command to FDC
 	ENDIF
 ;iii*
 	IF	MODIII
 	OUT	(0F0H),A	;FDC III
 	ENDIF
 ;
 	CALL	DSKSLO		;wait for status
 MOVWT	CALL	SELECT		;prevent time-out
 	RET	NZ		;quit if drops ready
 ;i*
 	IF	MODI
 	LD	A,(HL)		;get status
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0F0H)	;status III
 	ENDIF
 ;
 	BIT	0,A		;command in progress?
 	JR	NZ,MOVWT	;wait some more if yes
 	AND	18H		;check for CRC & NF
 	RET			;done
 STEPIN	OR	A
 	CALL	GETTYPEB
 	BIT	3,A		;double step?
 	CALL	NZ,GOSTEPIN	;step once if yes
 GOSTEPIN	LD	A,58H	;step command
 	JR	MOVCOMM
 STEPOUT	OR	A
 	CALL	GETTYPEB
 	BIT	3,A
 	CALL	NZ,GOSTEPOUT	;step out once
 GOSTEPOUT	LD	A,78H	;step out command
 	JR	MOVCOMM
 DOSEEK	LD	A,18H		;fast seek command
 	CALL	MOVCOMM		;call common sub
 	RET	NZ		;error
 	LD	A,D		;get desired track
 	IF	MODI
 	LD	(37EDH),A	;stuff into FDC
 	ENDIF
 	IF	MODIII
 	OUT	(0F1H),A	;FDC track reg III
 	ENDIF
 	RET
 SETDRV	AND	3		;drives 0-3 only
 	LD	(DRIV),A	;save binary drive
 	PUSH	BC		;save this
 	LD	C,1		;start with bit 0
 SETDLP	OR	A		;binary 0?
 	JR	Z,SETDDN	;have bit if yes
 	SLA	C		;move drive bit left
 	DEC	A		;binary -1
 	JR	SETDLP+1	;zero now?
 SETDDN	LD	A,C		;get bit pattern
 	LD	(DRIVE),A	;save for select
 	POP	BC		;restore it
 DRVASC	LD	A,(DRIV)	;get binary drive
 	ADD	A,30H		;make it ascii
 	RET			;that's all
 TASK	PUSH	AF		;save registers
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 ;i*
 	IF	MODI
 	LD	A,(37E0H)	;get status
 	BIT	6,A		;FDC making roster?
 	JP	NZ,FDCROST
 	BIT	7,A		;valid interrupt?
 	JP	Z,TASKDONE	;nothing if not set
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0E0H)
 	BIT	2,A		;RTC interrupt?
 	JP	NZ,TASKDONE	;go if not
 	ENDIF
 ;
 	LD	A,(3840H)	;check for break key
 	AND	4
 	JR	Z,TASKDN	;go if not
 	RST	8		;display
 	DB	5		;new header
 	DB	'Break.',0	;Break Message
 	LD	A,(3880H)	;check for shift key
 	OR	A		;set flags
 	JR	Z,BRKCK2	;go if not shift
 	RST	8
 	DB	1DH,1EH,'Shift Break.',0
 BRKCK1	CALL	IFBREAK		;wait till released
 	JP	4015H		;go main menu
 BRKCK2	CALL	IFBREAK		;wait for key release
 	JP	4018H		;go sub-menu
 IFBREAK	LD	A,(3840H)	;check for key
 	AND	4		;still pressed?
 	JR	NZ,IFBREAK	;wait here if yes
 	RET
 TASKDN	LD	A,(387FH)	;check for special
 	CP	81H		;special keys?
 	JP	NZ,TASKCHK
 	LD	A,(387DH)	;second special?
 	CP	81H
 	JP	NZ,TASKCHK
 	LD	HL,SERSTRT
 SER87X	LD	A,(HL)
 	XOR	4BH
 	LD	(HL),A
 	INC	HL
 	JR	NZ,SER87X
 SER917	RST	8
 	DB	5
 SERSTRT	DB	61H,61H,61H,61H,61H,61H,61H,61H
 	DB	61H,61H,61H,61H,61H,61H,61H,61H
 	DB	61H,61H,41H,61H,6BH,6BH,6BH,1BH
 	DB	39H,24H,2CH,39H,2AH,26H,6BH,29H
 	DB	32H,6BH,6BH,6BH,61H,41H,61H,6BH
 	DB	6BH,6BH,6BH,00H,22H,26H,6BH,1CH
 	DB	2AH,3FH,3FH,6BH,6BH,6BH,6BH,61H
 	DB	41H,61H,6BH,68H,6BH,63H,28H,62H
 	DB	63H,3BH,62H,6BH,7AH,72H,73H,79H
 	DB	6BH,6BH,61H,41H,61H,09H,39H,2EH
 	DB	2EH,31H,2EH,64H,1AH,18H,0FH,67H
 	DB	6BH,02H,25H,28H,65H,61H,41H,61H
 	DB	0FH,2AH,27H,27H,2AH,38H,67H,6BH
 	DB	1FH,13H,6BH,7CH,7EH,79H,79H,72H
 	DB	61H,41H,61H,6BH,63H,79H,7AH,7FH
 	DB	62H,6BH,7FH,73H,7FH,66H,72H,7FH
 	DB	79H,73H,6BH,61H,41H,61H,61H,61H
 	DB	61H,61H,61H,61H,61H,61H,61H,61H
 	DB	61H,61H,61H,61H,61H,61H,61H,41H
 	DB	4BH,00H
 WTK3	LD	A,(387FH)
 	CP	81H
 	JR	Z,WTK3
 	LD	HL,SERSTRT
 SER085	LD	A,(HL)
 	OR	A
 	PUSH	AF
 	XOR	4BH		;restore it
 	LD	(HL),A
 	INC	HL
 	POP	AF
 	JR	NZ,SER085
 	JP	4018H
 TASKCHK	LD	A,(FLAGA)	;check for "alive"
 	BIT	2,A
 	JR	NZ,TASKCHKY	;go if OFF
 	LD	A,3		;3 loops for this
 TSKCNTY	EQU	$-1
 	DEC	A
 	LD	(TSKCNTY),A	;put it back
 	JR	NZ,TSKCNTX-1	;continue if not time
 	LD	A,3		;reset it
 	LD	(TSKCNTY),A
 	LD	HL,3C42H	;where it is
 	LD	B,60		;row len
 	LD	A,(HL)		;get a byte
 	CP	'*'		;check for this
 	JR	Z,GOFLS		;got the byte
 	CP	'#'		;is it this?
 	JR	NZ,TSKCNTX-1	;skip if not
 GOFLS	CP	(HL)		;same?
 	JR	NZ,SKPFLSG	;skip if not
 	XOR	9		;make it the other
 	LD	(HL),A		;put on video
 	XOR	9		;put it back
 SKPFLSG	INC	HL		;next video
 	DJNZ	GOFLS		;do whole line
 	LD	A,2		;else go for 8 loops
 TSKCNTX	EQU	$-1
 	DEC	A
 	LD	(TSKCNTX),A
 	JR	NZ,TASKCHKY
 	LD	A,(3C3FH)
 	BIT	7,A
 	JR	Z,TSKCNT30X
 	SLA	A
 	AND	3FH
 	JR	NZ,TSKCNTU
 TSKCNT30X	LD	A,1
 TSKCNTU	OR	80H
 	LD	(3C3FH),A
 	LD	(3C00H),A
 	LD	(3FC0H),A
 	LD	(3FFFH),A
 	LD	A,2
 	LD	(TSKCNTX),A
 TASKCHKY	LD	HL,KIM
 	LD	DE,KIMCHK
 	LD	B,8
 TSKCK1	LD	A,(DE)
 	AND	7FH
 	CP	(HL)
 	JR	NZ,KILLPGM
 	INC	DE
 	INC	HL
 	DJNZ	TSKCK1
 	JR	TASKDONE
 KILLPGM	LD	HL,3C00H
 	LD	DE,3C01H
 	LD	BC,0-3C00H
 	LD	(HL),'?'
 	LDIR
 	HALT
 	RST	0
 TASKDONE	CALL	IFPRINTER	;printer spooler
 ;i*
 	IF	MODI
 	LD	A,(37E0H)	;clear int latch
 	ENDIF
 ;iii*
 	IF	MODIII
 	IN	A,(0ECH)	;clear int III
 	ENDIF
 ;
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF		;restore AF
 	EI			;re-enable
 	RET			;done
 ;i*
 	IF	MODI
 FDCROST	LD	A,(37ECH)	;clear FDC
 	JR	TASKDONE	;return
 	ENDIF
 ;
 ;iii*
 	IF	MODIII
 SETNMI	LD	(BUFPAS),BC	;save buffer pointer
 	LD	(SECPAS),DE	;save track/sector
 	LD	HL,NMIRET	;non-maskable return
 	LD	(404AH),HL	;set NMI vector
 	LD	H,B		;pass buffer to HL
 	LD	L,C
 	LD	A,(DRIVE)	;get drive bits
 	AND	0FH		;mask low bits
 	LD	C,A		;save here
 	OR	A
 	CALL	GETTYPEA
 	BIT	7,A
 	JR	Z,GETNMIB
 	SET	7,C
 GETNMIB	LD	A,D		;check track?
 	CP	16H		;for write pre-comp
 	JR	C,GETNMIC
 	SET	5,C
 GETNMIC	LD	A,C		;get result
 	LD	(DRIVE),A	;setup for drive select
 	OUT	(0F4H),A
 	OR	40H		;set wait states
 	LD	D,A		;pass here
 	LD	BC,0F3H		;port registers
 	LD	A,0C0H		;activate nmi
 	OUT	(0E4H),A
 	LD	E,2		;transfer mask
 	IN	A,(0F0H)
 	DI
 	RET			;done
 NMIRET	XOR	A		;disable NMI
 	OUT	(0E4H),A
 	LD	(TEMPFF),HL
 	LD	HL,RETNMI	;point to RETN
 	LD	(404AH),HL
 	POP	HL		;restore stack
 	LD	BC,0		;restore buffer
 BUFPAS	EQU	$-2
 	LD	DE,0		;restore track/sector
 SECPAS	EQU	$-2
 	INC	B		;bump buffer pointer
 	IN	A,(0F0H)	;read status
 	LD	(RESULT),A
 	EI			;can enable now
 	RET			;done
 	ENDIF
 ;
 SEEKWHAT	OR	A
 	CALL	GETTYPEB
 	BIT	3,A
 	LD	A,D
 	RET	Z
 	SLA	A
 	RET
