; smcopy2/asm
LOOPER	LD	SP,STAK
	IF	MODI
	LD	A,(37E0H)
	ENDIF
	IF	MODIII
	IN	A,(0ECH)
	ENDIF
	EI
	LD	IY,TABLE
	LD	A,(IY+22)
	OR	A
	JP	NZ,ENTRY
	CALL	SERIALNOS
	LD	HL,MSG5
	CALL	DISPLAY
	LD	B,1
	CALL	GETSTR
	LD	HL,DRIVES
	LD	DE,XDRIVES
	LD	BC,4
	LDIR
	LD	A,(IY+28)
	CP	'Y'
	CALL	Z,READGAT
	CALL	COPY
	CALL	PUTSERIAL
	CALL	RESULT
	LD	HL,(COUNT)
	LD	DE,(COPIES)
	OR	A
	SBC	HL,DE
	JR	C,LOOPER
	LD	HL,MSG6
	CALL	DISPLAY
	LD	B,1
	CALL	GETSTR
	JP	START
TERMIN
	CALL	RERROR
TERMINATE
	CALL	DISPLAY
	LD	HL,MSG29
	CALL	DISPLAY
	JR	LOOPER
DISPLAY	PUSH	IY
	PUSH	IX
	PUSH	DE
DISPLP	LD	A,(HL)
	INC	HL
	CP	3
	JR	Z,DISPDN
	PUSH	AF
	CALL	VOUT
	POP	AF
	CP	13
	JR	NZ,DISPLP
DISPDN	POP	DE
	POP	IX
	POP	IY
	RET
VOUT	CP	20H
	JP	C,33H
	PUSH	HL
	LD	HL,(4020H)
	LD	(HL),A
	NOP
	CP	(HL)
	JR	Z,VOK
	SUB	20H
	LD	(HL),A
VOK	INC	HL
	LD	(4020H),HL
	LD	A,H
	CP	40H
	JR	C,VOKOK
	LD	HL,3FFFH
	LD	(4020H),HL
	LD	A,10
	PUSH	IY
	PUSH	DE
	CALL	33H
	POP	DE
	POP	IY
VOKOK	POP	HL
	RET
GETSTR	LD	HL,STRING
	PUSH	IY
	CALL	40H
	POP	IY
	LD	A,B
	OR	A
	LD	A,(HL)
	RET
UCASE	CP	60H
	RET	C
	CP	80H
	RET	NC
	AND	5FH
	RET
	INC	HL
POSHL	LD	A,(HL)
	CP	20H
	JR	Z,POSHL-1
	CP	','
	JR	Z,POSHL-1
	CP	13
	SCF
	RET	Z
	CCF
	RET
VALUE	CALL	POSHL
	RET	C
	LD	BC,0
VALLP	LD	A,(HL)
	CP	20H
	RET	Z
	CP	','
	RET	Z
	CP	13
	RET	Z
	CALL	MAKNUM
	RET	C
	PUSH	HL
	LD	H,B
	LD	L,C
	ADD	HL,HL	;*2
	ADD	HL,HL	;*4
	ADD	HL,BC	;*5
	ADD	HL,HL	;*10
	LD	C,A
	LD	B,0	;BC = new number
	ADD	HL,BC
	LD	B,H
	LD	C,L
	POP	HL
	INC	HL
	JR	VALLP
MAKNUM	SUB	30H
	RET	C
	CP	10
	CCF
	RET
COPY	XOR	A
	LD	(IY+7),A
LOOPF	LD	HL,XDRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	CALL	Z,FORMAT
	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,LOOPF
	LD	HL,CLRIT
	CALL	DISPLAY
	LD	A,(IY+31)
	INC	A		;copy?
	RET	NZ		;nope, go back
	LD	DE,0
	LD	(TKIN),DE	;read posit
INNER	LD	DE,0
TKIN	EQU	$-2
	LD	(TKOUT),DE
	LD	(IY+24),0
	CALL	READ1
	CALL	DCOMMON
	LD	A,(TKIN+1)
	CP	(IY+9)
	JR	C,INNER
	RET
DCOMMON	XOR	A
	LD	(IY+7),A
DCLP	LD	HL,XDRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	CALL	Z,WRITE1
	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,DCLP
	RET
FORMAT	LD	A,(IY+30)	;format?
	INC	A		;true?
	RET	NZ		;nope, skip
	LD	A,(IY+7)
	CALL	SETDRV
	LD	(MSG7A),A
	LD	HL,MSG7
	CALL	DISPLAY
	LD	(IY+8),0
	CALL	STAT
	PUSH	HL
	JP	NZ,REMDRIVE
	POP	HL
	CALL	RESTORE
	JP	NZ,REMWRITE
FORMLP	CALL	FFLICK
	CALL	BUILD
	LD	BC,BUFFER
	CALL	WRITETR
	JR	NZ,REMWRITE
	INC	(IY+8)
	LD	A,(IY+8)
	CP	(IY+9)
	JR	C,FORMLP
	RET
REMWRITE PUSH	HL
	CALL	WERROR
	JR	REMDRIVE
REMREAD	PUSH	HL
	CALL	RERROR
REMDRIVE CALL	DISPLAY
	LD	A,(IY+7)
	ADD	A,30H
	LD	(MSG21A),A
	LD	HL,MSG21
	CALL	DISPLAY
	LD	HL,XDRIVES
	LD	A,(IY+7)
	ADD	A,L
	LD	L,A
	LD	(HL),0
	LD	HL,XDRIVES
	LD	B,4
CKLP	LD	A,(HL)
	INC	A
	JR	Z,CKDN
	INC	HL
	DJNZ	CKLP
	LD	HL,MSG9
	CALL	DISPLAY
	JP	LOOPER
CKDN	POP	HL
	OR	1
	RET
KIM2	DB	'K'+80H,'i'+80H,'m'+80H,' '+80H
	DB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
WERROR	LD	HL,TABLEW
	JR	RWERR
RERROR	LD	HL,TABLER
RWERR	RLCA
	JR	C,ERRHV
	INC	HL
	INC	HL
	JR	RWERR
ERRHV	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	RET
TABLEW	DW	MSG10
	DW	MSG11
	DW	MSG12
	DW	MSG13
	DW	MSG14
	DW	MSG15
	DW	MSG20
	DW	MSG28
TABLER	DW	MSG10
	DW	MSG20
	DW	MSG20
	DW	MSG17
	DW	MSG18
	DW	MSG19
	DW	MSG20
	DW	MSG28
FFLICK	LD	A,':'.XOR.' '
	PUSH	BC
	PUSH	HL
	PUSH	AF
	LD	HL,(4020H)
	XOR	(HL)
	LD	(HL),A
	INC	HL
	INC	HL
	LD	A,(IY+8)
	CALL	ASCII
	LD	(HL),C
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	POP	AF
	XOR	(HL)
	LD	(HL),A
	POP	HL
	POP	BC
	RET
RFLICK	LD	A,'-'.XOR.' '
	JR	FLICKER
WFLICK	LD	A,'+'.XOR.' '
	JR	FLICKER
VFLICK	LD	A,'='.XOR.' '
FLICKER	PUSH	HL
	PUSH	BC
	LD	HL,(4020H)
	PUSH	AF
	XOR	(HL)
	LD	(HL),A
	LD	A,D
	CALL	ASCII
	INC	HL
	INC	HL
	LD	(HL),C
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	POP	AF
	PUSH	AF
	XOR	(HL)
	LD	(HL),A
	LD	A,E
	CALL	ASCII
	INC	HL
	INC	HL
	LD	(HL),C
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	POP	AF
	POP	BC
	PUSH	BC
	PUSH	AF
	XOR	(HL)
	LD	(HL),A
	INC	HL
	INC	HL
	LD	A,B
	CALL	HEXCV
	LD	(HL),C
	INC	HL
	LD	(HL),A
	INC	HL
	LD	(HL),'0'
	INC	HL
	LD	(HL),'0'
	INC	HL
	INC	HL
	POP	AF
	XOR	(HL)
	LD	(HL),A
	POP	BC
	POP	HL
	RET
STAT	LD	A,0D0H
	IF	MODI
	LD	(37ECH),A
	ENDIF
	IF	MODIII
	OUT	(0F0H),A
	ENDIF
	CALL	SELECT
	LD	HL,MSG24
	JR	NZ,HOLDER
	LD	HL,MSG22
	LD	BC,600H
TT1	DEC	BC
	LD	A,B
	OR	C
	JR	Z,HOLDER
	IF	MODI
	LD	A,(37ECH)
	ENDIF
	IF	MODIII
	IN	A,(0F0H)
	ENDIF
	AND	2
	JR	NZ,TT1
	LD	BC,6000H
	LD	HL,MSG23
TT2	DEC	BC
	LD	A,B
	OR	C
	JR	Z,HOLDER
	IF	MODI
	LD	A,(37ECH)
	ENDIF
	IF	MODIII
	IN	A,(0F0H)
	ENDIF
	AND	2
	JR	Z,TT2
	LD	HL,MSG22
	LD	BC,600H
TT3	DEC	BC
	LD	A,B
	OR	C
	JR	Z,HOLDER
	IF	MODI
	LD	A,(37ECH)
	ENDIF
	IF	MODIII
	IN	A,(0F0H)
	ENDIF
	AND	2
	JR	NZ,TT3
	XOR	A
	RET
HOLDER	OR	1
	RET
READ1	LD	(IY+10),3
READ1Z	LD	A,(IY+5)
	CALL	SETDRV
	LD	(MSG25A),A
	LD	HL,MSG25
	CALL	DISPLAY
	CALL	STAT
	JP	NZ,TERMINATE
	LD	BC,BUFFER
	LD	IX,DAMBUFF
READ1L	LD	(IY+8),D
	CALL	RFLICK
	CALL	READ		;read the sector
	LD	A,(DAM)
	LD	(IX),A
	INC	IX
	JP	NZ,TERMIN
	CALL	NEXSEC		;next sector
	INC	(IY+24)
	INC	B
	JR	Z,READ1D
	LD	A,D
	CP	(IY+9)
	JR	C,READ1L
READ1D	LD	A,(IY+4)
	LD	(TKIN),DE
	CP	'Y'
	RET	NZ
	LD	A,(IY+5)
	CALL	SETDRV
	LD	(MSG27A),A
	LD	HL,MSG27
	CALL	DISPLAY
	LD	DE,0
TKOUT	EQU	$-2
	LD	BC,BUFFER
	LD	(IY+17),6
	LD	A,(IY+24)
	LD	(IY+25),A
	LD	IX,DAMBUFF
READ1V	LD	(IY+8),D
	CALL	VFLICK
	PUSH	BC
	LD	BC,VBUFF
	CALL	READ
	POP	BC
	JP	NZ,TERMIN
	CALL	COMPARE
	JR	NZ,READ1BB
	LD	A,(DAM)
	CP	(IX)
	JR	Z,READ1P
READ1BB	CALL	MOVBUF
	LD	A,(DAM)
	LD	(IX),A
	DEC	(IY+17)
	JR	NZ,READ1V
	DEC	(IY+10)
	JP	NZ,READ1Z
	LD	HL,MSG35
	JP	TERMINATE
READ1P	CALL	NEXSEC
	LD	(IY+17),6
	INC	B
	INC	IX
	DEC	(IY+25)
	JR	NZ,READ1V
	RET
WRITE1	LD	(IY+10),3
WRITE1Z	LD	A,(IY+7)
	CALL	SETDRV
	LD	(MSG26A),A
	LD	HL,MSG26
	CALL	DISPLAY
	LD	DE,(TKOUT)
	LD	BC,BUFFER
	LD	A,(IY+24)
	LD	(IY+25),A
	LD	IX,DAMBUFF
WRITE1L	LD	(IY+8),D
	CALL	WFLICK
	IF	MODI
	LD	A,0A8H
	ENDIF
	IF	MODIII
	LD	A,0A0H
	ENDIF
	OR	(IX)
	LD	(WRTYPE),A
	CALL	WRITE
	JP	NZ,REMWRITE	;remove the drive
	INC	IX
	INC	B
	CALL	NEXSEC
	DEC	(IY+25)
	JR	NZ,WRITE1L	;go if more
	LD	A,(IY+4)
	CP	'Y'
	RET	NZ
	LD	A,(IY+7)
	CALL	SETDRV
	LD	(MSG27A),A
	LD	HL,MSG27
	CALL	DISPLAY
	LD	DE,(TKOUT)
	LD	BC,BUFFER
	LD	(IY+17),6
	LD	A,(IY+24)
	LD	(IY+25),A
	LD	IX,DAMBUFF
VERIFY1L LD	(IY+8),D
	CALL	VFLICK
	PUSH	BC
	LD	BC,VBUFF
	CALL	READ
	POP	BC
	JR	Z,V1OKSO
	BIT	3,A
	JP	Z,REMREAD
	JR	V1BB
V1OKSO	CALL	COMPARE
	JR	NZ,V1BB
	LD	A,(DAM)
	CP	(IX)
	JR	Z,V1OK
V1BB	CALL	REWRITE
	DEC	(IY+17)
	JR	NZ,VERIFY1L
	DEC	(IY+10)
	JP	NZ,WRITE1Z
	LD	HL,MSG35
	PUSH	HL
	JP	REMDRIVE	;remove if from que
V1OK	INC	B
	INC	IX
	LD	(IY+17),6
	CALL	NEXSEC
	DEC	(IY+25)
	JR	NZ,VERIFY1L
	RET
NEXT0	LD	A,E		;get sector #
	INC	E		;bump to one
	OR	A		;on zero?
	RET	Z		;yes, DE = 0001
	LD	E,0		;reset to start
	JR	NEXGTK		;check track 1
NEXSEC	INC	D
	DEC	D
	JR	Z,NEXT0
;
	LD	A,10
	INC	E
	SUB	E
	RET	NZ
	LD	E,A
NEXGTK	INC	D
	LD	A,(IY+28)
	CP	'Y'
	RET	NZ
	LD	A,D
	CP	(IY+9)
	RET	NC
	PUSH	HL
	PUSH	BC
	LD	HL,GATBUFF
	LD	C,D	;track
	LD	B,0
	ADD	HL,BC
	LD	A,(IY+29)
	CP	(HL)
	POP	BC
	POP	HL
	JR	Z,NEXGTK
	RET
	IF	MODI
SELECT	LD	A,(37ECH)
	AND	80H
	LD	A,0
DRIVE	EQU	$-1
	LD	(37E1H),A
	RET	Z
	PUSH	BC
	LD	BC,0
	CALL	60H
	POP	BC
	JR	SELECT
	ENDIF
	IF	MODIII
SELECT	XOR	A
	LD	(DRIV0),A
	LD	A,(IY+8)
	CP	16H
	JR	C,SELEC
	LD	A,20H
	LD	(DRIV0),A
SELEC	IN	A,(0F0H)
	AND	80H
	PUSH	AF
	LD	A,0
DRIVE	EQU	$-1
	AND	0FH
	OR	0
DRIV0	EQU	$-1
	OR	(IY+21)
	LD	(DRIVE),A
	OUT	(0F4H),A
	POP	AF
	RET	Z
	PUSH	BC
	LD	BC,0
	CALL	60H
	POP	BC
	JR	SELEC
	ENDIF
SETDRV	PUSH	BC
	PUSH	AF
	LD	(DRV),A
	LD	C,1
	OR	A
SETDLP	JR	Z,SETDN
	SLA	C
	DEC	A
	JR	SETDLP
SETDN	LD	A,C
	LD	(DRIVE),A
	POP	AF
	ADD	A,30H
	POP	BC
	RET
READ	LD	HL,SREAD
	LD	A,9FH
	JR	COMMON
WRITE	LD	HL,SWRITE
	LD	A,0FFH
	JR	COMMON
WRITETR	LD	HL,TWRITE
	LD	A,0FFH
COMMON	LD	(VECTOR),HL
	LD	(MASK),A
	LD	A,(IY+15)
	LD	(IY+16),A
COMMLP	PUSH	BC
	CALL	0		;call vector
VECTOR	EQU	$-2
	POP	BC
	AND	0
MASK	EQU	$-1
	RET	Z		;OK now
	EX	AF,AF'		;save error
	LD	A,0D0H
	IF	MODI
	LD	(37ECH),A
	ENDIF
	IF	MODIII
	OUT	(0F0H),A
	ENDIF
	DEC	(IY+16)
	JR	NZ,COMMLP	;try again
	EX	AF,AF'		;restore error
	RET
SREAD	CALL	SETDEN		;setup density
	CALL	SEEK
	RET	NZ		;error now
	IF	MODIII
	LD	(STACK),SP
	CALL	RSETNMI		;setup for NMI return
	LD	A,80H		;read command
	OUT	(0F0H),A
	CALL	DSKSLO		;short wait
R1	IN	A,(0F0H)
	AND	E
	JR	Z,R1		;wait for byte
	INI			;read it
	LD	A,D
	OR	40H
R2	OUT	(0F4H),A
	INI
	JR	NZ,R2
	JR	$
	ENDIF
	IF	MODI
	LD	HL,37ECH
	DI
	LD	(HL),88H
	CALL	DSKSLO
	PUSH	DE
	PUSH	BC
	LD	DE,37EFH
RX0	LD	A,(HL)
	AND	87H
	JP	PO,RX0
RX1	LD	A,(DE)
	LD	(BC),A
	INC	BC
RX2	BIT	1,(HL)
	JR	NZ,RX1
	BIT	1,(HL)
	JR	NZ,RX1
	BIT	7,(HL)
	JR	NZ,RX3
	BIT	1,(HL)
	JR	NZ,RX1
	BIT	0,(HL)
	JR	NZ,RX2
RX3	LD	A,(HL)
	POP	BC
	POP	DE
	EI
	PUSH	AF
	RRCA
	RRCA
	RRCA
	RRCA
	RRCA
	AND	3
	LD	(DAM),A
	POP	AF
	RET
	ENDIF
	IF	MODI
TWRITE	LD	A,0F4H
	LD	(WRTYPE),A
	LD	DE,0		;force single den
	ENDIF
SWRITE	CALL	SETDEN
	CALL	SEEK
	RET	NZ
	IF	MODIII
	LD	(STACK),SP
	CALL	WSETNMI
	LD	A,0A0H
WRTYPE	EQU	$-1
	OUT	(0F0H),A
	CALL	DSKSLO
W1	IN	A,(0F0H)
	AND	E
	JR	Z,W1
	OUTI
	LD	B,60H
	DJNZ	$
	DEC	B
	LD	A,D
	OR	40H
W2	OUT	(0F4H),A
	OUTI
	JR	NZ,W2
	JR	$
	ENDIF
	IF	MODI
	LD	HL,37ECH
	DI
	LD	(HL),0A8H
WRTYPE	EQU	$-1
	CALL	DSKSLO
	PUSH	DE
	PUSH	BC
	LD	DE,37EFH
	LD	A,(HL)
	AND	40H
	JR	NZ,WX5
	LD	A,(BC)
WX1	BIT	7,(HL)
	JR	NZ,WX5
	BIT	1,(HL)
	JR	Z,WX1
	LD	(DE),A
	INC	BC
	LD	A,(BC)
WX2	BIT	1,(HL)
	JR	Z,WX2
WX3	LD	(DE),A
	INC	BC
	LD	A,(BC)
WX4	BIT	1,(HL)
	JR	NZ,WX3
	BIT	1,(HL)
	JR	NZ,WX3
	BIT	1,(HL)
	JR	NZ,WX3
	BIT	1,(HL)
	JR	NZ,WX3
	BIT	1,(HL)
	JR	NZ,WX3
	BIT	1,(HL)
	JR	NZ,WX3
	BIT	0,(HL)
	JR	NZ,WX4
WX5	LD	A,(HL)
	POP	BC
	POP	DE
	EI
	RET
	ENDIF
	IF	MODIII
TWRITE	LD	(IY+21),0
	CALL	SEEK
	RET	NZ
	LD	(STACK),SP
	CALL	WSETNMI
	LD	A,0F0H
	OUT	(0F0H),A
	CALL	DSKSLO
	LD	B,3
	LD	A,(IY+8)	;get track
	OR	A		;on zero?
	JP	NZ,WW101	;go disk
	JP	WW1010		;go track 0
RSETNMI	LD	HL,NMIRETR
	JR	SETNMI
WSETNMI	LD	HL,NMIRETW
SETNMI	LD	(BUFFPASS),BC
	LD	(SECPASS),DE
	LD	(404AH),HL
	LD	H,B
	LD	L,C
	LD	A,(DRIVE)
	OUT	(0F4H),A
	OR	40H
	LD	D,A
	DI
	LD	A,0C0H
	OUT	(0E4H),A
	LD	E,2		;for bit 1 mask
	LD	BC,0F3H		;count, port
;	IN	A,(0F0H)
	RET
	ENDIF
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
	IF	MODIII
NMIRETR	XOR	A
	OUT	(0E4H),A
	IN	A,(0F0H)
	RRCA
	RRCA
	RRCA
	RRCA
	RRCA
	AND	1
	LD	(DAM),A
	JR	NMIRET
NMIRETW	XOR	A
	OUT	(0E4H),A
NMIRET	LD	HL,RETNMI
	LD	(404AH),HL
	LD	SP,0
STACK	EQU	$-2
	LD	DE,0
SECPASS	EQU	$-2
	LD	BC,0
BUFFPASS EQU	$-2
	IN	A,(0F0H)
	EI
	RET
	ENDIF
SEEK	PUSH	HL
	LD	HL,CTRACK
	LD	A,0
DRV	EQU	$-1
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	IF	MODI
	LD	(37EDH),A
	ENDIF
	IF	MODIII
	OUT	(0F1H),A
	ENDIF
	OR	A
	JR	NZ,SEEK0
	CALL	RESTORE
	JR	NZ,BADSEEK	;force restore next time
SEEK0	LD	A,(IY+8)
	IF	MODI
	LD	(37EFH),A
	ENDIF
	IF	MODIII
	OUT	(0F3H),A
	ENDIF
	CALL	SELECT
	JR	NZ,BADSEEK
	LD	A,18H
	OR	(IY+26)
	IF	MODI
	LD	(37ECH),A
	ENDIF
	IF	MODIII
	OUT	(0F0H),A
	ENDIF
	CALL	DSKSLO
SEEKWT
	IF	MODI
	LD	A,(37ECH)
	ENDIF
	IF	MODIII
	IN	A,(0F0H)
	ENDIF
	BIT	0,A
	JR	NZ,SEEKWT
	AND	18H
	JR	NZ,BADSEEK
	PUSH	AF
	LD	A,E
	IF	MODI
	LD	(37EEH),A
	LD	A,(37EDH)
	ENDIF
	IF	MODIII
	OUT	(0F2H),A
	IN	A,(0F1H)	;get new track
	ENDIF
SEEKRET	LD	(HL),A
	POP	AF
	POP	HL
	RET
BADSEEK	PUSH	AF
	XOR	A		;force restore next time
	JR	SEEKRET
RESTORE	CALL	SELECT
	RET	NZ
	LD	A,8
	OR	(IY+26)
	IF	MODI
	LD	(37ECH),A
	ENDIF
	IF	MODIII
	OUT	(0F0H),A
	ENDIF
	CALL	DSKSLO
RESWT
	IF	MODI
	LD	A,(37ECH)
	ENDIF
	IF	MODIII
	IN	A,(0F0H)
	ENDIF
	BIT	0,A
	JR	NZ,RESWT
	CPL
	AND	4
	RET	Z
	LD	A,1		;use this for error code
	RET			;NZ = error
RESULT	LD	HL,CLRLIN
	CALL	DISPLAY
	XOR	A
	LD	(IY+7),A
RESLP	LD	HL,DRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	JR	NZ,RESNXT
	LD	A,(IY+7)
	LD	HL,XDRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	JR	NZ,BADDRV
	LD	HL,(COUNT)
	INC	HL
	LD	(COUNT),HL
	LD	A,(IY+7)
	ADD	A,30H
	LD	(MSG30A),A
	LD	HL,MSG30
	CALL	DISPLAY
	LD	A,(IY+6)
	CP	'*'
	JR	Z,RESFEED
	CALL	SHOWSER
	JR	RESNXT
BADDRV	LD	A,(IY+7)
	ADD	A,30H
	LD	(MSG31A),A
	LD	HL,MSG31
	CALL	DISPLAY
	LD	A,(IY+6)
	CP	'*'
	JR	Z,RESFEED
	CALL	SHOWSER
	JR	RESNXT
RESFEED	LD	A,10
	PUSH	IY
	CALL	33H
	POP	IY
RESNXT	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,RESLP
	LD	HL,(COUNT)
	PUSH	IY
	LD	IY,MSG32A
	CALL	WRLNO
	LD	HL,(COPIES)
	LD	IY,MSG32B
	CALL	WRLNO
	POP	IY
	LD	HL,MSG32A
	JP	DISPLAY
SHOWSER	CALL	FSER
	EX	DE,HL
	LD	DE,SERMSGA
	LD	C,(IY+23)
	LD	B,0
	LDIR
	LD	HL,SERMSG
	JP	DISPLAY
FSER	LD	A,(IY+7)
	SLA	A
	PUSH	HL
	LD	HL,SERTBL
	ADD	A,L
	LD	L,A
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	POP	HL
	RET
TENTBL	DW	-10000,-1000,-100,-10,-1
WRLNO	LD	DE,TENTBL
	PUSH	IY
WRL1	LD	A,(DE)
	LD	C,A
	INC	DE
	LD	A,(DE)
	LD	B,A
	INC	DE
	PUSH	DE
	LD	A,2FH
WRL2	INC	A
	LD	D,H
	LD	E,L
	ADD	HL,BC
	JR	C,WRL2
	EX	DE,HL
	POP	DE
	LD	(IY),A
	INC	IY
	INC	C
	JR	NZ,WRL1
	POP	IY
	LD	B,4
STPLP	LD	A,(IY)
	CP	'0'
	RET	NZ
	LD	A,20H
	LD	(IY),A
	INC	IY
	DJNZ	STPLP
	RET
BUILD	LD	A,(IY+8)
	OR	A
	JP	Z,BUILD0
	JP	BUILDTRK
TESTMEM	LD	HL,VBUFF	;start of buffer area
TESTLP	XOR	A
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	CPL
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	LD	A,0AAH
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	CPL
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	LD	A,0CCH
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	CPL
	LD	(HL),A
	NOP
	CP	(HL)
	JR	NZ,BADMEM
	INC	HL
	LD	A,H
	OR	L
	JR	NZ,TESTLP
	RET
BADMEM	LD	HL,MSG34
	CALL	DISPLAY
DEAD	JP	DEAD
COMPARE	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	D,B
	LD	E,C
	LD	HL,VBUFF
	LD	B,0
COMPLP	LD	A,(DE)
	CP	(HL)
	JR	NZ,COMPRET
	INC	DE
	INC	HL
	DJNZ	COMPLP
COMPRET	POP	BC
	POP	DE
	POP	HL
	RET
ORDNEW	PUSH	BC
	PUSH	DE
	PUSH	HL
	EX	DE,HL
	LD	B,3
	DEC	C
	LD	A,(IY+21)
	OR	A
	JR	Z,ORDNEW1
	LD	B,4
ORDNEW1	PUSH	BC
	LD	A,(HL)
	PUSH	HL
	INC	HL
ORDNEW2	LD	E,(HL)
	LD	(HL),A
	LD	A,E
	INC	HL
	DEC	C
	JR	NZ,ORDNEW2
	POP	HL
	LD	(HL),A
	POP	BC
	DJNZ	ORDNEW1
	POP	HL
	POP	DE
	POP	BC
	RET
BUILDTRK LD	HL,SORDER
	LD	A,(IY+21)
	OR	A
	JR	Z,FIGBUILD
	LD	HL,DORDER
FIGBUILD LD	C,(HL)
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	CALL	ORDNEW
	PUSH	DE
	LD	DE,BUFFER
	EX	DE,HL
	CALL	MOVEIN
	LD	(DESVE),DE
SECLP	CALL	MOVEIN
	CALL	MOVEIN
	LD	(HL),0FEH
	INC	HL
	LD	A,(IY+8)
	LD	(HL),A
	INC	HL
	LD	(HL),0
	INC	HL
	EX	(SP),HL
	LD	A,(HL)
	INC	HL
	EX	(SP),HL
	LD	(HL),A
	INC	HL
	LD	(HL),1
	INC	HL
	LD	(HL),0F7H
	INC	HL
	CALL	MOVEIN
	CALL	MOVEIN
	CALL	MOVEIN
	LD	(HL),0FBH
	INC	HL
	CALL	FILLDATA
	LD	(HL),0F7H
	INC	HL
	CALL	MOVEIN
	LD	DE,0
DESVE	EQU	$-2
	DEC	C
	JR	NZ,SECLP
	INC	SP
	INC	SP
	DEC	DE
	LD	A,(DE)
	JP	FILL
SORDER	DB	10
	DW	ORDERS
	DB	1FH,0FFH
	DB	3,0
	DB	3,0
	DB	0BH,0FFH
	DB	3,0
	DB	3,0
	DB	0BH,0FFH
ORDERS	DB	0,5,1,6,2,7,3,8,4,9
DORDER	DB	18
	DW	ORDERD
	DB	3EH,4EH
	DB	0CH,0
	DB	3,0F5H
	DB	16H,4EH
	DB	0CH,0
	DB	3,0F5H
	DB	16H,4EH
ORDERD	DB	0,6,12,1,7,13,2,8,14
	DB	3,9,15,4,10,16,5,11,17
MOVEIN	LD	A,(DE)
	INC	DE
	LD	B,A
	LD	A,(DE)
	INC	DE
FILL	LD	(HL),A
	INC	HL
	DJNZ	FILL
	RET
FILLDATA	LD	A,(IY+21)
	OR	A
	LD	A,128
	PUSH	BC
	LD	BC,6DB6H
	JR	NZ,FILLA
	LD	BC,0E5E5H
FILLA	LD	(HL),C
	INC	HL
	LD	(HL),B
	INC	HL
	DEC	A
	JR	NZ,FILLA
	POP	BC
	RET
	IF	MODIII
WW101	LD	A,D
	OUT	(0F4H),A
	IN	A,(0F0H)
	AND	B
	JP	PO,WW101
	OUTI
WW102	LD	A,D
	OR	40H
	OUT	(0F4H),A
	IN	A,(0F0H)
	AND	E
	JR	Z,WW102
	OUTI
	LD	A,D
	OR	40H
WW103	OUT	(0F4H),A
	OUTI
	JP	WW103
	ENDIF
ZBUFF	LD	HL,BUFFER
	LD	DE,BUFFER+1
	LD	BC,3000H
	LD	(HL),0
	LDIR
	RET
ASCII	LD	C,'0'
ASC1	SUB	10
	JR	C,ASC2
	INC	C
	JR	ASC1
ASC2	ADD	A,3AH
	RET
SERIALNOS
	LD	A,(IY+6)
	CP	'*'
	RET	Z
	CP	'Y'
	JR	Z,DOAUTO
	XOR	A
	LD	(IY+7),A
SERLP	LD	HL,DRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	CALL	Z,GETSER
	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,SERLP
	RET
DOAUTO	XOR	A
	LD	(IY+7),A
AUTOLP	LD	HL,DRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	CALL	Z,ASERIAL
	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,AUTOLP
	RET
ASERIAL	CALL	FSER
	LD	HL,SERX
	LD	C,(IY+23)
	LD	B,0
	PUSH	BC
	LDIR
	POP	BC
	LD	HL,SERX
	DEC	BC
	ADD	HL,BC
	LD	B,C
NEWSER	LD	A,(HL)
	INC	A
	LD	(HL),A
	CP	3AH
	RET	C
	LD	(HL),'0'
	DEC	HL
	DJNZ	NEWSER
	RET
GETSER	LD	A,(IY+7)
	ADD	A,30H
	LD	(MSG38A),A
	LD	HL,MSG38
	CALL	DISPLAY
	LD	B,(IY+23)
	CALL	GETSTR
	LD	A,B
	CP	(IY+23)
	JR	NZ,GETSER
	CALL	FSER
	LD	C,B
	LD	B,0
	LDIR
	RET
PUTSERIAL LD	A,(IY+6)
	CP	'*'
	RET	Z
	LD	HL,MSG39
	CALL	DISPLAY
	XOR	A
	LD	(IY+7),A
PUTSLP	LD	HL,XDRIVES
	ADD	A,L
	LD	L,A
	LD	A,(HL)
	INC	A
	CALL	Z,THISONE
	INC	(IY+7)
	LD	A,(IY+7)
	CP	4
	JR	C,PUTSLP
	RET
THISONE
	LD	A,(IY+7)
	CALL	SETDRV
	LD	BC,BUFFER
	LD	D,(IY+18)
	LD	E,(IY+19)
	LD	(IY+8),D
	CALL	READ
	JP	NZ,REMREAD
	CALL	DOTHIS
	LD	A,0
DAM	EQU	$-1
	LD	(DAMBUFF),A
	IF	MODI
	OR	0A8H
	ENDIF
	IF	MODIII
	OR	0A0H
	ENDIF
	LD	(WRTYPE),A
	CALL	WRITE
	JP	NZ,REMWRITE
	LD	A,(IY+4)
	CP	'Y'
	JR	NZ,SKSVER
	PUSH	BC
	LD	BC,VBUFF
	CALL	READ
	POP	BC
	JP	NZ,REMREAD
	CALL	COMPARE
	JR	NZ,SKSBB
	LD	A,(DAM)
	LD	L,A
	LD	A,(DAMBUFF)
	CP	L
	JR	Z,SKSVER
SKSBB	LD	HL,MSG35
	PUSH	HL
	JP	REMDRIVE
SKSVER	RET
DOTHIS	PUSH	DE
	PUSH	BC
	CALL	FSER
	EX	DE,HL
	LD	DE,BUFFER
	LD	E,(IY+20)
	LD	C,(IY+23)
	LD	B,0
	LDIR
	POP	BC
	POP	DE
	RET
HEXCV	LD	B,A
	SRL	A
	SRL	A
	SRL	A
	SRL	A
	CALL	HEXTST
	LD	C,A
	LD	A,B
	AND	0FH
HEXTST	ADD	A,30H
	CP	3AH
	RET	M
	ADD	A,7
	RET
MOVBUF	PUSH	DE
	PUSH	BC
	LD	D,B
	LD	E,C
	LD	HL,VBUFF
	LD	BC,100H
	LDIR
	POP	BC
	POP	DE
	RET
REWRITE	CALL	WRITE
	JP	NZ,REMWRITE
	RET
READGAT	LD	A,(IY+5)
	CALL	SETDRV
	CALL	STAT
	JP	NZ,TERMINATE
	LD	BC,BUFFER
	LD	DE,0
	LD	(IY+8),D
	CALL	READ
	JP	NZ,TERMIN
	PUSH	BC
	LD	BC,VBUFF
	CALL	READ
	POP	BC
	JP	NZ,TERMIN
	CALL	COMPARE
	JR	NZ,READGAT
	LD	A,(VBUFF+2)
	LD	D,A
	LD	E,0
	LD	BC,GATBUFF
	LD	(IY+8),D
	CALL	READ
	JP	NZ,TERMIN
	PUSH	BC
	LD	BC,VBUFF
	CALL	READ
	POP	BC
	JP	NZ,TERMIN
	CALL	COMPARE
	JR	NZ,READGAT
	RET
;
BUILD0	CALL	ZBUFF
	LD	HL,BUFFER
	LD	A,-1
	LD	B,31
	CALL	FILL
	LD	B,6
	XOR	A
	CALL	FILL
	LD	(HL),0FEH
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),1
	INC	HL
	LD	(HL),0F7H
	INC	HL
	LD	B,11
	LD	A,-1
	CALL	FILL
	LD	B,6
	XOR	A
	CALL	FILL
	LD	(HL),0FBH
	INC	HL
	LD	A,0E5H
	CALL	FILL
	LD	(HL),0F7H
	INC	HL
	LD	B,31
	LD	A,-1
	CALL	FILL
	CALL	FILL
	LD	B,62
	LD	A,4EH
	CALL	FILL
	LD	B,12
	XOR	A
	CALL	FILL
	LD	B,3
	LD	A,0F5H
	CALL	FILL
	LD	(HL),0FEH
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(HL),1
	INC	HL
	LD	(HL),1
	INC	HL
	LD	(HL),0F7H
	INC	HL
	LD	B,22
	LD	A,4EH
	CALL	FILL
	LD	B,12
	XOR	A
	CALL	FILL
	LD	B,3
	LD	A,0F5H
	CALL	FILL
	LD	(HL),0FBH
	INC	HL
	LD	A,0E5H
	CALL	FILL
	LD	(HL),0F7H
	INC	HL
	LD	B,22
	LD	A,4EH
	CALL	FILL
	JP	FILL
;
WW1010	LD	A,D
	OUT	(0F4H),A
	IN	A,(0F0H)
	AND	B
	JP	PO,WW1010
	OUTI
	LD	B,-1
WS2	LD	A,D
	OR	40H
	OUT	(0F4H),A
	IN	A,(0F0H)
	AND	E
	JR	Z,WS2
	OUTI
	LD	A,D
	OR	40H
WS3	OUT	(0F4H),A
	OUTI
	JR	NZ,WS3
WS4	OUT	(0F4H),A
	OUTI
	JR	NZ,WS4
	LD	B,93
WS5	OUT	(0F4H),A
	OUTI
	JR	NZ,WS5
	SET	7,A
WS6	OUT	(0F4H),A
	OUTI
	JR	NZ,WS6
WS7	OUT	(0F4H),A
	OUTI
	JR	NZ,WS7
	LD	B,144
WS8	OUT	(0F4H),A
	OUTI
	JR	NZ,WS8
	LD	HL,BUFFER+800H
WS9	OUT	(0F4H),A
	OUTI
	JP	WS9
SETDEN	LD	(IY+21),0	;set single density
	LD	A,D		;get track
	OR	A		;on zero?
	RET	NZ		;nope, return
	LD	A,E		;get sector
	CP	1		;on one?
	RET	NZ		;nope, return
	LD	(IY+21),80H	;set double density
;
GATBUFF	DS	256
DAMBUFF	DS	170
DBUFF	EQU	$&0FF00H
VBUFF	EQU	DBUFF+100H
BUFFER	EQU	VBUFF+200H
