; supurgb/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
;	$DSKDIR - full screen kill/unkill file editor
;
DSKDIR	CALL	GETDRVS		;multiple drive setup
	LD	DE,DSKDIRS	;subroutine address
	LD	BC,SUBMENU	;to sub-menu when done
	JP	DRVCOMM		;do all specified drives
;
;	$DSKDIRS - modify directory on a single drive
;
DSKDIRS	RST	@08		;couple of video lines
;
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read in the directory
	JP	NZ,NOTDIR	;can't find it!
	XOR	A		;set first page
	LD	(DIRPAGE),A	;filename page offset
	CALL	DIRPART		;display name/date
	CALL	PRESS		;'enter to continue'
;
MODIRBK	LD	A,(FLAGA)	;get system flag
	SET	1,A		;turn off 'alive'
	LD	(FLAGA),A	;put it back
	RST	@08		;clear screen
;
	DEFB	CLSA		;cls code
	DEFB	ETX		;term
;
	LD	HL,VIDEO+382H	;set cursor to bottom row
	LD	(CURSOR),HL	;save it
;
;	reset pointers to first file
;
MODDIR	CALL	SHOWDIR+3	;display without CLS
	LD	A,(DIRPAGE)	;fetch start page
	LD	B,A		;give to B
	LD	C,0		;BC = offset into files
	LD	IX,FILBUFF	;start of file records
	ADD	IX,BC		;IX => first file in blok
	LD	HL,VIDEO	;start of video
;
;	flash cursor at current posit, wait for a key
;
MODDIRO	LD	B,(HL)		;get current video char
	LD	C,8FH		;B=OFF char, C=ON char
	LD	A,12		;flash counter
	CALL	FLICKS		;flash, wait for key
;
	CALL	UCASE		;strip lower case
	CP	'A'		;next drive?
	RET	Z		;return to next drive
;
;	leave return vector on stack
;
	LD	DE,MODDIRO	;vector
	PUSH	DE		;to the stack
;
	LD	DE,MODDJMP	;modify jump table
	CALL	GOTABL		;execute command
	RET			;invalid, try again
;
MODDJMP	DEFB	'C'		;clear this entry?
	DEFW	CLRTHIS
;
	DEFB	'K'		;kill it?
	DEFW	MODKILL
;
	DEFB	'R'		;restore it?
	DEFW	MODREST
;
	DEFB	'W'		;write back directory?
	DEFW	PUTDIR
;
	DEFB	SRARR		;next immediate entry?
	DEFW	MODIRR
;
	DEFB	SLARR		;last immediate entry?
	DEFW	MODIRL
;
	DEFB	LARR		;last valid entry?
	DEFW	MODIRLN
;
	DEFB	RARR		;next valid entry?
	DEFW	MODIRRN
;
	DEFB	'N'		;next entry?
	DEFW	MODIRRN		;same as right arrow
;
	DEFB	DARR		;down a row?
	DEFW	MODIRD
;
	DEFB	UARR		;up a row?
	DEFW	MODIRU
;
;	since only 8 sectors of filenames will fit
;	on the video screen, use the shift up/down
;	arrow keys to bring in additional parts
;
	DEFB	SDARR		;move back block?
	DEFW	DIRDWN
;
	DEFB	SUARR		;move forward block?
	DEFW	DIRUP
;
	DEFB	CLEAR		;clear all unused?
	DEFW	NUNUSED
;
	DEFB	ETBL		;terminator
;
;	$CLRTHIS - kill and clear current entry
;
CLRTHIS	LD	DE,FILBUFF	;start of names
	LD	(KILLW),DE	;kill needs for extension
	CALL	KILLIT		;kill file IX =>
;
	CALL	CLRFILE		;zero it out
	JR	MODREST+3	;re-display & move right
;
;	$MODKILL - kill current entry, don't clear
;
MODKILL	LD	DE,FILBUFF	;filename area
	LD	(KILLW),DE	;kill need for extensions
	CALL	KILLIT		;kill the file
	JR	MODREST+3	;move to next position
;
;	$MODREST - restore a killed file
;
MODREST	CALL	RESCUE		;bring it back
	CALL	SHOWDIR		;re-display video
	JR	MODIRRN		;advance cursor
;
;	$NUNUSED - clear all unused directory records
;
NUNUSED	CALL	UNUSED		;clear all unused entries
	JP	SHOWDIR		;re-display again & ret
;
;	$MODIRR - advance cursor one position
;
;	ENT	HL => video
;		IX => directory record
;
;	EXT	Carry = at video limit
;		NC = HL & IX at next position
;
;	NOTE	the cursor may end up on a 'blank'
;		filename on the display
;
MODIRR	PUSH	HL		;save original
	LD	BC,16		;entry offset
	ADD	HL,BC		;HL => next entry
	LD	A,H		;check if still on video
	CP	VIDEND<-8	;still in video
	CCF			;adjust for correct error
	JR	C,MODIRXT	;cannot move it
	CALL	IXDIR		;advance IX to next entry
	EX	(SP),HL		;put new HL on stack
	OR	A		;return NC
;
MODIRXT	POP	HL		;get video pointer back
	RET			;back to caller
;
;	$MODIRRN - advance cursor to next entry on video
;
;	NOTE	unlike $MODIRR, this routine will
;		check the new cursor position to see
;		it is over a displayed name
;
MODIRRN	CALL	MODIRR		;advance right
	RET	C		;at end now!
;
	LD	A,(HL)		;fetch byte from video
	CP	SPACE		;on anything?
	JR	Z,MODIRRN	;try next one if nil
	RET			;back to caller
;
;	$MODIRL - advance left on position
;
;	NOTE	cursor may end up on a 'blank' filename
;
MODIRL	PUSH	HL		;save a sec
	LD	BC,-16		;offsect back a file
	ADD	HL,BC		;point to new spot
	LD	A,H		;see if still on video
	CP	VIDEO<-8	;less than video?
	JR	C,MODIRLB	;yes, return C error
	EX	(SP),HL		;put new HL on stack
	CALL	IXDIRB		;move IX back one record
	OR	A		;clear carry flag
;
MODIRLB	POP	HL		;restore video
	RET			;back to caller
;
;	$MODIRLN - move back to next displayed name
;
MODIRLN	CALL	MODIRL		;move left one place
	RET	C		;cannot move any more
;
	LD	A,(HL)		;fetch video character
	CP	SPACE		;blank name?
	JR	Z,MODIRLN	;try next one if yes
	RET			;else done
;
;	$MODIRU - move cursor up one row (4 files)
;
MODIRU	PUSH	HL		;save video
	LD	BC,-64		;row length
	ADD	HL,BC		;back one row
	LD	A,H		;check for video still
	CP	VIDEO<-8	;is it?
	JR	C,MODIRLB	;if not, pop & return
;
	EX	(SP),HL		;replace it on stack
	CALL	IXDIRB		;back 1
	CALL	IXDIRB		;2
	CALL	IXDIRB		;3
	CALL	IXDIRB		;4 filenames
	POP	HL		;restore stack
	RET			;back to caller
;
;	$MODIRD - move cursor down one row
;
MODIRD	PUSH	HL		;save video position
	LD	BC,64		;length of a line
	ADD	HL,BC		;new video place
	LD	A,H		;fetch MSB
	CP	VIDEND<-8	;still in video?
	JR	NC,MODIRLB	;nope, don't change
;
	EX	(SP),HL		;put HL on stack
	CALL	IXDIR		;next entry
	CALL	IXDIR		;2
	CALL	IXDIR		;3
	CALL	IXDIR		;4 filenames up
	POP	HL		;restore stack
	RET			;back to caller
;
;	$PUTDIR - write directory back to disk
;
PUTDIR	RST	@08		;clear screen
;
	DEFB	CLSF
	DEFB	ETX
;
	CALL	MAKEGAT		;update to correct grans
	CALL	DIRPART		;display name/date/grans
	RST	@08		;couple of linefeeds
;
	DEFB	LF
	DEFB	LF
	DEFB	ETX
;
PUTDIRB	RST	@08		;display prompt
;
	DEFB	EOL		;clear current line
	DEFM	'Write Directory? '
	DEFB	ETX
;
	LD	B,3		;3 key input
	RST	@10		;get from keyboard
	JR	Z,PUTDIRB	;no input, don't default
	CALL	UCASE		;make upper for compare
;
	CP	'N'		;no?
	JP	Z,MODIRBK	;back to display mode
;
	CP	'Y'		;yes?
	JR	NZ,PUTDIRB	;neither, error
;
	RST	@08		;display a linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	MAKEGAT		;build the GAT table
	CALL	MAKEHIT		;build the HIT table
	CALL	WRDIR		;write dir to disk
	JP	MODIRBK		;resume with display
;
;	shift down arrow, bring in more files
;
DIRDWN	LD	A,(DIRPAGE)	;fetch current page off.
	OR	A		;already at start?
	RET	Z		;yes, ignore command
	SUB	8		;else back 8 pages
	LD	(DIRPAGE),A	;update it
	CALL	SHOWDIR		;re-display new names
	JP	MODDIR+3	;resume
;
;	shift up arrow, bring in more files if any
;
DIRUP	LD	A,(DIRSCNT)	;get # sectors in dir
	SUB	10		;less 10
	LD	B,A		;save it
	LD	A,(DIRPAGE)	;get current page
	CP	B		;any more to bring in?
	RET	NC		;nope, resume
	ADD	A,8		;else adjust to next blk
	LD	(DIRPAGE),A	;save new offset
	CALL	SHOWDIR		;re-display all files
	JP	MODDIR+3	;resume
;
;	cannot locate directory, display it
;
NOTDIR	PUSH	AF		;save error status
	CALL	DRVASC		;get ascii drive number
	LD	(NOTDIRM),A	;to the string
	RST	@08		;display it
;
	DEFB	LF
	DEFM	'Cannot locate directory Drive '
NOTDIRM	DEFM	'x'
	DEFB	LF
	DEFB	ETX
;
	POP	AF		;restore status
	RET			;back to caller
;
	PAGE
;
;	$DIRPART - display name/date free grans/files
;
;	ENT	directory loaded into memory at (GATBUFF)
;
;	EXT	name/date/free grans/free files displayed
;
DIRPART	CALL	DRVASC		;get ascii drive number
	LD	(DXTTX),A	;to the string
	LD	A,27H		;single side
	BIT	0,(IY+5)	;single?
	JR	Z,DYTTY		;yes, go!
	LD	A,'"'		;double side
DYTTY	LD	(DXTTX+1),A	;to string
	RST	@08		;display it
;
	DEFB	LF
	DEFB	LF
	DEFM	'Drive '
DXTTX	DEFM	'x   '
	DEFB	ETX
;
	CALL	NAMDATE		;display name/date
	CALL	FIGTKS		;get track count from GAT
	LD	A,(IY+1)	;get relative tracks
	RST	@18		;to decimal ascii
	LD	(DE1),A		;to the string
	LD	(DE1+1),BC	;rest of it
;
;	compute free granules
;
	LD	B,(IY+1)	;track count relative
	LD	HL,GATBUFF	;start of GAT
	LD	A,38H		;JR C opcode
	CALL	GETGCNT		;count OFF bits
;
	PUSH	IY		;save DCT
	LD	IY,DE2		;string where it goes
	EX	DE,HL		;HL = number free grans
	LD	(FREEG),HL	;save it
	CALL	BINASC		;convert to decimal ascii
	POP	IY		;restore DCT
;
	LD	A,(IY+10)	;get sectors/gran
	CALL	DMULT		;multiply grans*sect/gran
	LD	B,H		;pass result
	LD	H,L
	LD	L,A		;BHL = result
	LD	A,4		;# sectors/K
	CALL	TDIVD		;get K
;
	PUSH	AF		;save remainder
	PUSH	IY		;save DCT
	LD	IY,DE4		;string to place it
	CALL	BINASC		;convert to decimal
	POP	IY		;restore DCT
	POP	AF		;get remainder
;
	LD	E,A		;E = remainder
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,E		;*5
	SRL	A		;/2
	ADD	A,'0'		;make it ascii
	LD	(DE4A),A	;to the string
;
;	compute free files
;
	CALL	ENTRIES		;total directory entries
	LD	B,0		;init counter
	LD	HL,FILBUFF	;start of file records
;
DE3LP	BIT	4,(HL)		;active entry?
	JR	NZ,DE4LP	;yes, don't count it
	INC	B		;bump counter
DE4LP	CALL	HLDIR		;advance HL to next entry
	DEC	E		;less entry counter
	JR	NZ,DE3LP	;go till all done
	LD	A,B		;fetch counter
	LD	(FREEF),A	;save free files
	RST	@18		;to decimal ascii
	LD	(DE3),A		;to the string
	LD	(DE3+1),BC	;rest of it
	RST	@08		;display it
;
	DEFB	LF		;linefeed
DE1	DEFM	'xxx Tracks - '
DE2	DEFM	'xxxxx Grans  '
DE4	DEFM	'xxxxx.'
DE4A	DEFM	'x K  '
DE3	DEFM	'xxx Files Free'
	DEFB	LF
	DEFB	ETX
;
	RET			;done!
;
	PAGE
;
;	$GETGCNT - count on/off bits in gat table
;
;	ENT	B = number of tracks to check
;		HL => GAT table
;		A = 30H or 38H for JR NC/C opcodes
;		(38 counts ON bits / 30 counts OFF bits)
;
;	EXT	DE = number of free/used bits (grans)
;
GETGCNT	LD	(GETGAT1),A	;save opcode
	LD	DE,0		;reset counter
;
GETGAT2	LD	C,(IY+11)	;get grans/track
	BIT	0,(IY+5)	;2 sides?
	JR	Z,GETGAT5	;go if not
	SLA	C		;double it
;
GETGAT5	LD	A,(HL)		;fetch GAT byte
	INC	HL		;bump to next track
;
GETGAT3	RRA
GETGAT1	JR	NC,GETGAT4	;go if set/reset
	INC	DE		;bump counter
GETGAT4	DEC	C		;less gran counter
	JR	NZ,GETGAT3	;go till byte done
	DJNZ	GETGAT2		;do next track
	RET			;return DE = number grans
;
	PAGE
;
;	$CHDNAME - change diskette name/date/pass/auto
;
CHDNAME	CALL	GETDRVS		;get multiple drives
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	LD	DE,CHDNAMC	;subroutine address
	LD	BC,GOBACK	;back to menu when done
	JP	DRVCOMM		;do all specified drives
;
CHDNAMC	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read in the directory
	JP	NZ,NOTDIR	;error, abort!
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	NAMDATE		;display name/date
	RST	@08		;prompt for new name
;
	DEFB	LF
	DEFM	'Name? '
	DEFB	ETX
;
	LD	B,8		;8 chars in name
	RST	@10		;get from keyboard
	JR	Z,NEWDATE	;nil input, don't change
;
	EXX			;save string and length
	LD	HL,GATBUFF+0D0H	;name in GAT table
	PUSH	HL		;save on stack
	LD	A,SPACE		;space
	LD	B,8		;8 chars long
	CALL	FILL		;fill name with spaces
	EXX			;get set back
	POP	DE		;get where in GAT it goes
	LD	C,B		;length in B, move to C
	LD	B,0		;BC = length of input
	LDIR			;move user input into GAT
;
NEWDATE	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Date? '
	DEFB	ETX
;
	LD	B,8		;8 chars long
	RST	@10		;fetch from keyboard
	JR	Z,APASSWD	;nothing, leave alone
;
	EXX			;save pointer/length
	LD	HL,GATBUFF+0D8H	;where in GAT it goes
	PUSH	HL		;save on stack
	LD	B,8		;8 chars long
	LD	A,SPACE		;space
	CALL	FILL		;fill date in gat
	EXX			;get set back
	POP	DE		;where in GAT it goes
	LD	C,B		;pass length to C
	LD	B,0		;BC = length user input
	LDIR			;move user input to GAT
;
APASSWD	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Master Password? '
	DEFB	ETX
;
	LD	B,8		;8 chars long
	RST	@10		;fetch from keyboard
	JR	Z,ASKAUTO	;nil, leave alone
;
	CALL	CODE		;code the password
	LD	(GATBUFF+0CEH),HL	;put in GAT
;
ASKAUTO	RST	@08		;display prompt
;
	DEFB	LF
	DEFM	'Auto Command? '
	DEFB	ETX
;
	LD	B,31		;31 chars max (+CR)
	RST	@10		;fetch from keyboard
;
;	nil input at this point will disable the
;	auto command
;
	EXX			;save pointer/length
	LD	HL,GATBUFF+0E0H	;where it goes in GAT
	PUSH	HL		;save on stack
	LD	A,SPACE		;fill with spaces
	LD	B,32		;32 chars long
	CALL	FILL		;fill it
	EXX			;get pointer back
	POP	DE		;where it goes
	LD	C,B		;pass length to C
	INC	C		;+ 1 for carriage return
	LD	B,0		;BC = length +1
	LDIR			;move into GAT
;
	CALL	COMPDIR		;compute correct DAM type
	LD	(WRTYPE),A	;save write type byte
	CALL	GETDIR		;load DE with GAT trk/sec
	LD	BC,GATBUFF	;where data is in memory
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;check disk status
	RET	NZ		;not ready, don't write
	RST	@30		;write sector to disk
	RET			;on to the next drive
;
	PAGE
;
;	$ZUNUSE - zero unused directory entries
;
ZUNUSE	CALL	GETDRVS		;get multiple drives
	LD	DE,ZUNUSEC	;subroutine address
	LD	BC,GOBACK	;to sub-menu when done
	JP	DRVCOMM		;do all specified drives
;
ZUNUSEC	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read in directory
	JP	NZ,NOTDIR	;can't read it, return!
;
	CALL	DIRPART		;display name/grans/etc
	CALL	UNUSED		;clear all unused
	CALL	SHOCNT		;display counter
	RST	@08		;message
;
	DEFM	'clear entries'
	DEFB	LF
	DEFB	ETX
;
	JP	WRDIR		;write directory back!
;
;	$CLRFILE - erase current directory record
;
;	ENT	IX => directory record
;
;	EXT	entry is zeroed out
;
CLRFILE	PUSH	HL		;save video pointer
	PUSH	BC		;need this too
;
	PUSH	IX		;pass to HL
	POP	HL
;
	CALL	BCDIR		;load BC with dir length
	LD	B,C		;pass it to B
	XOR	A		;zero
	CALL	FILL		;fill the entry with 'em
	CALL	ADDCNT		;bump counter
	POP	BC		;unstack
	POP	HL
	RET			;and return
;
	PAGE
;
;	$DIRLIST - display diskette directory
;
DIRLIST	CALL	GETDRVS		;get multiple drives
	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	XOR	A		;clear line counter
	LD	(LINEC),A	;set to zero
	LD	DE,DIRLSTC	;subroutine address
	LD	BC,GOBACK	;menu when all are done
	JP	DRVCOMM		;do all requested drives
;
DIRLSTC	RST	@08		;display linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	RDDIR		;read the directory
	JP	NZ,NOTDIR	;can't find the bugger
;
	CALL	DIRPART		;show name etc
	CALL	ALINE		;count 3 lines
	CALL	ALINE
;
;	check for Mod I/III DD TRSDOS
;
	CALL	SHOWSYS		;display sys files
;
	CALL	ENTRIES		;load DE with # files
	LD	IX,FILBUFF	;start of file records
	LD	HL,(CURSOR)	;where to display it
DIRLSTO	LD	D,3		;# / line counter
;
DIRLSTI	BIT	4,(IX)		;active?
	JR	Z,DIRLSTD	;nope, skip this one
	BIT	7,(IX)		;extended entry?
	JR	NZ,DIRLSTD	;yes, skip it
;
	CALL	SHOWIT		;display filename
	JR	NZ,DIRLSTD	;invalid! re-use same vid
;
	CALL	PAUSE		;check for pause key
	LD	BC,13		;offset to end of name
	ADD	HL,BC		;HL => end of video name
;
	BIT	6,(IX)		;system file?
	JR	Z,DDAA1		;nope, go
	LD	(HL),'S'	;put on video
;
DDAA1	INC	HL		;bump video
	BIT	3,(IX)		;invisible?
	JR	Z,DDAA2		;nope, go
	LD	(HL),'I'	;put on video
;
DDAA2	INC	HL		;bump video
	LD	A,(IX)		;get type byte
	AND	7		;any password prot?
	JR	Z,DDAA3		;nope, go
	LD	(HL),'P'	;show protected
	INC	HL		;bump video
	LD	(HL),'='	;for level
	INC	HL		;bump video
	ADD	A,'0'		;make prot level ascii
	LD	(HL),A		;display prot level
	JR	DDAA3+2		;continue
;
DDAA3	INC	HL		;bump video to next field
	INC	HL
	INC	HL
;	INC	HL
	INC	HL
	DEC	D		;less this entry
	JR	NZ,DIRLSTD	;stay on this line
	LD	(CURSOR),HL	;update cursor position
	RST	@08		;send linefeed
;
	DEFB	LF		;to go to next line
	DEFB	ETX
;
	CALL	ALINE		;count the line
	LD	HL,(CURSOR)	;new position
	LD	D,3		;start fresh
;
DIRLSTD	CALL	IXDIR		;move IX to next entry
	DEC	E		;less entry counter
	JR	NZ,DIRLSTI	;go more if any
	LD	(CURSOR),HL	;update cursor location
	RET			;on to next drive
;
	PAGE
;
;	$ALINE - count displayed line, pause screen full
;
ALINE	LD	A,0		;get line counter
LINEC	EQU	$-1
	INC	A		;add one
	LD	(LINEC),A	;put it back
	CP	8		;max lines to display?
	RET	C		;nope, return
;
	XOR	A		;reset counter
	LD	(LINEC),A	;put it back
	OR	80H		;set bit 7
	LD	(PAUFLG),A	;set pause flag
	JP	PAUSE		;forced pause
;
	PAGE
;
;	$KILLIT - kill current file
;
;	ENT	IX => directory entry
;		($KILLW) = address of filename start
;		(needed to locate extended entries)
;
;	EXT	file is deleted from dir in memory
;
KILLIT	BIT	4,(IX)		;live entry?
	RET	Z		;already dead
	BIT	7,(IX)		;extension?
	RET	NZ		;can't kill that
	CALL	SAVEREG		;save registers
;
KILLOP	RES	4,(IX)		;kill it!
	CALL	GETEXTS		;get # of extents to B
;
KILLLP	LD	A,(IX+16H)	;get extent byte
	INC	A		;terminator?
	RET	Z		;yes, done!
	INC	A		;extended entry?
	JR	Z,KILEXT	;get that one too
	INC	IX		;bump to next extent
	INC	IX
	DJNZ	KILLLP		;go for all extents
	RET			;bad directory entry!
;
KILEXT	LD	A,(IX+17H)	;get DEC of extension
	CALL	WHATDEC		;compute DEC offset
	LD	IX,FILBUFF	;start of entries
KILLW	EQU	$-2
	ADD	IX,DE		;point to it
;
	JR	KILLOP		;kill the extension
;
	PAGE
;
;	$RESCUE - restore current entry
;
;	ENT	IX => directory record
;		directory assumed to be at $GATBUFF
;
;	EXT	directory record restored
;
RESCUE	CALL	SAVEREG		;save registers
;
RESTOP	SET	4,(IX)		;liven it up
	CALL	GETEXTS		;get number of extents
;
RESLLLP	LD	A,(IX+16H)	;get extent byte
	INC	A		;terminator?
	RET	Z		;yes, done!
	INC	A		;extended entry?
	JR	Z,RESCEXT	;rescue that too!
	INC	IX		;bump to next extent
	INC	IX
	DJNZ	RESLLLP		;do all extents
	RET			;record corrupt!
RESCEXT	LD	A,(IX+17H)	;get DEC of extension
	CALL	WHATDEC		;compute offset
	LD	IX,FILBUFF	;start of file data
	ADD	IX,DE		;point to extension
	JR	RESTOP		;restore this too!
;
;	$GETEXTS - fetch number extents / entry
;
;	ENT	IY => DCT
;
;	EXT	B = number of extents per file entry
;
GETEXTS	LD	B,5		;normally 5
	LD	A,(IY+7)	;get dos type
	CP	3		;trsiii?
	RET	NZ		;nope, return
	LD	B,13		;TRSDOS III has 13
	RET			;done
;
;	display Mod I/III DD TRSDOS system files
;
SHOWSYS	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	Z,SHOSYX	;go if yes
	CP	3		;t3?
	RET	NZ		;neither, return
;
SHOSYX	LD	HL,HITBUFF+0D0H	;sys files Mod I DD
	LD	E,24		;24 files
	LD	D,0		;init sys #
	CP	2		;I DD?
	JR	Z,SHOSYS1	;have it, go!
;
	LD	L,0E0H		;sys files Mod III DD
	LD	E,16		;16 files
;
SHOSYS1	LD	A,(HL)		;get a byte
	INC	HL		;bump pointer
	AND	(HL)		;check for FFFF
	INC	A		;active?
	CALL	NZ,SHOWSY2	;have an active one
;
	INC	L		;to next extent
	INC	D		;bump sys #
	LD	A,D		;get sys #
	AND	7		;check for linefeed time
	JR	NZ,SHOSYS3	;nope, go!
;
	RST	@08		;send linefeed
;
	DEFB	BACKSP		;backspace
	DEFB	LF		;linefeed
	DEFB	ETX		;end of text
;
SHOSYS3	DEC	E		;less counter
	JR	NZ,SHOSYS1	;go if more
	RET			;else done!
;
SHOWSY2	LD	A,D		;get sys #
	RST	@18		;to decimal ascii
	LD	(SHOWSY4),BC	;save ascii
	RST	@08		;display it
;
SHOWSY4	DEFM	'xx-'
	DEFB	ETX
;
	RET			;done
;
