; suformc/asm - kjw/bqsd - 08/78 - version 3.0 - 11/82
;
; revised 03/16/83 - kjw
;
	PAGE
;
LOKGRAN	PUSH	HL		;save it
	PUSH	DE		;save track/sector
	LD	H,GATBUFF<-8	;get MSB gat table
	LD	L,D		;HL => cylinder byte
	LD	A,E		;get sector to lock
	LD	D,1		;set gran 0 bit
;
LOKDL	SUB	(IY+10)		;less sectors/gran
	JR	C,LOKDF		;found it
	SLA	D		;move lock bit
	JR	LOKDL		;continue
;
LOKDF	LD	A,(HL)		;get the byte
	OR	D		;lock the gran
	LD	(HL),A		;put it back
	BIT	3,(IY+6)	;relative engaged?
	JR	NZ,LOKFIN	;no lockout table here!
	LD	DE,60H		;offset to lockout table
	ADD	HL,DE		;HL => lockout byte
	LD	(HL),A		;save into table
;
LOKFIN	POP	DE		;get track/sector back
	POP	HL		;this too
	RET
;
	PAGE
;
;	$NEXGRAN - advance DE to start next gran
;
NEXGRAN	LD	A,E		;get sector number
	LD	E,1		;starting gran # +1
;
NEXGLX	SUB	(IY+10)		;less sectors/gran
	JR	C,NEXGLY	;go if found
	INC	E		;bump gran counter
	JR	NEXGLX		;continue
;
NEXGLY	PUSH	DE		;save on stack
	CALL	FIRSTS		;load E with first sector
	LD	A,E		;get first sector
	POP	DE		;gran offset in E
	JR	NXGZ		;dec immed
;
NEXGLZ	ADD	A,(IY+10)	;offset to next gran
NXGZ	DEC	E		;less gran offset
	JR	NZ,NEXGLZ	;go till found
;
	LD	E,A		;E = start current gran
;
	PUSH	BC		;save for loop
	LD	B,(IY+10)	;# sectors / gran
;
NXGGZZ	CALL	NEXSEC		;logical advance
	DJNZ	NXGGZZ		;go for # s/g
	POP	BC		;restore
;
	RET			;done! DE = next gran
;
	PAGE
;
;	$BULKGO - begin erasing diskette
;
BULKGO	RST	@08		;send linefeed
;
	DEFB	LF
	DEFB	ETX
;
	CALL	DSTAT		;drive ready?
	RET	NZ		;skip if not!
;
	CALL	RESTORE		;move head to track 0
	RET	NZ		;not in system
;
	LD	HL,BUFFER	;setup buffer
	LD	(FMTBUFF),HL	;for format buffer
	CALL	CLRBUFF		;clear buffer to zeroes
;
;	loop to format with all zeroes
;
BULKLP	LD	BC,(FMTBUFF)	;get I/O buffer
	BIT	0,(IY+5)	;double side?
	JR	Z,BULKSS	;nope, go!
	SET	1,(IY+5)	;set side one
	CALL	SHOFMT		;format track
BULKSS	RES	1,(IY+5)	;set side zero
	LD	BC,(FMTBUFF)	;get I/O buffer
	CALL	SHOFMT		;format track
;
	LD	A,(IY+0)	;get physical tracks
	DEC	A		;A = highest track
	CP	(IY+3)		;at last track now?
	RET	Z		;yes, done with disk!
;
	CALL	STEPIN		;step to next track
	RET	NZ		;error!
	JR	BULKLP		;else do next track
;
;	bulk erase diskettes!
;
BLKERAS	RST	@08		;give warning message
;
	DEFB	LF
	DEFM	'Be CAREFUL'
	DEFB	ETX
;
	CALL	GETDRVS		;ask for which drive(s)
	LD	DE,BULKGO	;subroutine vector
	LD	BC,GOBACK	;completion vector
	JP	DRVCOMM		;do all indicated drives
;
	PAGE
;
;	patterns to use when formatting
;	data loaded into all empty sectors
;
SPATTRN	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
	DEFB	0E5H,0E5H,0E5H,0E5H
;
DPATTRN	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
	DEFB	06DH,0B6H,06DH,0B6H
;
	PAGE
;
;	$CLRBUFF - clear out format buffer
;
;	fill buffer with zeroes in perparation for format
;
CLRBUFF	CALL	SAVEREG		;save registers
;
	LD	HL,(FMTBUFF)	;get format buff start
	LD	D,H		;pass start to DE
	LD	E,L		;DE = buffer start
	INC	DE		;DE = start +1
	LD	BC,17FFH	;length to fill
	LD	(HL),0		;load one zero
	LDIR			;load all zeroes
	RET			;done, buffer cleared
;
	PAGE
;
;	$COMPCOD - compute differences between
;		   password encoding between dos's
;
COMPCOD	PUSH	AF		;save flag
	LD	A,(IY+7)	;get dos type
	CP	2		;t1d?
	JR	Z,COMPCD3	;yes, go!
	CP	3		;t3?
	JR	Z,COMPCD3	;yes, go!
;
	ADD	HL,HL		;finish it off
	ADD	HL,HL
;
	POP	AF
	RET
;
COMPCD3	SBC	HL,DE		;finish it off
;
	POP	AF
	RET
;
COMPCOE	PUSH	AF		;save
	LD	A,(IY+7)	;get dos type
	CP	2		;trsdos I DD?
	JR	NZ,COMPCOF	;go if not
	ADD	HL,DE		;extra instruction
COMPCOF	POP	AF		;restore
	RET			;done
;
